% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eks_operations.R
\name{eks_describe_addon_versions}
\alias{eks_describe_addon_versions}
\title{Describes the Kubernetes versions that the add-on can be used with}
\usage{
eks_describe_addon_versions(
  kubernetesVersion = NULL,
  maxResults = NULL,
  nextToken = NULL,
  addonName = NULL
)
}
\arguments{
\item{kubernetesVersion}{The Kubernetes versions that the add-on can be used with.}

\item{maxResults}{The maximum number of results to return.}

\item{nextToken}{The \code{nextToken} value returned from a previous paginated
\code{DescribeAddonVersionsRequest} where \code{maxResults} was used and the
results exceeded the value of that parameter. Pagination continues from
the end of the previous results that returned the \code{nextToken} value.

This token should be treated as an opaque identifier that is used only
to retrieve the next items in a list and not for other programmatic
purposes.}

\item{addonName}{The name of the add-on. The name must match one of the names returned by
\href{https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html}{\code{list_addons}}
.}
}
\description{
Describes the Kubernetes versions that the add-on can be used with.

See \url{https://paws-r.github.io/docs/eks/describe_addon_versions.html} for full documentation.
}
\keyword{internal}
