% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_get_load_balancer_metric_data}
\alias{lightsail_get_load_balancer_metric_data}
\title{Returns information about health metrics for your Lightsail load
balancer}
\usage{
lightsail_get_load_balancer_metric_data(
  loadBalancerName,
  metricName,
  period,
  startTime,
  endTime,
  unit,
  statistics
)
}
\arguments{
\item{loadBalancerName}{[required] The name of the load balancer.}

\item{metricName}{[required] The metric for which you want to return information.

Valid load balancer metric names are listed below, along with the most
useful \code{statistics} to include in your request, and the published \code{unit}
value.
\itemize{
\item \strong{\code{ClientTLSNegotiationErrorCount}} - The number of TLS connections
initiated by the client that did not establish a session with the
load balancer due to a TLS error generated by the load balancer.
Possible causes include a mismatch of ciphers or protocols.

\code{Statistics}: The most useful statistic is \code{Sum}.

\code{Unit}: The published unit is \code{Count}.
\item \strong{\code{HealthyHostCount}} - The number of target instances that are
considered healthy.

\code{Statistics}: The most useful statistic are \code{Average}, \code{Minimum},
and \code{Maximum}.

\code{Unit}: The published unit is \code{Count}.
\item \strong{\code{HTTPCode_Instance_2XX_Count}} - The number of HTTP 2XX response
codes generated by the target instances. This does not include any
response codes generated by the load balancer.

\code{Statistics}: The most useful statistic is \code{Sum}. Note that
\code{Minimum}, \code{Maximum}, and \code{Average} all return \code{1}.

\code{Unit}: The published unit is \code{Count}.
\item \strong{\code{HTTPCode_Instance_3XX_Count}} - The number of HTTP 3XX response
codes generated by the target instances. This does not include any
response codes generated by the load balancer.

\code{Statistics}: The most useful statistic is \code{Sum}. Note that
\code{Minimum}, \code{Maximum}, and \code{Average} all return \code{1}.

\code{Unit}: The published unit is \code{Count}.
\item \strong{\code{HTTPCode_Instance_4XX_Count}} - The number of HTTP 4XX response
codes generated by the target instances. This does not include any
response codes generated by the load balancer.

\code{Statistics}: The most useful statistic is \code{Sum}. Note that
\code{Minimum}, \code{Maximum}, and \code{Average} all return \code{1}.

\code{Unit}: The published unit is \code{Count}.
\item \strong{\code{HTTPCode_Instance_5XX_Count}} - The number of HTTP 5XX response
codes generated by the target instances. This does not include any
response codes generated by the load balancer.

\code{Statistics}: The most useful statistic is \code{Sum}. Note that
\code{Minimum}, \code{Maximum}, and \code{Average} all return \code{1}.

\code{Unit}: The published unit is \code{Count}.
\item \strong{\code{HTTPCode_LB_4XX_Count}} - The number of HTTP 4XX client error
codes that originated from the load balancer. Client errors are
generated when requests are malformed or incomplete. These requests
were not received by the target instance. This count does not
include response codes generated by the target instances.

\code{Statistics}: The most useful statistic is \code{Sum}. Note that
\code{Minimum}, \code{Maximum}, and \code{Average} all return \code{1}.

\code{Unit}: The published unit is \code{Count}.
\item \strong{\code{HTTPCode_LB_5XX_Count}} - The number of HTTP 5XX server error
codes that originated from the load balancer. This does not include
any response codes generated by the target instance. This metric is
reported if there are no healthy instances attached to the load
balancer, or if the request rate exceeds the capacity of the
instances (spillover) or the load balancer.

\code{Statistics}: The most useful statistic is \code{Sum}. Note that
\code{Minimum}, \code{Maximum}, and \code{Average} all return \code{1}.

\code{Unit}: The published unit is \code{Count}.
\item \strong{\code{InstanceResponseTime}} - The time elapsed, in seconds, after the
request leaves the load balancer until a response from the target
instance is received.

\code{Statistics}: The most useful statistic is \code{Average}.

\code{Unit}: The published unit is \code{Seconds}.
\item \strong{\code{RejectedConnectionCount}} - The number of connections that were
rejected because the load balancer had reached its maximum number of
connections.

\code{Statistics}: The most useful statistic is \code{Sum}.

\code{Unit}: The published unit is \code{Count}.
\item \strong{\code{RequestCount}} - The number of requests processed over IPv4.
This count includes only the requests with a response generated by a
target instance of the load balancer.

\code{Statistics}: The most useful statistic is \code{Sum}. Note that
\code{Minimum}, \code{Maximum}, and \code{Average} all return \code{1}.

\code{Unit}: The published unit is \code{Count}.
\item \strong{\code{UnhealthyHostCount}} - The number of target instances that are
considered unhealthy.

\code{Statistics}: The most useful statistic are \code{Average}, \code{Minimum},
and \code{Maximum}.

\code{Unit}: The published unit is \code{Count}.
}}

\item{period}{[required] The granularity, in seconds, of the returned data points.}

\item{startTime}{[required] The start time of the period.}

\item{endTime}{[required] The end time of the period.}

\item{unit}{[required] The unit for the metric data request. Valid units depend on the metric
data being requested. For the valid units with each available metric,
see the \code{metricName} parameter.}

\item{statistics}{[required] The statistic for the metric.

The following statistics are available:
\itemize{
\item \code{Minimum} - The lowest value observed during the specified period.
Use this value to determine low volumes of activity for your
application.
\item \code{Maximum} - The highest value observed during the specified period.
Use this value to determine high volumes of activity for your
application.
\item \code{Sum} - All values submitted for the matching metric added together.
You can use this statistic to determine the total volume of a
metric.
\item \code{Average} - The value of Sum / SampleCount during the specified
period. By comparing this statistic with the Minimum and Maximum
values, you can determine the full scope of a metric and how close
the average use is to the Minimum and Maximum values. This
comparison helps you to know when to increase or decrease your
resources.
\item \code{SampleCount} - The count, or number, of data points used for the
statistical calculation.
}}
}
\description{
Returns information about health metrics for your Lightsail load balancer.

See \url{https://paws-r.github.io/docs/lightsail/get_load_balancer_metric_data.html} for full documentation.
}
\keyword{internal}
