% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_test_alarm}
\alias{lightsail_test_alarm}
\title{Tests an alarm by displaying a banner on the Amazon Lightsail console}
\usage{
lightsail_test_alarm(alarmName, state)
}
\arguments{
\item{alarmName}{[required] The name of the alarm to test.}

\item{state}{[required] The alarm state to test.

An alarm has the following possible states that can be tested:
\itemize{
\item \code{ALARM} - The metric is outside of the defined threshold.
\item \code{INSUFFICIENT_DATA} - The alarm has just started, the metric is not
available, or not enough data is available for the metric to
determine the alarm state.
\item \code{OK} - The metric is within the defined threshold.
}}
}
\description{
Tests an alarm by displaying a banner on the Amazon Lightsail console. If a notification trigger is configured for the specified alarm, the test also sends a notification to the notification protocol (\code{Email} and/or \code{SMS}) configured for the alarm.

See \url{https://paws-r.github.io/docs/lightsail/test_alarm.html} for full documentation.
}
\keyword{internal}
