# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Braket
#'
#' @description
#' The Amazon Braket API Reference provides information about the
#' operations and structures supported in Amazon Braket.
#' 
#' Additional Resources:
#' 
#' -   [Amazon Braket Developer
#'     Guide](https://docs.aws.amazon.com/braket/latest/developerguide/what-is-braket.html)
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- braket(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- braket()
#' svc$cancel_job(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=braket_cancel_job]{cancel_job} \tab Cancels an Amazon Braket job\cr
#'  \link[=braket_cancel_quantum_task]{cancel_quantum_task} \tab Cancels the specified task\cr
#'  \link[=braket_create_job]{create_job} \tab Creates an Amazon Braket job\cr
#'  \link[=braket_create_quantum_task]{create_quantum_task} \tab Creates a quantum task\cr
#'  \link[=braket_get_device]{get_device} \tab Retrieves the devices available in Amazon Braket\cr
#'  \link[=braket_get_job]{get_job} \tab Retrieves the specified Amazon Braket job\cr
#'  \link[=braket_get_quantum_task]{get_quantum_task} \tab Retrieves the specified quantum task\cr
#'  \link[=braket_list_tags_for_resource]{list_tags_for_resource} \tab Shows the tags associated with this resource\cr
#'  \link[=braket_search_devices]{search_devices} \tab Searches for devices using the specified filters\cr
#'  \link[=braket_search_jobs]{search_jobs} \tab Searches for Amazon Braket jobs that match the specified filter values\cr
#'  \link[=braket_search_quantum_tasks]{search_quantum_tasks} \tab Searches for tasks that match the specified filter values\cr
#'  \link[=braket_tag_resource]{tag_resource} \tab Add a tag to the specified resource\cr
#'  \link[=braket_untag_resource]{untag_resource} \tab Remove tags from a resource
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname braket
#' @export
braket <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .braket$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.braket <- list()

.braket$operations <- list()

.braket$metadata <- list(
  service_name = "braket",
  endpoints = list("*" = list(endpoint = "braket.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "braket.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "braket.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "braket.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "braket.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "braket.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "Braket",
  api_version = "2019-09-01",
  signing_name = "braket",
  json_version = "1.1",
  target_prefix = ""
)

.braket$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.braket$metadata, handlers, config, op)
}
