% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeoptimizer_operations.R
\name{computeoptimizer_export_auto_scaling_group_recommendations}
\alias{computeoptimizer_export_auto_scaling_group_recommendations}
\title{Exports optimization recommendations for Auto Scaling groups}
\usage{
computeoptimizer_export_auto_scaling_group_recommendations(
  accountIds = NULL,
  filters = NULL,
  fieldsToExport = NULL,
  s3DestinationConfig,
  fileFormat = NULL,
  includeMemberAccounts = NULL,
  recommendationPreferences = NULL
)
}
\arguments{
\item{accountIds}{The IDs of the Amazon Web Services accounts for which to export Auto
Scaling group recommendations.

If your account is the management account of an organization, use this
parameter to specify the member account for which you want to export
recommendations.

This parameter cannot be specified together with the include member
accounts parameter. The parameters are mutually exclusive.

Recommendations for member accounts are not included in the export if
this parameter, or the include member accounts parameter, is omitted.

You can specify multiple account IDs per request.}

\item{filters}{An array of objects to specify a filter that exports a more specific set
of Auto Scaling group recommendations.}

\item{fieldsToExport}{The recommendations data to include in the export file. For more
information about the fields that can be exported, see \href{https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files}{Exported files}
in the \emph{Compute Optimizer User Guide}.}

\item{s3DestinationConfig}{[required] An object to specify the destination Amazon Simple Storage Service
(Amazon S3) bucket name and key prefix for the export job.

You must create the destination Amazon S3 bucket for your
recommendations export before you create the export job. Compute
Optimizer does not create the S3 bucket for you. After you create the S3
bucket, ensure that it has the required permissions policy to allow
Compute Optimizer to write the export file to it. If you plan to specify
an object prefix when you create the export job, you must include the
object prefix in the policy that you add to the S3 bucket. For more
information, see \href{https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html}{Amazon S3 Bucket Policy for Compute Optimizer}
in the \emph{Compute Optimizer User Guide}.}

\item{fileFormat}{The format of the export file.

The only export file format currently supported is \code{Csv}.}

\item{includeMemberAccounts}{Indicates whether to include recommendations for resources in all member
accounts of the organization if your account is the management account
of an organization.

The member accounts must also be opted in to Compute Optimizer, and
trusted access for Compute Optimizer must be enabled in the organization
account. For more information, see \href{https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access}{Compute Optimizer and Amazon Web Services Organizations trusted access}
in the \emph{Compute Optimizer User Guide}.

Recommendations for member accounts of the organization are not included
in the export file if this parameter is omitted.

This parameter cannot be specified together with the account IDs
parameter. The parameters are mutually exclusive.

Recommendations for member accounts are not included in the export if
this parameter, or the account IDs parameter, is omitted.}

\item{recommendationPreferences}{An object to specify the preferences for the Auto Scaling group
recommendations to export.}
}
\description{
Exports optimization recommendations for Auto Scaling groups.

See \url{https://www.paws-r-sdk.com/docs/computeoptimizer_export_auto_scaling_group_recommendations/} for full documentation.
}
\keyword{internal}
