% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_nat_gateway}
\alias{ec2_create_nat_gateway}
\title{Creates a NAT gateway in the specified subnet}
\usage{
ec2_create_nat_gateway(
  AllocationId = NULL,
  ClientToken = NULL,
  DryRun = NULL,
  SubnetId,
  TagSpecifications = NULL,
  ConnectivityType = NULL,
  PrivateIpAddress = NULL,
  SecondaryAllocationIds = NULL,
  SecondaryPrivateIpAddresses = NULL,
  SecondaryPrivateIpAddressCount = NULL
)
}
\arguments{
\item{AllocationId}{[Public NAT gateways only] The allocation ID of an Elastic IP address
to associate with the NAT gateway. You cannot specify an Elastic IP
address with a private NAT gateway. If the Elastic IP address is
associated with another resource, you must first disassociate it.}

\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring idempotency}.

Constraint: Maximum 64 ASCII characters.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{SubnetId}{[required] The ID of the subnet in which to create the NAT gateway.}

\item{TagSpecifications}{The tags to assign to the NAT gateway.}

\item{ConnectivityType}{Indicates whether the NAT gateway supports public or private
connectivity. The default is public connectivity.}

\item{PrivateIpAddress}{The private IPv4 address to assign to the NAT gateway. If you don't
provide an address, a private IPv4 address will be automatically
assigned.}

\item{SecondaryAllocationIds}{Secondary EIP allocation IDs. For more information, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html}{Create a NAT gateway}
in the \emph{Amazon VPC User Guide}.}

\item{SecondaryPrivateIpAddresses}{Secondary private IPv4 addresses. For more information about secondary
addresses, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html}{Create a NAT gateway}
in the \emph{Amazon VPC User Guide}.}

\item{SecondaryPrivateIpAddressCount}{[Private NAT gateway only] The number of secondary private IPv4
addresses you want to assign to the NAT gateway. For more information
about secondary addresses, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html}{Create a NAT gateway}
in the \emph{Amazon VPC User Guide}.}
}
\description{
Creates a NAT gateway in the specified subnet. This action creates a network interface in the specified subnet with a private IP address from the IP address range of the subnet. You can create either a public NAT gateway or a private NAT gateway.

See \url{https://www.paws-r-sdk.com/docs/ec2_create_nat_gateway/} for full documentation.
}
\keyword{internal}
