% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costexplorer_operations.R
\name{costexplorer_describe_cost_category_definition}
\alias{costexplorer_describe_cost_category_definition}
\title{Returns the name, ARN, rules, definition, and effective dates of a Cost
Category that's defined in the account}
\usage{
costexplorer_describe_cost_category_definition(CostCategoryArn,
  EffectiveOn)
}
\arguments{
\item{CostCategoryArn}{[required] The unique identifier for your Cost Category.}

\item{EffectiveOn}{The date when the Cost Category was effective.}
}
\description{
Returns the name, ARN, rules, definition, and effective dates of a Cost
Category that's defined in the account.

You have the option to use \code{EffectiveOn} to return a Cost Category that
is active on a specific date. If there is no \code{EffectiveOn} specified,
you’ll see a Cost Category that is effective on the current date. If
Cost Category is still effective, \code{EffectiveEnd} is omitted in the
response.
}
\section{Request syntax}{
\preformatted{svc$describe_cost_category_definition(
  CostCategoryArn = "string",
  EffectiveOn = "string"
)
}
}

\keyword{internal}
