% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/budgets_operations.R
\name{budgets_describe_subscribers_for_notification}
\alias{budgets_describe_subscribers_for_notification}
\title{Lists the subscribers that are associated with a notification}
\usage{
budgets_describe_subscribers_for_notification(
  AccountId,
  BudgetName,
  Notification,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{AccountId}{[required] The \code{accountId} that is associated with the budget whose subscribers you
want descriptions of.}

\item{BudgetName}{[required] The name of the budget whose subscribers you want descriptions of.}

\item{Notification}{[required] The notification whose subscribers you want to list.}

\item{MaxResults}{An optional integer that represents how many entries a paginated
response contains. The maximum is 100.}

\item{NextToken}{The pagination token that you include in your request to indicate the
next set of results that you want to retrieve.}
}
\description{
Lists the subscribers that are associated with a notification.

See \url{https://paws-r.github.io/docs/budgets/describe_subscribers_for_notification.html} for full documentation.
}
\keyword{internal}
