# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include pricing_service.R
NULL

#' Returns the metadata for one service or a list of the metadata for all
#' services
#'
#' @description
#' Returns the metadata for one service or a list of the metadata for all services. Use this without a service code to get the service codes for all services. Use it with a service code, such as `AmazonEC2`, to get information specific to that service, such as the attribute names available for that service. For example, some of the attribute names available for EC2 are `volumeType`, `maxIopsVolume`, `operation`, `locationType`, and `instanceCapacity10xlarge`.
#'
#' See [https://www.paws-r-sdk.com/docs/pricing_describe_services/](https://www.paws-r-sdk.com/docs/pricing_describe_services/) for full documentation.
#'
#' @param ServiceCode The code for the service whose information you want to retrieve, such as
#' `AmazonEC2`. You can use the `ServiceCode` to filter the results in a
#' [`get_products`][pricing_get_products] call. To retrieve a list of all
#' services, leave this blank.
#' @param FormatVersion The format version that you want the response to be in.
#' 
#' Valid values are: `aws_v1`
#' @param NextToken The pagination token that indicates the next set of results that you
#' want to retrieve.
#' @param MaxResults The maximum number of results that you want returned in the response.
#'
#' @keywords internal
#'
#' @rdname pricing_describe_services
pricing_describe_services <- function(ServiceCode = NULL, FormatVersion = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeServices",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pricing$describe_services_input(ServiceCode = ServiceCode, FormatVersion = FormatVersion, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pricing$describe_services_output()
  config <- get_config()
  svc <- .pricing$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pricing$operations$describe_services <- pricing_describe_services

#' Returns a list of attribute values
#'
#' @description
#' Returns a list of attribute values. Attributes are similar to the details in a Price List API offer file. For a list of available attributes, see [Offer File Definitions](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/reading-an-offer.html#pps-defs) in the [Billing and Cost Management User Guide](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-what-is.html).
#'
#' See [https://www.paws-r-sdk.com/docs/pricing_get_attribute_values/](https://www.paws-r-sdk.com/docs/pricing_get_attribute_values/) for full documentation.
#'
#' @param ServiceCode &#91;required&#93; The service code for the service whose attributes you want to retrieve.
#' For example, if you want the retrieve an EC2 attribute, use `AmazonEC2`.
#' @param AttributeName &#91;required&#93; The name of the attribute that you want to retrieve the values for, such
#' as `volumeType`.
#' @param NextToken The pagination token that indicates the next set of results that you
#' want to retrieve.
#' @param MaxResults The maximum number of results to return in response.
#'
#' @keywords internal
#'
#' @rdname pricing_get_attribute_values
pricing_get_attribute_values <- function(ServiceCode, AttributeName, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetAttributeValues",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pricing$get_attribute_values_input(ServiceCode = ServiceCode, AttributeName = AttributeName, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pricing$get_attribute_values_output()
  config <- get_config()
  svc <- .pricing$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pricing$operations$get_attribute_values <- pricing_get_attribute_values

#' This feature is in preview release and is subject to change
#'
#' @description
#' *This feature is in preview release and is subject to change. Your use of Amazon Web Services Price List API is subject to the Beta Service Participation terms of the \href{https://aws.amazon.com/service-terms/}{Amazon Web Services Service Terms} (Section 1.10).*
#'
#' See [https://www.paws-r-sdk.com/docs/pricing_get_price_list_file_url/](https://www.paws-r-sdk.com/docs/pricing_get_price_list_file_url/) for full documentation.
#'
#' @param PriceListArn &#91;required&#93; The unique identifier that maps to where your Price List files are
#' located. `PriceListArn` can be obtained from the
#' [`list_price_lists`](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_ListPriceLists.html)
#' response.
#' @param FileFormat &#91;required&#93; The format that you want to retrieve your Price List files in. The
#' `FileFormat` can be obtained from the
#' [`list_price_lists`](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_ListPriceLists.html)
#' response.
#'
#' @keywords internal
#'
#' @rdname pricing_get_price_list_file_url
pricing_get_price_list_file_url <- function(PriceListArn, FileFormat) {
  op <- new_operation(
    name = "GetPriceListFileUrl",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pricing$get_price_list_file_url_input(PriceListArn = PriceListArn, FileFormat = FileFormat)
  output <- .pricing$get_price_list_file_url_output()
  config <- get_config()
  svc <- .pricing$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pricing$operations$get_price_list_file_url <- pricing_get_price_list_file_url

#' Returns a list of all products that match the filter criteria
#'
#' @description
#' Returns a list of all products that match the filter criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/pricing_get_products/](https://www.paws-r-sdk.com/docs/pricing_get_products/) for full documentation.
#'
#' @param ServiceCode &#91;required&#93; The code for the service whose products you want to retrieve.
#' @param Filters The list of filters that limit the returned products. only products that
#' match all filters are returned.
#' @param FormatVersion The format version that you want the response to be in.
#' 
#' Valid values are: `aws_v1`
#' @param NextToken The pagination token that indicates the next set of results that you
#' want to retrieve.
#' @param MaxResults The maximum number of results to return in the response.
#'
#' @keywords internal
#'
#' @rdname pricing_get_products
pricing_get_products <- function(ServiceCode, Filters = NULL, FormatVersion = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetProducts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pricing$get_products_input(ServiceCode = ServiceCode, Filters = Filters, FormatVersion = FormatVersion, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pricing$get_products_output()
  config <- get_config()
  svc <- .pricing$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pricing$operations$get_products <- pricing_get_products

#' This feature is in preview release and is subject to change
#'
#' @description
#' *This feature is in preview release and is subject to change. Your use of Amazon Web Services Price List API is subject to the Beta Service Participation terms of the \href{https://aws.amazon.com/service-terms/}{Amazon Web Services Service Terms} (Section 1.10).*
#'
#' See [https://www.paws-r-sdk.com/docs/pricing_list_price_lists/](https://www.paws-r-sdk.com/docs/pricing_list_price_lists/) for full documentation.
#'
#' @param ServiceCode &#91;required&#93; The service code or the Savings Plan service code for the attributes
#' that you want to retrieve. For example, to get the list of applicable
#' Amazon EC2 price lists, use `AmazonEC2`. For a full list of service
#' codes containing On-Demand and Reserved Instance (RI) pricing, use the
#' [`describe_services`](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_DescribeServices.html#awscostmanagement-pricing_DescribeServices-request-FormatVersion)
#' API.
#' 
#' To retrieve the Compute Savings Plan price lists, use
#' `ComputeSavingsPlans`. To retrieve Machine Learning Savings Plans price
#' lists, use `MachineLearningSavingsPlans`.
#' @param EffectiveDate &#91;required&#93; The date that the Price List file prices are effective from.
#' @param RegionCode This is used to filter the Price List by Amazon Web Services Region. For
#' example, to get the price list only for the `US East (N. Virginia)`
#' Region, use `us-east-1`. If nothing is specified, you retrieve price
#' lists for all applicable Regions. The available `RegionCode` list can be
#' retrieved from
#' [`get_attribute_values`](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_GetAttributeValues.html)
#' API.
#' @param CurrencyCode &#91;required&#93; The three alphabetical character ISO-4217 currency code that the Price
#' List files are denominated in.
#' @param NextToken The pagination token that indicates the next set of results that you
#' want to retrieve.
#' @param MaxResults The maximum number of results to return in the response.
#'
#' @keywords internal
#'
#' @rdname pricing_list_price_lists
pricing_list_price_lists <- function(ServiceCode, EffectiveDate, RegionCode = NULL, CurrencyCode, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListPriceLists",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .pricing$list_price_lists_input(ServiceCode = ServiceCode, EffectiveDate = EffectiveDate, RegionCode = RegionCode, CurrencyCode = CurrencyCode, NextToken = NextToken, MaxResults = MaxResults)
  output <- .pricing$list_price_lists_output()
  config <- get_config()
  svc <- .pricing$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pricing$operations$list_price_lists <- pricing_list_price_lists
