# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include budgets_service.R
NULL

#' Creates a budget and, if included, notifications and subscribers
#'
#' @description
#' Creates a budget and, if included, notifications and subscribers.
#'
#' See [https://www.paws-r-sdk.com/docs/budgets_create_budget/](https://www.paws-r-sdk.com/docs/budgets_create_budget/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The `accountId` that is associated with the budget.
#' @param Budget &#91;required&#93; The budget object that you want to create.
#' @param NotificationsWithSubscribers A notification that you want to associate with a budget. A budget can
#' have up to five notifications, and each notification can have one SNS
#' subscriber and up to 10 email subscribers. If you include notifications
#' and subscribers in your [`create_budget`][budgets_create_budget] call,
#' Amazon Web Services creates the notifications and subscribers for you.
#'
#' @keywords internal
#'
#' @rdname budgets_create_budget
budgets_create_budget <- function(AccountId, Budget, NotificationsWithSubscribers = NULL) {
  op <- new_operation(
    name = "CreateBudget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .budgets$create_budget_input(AccountId = AccountId, Budget = Budget, NotificationsWithSubscribers = NotificationsWithSubscribers)
  output <- .budgets$create_budget_output()
  config <- get_config()
  svc <- .budgets$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$create_budget <- budgets_create_budget

#' Creates a budget action
#'
#' @description
#' Creates a budget action.
#'
#' See [https://www.paws-r-sdk.com/docs/budgets_create_budget_action/](https://www.paws-r-sdk.com/docs/budgets_create_budget_action/) for full documentation.
#'
#' @param AccountId &#91;required&#93; 
#' @param BudgetName &#91;required&#93; 
#' @param NotificationType &#91;required&#93; 
#' @param ActionType &#91;required&#93; The type of action. This defines the type of tasks that can be carried
#' out by this action. This field also determines the format for
#' definition.
#' @param ActionThreshold &#91;required&#93; 
#' @param Definition &#91;required&#93; 
#' @param ExecutionRoleArn &#91;required&#93; The role passed for action execution and reversion. Roles and actions
#' must be in the same account.
#' @param ApprovalModel &#91;required&#93; This specifies if the action needs manual or automatic approval.
#' @param Subscribers &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname budgets_create_budget_action
budgets_create_budget_action <- function(AccountId, BudgetName, NotificationType, ActionType, ActionThreshold, Definition, ExecutionRoleArn, ApprovalModel, Subscribers) {
  op <- new_operation(
    name = "CreateBudgetAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .budgets$create_budget_action_input(AccountId = AccountId, BudgetName = BudgetName, NotificationType = NotificationType, ActionType = ActionType, ActionThreshold = ActionThreshold, Definition = Definition, ExecutionRoleArn = ExecutionRoleArn, ApprovalModel = ApprovalModel, Subscribers = Subscribers)
  output <- .budgets$create_budget_action_output()
  config <- get_config()
  svc <- .budgets$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$create_budget_action <- budgets_create_budget_action

#' Creates a notification
#'
#' @description
#' Creates a notification. You must create the budget before you create the associated notification.
#'
#' See [https://www.paws-r-sdk.com/docs/budgets_create_notification/](https://www.paws-r-sdk.com/docs/budgets_create_notification/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The `accountId` that is associated with the budget that you want to
#' create a notification for.
#' @param BudgetName &#91;required&#93; The name of the budget that you want Amazon Web Services to notify you
#' about. Budget names must be unique within an account.
#' @param Notification &#91;required&#93; The notification that you want to create.
#' @param Subscribers &#91;required&#93; A list of subscribers that you want to associate with the notification.
#' Each notification can have one SNS subscriber and up to 10 email
#' subscribers.
#'
#' @keywords internal
#'
#' @rdname budgets_create_notification
budgets_create_notification <- function(AccountId, BudgetName, Notification, Subscribers) {
  op <- new_operation(
    name = "CreateNotification",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .budgets$create_notification_input(AccountId = AccountId, BudgetName = BudgetName, Notification = Notification, Subscribers = Subscribers)
  output <- .budgets$create_notification_output()
  config <- get_config()
  svc <- .budgets$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$create_notification <- budgets_create_notification

#' Creates a subscriber
#'
#' @description
#' Creates a subscriber. You must create the associated budget and notification before you create the subscriber.
#'
#' See [https://www.paws-r-sdk.com/docs/budgets_create_subscriber/](https://www.paws-r-sdk.com/docs/budgets_create_subscriber/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The `accountId` that is associated with the budget that you want to
#' create a subscriber for.
#' @param BudgetName &#91;required&#93; The name of the budget that you want to subscribe to. Budget names must
#' be unique within an account.
#' @param Notification &#91;required&#93; The notification that you want to create a subscriber for.
#' @param Subscriber &#91;required&#93; The subscriber that you want to associate with a budget notification.
#'
#' @keywords internal
#'
#' @rdname budgets_create_subscriber
budgets_create_subscriber <- function(AccountId, BudgetName, Notification, Subscriber) {
  op <- new_operation(
    name = "CreateSubscriber",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .budgets$create_subscriber_input(AccountId = AccountId, BudgetName = BudgetName, Notification = Notification, Subscriber = Subscriber)
  output <- .budgets$create_subscriber_output()
  config <- get_config()
  svc <- .budgets$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$create_subscriber <- budgets_create_subscriber

#' Deletes a budget
#'
#' @description
#' Deletes a budget. You can delete your budget at any time.
#'
#' See [https://www.paws-r-sdk.com/docs/budgets_delete_budget/](https://www.paws-r-sdk.com/docs/budgets_delete_budget/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The `accountId` that is associated with the budget that you want to
#' delete.
#' @param BudgetName &#91;required&#93; The name of the budget that you want to delete.
#'
#' @keywords internal
#'
#' @rdname budgets_delete_budget
budgets_delete_budget <- function(AccountId, BudgetName) {
  op <- new_operation(
    name = "DeleteBudget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .budgets$delete_budget_input(AccountId = AccountId, BudgetName = BudgetName)
  output <- .budgets$delete_budget_output()
  config <- get_config()
  svc <- .budgets$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$delete_budget <- budgets_delete_budget

#' Deletes a budget action
#'
#' @description
#' Deletes a budget action.
#'
#' See [https://www.paws-r-sdk.com/docs/budgets_delete_budget_action/](https://www.paws-r-sdk.com/docs/budgets_delete_budget_action/) for full documentation.
#'
#' @param AccountId &#91;required&#93; 
#' @param BudgetName &#91;required&#93; 
#' @param ActionId &#91;required&#93; A system-generated universally unique identifier (UUID) for the action.
#'
#' @keywords internal
#'
#' @rdname budgets_delete_budget_action
budgets_delete_budget_action <- function(AccountId, BudgetName, ActionId) {
  op <- new_operation(
    name = "DeleteBudgetAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .budgets$delete_budget_action_input(AccountId = AccountId, BudgetName = BudgetName, ActionId = ActionId)
  output <- .budgets$delete_budget_action_output()
  config <- get_config()
  svc <- .budgets$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$delete_budget_action <- budgets_delete_budget_action

#' Deletes a notification
#'
#' @description
#' Deletes a notification.
#'
#' See [https://www.paws-r-sdk.com/docs/budgets_delete_notification/](https://www.paws-r-sdk.com/docs/budgets_delete_notification/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The `accountId` that is associated with the budget whose notification
#' you want to delete.
#' @param BudgetName &#91;required&#93; The name of the budget whose notification you want to delete.
#' @param Notification &#91;required&#93; The notification that you want to delete.
#'
#' @keywords internal
#'
#' @rdname budgets_delete_notification
budgets_delete_notification <- function(AccountId, BudgetName, Notification) {
  op <- new_operation(
    name = "DeleteNotification",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .budgets$delete_notification_input(AccountId = AccountId, BudgetName = BudgetName, Notification = Notification)
  output <- .budgets$delete_notification_output()
  config <- get_config()
  svc <- .budgets$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$delete_notification <- budgets_delete_notification

#' Deletes a subscriber
#'
#' @description
#' Deletes a subscriber.
#'
#' See [https://www.paws-r-sdk.com/docs/budgets_delete_subscriber/](https://www.paws-r-sdk.com/docs/budgets_delete_subscriber/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The `accountId` that is associated with the budget whose subscriber you
#' want to delete.
#' @param BudgetName &#91;required&#93; The name of the budget whose subscriber you want to delete.
#' @param Notification &#91;required&#93; The notification whose subscriber you want to delete.
#' @param Subscriber &#91;required&#93; The subscriber that you want to delete.
#'
#' @keywords internal
#'
#' @rdname budgets_delete_subscriber
budgets_delete_subscriber <- function(AccountId, BudgetName, Notification, Subscriber) {
  op <- new_operation(
    name = "DeleteSubscriber",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .budgets$delete_subscriber_input(AccountId = AccountId, BudgetName = BudgetName, Notification = Notification, Subscriber = Subscriber)
  output <- .budgets$delete_subscriber_output()
  config <- get_config()
  svc <- .budgets$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$delete_subscriber <- budgets_delete_subscriber

#' Describes a budget
#'
#' @description
#' Describes a budget.
#'
#' See [https://www.paws-r-sdk.com/docs/budgets_describe_budget/](https://www.paws-r-sdk.com/docs/budgets_describe_budget/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The `accountId` that is associated with the budget that you want a
#' description of.
#' @param BudgetName &#91;required&#93; The name of the budget that you want a description of.
#'
#' @keywords internal
#'
#' @rdname budgets_describe_budget
budgets_describe_budget <- function(AccountId, BudgetName) {
  op <- new_operation(
    name = "DescribeBudget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .budgets$describe_budget_input(AccountId = AccountId, BudgetName = BudgetName)
  output <- .budgets$describe_budget_output()
  config <- get_config()
  svc <- .budgets$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$describe_budget <- budgets_describe_budget

#' Describes a budget action detail
#'
#' @description
#' Describes a budget action detail.
#'
#' See [https://www.paws-r-sdk.com/docs/budgets_describe_budget_action/](https://www.paws-r-sdk.com/docs/budgets_describe_budget_action/) for full documentation.
#'
#' @param AccountId &#91;required&#93; 
#' @param BudgetName &#91;required&#93; 
#' @param ActionId &#91;required&#93; A system-generated universally unique identifier (UUID) for the action.
#'
#' @keywords internal
#'
#' @rdname budgets_describe_budget_action
budgets_describe_budget_action <- function(AccountId, BudgetName, ActionId) {
  op <- new_operation(
    name = "DescribeBudgetAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .budgets$describe_budget_action_input(AccountId = AccountId, BudgetName = BudgetName, ActionId = ActionId)
  output <- .budgets$describe_budget_action_output()
  config <- get_config()
  svc <- .budgets$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$describe_budget_action <- budgets_describe_budget_action

#' Describes a budget action history detail
#'
#' @description
#' Describes a budget action history detail.
#'
#' See [https://www.paws-r-sdk.com/docs/budgets_describe_budget_action_histories/](https://www.paws-r-sdk.com/docs/budgets_describe_budget_action_histories/) for full documentation.
#'
#' @param AccountId &#91;required&#93; 
#' @param BudgetName &#91;required&#93; 
#' @param ActionId &#91;required&#93; A system-generated universally unique identifier (UUID) for the action.
#' @param TimePeriod 
#' @param MaxResults 
#' @param NextToken 
#'
#' @keywords internal
#'
#' @rdname budgets_describe_budget_action_histories
budgets_describe_budget_action_histories <- function(AccountId, BudgetName, ActionId, TimePeriod = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeBudgetActionHistories",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ActionHistories")
  )
  input <- .budgets$describe_budget_action_histories_input(AccountId = AccountId, BudgetName = BudgetName, ActionId = ActionId, TimePeriod = TimePeriod, MaxResults = MaxResults, NextToken = NextToken)
  output <- .budgets$describe_budget_action_histories_output()
  config <- get_config()
  svc <- .budgets$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$describe_budget_action_histories <- budgets_describe_budget_action_histories

#' Describes all of the budget actions for an account
#'
#' @description
#' Describes all of the budget actions for an account.
#'
#' See [https://www.paws-r-sdk.com/docs/budgets_describe_budget_actions_for_account/](https://www.paws-r-sdk.com/docs/budgets_describe_budget_actions_for_account/) for full documentation.
#'
#' @param AccountId &#91;required&#93; 
#' @param MaxResults 
#' @param NextToken 
#'
#' @keywords internal
#'
#' @rdname budgets_describe_budget_actions_for_account
budgets_describe_budget_actions_for_account <- function(AccountId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeBudgetActionsForAccount",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Actions")
  )
  input <- .budgets$describe_budget_actions_for_account_input(AccountId = AccountId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .budgets$describe_budget_actions_for_account_output()
  config <- get_config()
  svc <- .budgets$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$describe_budget_actions_for_account <- budgets_describe_budget_actions_for_account

#' Describes all of the budget actions for a budget
#'
#' @description
#' Describes all of the budget actions for a budget.
#'
#' See [https://www.paws-r-sdk.com/docs/budgets_describe_budget_actions_for_budget/](https://www.paws-r-sdk.com/docs/budgets_describe_budget_actions_for_budget/) for full documentation.
#'
#' @param AccountId &#91;required&#93; 
#' @param BudgetName &#91;required&#93; 
#' @param MaxResults 
#' @param NextToken 
#'
#' @keywords internal
#'
#' @rdname budgets_describe_budget_actions_for_budget
budgets_describe_budget_actions_for_budget <- function(AccountId, BudgetName, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeBudgetActionsForBudget",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Actions")
  )
  input <- .budgets$describe_budget_actions_for_budget_input(AccountId = AccountId, BudgetName = BudgetName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .budgets$describe_budget_actions_for_budget_output()
  config <- get_config()
  svc <- .budgets$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$describe_budget_actions_for_budget <- budgets_describe_budget_actions_for_budget

#' Lists the budget names and notifications that are associated with an
#' account
#'
#' @description
#' Lists the budget names and notifications that are associated with an account.
#'
#' See [https://www.paws-r-sdk.com/docs/budgets_describe_budget_notifications_for_account/](https://www.paws-r-sdk.com/docs/budgets_describe_budget_notifications_for_account/) for full documentation.
#'
#' @param AccountId &#91;required&#93; 
#' @param MaxResults An integer that shows how many budget name entries a paginated response
#' contains.
#' @param NextToken 
#'
#' @keywords internal
#'
#' @rdname budgets_describe_budget_notifications_for_account
budgets_describe_budget_notifications_for_account <- function(AccountId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeBudgetNotificationsForAccount",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "BudgetNotificationsForAccount")
  )
  input <- .budgets$describe_budget_notifications_for_account_input(AccountId = AccountId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .budgets$describe_budget_notifications_for_account_output()
  config <- get_config()
  svc <- .budgets$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$describe_budget_notifications_for_account <- budgets_describe_budget_notifications_for_account

#' Describes the history for DAILY, MONTHLY, and QUARTERLY budgets
#'
#' @description
#' Describes the history for `DAILY`, `MONTHLY`, and `QUARTERLY` budgets. Budget history isn't available for `ANNUAL` budgets.
#'
#' See [https://www.paws-r-sdk.com/docs/budgets_describe_budget_performance_history/](https://www.paws-r-sdk.com/docs/budgets_describe_budget_performance_history/) for full documentation.
#'
#' @param AccountId &#91;required&#93; 
#' @param BudgetName &#91;required&#93; 
#' @param TimePeriod Retrieves how often the budget went into an `ALARM` state for the
#' specified time period.
#' @param MaxResults 
#' @param NextToken 
#'
#' @keywords internal
#'
#' @rdname budgets_describe_budget_performance_history
budgets_describe_budget_performance_history <- function(AccountId, BudgetName, TimePeriod = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeBudgetPerformanceHistory",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "BudgetPerformanceHistory")
  )
  input <- .budgets$describe_budget_performance_history_input(AccountId = AccountId, BudgetName = BudgetName, TimePeriod = TimePeriod, MaxResults = MaxResults, NextToken = NextToken)
  output <- .budgets$describe_budget_performance_history_output()
  config <- get_config()
  svc <- .budgets$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$describe_budget_performance_history <- budgets_describe_budget_performance_history

#' Lists the budgets that are associated with an account
#'
#' @description
#' Lists the budgets that are associated with an account.
#'
#' See [https://www.paws-r-sdk.com/docs/budgets_describe_budgets/](https://www.paws-r-sdk.com/docs/budgets_describe_budgets/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The `accountId` that is associated with the budgets that you want
#' descriptions of.
#' @param MaxResults An optional integer that represents how many entries a paginated
#' response contains. The maximum is 100.
#' @param NextToken The pagination token that you include in your request to indicate the
#' next set of results that you want to retrieve.
#'
#' @keywords internal
#'
#' @rdname budgets_describe_budgets
budgets_describe_budgets <- function(AccountId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeBudgets",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Budgets")
  )
  input <- .budgets$describe_budgets_input(AccountId = AccountId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .budgets$describe_budgets_output()
  config <- get_config()
  svc <- .budgets$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$describe_budgets <- budgets_describe_budgets

#' Lists the notifications that are associated with a budget
#'
#' @description
#' Lists the notifications that are associated with a budget.
#'
#' See [https://www.paws-r-sdk.com/docs/budgets_describe_notifications_for_budget/](https://www.paws-r-sdk.com/docs/budgets_describe_notifications_for_budget/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The `accountId` that is associated with the budget whose notifications
#' you want descriptions of.
#' @param BudgetName &#91;required&#93; The name of the budget whose notifications you want descriptions of.
#' @param MaxResults An optional integer that represents how many entries a paginated
#' response contains. The maximum is 100.
#' @param NextToken The pagination token that you include in your request to indicate the
#' next set of results that you want to retrieve.
#'
#' @keywords internal
#'
#' @rdname budgets_describe_notifications_for_budget
budgets_describe_notifications_for_budget <- function(AccountId, BudgetName, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeNotificationsForBudget",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Notifications")
  )
  input <- .budgets$describe_notifications_for_budget_input(AccountId = AccountId, BudgetName = BudgetName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .budgets$describe_notifications_for_budget_output()
  config <- get_config()
  svc <- .budgets$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$describe_notifications_for_budget <- budgets_describe_notifications_for_budget

#' Lists the subscribers that are associated with a notification
#'
#' @description
#' Lists the subscribers that are associated with a notification.
#'
#' See [https://www.paws-r-sdk.com/docs/budgets_describe_subscribers_for_notification/](https://www.paws-r-sdk.com/docs/budgets_describe_subscribers_for_notification/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The `accountId` that is associated with the budget whose subscribers you
#' want descriptions of.
#' @param BudgetName &#91;required&#93; The name of the budget whose subscribers you want descriptions of.
#' @param Notification &#91;required&#93; The notification whose subscribers you want to list.
#' @param MaxResults An optional integer that represents how many entries a paginated
#' response contains. The maximum is 100.
#' @param NextToken The pagination token that you include in your request to indicate the
#' next set of results that you want to retrieve.
#'
#' @keywords internal
#'
#' @rdname budgets_describe_subscribers_for_notification
budgets_describe_subscribers_for_notification <- function(AccountId, BudgetName, Notification, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeSubscribersForNotification",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Subscribers")
  )
  input <- .budgets$describe_subscribers_for_notification_input(AccountId = AccountId, BudgetName = BudgetName, Notification = Notification, MaxResults = MaxResults, NextToken = NextToken)
  output <- .budgets$describe_subscribers_for_notification_output()
  config <- get_config()
  svc <- .budgets$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$describe_subscribers_for_notification <- budgets_describe_subscribers_for_notification

#' Executes a budget action
#'
#' @description
#' Executes a budget action.
#'
#' See [https://www.paws-r-sdk.com/docs/budgets_execute_budget_action/](https://www.paws-r-sdk.com/docs/budgets_execute_budget_action/) for full documentation.
#'
#' @param AccountId &#91;required&#93; 
#' @param BudgetName &#91;required&#93; 
#' @param ActionId &#91;required&#93; A system-generated universally unique identifier (UUID) for the action.
#' @param ExecutionType &#91;required&#93; The type of execution.
#'
#' @keywords internal
#'
#' @rdname budgets_execute_budget_action
budgets_execute_budget_action <- function(AccountId, BudgetName, ActionId, ExecutionType) {
  op <- new_operation(
    name = "ExecuteBudgetAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .budgets$execute_budget_action_input(AccountId = AccountId, BudgetName = BudgetName, ActionId = ActionId, ExecutionType = ExecutionType)
  output <- .budgets$execute_budget_action_output()
  config <- get_config()
  svc <- .budgets$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$execute_budget_action <- budgets_execute_budget_action

#' Updates a budget
#'
#' @description
#' Updates a budget. You can change every part of a budget except for the `budgetName` and the `calculatedSpend`. When you modify a budget, the `calculatedSpend` drops to zero until Amazon Web Services has new usage data to use for forecasting.
#'
#' See [https://www.paws-r-sdk.com/docs/budgets_update_budget/](https://www.paws-r-sdk.com/docs/budgets_update_budget/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The `accountId` that is associated with the budget that you want to
#' update.
#' @param NewBudget &#91;required&#93; The budget that you want to update your budget to.
#'
#' @keywords internal
#'
#' @rdname budgets_update_budget
budgets_update_budget <- function(AccountId, NewBudget) {
  op <- new_operation(
    name = "UpdateBudget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .budgets$update_budget_input(AccountId = AccountId, NewBudget = NewBudget)
  output <- .budgets$update_budget_output()
  config <- get_config()
  svc <- .budgets$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$update_budget <- budgets_update_budget

#' Updates a budget action
#'
#' @description
#' Updates a budget action.
#'
#' See [https://www.paws-r-sdk.com/docs/budgets_update_budget_action/](https://www.paws-r-sdk.com/docs/budgets_update_budget_action/) for full documentation.
#'
#' @param AccountId &#91;required&#93; 
#' @param BudgetName &#91;required&#93; 
#' @param ActionId &#91;required&#93; A system-generated universally unique identifier (UUID) for the action.
#' @param NotificationType 
#' @param ActionThreshold 
#' @param Definition 
#' @param ExecutionRoleArn The role passed for action execution and reversion. Roles and actions
#' must be in the same account.
#' @param ApprovalModel This specifies if the action needs manual or automatic approval.
#' @param Subscribers 
#'
#' @keywords internal
#'
#' @rdname budgets_update_budget_action
budgets_update_budget_action <- function(AccountId, BudgetName, ActionId, NotificationType = NULL, ActionThreshold = NULL, Definition = NULL, ExecutionRoleArn = NULL, ApprovalModel = NULL, Subscribers = NULL) {
  op <- new_operation(
    name = "UpdateBudgetAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .budgets$update_budget_action_input(AccountId = AccountId, BudgetName = BudgetName, ActionId = ActionId, NotificationType = NotificationType, ActionThreshold = ActionThreshold, Definition = Definition, ExecutionRoleArn = ExecutionRoleArn, ApprovalModel = ApprovalModel, Subscribers = Subscribers)
  output <- .budgets$update_budget_action_output()
  config <- get_config()
  svc <- .budgets$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$update_budget_action <- budgets_update_budget_action

#' Updates a notification
#'
#' @description
#' Updates a notification.
#'
#' See [https://www.paws-r-sdk.com/docs/budgets_update_notification/](https://www.paws-r-sdk.com/docs/budgets_update_notification/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The `accountId` that is associated with the budget whose notification
#' you want to update.
#' @param BudgetName &#91;required&#93; The name of the budget whose notification you want to update.
#' @param OldNotification &#91;required&#93; The previous notification that is associated with a budget.
#' @param NewNotification &#91;required&#93; The updated notification to be associated with a budget.
#'
#' @keywords internal
#'
#' @rdname budgets_update_notification
budgets_update_notification <- function(AccountId, BudgetName, OldNotification, NewNotification) {
  op <- new_operation(
    name = "UpdateNotification",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .budgets$update_notification_input(AccountId = AccountId, BudgetName = BudgetName, OldNotification = OldNotification, NewNotification = NewNotification)
  output <- .budgets$update_notification_output()
  config <- get_config()
  svc <- .budgets$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$update_notification <- budgets_update_notification

#' Updates a subscriber
#'
#' @description
#' Updates a subscriber.
#'
#' See [https://www.paws-r-sdk.com/docs/budgets_update_subscriber/](https://www.paws-r-sdk.com/docs/budgets_update_subscriber/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The `accountId` that is associated with the budget whose subscriber you
#' want to update.
#' @param BudgetName &#91;required&#93; The name of the budget whose subscriber you want to update.
#' @param Notification &#91;required&#93; The notification whose subscriber you want to update.
#' @param OldSubscriber &#91;required&#93; The previous subscriber that is associated with a budget notification.
#' @param NewSubscriber &#91;required&#93; The updated subscriber that is associated with a budget notification.
#'
#' @keywords internal
#'
#' @rdname budgets_update_subscriber
budgets_update_subscriber <- function(AccountId, BudgetName, Notification, OldSubscriber, NewSubscriber) {
  op <- new_operation(
    name = "UpdateSubscriber",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .budgets$update_subscriber_input(AccountId = AccountId, BudgetName = BudgetName, Notification = Notification, OldSubscriber = OldSubscriber, NewSubscriber = NewSubscriber)
  output <- .budgets$update_subscriber_output()
  config <- get_config()
  svc <- .budgets$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$update_subscriber <- budgets_update_subscriber
