% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paymentcryptographycontrolplane_operations.R
\name{paymentcryptographycontrolplane_import_key}
\alias{paymentcryptographycontrolplane_import_key}
\title{Imports symmetric keys and public key certificates in PEM format (base64
encoded) into Amazon Web Services Payment Cryptography}
\usage{
paymentcryptographycontrolplane_import_key(
  Enabled = NULL,
  KeyCheckValueAlgorithm = NULL,
  KeyMaterial,
  Tags = NULL
)
}
\arguments{
\item{Enabled}{Specifies whether import key is enabled.}

\item{KeyCheckValueAlgorithm}{The algorithm that Amazon Web Services Payment Cryptography uses to
calculate the key check value (KCV). It is used to validate the key
integrity.

For TDES keys, the KCV is computed by encrypting 8 bytes, each with
value of zero, with the key to be checked and retaining the 3 highest
order bytes of the encrypted result. For AES keys, the KCV is computed
using a CMAC algorithm where the input data is 16 bytes of zero and
retaining the 3 highest order bytes of the encrypted result.}

\item{KeyMaterial}{[required] The key or public key certificate type to use during key material
import, for example TR-34 or RootCertificatePublicKey.}

\item{Tags}{Assigns one or more tags to the Amazon Web Services Payment Cryptography
key. Use this parameter to tag a key when it is imported. To tag an
existing Amazon Web Services Payment Cryptography key, use the
\code{\link[=paymentcryptographycontrolplane_tag_resource]{tag_resource}}
operation.

Each tag consists of a tag key and a tag value. Both the tag key and the
tag value are required, but the tag value can be an empty (null) string.
You can't have more than one tag on an Amazon Web Services Payment
Cryptography key with the same tag key. If you specify an existing tag
key with a different tag value, Amazon Web Services Payment Cryptography
replaces the current tag value with the specified one.

Don't include personal, confidential or sensitive information in this
field. This field may be displayed in plaintext in CloudTrail logs and
other output.

Tagging or untagging an Amazon Web Services Payment Cryptography key can
allow or deny permission to the key.}
}
\description{
Imports symmetric keys and public key certificates in PEM format (base64 encoded) into Amazon Web Services Payment Cryptography.

See \url{https://www.paws-r-sdk.com/docs/paymentcryptographycontrolplane_import_key/} for full documentation.
}
\keyword{internal}
