% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/billingconductor_operations.R
\name{billingconductor_list_pricing_plans}
\alias{billingconductor_list_pricing_plans}
\title{A paginated call to get pricing plans for the given billing period}
\usage{
billingconductor_list_pricing_plans(
  BillingPeriod = NULL,
  Filters = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{BillingPeriod}{The preferred billing period to get pricing plan.}

\item{Filters}{A \code{ListPricingPlansFilter} that specifies the Amazon Resource Name
(ARNs) of pricing plans to retrieve pricing plans information.}

\item{MaxResults}{The maximum number of pricing plans to retrieve.}

\item{NextToken}{The pagination token that's used on subsequent call to get pricing
plans.}
}
\description{
A paginated call to get pricing plans for the given billing period. If you don't provide a billing period, the current billing period is used.

See \url{https://www.paws-r-sdk.com/docs/billingconductor_list_pricing_plans/} for full documentation.
}
\keyword{internal}
