% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costexplorer_operations.R
\name{costexplorer_get_savings_plans_utilization_details}
\alias{costexplorer_get_savings_plans_utilization_details}
\title{Retrieves attribute data along with aggregate utilization and savings
data for a given time period}
\usage{
costexplorer_get_savings_plans_utilization_details(
  TimePeriod,
  Filter = NULL,
  DataType = NULL,
  NextToken = NULL,
  MaxResults = NULL,
  SortBy = NULL
)
}
\arguments{
\item{TimePeriod}{[required] The time period that you want the usage and costs for. The \code{Start} date
must be within 13 months. The \code{End} date must be after the \code{Start} date,
and before the current date. Future dates can't be used as an \code{End}
date.}

\item{Filter}{Filters Savings Plans utilization coverage data for active Savings Plans
dimensions. You can filter data with the following dimensions:
\itemize{
\item \code{LINKED_ACCOUNT}
\item \code{SAVINGS_PLAN_ARN}
\item \code{REGION}
\item \code{PAYMENT_OPTION}
\item \code{INSTANCE_TYPE_FAMILY}
}

\code{\link[=costexplorer_get_savings_plans_utilization_details]{get_savings_plans_utilization_details}}
uses the same
\href{https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html}{Expression}
object as the other operations, but only \code{AND} is supported among each
dimension.}

\item{DataType}{The data type.}

\item{NextToken}{The token to retrieve the next set of results. Amazon Web Services
provides the token when the response from a previous call has more
results than the maximum page size.}

\item{MaxResults}{The number of items to be returned in a response. The default is \code{20},
with a minimum value of \code{1}.}

\item{SortBy}{The value that you want to sort the data by.

The following values are supported for \code{Key}:
\itemize{
\item \code{UtilizationPercentage}
\item \code{TotalCommitment}
\item \code{UsedCommitment}
\item \code{UnusedCommitment}
\item \code{NetSavings}
\item \code{AmortizedRecurringCommitment}
\item \code{AmortizedUpfrontCommitment}
}

The supported values for \code{SortOrder} are \code{ASCENDING} and \code{DESCENDING}.}
}
\description{
Retrieves attribute data along with aggregate utilization and savings data for a given time period. This doesn't support granular or grouped data (daily/monthly) in response. You can't retrieve data by dates in a single response similar to \code{GetSavingsPlanUtilization}, but you have the option to make multiple calls to \code{GetSavingsPlanUtilizationDetails} by providing individual dates. You can use \code{\link[=costexplorer_get_dimension_values]{get_dimension_values}} in \code{SAVINGS_PLANS} to determine the possible dimension values.

See \url{https://www.paws-r-sdk.com/docs/costexplorer_get_savings_plans_utilization_details/} for full documentation.
}
\keyword{internal}
