% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_list_prompts}
\alias{connect_list_prompts}
\title{Provides information about the prompts for the specified Amazon Connect
instance}
\usage{
connect_list_prompts(InstanceId, NextToken, MaxResults)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance.}

\item{NextToken}{The token for the next set of results. Use the value returned in the
previous response in the next request to retrieve the next set of
results.}

\item{MaxResults}{The maximum number of results to return per page.}
}
\value{
A list with the following syntax:\preformatted{list(
  PromptSummaryList = list(
    list(
      Id = "string",
      Arn = "string",
      Name = "string"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Provides information about the prompts for the specified Amazon Connect
instance.
}
\section{Request syntax}{
\preformatted{svc$list_prompts(
  InstanceId = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
