% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_list_configuration_sets}
\alias{ses_list_configuration_sets}
\title{Provides a list of the configuration sets associated with your Amazon
SES account in the current AWS Region}
\usage{
ses_list_configuration_sets(NextToken, MaxItems)
}
\arguments{
\item{NextToken}{A token returned from a previous call to \code{ListConfigurationSets} to
indicate the position of the configuration set in the configuration set
list.}

\item{MaxItems}{The number of configuration sets to return.}
}
\description{
Provides a list of the configuration sets associated with your Amazon
SES account in the current AWS Region. For information about using
configuration sets, see \href{https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html}{Monitoring Your Amazon SES Sending Activity}
in the \emph{Amazon SES Developer Guide.}
}
\details{
You can execute this operation no more than once per second. This
operation will return up to 1,000 configuration sets each time it is
run. If your Amazon SES account has more than 1,000 configuration sets,
this operation will also return a NextToken element. You can then
execute the \code{ListConfigurationSets} operation again, passing the
\code{NextToken} parameter and the value of the NextToken element to retrieve
additional results.
}
\section{Request syntax}{
\preformatted{svc$list_configuration_sets(
  NextToken = "string",
  MaxItems = 123
)
}
}

\keyword{internal}
