% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_get_metric_data_v2}
\alias{connect_get_metric_data_v2}
\title{Gets metric data from the specified Amazon Connect instance}
\usage{
connect_get_metric_data_v2(
  ResourceArn,
  StartTime,
  EndTime,
  Filters,
  Groupings = NULL,
  Metrics,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the resource. This includes the
\code{instanceId} an Amazon Connect instance.}

\item{StartTime}{[required] The timestamp, in UNIX Epoch time format, at which to start the
reporting interval for the retrieval of historical metrics data. The
time must be before the end time timestamp. The time range between the
start and end time must be less than 24 hours. The start time cannot be
earlier than 35 days before the time of the request. Historical metrics
are available for 35 days.}

\item{EndTime}{[required] The timestamp, in UNIX Epoch time format, at which to end the reporting
interval for the retrieval of historical metrics data. The time must be
later than the start time timestamp. It cannot be later than the current
timestamp.

The time range between the start and end time must be less than 24
hours.}

\item{Filters}{[required] The filters to apply to returned metrics. You can filter on the
following resources:
\itemize{
\item Queues
\item Routing profiles
\item Agents
\item Channels
\item User hierarchy groups
\item Feature
}

At least one filter must be passed from queues, routing profiles,
agents, or user hierarchy groups.

To filter by phone number, see \href{https://docs.aws.amazon.com/connect/latest/adminguide/create-historical-metrics-report.html}{Create a historical metrics report}
in the \emph{Amazon Connect Administrator's Guide}.

Note the following limits:
\itemize{
\item \strong{Filter keys}: A maximum of 5 filter keys are supported in a
single request. Valid filter keys: \code{QUEUE} | \code{ROUTING_PROFILE} |
\code{AGENT} | \code{CHANNEL} | \code{AGENT_HIERARCHY_LEVEL_ONE} |
\code{AGENT_HIERARCHY_LEVEL_TWO} | \code{AGENT_HIERARCHY_LEVEL_THREE} |
\code{AGENT_HIERARCHY_LEVEL_FOUR} | \code{AGENT_HIERARCHY_LEVEL_FIVE} |
\code{FEATURE}
\item \strong{Filter values}: A maximum of 100 filter values are supported in a
single request. VOICE, CHAT, and TASK are valid \code{filterValue} for
the CHANNEL filter key. They do not count towards limitation of 100
filter values. For example, a GetMetricDataV2 request can filter by
50 queues, 35 agents, and 15 routing profiles for a total of 100
filter values, along with 3 channel filters.

\code{contact_lens_conversational_analytics} is a valid filterValue for
the \code{FEATURE} filter key. It is available only to contacts analyzed
by Contact Lens conversational analytics.
}}

\item{Groupings}{The grouping applied to the metrics that are returned. For example, when
results are grouped by queue, the metrics returned are grouped by queue.
The values that are returned apply to the metrics for each queue. They
are not aggregated for all queues.

If no grouping is specified, a summary of all metrics is returned.

Valid grouping keys: \code{QUEUE} | \code{ROUTING_PROFILE} | \code{AGENT} | \code{CHANNEL} |
\code{AGENT_HIERARCHY_LEVEL_ONE} | \code{AGENT_HIERARCHY_LEVEL_TWO} |
\code{AGENT_HIERARCHY_LEVEL_THREE} | \code{AGENT_HIERARCHY_LEVEL_FOUR} |
\code{AGENT_HIERARCHY_LEVEL_FIVE}}

\item{Metrics}{[required] The metrics to retrieve. Specify the name, groupings, and filters for
each metric. The following historical metrics are available. For a
description of each metric, see \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html}{Historical metrics definitions}
in the \emph{Amazon Connect Administrator's Guide}.

\strong{AGENT_ADHERENT_TIME}

This metric is available only in Amazon Web Services Regions where
\href{https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region}{Forecasting, capacity planning, and scheduling}
is available.

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{AGENT_NON_RESPONSE}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{AGENT_OCCUPANCY}

Unit: Percentage

Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy

\strong{AGENT_SCHEDULE_ADHERENCE}

This metric is available only in Amazon Web Services Regions where
\href{https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region}{Forecasting, capacity planning, and scheduling}
is available.

Unit: Percent

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{AGENT_SCHEDULED_TIME}

This metric is available only in Amazon Web Services Regions where
\href{https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region}{Forecasting, capacity planning, and scheduling}
is available.

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{AVG_ABANDON_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{AVG_AFTER_CONTACT_WORK_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature

Feature is a valid filter but not a valid grouping.

\strong{AVG_AGENT_CONNECTING_TIME}

Unit: Seconds

Valid metric filter key: \code{INITIATION_METHOD}. For now, this metric only
supports the following as \code{INITIATION_METHOD}: \code{INBOUND} | \code{OUTBOUND} |
\code{CALLBACK} | \code{API}

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{AVG_AGENT_CONNECTING_TIME}

Unit: Seconds

Valid metric filter key: \code{INITIATION_METHOD}. For now, this metric only
supports the following as \code{INITIATION_METHOD}: \code{INBOUND} | \code{OUTBOUND} |
\code{CALLBACK} | \code{API}

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{AVG_CONTACT_DURATION}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature

Feature is a valid filter but not a valid grouping.

\strong{AVG_CONVERSATION_DURATION}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{AVG_GREETING_TIME_AGENT}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{AVG_HANDLE_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature

Feature is a valid filter but not a valid grouping.

\strong{AVG_HOLD_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature

Feature is a valid filter but not a valid grouping.

\strong{AVG_HOLDS}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature

Feature is a valid filter but not a valid grouping.

\strong{AVG_INTERACTION_AND_HOLD_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{AVG_INTERACTION_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Feature

Feature is a valid filter but not a valid grouping.

\strong{AVG_INTERRUPTIONS_AGENT}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{AVG_INTERRUPTION_TIME_AGENT}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{AVG_NON_TALK_TIME}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{AVG_QUEUE_ANSWER_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Feature

Feature is a valid filter but not a valid grouping.

\strong{AVG_TALK_TIME}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{AVG_TALK_TIME_AGENT}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{AVG_TALK_TIME_CUSTOMER}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{CONTACTS_ABANDONED}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{CONTACTS_CREATED}

Unit: Count

Valid metric filter key: \code{INITIATION_METHOD}

Valid groupings and filters: Queue, Channel, Routing Profile, Feature

Feature is a valid filter but not a valid grouping.

\strong{CONTACTS_HANDLED}

Unit: Count

Valid metric filter key: \code{INITIATION_METHOD}, \code{DISCONNECT_REASON}

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature

Feature is a valid filter but not a valid grouping.

\strong{CONTACTS_HOLD_ABANDONS}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{CONTACTS_QUEUED}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{CONTACTS_TRANSFERRED_OUT}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature

Feature is a valid filter but not a valid grouping.

\strong{CONTACTS_TRANSFERRED_OUT_BY_AGENT}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{CONTACTS_TRANSFERRED_OUT_FROM_QUEUE}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{MAX_QUEUED_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{SERVICE_LEVEL}

You can include up to 20 SERVICE_LEVEL metrics in a request.

Unit: Percent

Valid groupings and filters: Queue, Channel, Routing Profile

Threshold: For \code{ThresholdValue}, enter any whole number from 1 to 604800
(inclusive), in seconds. For \code{Comparison}, you must enter \code{LT} (for
"Less than").

\strong{SUM_CONTACTS_ANSWERED_IN_X}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile

Threshold: For \code{ThresholdValue}, enter any whole number from 1 to 604800
(inclusive), in seconds. For \code{Comparison}, you must enter \code{LT} (for
"Less than").

\strong{SUM_CONTACTS_ABANDONED_IN_X}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile

Threshold: For \code{ThresholdValue}, enter any whole number from 1 to 604800
(inclusive), in seconds. For \code{Comparison}, you must enter \code{LT} (for
"Less than").

\strong{SUM_CONTACTS_DISCONNECTED}

Valid metric filter key: \code{DISCONNECT_REASON}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile

\strong{SUM_RETRY_CALLBACK_ATTEMPTS}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile}

\item{NextToken}{The token for the next set of results. Use the value returned in the
previous response in the next request to retrieve the next set of
results.}

\item{MaxResults}{The maximum number of results to return per page.}
}
\description{
Gets metric data from the specified Amazon Connect instance.

See \url{https://www.paws-r-sdk.com/docs/connect_get_metric_data_v2/} for full documentation.
}
\keyword{internal}
