% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_db_security_groups}
\alias{rds_describe_db_security_groups}
\title{Returns a list of DBSecurityGroup descriptions}
\usage{
rds_describe_db_security_groups(DBSecurityGroupName, Filters,
  MaxRecords, Marker)
}
\arguments{
\item{DBSecurityGroupName}{The name of the DB security group to return details for.}

\item{Filters}{This parameter isn't currently supported.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so that you can retrieve the
remaining results.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous
\code{DescribeDBSecurityGroups} request. If this parameter is specified, the
response includes only records beyond the marker, up to the value
specified by \code{MaxRecords}.}
}
\description{
Returns a list of \code{DBSecurityGroup} descriptions. If a
\code{DBSecurityGroupName} is specified, the list will contain only the
descriptions of the specified DB security group.
}
\section{Request syntax}{
\preformatted{svc$describe_db_security_groups(
  DBSecurityGroupName = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxRecords = 123,
  Marker = "string"
)
}
}

\keyword{internal}
