% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_describe_resize}
\alias{redshift_describe_resize}
\title{Returns information about the last resize operation for the specified
cluster}
\usage{
redshift_describe_resize(ClusterIdentifier)
}
\arguments{
\item{ClusterIdentifier}{[required] The unique identifier of a cluster whose resize progress you are
requesting. This parameter is case-sensitive.

By default, resize operations for all clusters defined for an AWS
account are returned.}
}
\description{
Returns information about the last resize operation for the specified
cluster. If no resize operation has ever been initiated for the
specified cluster, a \verb{HTTP 404} error is returned. If a resize operation
was initiated and completed, the status of the resize remains as
\code{SUCCEEDED} until the next resize.

A resize operation can be requested using ModifyCluster and specifying a
different number or type of nodes for the cluster.
}
\section{Request syntax}{
\preformatted{svc$describe_resize(
  ClusterIdentifier = "string"
)
}
}

\keyword{internal}
