% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdb_operations.R
\name{docdb_describe_events}
\alias{docdb_describe_events}
\title{Returns events related to instances, security groups, snapshots, and DB
parameter groups for the past 14 days}
\usage{
docdb_describe_events(SourceIdentifier, SourceType, StartTime, EndTime,
  Duration, EventCategories, Filters, MaxRecords, Marker)
}
\arguments{
\item{SourceIdentifier}{The identifier of the event source for which events are returned. If not
specified, then all sources are included in the response.

Constraints:
\itemize{
\item If \code{SourceIdentifier} is provided, \code{SourceType} must also be
provided.
\item If the source type is \code{DBInstance}, a \code{DBInstanceIdentifier} must be
provided.
\item If the source type is \code{DBSecurityGroup}, a \code{DBSecurityGroupName}
must be provided.
\item If the source type is \code{DBParameterGroup}, a \code{DBParameterGroupName}
must be provided.
\item If the source type is \code{DBSnapshot}, a \code{DBSnapshotIdentifier} must be
provided.
\item Cannot end with a hyphen or contain two consecutive hyphens.
}}

\item{SourceType}{The event source to retrieve events for. If no value is specified, all
events are returned.}

\item{StartTime}{The beginning of the time interval to retrieve events for, specified in
ISO 8601 format.

Example: 2009-07-08T18:00Z}

\item{EndTime}{The end of the time interval for which to retrieve events, specified in
ISO 8601 format.

Example: 2009-07-08T18:00Z}

\item{Duration}{The number of minutes to retrieve events for.

Default: 60}

\item{EventCategories}{A list of event categories that trigger notifications for an event
notification subscription.}

\item{Filters}{This parameter is not currently supported.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
(marker) is included in the response so that the remaining results can
be retrieved.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous request. If this
parameter is specified, the response includes only records beyond the
marker, up to the value specified by \code{MaxRecords}.}
}
\value{
A list with the following syntax:\preformatted{list(
  Marker = "string",
  Events = list(
    list(
      SourceIdentifier = "string",
      SourceType = "db-instance"|"db-parameter-group"|"db-security-group"|"db-snapshot"|"db-cluster"|"db-cluster-snapshot",
      Message = "string",
      EventCategories = list(
        "string"
      ),
      Date = as.POSIXct(
        "2015-01-01"
      ),
      SourceArn = "string"
    )
  )
)
}
}
\description{
Returns events related to instances, security groups, snapshots, and DB
parameter groups for the past 14 days. You can obtain events specific to
a particular DB instance, security group, snapshot, or parameter group
by providing the name as a parameter. By default, the events of the past
hour are returned.
}
\section{Request syntax}{
\preformatted{svc$describe_events(
  SourceIdentifier = "string",
  SourceType = "db-instance"|"db-parameter-group"|"db-security-group"|"db-snapshot"|"db-cluster"|"db-cluster-snapshot",
  StartTime = as.POSIXct(
    "2015-01-01"
  ),
  EndTime = as.POSIXct(
    "2015-01-01"
  ),
  Duration = 123,
  EventCategories = list(
    "string"
  ),
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxRecords = 123,
  Marker = "string"
)
}
}

\keyword{internal}
