% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_cancel_resize}
\alias{redshift_cancel_resize}
\title{Cancels a resize operation for a cluster}
\usage{
redshift_cancel_resize(ClusterIdentifier)
}
\arguments{
\item{ClusterIdentifier}{[required] The unique identifier for the cluster that you want to cancel a resize
operation for.}
}
\value{
A list with the following syntax:\preformatted{list(
  TargetNodeType = "string",
  TargetNumberOfNodes = 123,
  TargetClusterType = "string",
  Status = "string",
  ImportTablesCompleted = list(
    "string"
  ),
  ImportTablesInProgress = list(
    "string"
  ),
  ImportTablesNotStarted = list(
    "string"
  ),
  AvgResizeRateInMegaBytesPerSecond = 123.0,
  TotalResizeDataInMegaBytes = 123,
  ProgressInMegaBytes = 123,
  ElapsedTimeInSeconds = 123,
  EstimatedTimeToCompletionInSeconds = 123,
  ResizeType = "string",
  Message = "string",
  TargetEncryptionType = "string",
  DataTransferProgressPercent = 123.0
)
}
}
\description{
Cancels a resize operation for a cluster.
}
\section{Request syntax}{
\preformatted{svc$cancel_resize(
  ClusterIdentifier = "string"
)
}
}

\keyword{internal}
