% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpledb_operations.R
\name{simpledb_select}
\alias{simpledb_select}
\title{The Select operation returns a set of attributes for ItemNames that
match the select expression}
\usage{
simpledb_select(SelectExpression, NextToken, ConsistentRead)
}
\arguments{
\item{SelectExpression}{[required] The expression used to query the domain.}

\item{NextToken}{A string informing Amazon SimpleDB where to start the next list of <code>ItemNames</code>.}

\item{ConsistentRead}{Determines whether or not strong consistency should be enforced when data is read from SimpleDB. If <code>true</code>, any data previously written to SimpleDB will be returned. Otherwise, results will be consistent eventually, and the client may not see data that was written immediately before your read.}
}
\description{
The \code{Select} operation returns a set of attributes for \code{ItemNames} that
match the select expression. \code{Select} is similar to the standard SQL
SELECT statement.
}
\details{
The total size of the response cannot exceed 1 MB in total size. Amazon
SimpleDB automatically adjusts the number of items returned per page to
enforce this limit. For example, if the client asks to retrieve 2500
items, but each individual item is 10 kB in size, the system returns 100
items and an appropriate \code{NextToken} so the client can access the next
page of results.

For information on how to construct select expressions, see Using Select
to Create Amazon SimpleDB Queries in the Developer Guide.
}
\section{Request syntax}{
\preformatted{svc$select(
  SelectExpression = "string",
  NextToken = "string",
  ConsistentRead = TRUE|FALSE
)
}
}

\keyword{internal}
