% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_create_db_subnet_group}
\alias{neptune_create_db_subnet_group}
\title{Creates a new DB subnet group}
\usage{
neptune_create_db_subnet_group(DBSubnetGroupName,
  DBSubnetGroupDescription, SubnetIds, Tags)
}
\arguments{
\item{DBSubnetGroupName}{[required] The name for the DB subnet group. This value is stored as a lowercase
string.

Constraints: Must contain no more than 255 letters, numbers, periods,
underscores, spaces, or hyphens. Must not be default.

Example: \code{mySubnetgroup}}

\item{DBSubnetGroupDescription}{[required] The description for the DB subnet group.}

\item{SubnetIds}{[required] The EC2 Subnet IDs for the DB subnet group.}

\item{Tags}{The tags to be assigned to the new DB subnet group.}
}
\description{
Creates a new DB subnet group. DB subnet groups must contain at least
one subnet in at least two AZs in the AWS Region.
}
\section{Request syntax}{
\preformatted{svc$create_db_subnet_group(
  DBSubnetGroupName = "string",
  DBSubnetGroupDescription = "string",
  SubnetIds = list(
    "string"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
