% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_create_global_cluster}
\alias{rds_create_global_cluster}
\title{Creates an Aurora global database spread across multiple regions}
\usage{
rds_create_global_cluster(GlobalClusterIdentifier,
  SourceDBClusterIdentifier, Engine, EngineVersion, DeletionProtection,
  DatabaseName, StorageEncrypted)
}
\arguments{
\item{GlobalClusterIdentifier}{The cluster identifier of the new global database cluster.}

\item{SourceDBClusterIdentifier}{The Amazon Resource Name (ARN) to use as the primary cluster of the
global database. This parameter is optional.}

\item{Engine}{Provides the name of the database engine to be used for this DB cluster.}

\item{EngineVersion}{The engine version of the Aurora global database.}

\item{DeletionProtection}{The deletion protection setting for the new global database. The global
database can\'t be deleted when deletion protection is enabled.}

\item{DatabaseName}{The name for your database of up to 64 alpha-numeric characters. If you
do not provide a name, Amazon Aurora will not create a database in the
global database cluster you are creating.}

\item{StorageEncrypted}{The storage encryption setting for the new global database cluster.}
}
\description{
Creates an Aurora global database spread across multiple regions. The
global database contains a single primary cluster with read-write
capability, and a read-only secondary cluster that receives data from
the primary cluster through high-speed replication performed by the
Aurora storage subsystem.
}
\details{
You can create a global database that is initially empty, and then add a
primary cluster and a secondary cluster to it. Or you can specify an
existing Aurora cluster during the create operation, and this cluster
becomes the primary cluster of the global database.

This action only applies to Aurora DB clusters.
}
\section{Request syntax}{
\preformatted{svc$create_global_cluster(
  GlobalClusterIdentifier = "string",
  SourceDBClusterIdentifier = "string",
  Engine = "string",
  EngineVersion = "string",
  DeletionProtection = TRUE|FALSE,
  DatabaseName = "string",
  StorageEncrypted = TRUE|FALSE
)
}
}

\keyword{internal}
