% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_installation_media}
\alias{rds_describe_installation_media}
\title{Describes the available installation media for a DB engine that requires
an on-premises customer provided license, such as Microsoft SQL Server}
\usage{
rds_describe_installation_media(InstallationMediaId, Filters,
  MaxRecords, Marker)
}
\arguments{
\item{InstallationMediaId}{The installation medium ID.}

\item{Filters}{A filter that specifies one or more installation media to describe.
Supported filters include the following:
\itemize{
\item \code{custom-availability-zone-id} - Accepts custom Availability Zone
(AZ) identifiers. The results list includes information about only
the custom AZs identified by these identifiers.
\item \code{engine} - Accepts database engines. The results list includes
information about only the database engines identified by these
identifiers.

For more information about the valid engines for installation media,
see ImportInstallationMedia.
}}

\item{MaxRecords}{An optional pagination token provided by a previous
DescribeInstallationMedia request. If this parameter is specified, the
response includes only records beyond the marker, up to the value
specified by \code{MaxRecords}.}

\item{Marker}{An optional pagination token provided by a previous request. If this
parameter is specified, the response includes only records beyond the
marker, up to the value specified by \code{MaxRecords}.}
}
\description{
Describes the available installation media for a DB engine that requires
an on-premises customer provided license, such as Microsoft SQL Server.
}
\section{Request syntax}{
\preformatted{svc$describe_installation_media(
  InstallationMediaId = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxRecords = 123,
  Marker = "string"
)
}
}

\keyword{internal}
