% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_copy_option_group}
\alias{rds_copy_option_group}
\title{Copies the specified option group}
\usage{
rds_copy_option_group(SourceOptionGroupIdentifier,
  TargetOptionGroupIdentifier, TargetOptionGroupDescription, Tags)
}
\arguments{
\item{SourceOptionGroupIdentifier}{[required] The identifier or ARN for the source option group. For information about
creating an ARN, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing}{Constructing an ARN for Amazon RDS}
in the \emph{Amazon RDS User Guide}.

Constraints:
\itemize{
\item Must specify a valid option group.
\item If the source option group is in the same AWS Region as the copy,
specify a valid option group identifier, for example
\code{my-option-group}, or a valid ARN.
\item If the source option group is in a different AWS Region than the
copy, specify a valid option group ARN, for example
\code{arn:aws:rds:us-west-2:123456789012:og:special-options}.
}}

\item{TargetOptionGroupIdentifier}{[required] The identifier for the copied option group.

Constraints:
\itemize{
\item Can\'t be null, empty, or blank
\item Must contain from 1 to 255 letters, numbers, or hyphens
\item First character must be a letter
\item Can\'t end with a hyphen or contain two consecutive hyphens
}

Example: \code{my-option-group}}

\item{TargetOptionGroupDescription}{[required] The description for the copied option group.}

\item{Tags}{}
}
\description{
Copies the specified option group.
}
\section{Request syntax}{
\preformatted{svc$copy_option_group(
  SourceOptionGroupIdentifier = "string",
  TargetOptionGroupIdentifier = "string",
  TargetOptionGroupDescription = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
