% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_describe_usage_limits}
\alias{redshift_describe_usage_limits}
\title{Shows usage limits on a cluster}
\usage{
redshift_describe_usage_limits(UsageLimitId, ClusterIdentifier,
  FeatureType, MaxRecords, Marker, TagKeys, TagValues)
}
\arguments{
\item{UsageLimitId}{The identifier of the usage limit to describe.}

\item{ClusterIdentifier}{The identifier of the cluster for which you want to describe usage
limits.}

\item{FeatureType}{The feature type for which you want to describe usage limits.}

\item{MaxRecords}{The maximum number of response records to return in each call. If the
number of remaining response records exceeds the specified \code{MaxRecords}
value, a value is returned in a \code{marker} field of the response. You can
retrieve the next set of records by retrying the command with the
returned marker value.

Default: \code{100}

Constraints: minimum 20, maximum 100.}

\item{Marker}{An optional parameter that specifies the starting point to return a set
of response records. When the results of a DescribeUsageLimits request
exceed the value specified in \code{MaxRecords}, AWS returns a value in the
\code{Marker} field of the response. You can retrieve the next set of
response records by providing the returned marker value in the \code{Marker}
parameter and retrying the request.}

\item{TagKeys}{A tag key or keys for which you want to return all matching usage limit
objects that are associated with the specified key or keys. For example,
suppose that you have parameter groups that are tagged with keys called
\code{owner} and \code{environment}. If you specify both of these tag keys in the
request, Amazon Redshift returns a response with the usage limit objects
have either or both of these tag keys associated with them.}

\item{TagValues}{A tag value or values for which you want to return all matching usage
limit objects that are associated with the specified tag value or
values. For example, suppose that you have parameter groups that are
tagged with values called \code{admin} and \code{test}. If you specify both of
these tag values in the request, Amazon Redshift returns a response with
the usage limit objects that have either or both of these tag values
associated with them.}
}
\description{
Shows usage limits on a cluster. Results are filtered based on the
combination of input usage limit identifier, cluster identifier, and
feature type parameters:
}
\details{
\itemize{
\item If usage limit identifier, cluster identifier, and feature type are
not provided, then all usage limit objects for the current account
in the current region are returned.
\item If usage limit identifier is provided, then the corresponding usage
limit object is returned.
\item If cluster identifier is provided, then all usage limit objects for
the specified cluster are returned.
\item If cluster identifier and feature type are provided, then all usage
limit objects for the combination of cluster and feature are
returned.
}
}
\section{Request syntax}{
\preformatted{svc$describe_usage_limits(
  UsageLimitId = "string",
  ClusterIdentifier = "string",
  FeatureType = "spectrum"|"concurrency-scaling",
  MaxRecords = 123,
  Marker = "string",
  TagKeys = list(
    "string"
  ),
  TagValues = list(
    "string"
  )
)
}
}

\keyword{internal}
