% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_create_replication_group}
\alias{elasticache_create_replication_group}
\title{Creates a Redis (cluster mode disabled) or a Redis (cluster mode
enabled) replication group}
\usage{
elasticache_create_replication_group(
  ReplicationGroupId,
  ReplicationGroupDescription,
  GlobalReplicationGroupId = NULL,
  PrimaryClusterId = NULL,
  AutomaticFailoverEnabled = NULL,
  MultiAZEnabled = NULL,
  NumCacheClusters = NULL,
  PreferredCacheClusterAZs = NULL,
  NumNodeGroups = NULL,
  ReplicasPerNodeGroup = NULL,
  NodeGroupConfiguration = NULL,
  CacheNodeType = NULL,
  Engine = NULL,
  EngineVersion = NULL,
  CacheParameterGroupName = NULL,
  CacheSubnetGroupName = NULL,
  CacheSecurityGroupNames = NULL,
  SecurityGroupIds = NULL,
  Tags = NULL,
  SnapshotArns = NULL,
  SnapshotName = NULL,
  PreferredMaintenanceWindow = NULL,
  Port = NULL,
  NotificationTopicArn = NULL,
  AutoMinorVersionUpgrade = NULL,
  SnapshotRetentionLimit = NULL,
  SnapshotWindow = NULL,
  AuthToken = NULL,
  TransitEncryptionEnabled = NULL,
  AtRestEncryptionEnabled = NULL,
  KmsKeyId = NULL,
  UserGroupIds = NULL,
  LogDeliveryConfigurations = NULL,
  DataTieringEnabled = NULL,
  NetworkType = NULL,
  IpDiscovery = NULL,
  TransitEncryptionMode = NULL,
  ClusterMode = NULL
)
}
\arguments{
\item{ReplicationGroupId}{[required] The replication group identifier. This parameter is stored as a
lowercase string.

Constraints:
\itemize{
\item A name must contain from 1 to 40 alphanumeric characters or hyphens.
\item The first character must be a letter.
\item A name cannot end with a hyphen or contain two consecutive hyphens.
}}

\item{ReplicationGroupDescription}{[required] A user-created description for the replication group.}

\item{GlobalReplicationGroupId}{The name of the Global datastore}

\item{PrimaryClusterId}{The identifier of the cluster that serves as the primary for this
replication group. This cluster must already exist and have a status of
\code{available}.

This parameter is not required if \code{NumCacheClusters}, \code{NumNodeGroups},
or \code{ReplicasPerNodeGroup} is specified.}

\item{AutomaticFailoverEnabled}{Specifies whether a read-only replica is automatically promoted to
read/write primary if the existing primary fails.

\code{AutomaticFailoverEnabled} must be enabled for Redis (cluster mode
enabled) replication groups.

Default: false}

\item{MultiAZEnabled}{A flag indicating if you have Multi-AZ enabled to enhance fault
tolerance. For more information, see \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html}{Minimizing Downtime: Multi-AZ}.}

\item{NumCacheClusters}{The number of clusters this replication group initially has.

This parameter is not used if there is more than one node group (shard).
You should use \code{ReplicasPerNodeGroup} instead.

If \code{AutomaticFailoverEnabled} is \code{true}, the value of this parameter
must be at least 2. If \code{AutomaticFailoverEnabled} is \code{false} you can
omit this parameter (it will default to 1), or you can explicitly set it
to a value between 2 and 6.

The maximum permitted value for \code{NumCacheClusters} is 6 (1 primary plus
5 replicas).}

\item{PreferredCacheClusterAZs}{A list of EC2 Availability Zones in which the replication group's
clusters are created. The order of the Availability Zones in the list is
the order in which clusters are allocated. The primary cluster is
created in the first AZ in the list.

This parameter is not used if there is more than one node group (shard).
You should use \code{NodeGroupConfiguration} instead.

If you are creating your replication group in an Amazon VPC
(recommended), you can only locate clusters in Availability Zones
associated with the subnets in the selected subnet group.

The number of Availability Zones listed must equal the value of
\code{NumCacheClusters}.

Default: system chosen Availability Zones.}

\item{NumNodeGroups}{An optional parameter that specifies the number of node groups (shards)
for this Redis (cluster mode enabled) replication group. For Redis
(cluster mode disabled) either omit this parameter or set it to 1.

Default: 1}

\item{ReplicasPerNodeGroup}{An optional parameter that specifies the number of replica nodes in each
node group (shard). Valid values are 0 to 5.}

\item{NodeGroupConfiguration}{A list of node group (shard) configuration options. Each node group
(shard) configuration has the following members:
\code{PrimaryAvailabilityZone}, \code{ReplicaAvailabilityZones}, \code{ReplicaCount},
and \code{Slots}.

If you're creating a Redis (cluster mode disabled) or a Redis (cluster
mode enabled) replication group, you can use this parameter to
individually configure each node group (shard), or you can omit this
parameter. However, it is required when seeding a Redis (cluster mode
enabled) cluster from a S3 rdb file. You must configure each node group
(shard) using this parameter because you must specify the slots for each
node group.}

\item{CacheNodeType}{The compute and memory capacity of the nodes in the node group (shard).

The following node types are supported by ElastiCache. Generally
speaking, the current generation types provide more memory and
computational power at lower cost when compared to their equivalent
previous generation counterparts.
\itemize{
\item General purpose:
\itemize{
\item Current generation:

\strong{M6g node types} (available only for Redis engine version
5.0.6 onward and for Memcached engine version 1.5.16 onward):
\code{cache.m6g.large}, \code{cache.m6g.xlarge}, \code{cache.m6g.2xlarge},
\code{cache.m6g.4xlarge}, \code{cache.m6g.8xlarge}, \code{cache.m6g.12xlarge},
\code{cache.m6g.16xlarge}

For region availability, see \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion}{Supported Node Types}

\strong{M5 node types:} \code{cache.m5.large}, \code{cache.m5.xlarge},
\code{cache.m5.2xlarge}, \code{cache.m5.4xlarge}, \code{cache.m5.12xlarge},
\code{cache.m5.24xlarge}

\strong{M4 node types:} \code{cache.m4.large}, \code{cache.m4.xlarge},
\code{cache.m4.2xlarge}, \code{cache.m4.4xlarge}, \code{cache.m4.10xlarge}

\strong{T4g node types} (available only for Redis engine version
5.0.6 onward and Memcached engine version 1.5.16 onward):
\code{cache.t4g.micro}, \code{cache.t4g.small}, \code{cache.t4g.medium}

\strong{T3 node types:} \code{cache.t3.micro}, \code{cache.t3.small},
\code{cache.t3.medium}

\strong{T2 node types:} \code{cache.t2.micro}, \code{cache.t2.small},
\code{cache.t2.medium}
\item Previous generation: (not recommended. Existing clusters are
still supported but creation of new clusters is not supported
for these types.)

\strong{T1 node types:} \code{cache.t1.micro}

\strong{M1 node types:} \code{cache.m1.small}, \code{cache.m1.medium},
\code{cache.m1.large}, \code{cache.m1.xlarge}

\strong{M3 node types:} \code{cache.m3.medium}, \code{cache.m3.large},
\code{cache.m3.xlarge}, \code{cache.m3.2xlarge}
}
\item Compute optimized:
\itemize{
\item Previous generation: (not recommended. Existing clusters are
still supported but creation of new clusters is not supported
for these types.)

\strong{C1 node types:} \code{cache.c1.xlarge}
}
\item Memory optimized:
\itemize{
\item Current generation:

\strong{R6g node types} (available only for Redis engine version
5.0.6 onward and for Memcached engine version 1.5.16 onward).

\code{cache.r6g.large}, \code{cache.r6g.xlarge}, \code{cache.r6g.2xlarge},
\code{cache.r6g.4xlarge}, \code{cache.r6g.8xlarge}, \code{cache.r6g.12xlarge},
\code{cache.r6g.16xlarge}

For region availability, see \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion}{Supported Node Types}

\strong{R5 node types:} \code{cache.r5.large}, \code{cache.r5.xlarge},
\code{cache.r5.2xlarge}, \code{cache.r5.4xlarge}, \code{cache.r5.12xlarge},
\code{cache.r5.24xlarge}

\strong{R4 node types:} \code{cache.r4.large}, \code{cache.r4.xlarge},
\code{cache.r4.2xlarge}, \code{cache.r4.4xlarge}, \code{cache.r4.8xlarge},
\code{cache.r4.16xlarge}
\item Previous generation: (not recommended. Existing clusters are
still supported but creation of new clusters is not supported
for these types.)

\strong{M2 node types:} \code{cache.m2.xlarge}, \code{cache.m2.2xlarge},
\code{cache.m2.4xlarge}

\strong{R3 node types:} \code{cache.r3.large}, \code{cache.r3.xlarge},
\code{cache.r3.2xlarge}, \code{cache.r3.4xlarge}, \code{cache.r3.8xlarge}
}
}

\strong{Additional node type info}
\itemize{
\item All current generation instance types are created in Amazon VPC by
default.
\item Redis append-only files (AOF) are not supported for T1 or T2
instances.
\item Redis Multi-AZ with automatic failover is not supported on T1
instances.
\item Redis configuration variables \code{appendonly} and \code{appendfsync} are not
supported on Redis version 2.8.22 and later.
}}

\item{Engine}{The name of the cache engine to be used for the clusters in this
replication group. The value must be set to \code{Redis}.}

\item{EngineVersion}{The version number of the cache engine to be used for the clusters in
this replication group. To view the supported cache engine versions, use
the
\code{\link[=elasticache_describe_cache_engine_versions]{describe_cache_engine_versions}}
operation.

\strong{Important:} You can upgrade to a newer engine version (see \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement}{Selecting a Cache Engine and Version})
in the \emph{ElastiCache User Guide}, but you cannot downgrade to an earlier
engine version. If you want to use an earlier engine version, you must
delete the existing cluster or replication group and create it anew with
the earlier engine version.}

\item{CacheParameterGroupName}{The name of the parameter group to associate with this replication
group. If this argument is omitted, the default cache parameter group
for the specified engine is used.

If you are running Redis version 3.2.4 or later, only one node group
(shard), and want to use a default parameter group, we recommend that
you specify the parameter group by name.
\itemize{
\item To create a Redis (cluster mode disabled) replication group, use
\code{CacheParameterGroupName=default.redis3.2}.
\item To create a Redis (cluster mode enabled) replication group, use
\code{CacheParameterGroupName=default.redis3.2.cluster.on}.
}}

\item{CacheSubnetGroupName}{The name of the cache subnet group to be used for the replication group.

If you're going to launch your cluster in an Amazon VPC, you need to
create a subnet group before you start creating a cluster. For more
information, see \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html}{Subnets and Subnet Groups}.}

\item{CacheSecurityGroupNames}{A list of cache security group names to associate with this replication
group.}

\item{SecurityGroupIds}{One or more Amazon VPC security groups associated with this replication
group.

Use this parameter only when you are creating a replication group in an
Amazon Virtual Private Cloud (Amazon VPC).}

\item{Tags}{A list of tags to be added to this resource. Tags are comma-separated
key,value pairs (e.g. Key=\code{myKey}, Value=\code{myKeyValue}. You can include
multiple tags as shown following: Key=\code{myKey}, Value=\code{myKeyValue}
Key=\code{mySecondKey}, Value=\code{mySecondKeyValue}. Tags on replication groups
will be replicated to all nodes.}

\item{SnapshotArns}{A list of Amazon Resource Names (ARN) that uniquely identify the Redis
RDB snapshot files stored in Amazon S3. The snapshot files are used to
populate the new replication group. The Amazon S3 object name in the ARN
cannot contain any commas. The new replication group will have the
number of node groups (console: shards) specified by the parameter
\emph{NumNodeGroups} or the number of node groups configured by
\emph{NodeGroupConfiguration} regardless of the number of ARNs specified
here.

Example of an Amazon S3 ARN: \code{arn:aws:s3:::my_bucket/snapshot1.rdb}}

\item{SnapshotName}{The name of a snapshot from which to restore data into the new
replication group. The snapshot status changes to \code{restoring} while the
new replication group is being created.}

\item{PreferredMaintenanceWindow}{Specifies the weekly time range during which maintenance on the cluster
is performed. It is specified as a range in the format
ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window
is a 60 minute period. Valid values for \code{ddd} are:

Specifies the weekly time range during which maintenance on the cluster
is performed. It is specified as a range in the format
ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window
is a 60 minute period.

Valid values for \code{ddd} are:
\itemize{
\item \code{sun}
\item \code{mon}
\item \code{tue}
\item \code{wed}
\item \code{thu}
\item \code{fri}
\item \code{sat}
}

Example: \code{sun:23:00-mon:01:30}}

\item{Port}{The port number on which each member of the replication group accepts
connections.}

\item{NotificationTopicArn}{The Amazon Resource Name (ARN) of the Amazon Simple Notification Service
(SNS) topic to which notifications are sent.

The Amazon SNS topic owner must be the same as the cluster owner.}

\item{AutoMinorVersionUpgrade}{If you are running Redis engine version 6.0 or later, set this
parameter to yes if you want to opt-in to the next auto minor version
upgrade campaign. This parameter is disabled for previous versions.}

\item{SnapshotRetentionLimit}{The number of days for which ElastiCache retains automatic snapshots
before deleting them. For example, if you set \code{SnapshotRetentionLimit}
to 5, a snapshot that was taken today is retained for 5 days before
being deleted.

Default: 0 (i.e., automatic backups are disabled for this cluster).}

\item{SnapshotWindow}{The daily time range (in UTC) during which ElastiCache begins taking a
daily snapshot of your node group (shard).

Example: \code{05:00-09:00}

If you do not specify this parameter, ElastiCache automatically chooses
an appropriate time range.}

\item{AuthToken}{\strong{Reserved parameter.} The password used to access a password protected
server.

\code{AuthToken} can be specified only on replication groups where
\code{TransitEncryptionEnabled} is \code{true}.

For HIPAA compliance, you must specify \code{TransitEncryptionEnabled} as
\code{true}, an \code{AuthToken}, and a \code{CacheSubnetGroup}.

Password constraints:
\itemize{
\item Must be only printable ASCII characters.
\item Must be at least 16 characters and no more than 128 characters in
length.
\item The only permitted printable special characters are !, &, #, $, ^,
\<, \>, and -. Other printable special characters cannot be used in
the AUTH token.
}

For more information, see \href{https://redis.io/commands/auth/}{AUTH password} at
http://redis.io/commands/AUTH.}

\item{TransitEncryptionEnabled}{A flag that enables in-transit encryption when set to \code{true}.

This parameter is valid only if the \code{Engine} parameter is \code{redis}, the
\code{EngineVersion} parameter is \verb{3.2.6}, \verb{4.x} or later, and the cluster is
being created in an Amazon VPC.

If you enable in-transit encryption, you must also specify a value for
\code{CacheSubnetGroup}.

\strong{Required:} Only available when creating a replication group in an
Amazon VPC using redis version \verb{3.2.6}, \verb{4.x} or later.

Default: \code{false}

For HIPAA compliance, you must specify \code{TransitEncryptionEnabled} as
\code{true}, an \code{AuthToken}, and a \code{CacheSubnetGroup}.}

\item{AtRestEncryptionEnabled}{A flag that enables encryption at rest when set to \code{true}.

You cannot modify the value of \code{AtRestEncryptionEnabled} after the
replication group is created. To enable encryption at rest on a
replication group you must set \code{AtRestEncryptionEnabled} to \code{true} when
you create the replication group.

\strong{Required:} Only available when creating a replication group in an
Amazon VPC using redis version \verb{3.2.6}, \verb{4.x} or later.

Default: \code{false}}

\item{KmsKeyId}{The ID of the KMS key used to encrypt the disk in the cluster.}

\item{UserGroupIds}{The user group to associate with the replication group.}

\item{LogDeliveryConfigurations}{Specifies the destination, format and type of the logs.}

\item{DataTieringEnabled}{Enables data tiering. Data tiering is only supported for replication
groups using the r6gd node type. This parameter must be set to true when
using r6gd nodes. For more information, see \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html}{Data tiering}.}

\item{NetworkType}{Must be either \code{ipv4} | \code{ipv6} | \code{dual_stack}. IPv6 is supported for
workloads using Redis engine version 6.2 onward or Memcached engine
version 1.6.6 on all instances built on the \href{https://aws.amazon.com/ec2/nitro/}{Nitro system}.}

\item{IpDiscovery}{The network type you choose when creating a replication group, either
\code{ipv4} | \code{ipv6}. IPv6 is supported for workloads using Redis engine
version 6.2 onward or Memcached engine version 1.6.6 on all instances
built on the \href{https://aws.amazon.com/ec2/nitro/}{Nitro system}.}

\item{TransitEncryptionMode}{A setting that allows you to migrate your clients to use in-transit
encryption, with no downtime.

When setting \code{TransitEncryptionEnabled} to \code{true}, you can set your
\code{TransitEncryptionMode} to \code{preferred} in the same request, to allow
both encrypted and unencrypted connections at the same time. Once you
migrate all your Redis clients to use encrypted connections you can
modify the value to \code{required} to allow encrypted connections only.

Setting \code{TransitEncryptionMode} to \code{required} is a two-step process that
requires you to first set the \code{TransitEncryptionMode} to \code{preferred},
after that you can set \code{TransitEncryptionMode} to \code{required}.

This process will not trigger the replacement of the replication group.}

\item{ClusterMode}{Enabled or Disabled. To modify cluster mode from Disabled to Enabled,
you must first set the cluster mode to Compatible. Compatible mode
allows your Redis clients to connect using both cluster mode enabled and
cluster mode disabled. After you migrate all Redis clients to use
cluster mode enabled, you can then complete cluster mode configuration
and set the cluster mode to Enabled.}
}
\description{
Creates a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group.

See \url{https://www.paws-r-sdk.com/docs/elasticache_create_replication_group/} for full documentation.
}
\keyword{internal}
