% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_create_db_cluster_snapshot}
\alias{rds_create_db_cluster_snapshot}
\title{Creates a snapshot of a DB cluster}
\usage{
rds_create_db_cluster_snapshot(
  DBClusterSnapshotIdentifier,
  DBClusterIdentifier,
  Tags = NULL
)
}
\arguments{
\item{DBClusterSnapshotIdentifier}{[required] The identifier of the DB cluster snapshot. This parameter is stored as a
lowercase string.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens.
\item First character must be a letter.
\item Can't end with a hyphen or contain two consecutive hyphens.
}

Example: \code{my-cluster1-snapshot1}}

\item{DBClusterIdentifier}{[required] The identifier of the DB cluster to create a snapshot for. This
parameter isn't case-sensitive.

Constraints:
\itemize{
\item Must match the identifier of an existing DBCluster.
}

Example: \code{my-cluster1}}

\item{Tags}{The tags to be assigned to the DB cluster snapshot.}
}
\description{
Creates a snapshot of a DB cluster.

See \url{https://www.paws-r-sdk.com/docs/rds_create_db_cluster_snapshot/} for full documentation.
}
\keyword{internal}
