% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_reset_db_cluster_parameter_group}
\alias{rds_reset_db_cluster_parameter_group}
\title{Modifies the parameters of a DB cluster parameter group to the default
value}
\usage{
rds_reset_db_cluster_parameter_group(
  DBClusterParameterGroupName,
  ResetAllParameters = NULL,
  Parameters = NULL
)
}
\arguments{
\item{DBClusterParameterGroupName}{[required] The name of the DB cluster parameter group to reset.}

\item{ResetAllParameters}{A value that indicates whether to reset all parameters in the DB cluster
parameter group to their default values. You can't use this parameter if
there is a list of parameter names specified for the \code{Parameters}
parameter.}

\item{Parameters}{A list of parameter names in the DB cluster parameter group to reset to
the default values. You can't use this parameter if the
\code{ResetAllParameters} parameter is enabled.}
}
\description{
Modifies the parameters of a DB cluster parameter group to the default value. To reset specific parameters submit a list of the following: \code{ParameterName} and \code{ApplyMethod}. To reset the entire DB cluster parameter group, specify the \code{DBClusterParameterGroupName} and \code{ResetAllParameters} parameters.

See \url{https://www.paws-r-sdk.com/docs/rds_reset_db_cluster_parameter_group/} for full documentation.
}
\keyword{internal}
