# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include rds_service.R
NULL

#' Associates an Identity and Access Management (IAM) role with a DB
#' cluster
#'
#' @description
#' Associates an Identity and Access Management (IAM) role with a DB cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_add_role_to_db_cluster/](https://www.paws-r-sdk.com/docs/rds_add_role_to_db_cluster/) for full documentation.
#'
#' @param DBClusterIdentifier &#91;required&#93; The name of the DB cluster to associate the IAM role with.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role to associate with the
#' Aurora DB cluster, for example
#' `arn:aws:iam::123456789012:role/AuroraAccessRole`.
#' @param FeatureName The name of the feature for the DB cluster that the IAM role is to be
#' associated with. For information about supported feature names, see
#' DBEngineVersion.
#'
#' @keywords internal
#'
#' @rdname rds_add_role_to_db_cluster
rds_add_role_to_db_cluster <- function(DBClusterIdentifier, RoleArn, FeatureName = NULL) {
  op <- new_operation(
    name = "AddRoleToDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$add_role_to_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier, RoleArn = RoleArn, FeatureName = FeatureName)
  output <- .rds$add_role_to_db_cluster_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$add_role_to_db_cluster <- rds_add_role_to_db_cluster

#' Associates an Amazon Web Services Identity and Access Management (IAM)
#' role with a DB instance
#'
#' @description
#' Associates an Amazon Web Services Identity and Access Management (IAM) role with a DB instance.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_add_role_to_db_instance/](https://www.paws-r-sdk.com/docs/rds_add_role_to_db_instance/) for full documentation.
#'
#' @param DBInstanceIdentifier &#91;required&#93; The name of the DB instance to associate the IAM role with.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role to associate with the DB
#' instance, for example `arn:aws:iam::123456789012:role/AccessRole`.
#' @param FeatureName &#91;required&#93; The name of the feature for the DB instance that the IAM role is to be
#' associated with. For information about supported feature names, see
#' DBEngineVersion.
#'
#' @keywords internal
#'
#' @rdname rds_add_role_to_db_instance
rds_add_role_to_db_instance <- function(DBInstanceIdentifier, RoleArn, FeatureName) {
  op <- new_operation(
    name = "AddRoleToDBInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$add_role_to_db_instance_input(DBInstanceIdentifier = DBInstanceIdentifier, RoleArn = RoleArn, FeatureName = FeatureName)
  output <- .rds$add_role_to_db_instance_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$add_role_to_db_instance <- rds_add_role_to_db_instance

#' Adds a source identifier to an existing RDS event notification
#' subscription
#'
#' @description
#' Adds a source identifier to an existing RDS event notification subscription.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_add_source_identifier_to_subscription/](https://www.paws-r-sdk.com/docs/rds_add_source_identifier_to_subscription/) for full documentation.
#'
#' @param SubscriptionName &#91;required&#93; The name of the RDS event notification subscription you want to add a
#' source identifier to.
#' @param SourceIdentifier &#91;required&#93; The identifier of the event source to be added.
#' 
#' Constraints:
#' 
#' -   If the source type is a DB instance, a `DBInstanceIdentifier` value
#'     must be supplied.
#' 
#' -   If the source type is a DB cluster, a `DBClusterIdentifier` value
#'     must be supplied.
#' 
#' -   If the source type is a DB parameter group, a `DBParameterGroupName`
#'     value must be supplied.
#' 
#' -   If the source type is a DB security group, a `DBSecurityGroupName`
#'     value must be supplied.
#' 
#' -   If the source type is a DB snapshot, a `DBSnapshotIdentifier` value
#'     must be supplied.
#' 
#' -   If the source type is a DB cluster snapshot, a
#'     `DBClusterSnapshotIdentifier` value must be supplied.
#' 
#' -   If the source type is an RDS Proxy, a `DBProxyName` value must be
#'     supplied.
#'
#' @keywords internal
#'
#' @rdname rds_add_source_identifier_to_subscription
rds_add_source_identifier_to_subscription <- function(SubscriptionName, SourceIdentifier) {
  op <- new_operation(
    name = "AddSourceIdentifierToSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$add_source_identifier_to_subscription_input(SubscriptionName = SubscriptionName, SourceIdentifier = SourceIdentifier)
  output <- .rds$add_source_identifier_to_subscription_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$add_source_identifier_to_subscription <- rds_add_source_identifier_to_subscription

#' Adds metadata tags to an Amazon RDS resource
#'
#' @description
#' Adds metadata tags to an Amazon RDS resource. These tags can also be used with cost allocation reporting to track cost associated with Amazon RDS resources, or used in a Condition statement in an IAM policy for Amazon RDS.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_add_tags_to_resource/](https://www.paws-r-sdk.com/docs/rds_add_tags_to_resource/) for full documentation.
#'
#' @param ResourceName &#91;required&#93; The Amazon RDS resource that the tags are added to. This value is an
#' Amazon Resource Name (ARN). For information about creating an ARN, see
#' [Constructing an RDS Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing).
#' @param Tags &#91;required&#93; The tags to be assigned to the Amazon RDS resource.
#'
#' @keywords internal
#'
#' @rdname rds_add_tags_to_resource
rds_add_tags_to_resource <- function(ResourceName, Tags) {
  op <- new_operation(
    name = "AddTagsToResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$add_tags_to_resource_input(ResourceName = ResourceName, Tags = Tags)
  output <- .rds$add_tags_to_resource_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$add_tags_to_resource <- rds_add_tags_to_resource

#' Applies a pending maintenance action to a resource (for example, to a DB
#' instance)
#'
#' @description
#' Applies a pending maintenance action to a resource (for example, to a DB instance).
#'
#' See [https://www.paws-r-sdk.com/docs/rds_apply_pending_maintenance_action/](https://www.paws-r-sdk.com/docs/rds_apply_pending_maintenance_action/) for full documentation.
#'
#' @param ResourceIdentifier &#91;required&#93; The RDS Amazon Resource Name (ARN) of the resource that the pending
#' maintenance action applies to. For information about creating an ARN,
#' see [Constructing an RDS Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing).
#' @param ApplyAction &#91;required&#93; The pending maintenance action to apply to this resource.
#' 
#' Valid values: `system-update`, `db-upgrade`, `hardware-maintenance`,
#' `ca-certificate-rotation`
#' @param OptInType &#91;required&#93; A value that specifies the type of opt-in request, or undoes an opt-in
#' request. An opt-in request of type `immediate` can't be undone.
#' 
#' Valid values:
#' 
#' -   `immediate` - Apply the maintenance action immediately.
#' 
#' -   `next-maintenance` - Apply the maintenance action during the next
#'     maintenance window for the resource.
#' 
#' -   `undo-opt-in` - Cancel any existing `next-maintenance` opt-in
#'     requests.
#'
#' @keywords internal
#'
#' @rdname rds_apply_pending_maintenance_action
rds_apply_pending_maintenance_action <- function(ResourceIdentifier, ApplyAction, OptInType) {
  op <- new_operation(
    name = "ApplyPendingMaintenanceAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$apply_pending_maintenance_action_input(ResourceIdentifier = ResourceIdentifier, ApplyAction = ApplyAction, OptInType = OptInType)
  output <- .rds$apply_pending_maintenance_action_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$apply_pending_maintenance_action <- rds_apply_pending_maintenance_action

#' Enables ingress to a DBSecurityGroup using one of two forms of
#' authorization
#'
#' @description
#' Enables ingress to a DBSecurityGroup using one of two forms of authorization. First, EC2 or VPC security groups can be added to the DBSecurityGroup if the application using the database is running on EC2 or VPC instances. Second, IP ranges are available if the application accessing your database is running on the internet. Required parameters for this API are one of CIDR range, EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId and either EC2SecurityGroupName or EC2SecurityGroupId for non-VPC).
#'
#' See [https://www.paws-r-sdk.com/docs/rds_authorize_db_security_group_ingress/](https://www.paws-r-sdk.com/docs/rds_authorize_db_security_group_ingress/) for full documentation.
#'
#' @param DBSecurityGroupName &#91;required&#93; The name of the DB security group to add authorization to.
#' @param CIDRIP The IP range to authorize.
#' @param EC2SecurityGroupName Name of the EC2 security group to authorize. For VPC DB security groups,
#' `EC2SecurityGroupId` must be provided. Otherwise,
#' `EC2SecurityGroupOwnerId` and either `EC2SecurityGroupName` or
#' `EC2SecurityGroupId` must be provided.
#' @param EC2SecurityGroupId Id of the EC2 security group to authorize. For VPC DB security groups,
#' `EC2SecurityGroupId` must be provided. Otherwise,
#' `EC2SecurityGroupOwnerId` and either `EC2SecurityGroupName` or
#' `EC2SecurityGroupId` must be provided.
#' @param EC2SecurityGroupOwnerId Amazon Web Services account number of the owner of the EC2 security
#' group specified in the `EC2SecurityGroupName` parameter. The Amazon Web
#' Services access key ID isn't an acceptable value. For VPC DB security
#' groups, `EC2SecurityGroupId` must be provided. Otherwise,
#' `EC2SecurityGroupOwnerId` and either `EC2SecurityGroupName` or
#' `EC2SecurityGroupId` must be provided.
#'
#' @keywords internal
#'
#' @rdname rds_authorize_db_security_group_ingress
rds_authorize_db_security_group_ingress <- function(DBSecurityGroupName, CIDRIP = NULL, EC2SecurityGroupName = NULL, EC2SecurityGroupId = NULL, EC2SecurityGroupOwnerId = NULL) {
  op <- new_operation(
    name = "AuthorizeDBSecurityGroupIngress",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$authorize_db_security_group_ingress_input(DBSecurityGroupName = DBSecurityGroupName, CIDRIP = CIDRIP, EC2SecurityGroupName = EC2SecurityGroupName, EC2SecurityGroupId = EC2SecurityGroupId, EC2SecurityGroupOwnerId = EC2SecurityGroupOwnerId)
  output <- .rds$authorize_db_security_group_ingress_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$authorize_db_security_group_ingress <- rds_authorize_db_security_group_ingress

#' Backtracks a DB cluster to a specific time, without creating a new DB
#' cluster
#'
#' @description
#' Backtracks a DB cluster to a specific time, without creating a new DB cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_backtrack_db_cluster/](https://www.paws-r-sdk.com/docs/rds_backtrack_db_cluster/) for full documentation.
#'
#' @param DBClusterIdentifier &#91;required&#93; The DB cluster identifier of the DB cluster to be backtracked. This
#' parameter is stored as a lowercase string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 alphanumeric characters or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-cluster1`
#' @param BacktrackTo &#91;required&#93; The timestamp of the time to backtrack the DB cluster to, specified in
#' ISO 8601 format. For more information about ISO 8601, see the [ISO8601
#' Wikipedia page.](https://en.wikipedia.org/wiki/ISO_8601)
#' 
#' If the specified time isn't a consistent time for the DB cluster, Aurora
#' automatically chooses the nearest possible consistent time for the DB
#' cluster.
#' 
#' Constraints:
#' 
#' -   Must contain a valid ISO 8601 timestamp.
#' 
#' -   Can't contain a timestamp set in the future.
#' 
#' Example: `2017-07-08T18:00Z`
#' @param Force A value that indicates whether to force the DB cluster to backtrack when
#' binary logging is enabled. Otherwise, an error occurs when binary
#' logging is enabled.
#' @param UseEarliestTimeOnPointInTimeUnavailable A value that indicates whether to backtrack the DB cluster to the
#' earliest possible backtrack time when *BacktrackTo* is set to a
#' timestamp earlier than the earliest backtrack time. When this parameter
#' is disabled and *BacktrackTo* is set to a timestamp earlier than the
#' earliest backtrack time, an error occurs.
#'
#' @keywords internal
#'
#' @rdname rds_backtrack_db_cluster
rds_backtrack_db_cluster <- function(DBClusterIdentifier, BacktrackTo, Force = NULL, UseEarliestTimeOnPointInTimeUnavailable = NULL) {
  op <- new_operation(
    name = "BacktrackDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$backtrack_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier, BacktrackTo = BacktrackTo, Force = Force, UseEarliestTimeOnPointInTimeUnavailable = UseEarliestTimeOnPointInTimeUnavailable)
  output <- .rds$backtrack_db_cluster_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$backtrack_db_cluster <- rds_backtrack_db_cluster

#' Cancels an export task in progress that is exporting a snapshot or
#' cluster to Amazon S3
#'
#' @description
#' Cancels an export task in progress that is exporting a snapshot or cluster to Amazon S3. Any data that has already been written to the S3 bucket isn't removed.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_cancel_export_task/](https://www.paws-r-sdk.com/docs/rds_cancel_export_task/) for full documentation.
#'
#' @param ExportTaskIdentifier &#91;required&#93; The identifier of the snapshot or cluster export task to cancel.
#'
#' @keywords internal
#'
#' @rdname rds_cancel_export_task
rds_cancel_export_task <- function(ExportTaskIdentifier) {
  op <- new_operation(
    name = "CancelExportTask",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$cancel_export_task_input(ExportTaskIdentifier = ExportTaskIdentifier)
  output <- .rds$cancel_export_task_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$cancel_export_task <- rds_cancel_export_task

#' Copies the specified DB cluster parameter group
#'
#' @description
#' Copies the specified DB cluster parameter group.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_copy_db_cluster_parameter_group/](https://www.paws-r-sdk.com/docs/rds_copy_db_cluster_parameter_group/) for full documentation.
#'
#' @param SourceDBClusterParameterGroupIdentifier &#91;required&#93; The identifier or Amazon Resource Name (ARN) for the source DB cluster
#' parameter group. For information about creating an ARN, see
#' [Constructing an ARN for Amazon
#' RDS](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing)
#' in the *Amazon Aurora User Guide*.
#' 
#' Constraints:
#' 
#' -   Must specify a valid DB cluster parameter group.
#' @param TargetDBClusterParameterGroupIdentifier &#91;required&#93; The identifier for the copied DB cluster parameter group.
#' 
#' Constraints:
#' 
#' -   Can't be null, empty, or blank
#' 
#' -   Must contain from 1 to 255 letters, numbers, or hyphens
#' 
#' -   First character must be a letter
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens
#' 
#' Example: `my-cluster-param-group1`
#' @param TargetDBClusterParameterGroupDescription &#91;required&#93; A description for the copied DB cluster parameter group.
#' @param Tags 
#'
#' @keywords internal
#'
#' @rdname rds_copy_db_cluster_parameter_group
rds_copy_db_cluster_parameter_group <- function(SourceDBClusterParameterGroupIdentifier, TargetDBClusterParameterGroupIdentifier, TargetDBClusterParameterGroupDescription, Tags = NULL) {
  op <- new_operation(
    name = "CopyDBClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$copy_db_cluster_parameter_group_input(SourceDBClusterParameterGroupIdentifier = SourceDBClusterParameterGroupIdentifier, TargetDBClusterParameterGroupIdentifier = TargetDBClusterParameterGroupIdentifier, TargetDBClusterParameterGroupDescription = TargetDBClusterParameterGroupDescription, Tags = Tags)
  output <- .rds$copy_db_cluster_parameter_group_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$copy_db_cluster_parameter_group <- rds_copy_db_cluster_parameter_group

#' Copies a snapshot of a DB cluster
#'
#' @description
#' Copies a snapshot of a DB cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_copy_db_cluster_snapshot/](https://www.paws-r-sdk.com/docs/rds_copy_db_cluster_snapshot/) for full documentation.
#'
#' @param SourceDBClusterSnapshotIdentifier &#91;required&#93; The identifier of the DB cluster snapshot to copy. This parameter isn't
#' case-sensitive.
#' 
#' You can't copy an encrypted, shared DB cluster snapshot from one Amazon
#' Web Services Region to another.
#' 
#' Constraints:
#' 
#' -   Must specify a valid system snapshot in the "available" state.
#' 
#' -   If the source snapshot is in the same Amazon Web Services Region as
#'     the copy, specify a valid DB snapshot identifier.
#' 
#' -   If the source snapshot is in a different Amazon Web Services Region
#'     than the copy, specify a valid DB cluster snapshot ARN. For more
#'     information, go to [Copying Snapshots Across Amazon Web Services
#'     Regions](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-copy-snapshot.html#USER_CopySnapshot.AcrossRegions)
#'     in the *Amazon Aurora User Guide*.
#' 
#' Example: `my-cluster-snapshot1`
#' @param TargetDBClusterSnapshotIdentifier &#91;required&#93; The identifier of the new DB cluster snapshot to create from the source
#' DB cluster snapshot. This parameter isn't case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-cluster-snapshot2`
#' @param KmsKeyId The Amazon Web Services KMS key identifier for an encrypted DB cluster
#' snapshot. The Amazon Web Services KMS key identifier is the key ARN, key
#' ID, alias ARN, or alias name for the Amazon Web Services KMS key.
#' 
#' If you copy an encrypted DB cluster snapshot from your Amazon Web
#' Services account, you can specify a value for `KmsKeyId` to encrypt the
#' copy with a new KMS key. If you don't specify a value for `KmsKeyId`,
#' then the copy of the DB cluster snapshot is encrypted with the same KMS
#' key as the source DB cluster snapshot.
#' 
#' If you copy an encrypted DB cluster snapshot that is shared from another
#' Amazon Web Services account, then you must specify a value for
#' `KmsKeyId`.
#' 
#' To copy an encrypted DB cluster snapshot to another Amazon Web Services
#' Region, you must set `KmsKeyId` to the Amazon Web Services KMS key
#' identifier you want to use to encrypt the copy of the DB cluster
#' snapshot in the destination Amazon Web Services Region. KMS keys are
#' specific to the Amazon Web Services Region that they are created in, and
#' you can't use KMS keys from one Amazon Web Services Region in another
#' Amazon Web Services Region.
#' 
#' If you copy an unencrypted DB cluster snapshot and specify a value for
#' the `KmsKeyId` parameter, an error is returned.
#' @param PreSignedUrl When you are copying a DB cluster snapshot from one Amazon Web Services
#' GovCloud (US) Region to another, the URL that contains a Signature
#' Version 4 signed request for the
#' [`copy_db_cluster_snapshot`][rds_copy_db_cluster_snapshot] API operation
#' in the Amazon Web Services Region that contains the source DB cluster
#' snapshot to copy. Use the `PreSignedUrl` parameter when copying an
#' encrypted DB cluster snapshot from another Amazon Web Services Region.
#' Don't specify `PreSignedUrl` when copying an encrypted DB cluster
#' snapshot in the same Amazon Web Services Region.
#' 
#' This setting applies only to Amazon Web Services GovCloud (US) Regions.
#' It's ignored in other Amazon Web Services Regions.
#' 
#' The presigned URL must be a valid request for the
#' [`copy_db_cluster_snapshot`][rds_copy_db_cluster_snapshot] API operation
#' that can run in the source Amazon Web Services Region that contains the
#' encrypted DB cluster snapshot to copy. The presigned URL request must
#' contain the following parameter values:
#' 
#' -   `KmsKeyId` - The KMS key identifier for the KMS key to use to
#'     encrypt the copy of the DB cluster snapshot in the destination
#'     Amazon Web Services Region. This is the same identifier for both the
#'     [`copy_db_cluster_snapshot`][rds_copy_db_cluster_snapshot] operation
#'     that is called in the destination Amazon Web Services Region, and
#'     the operation contained in the presigned URL.
#' 
#' -   `DestinationRegion` - The name of the Amazon Web Services Region
#'     that the DB cluster snapshot is to be created in.
#' 
#' -   `SourceDBClusterSnapshotIdentifier` - The DB cluster snapshot
#'     identifier for the encrypted DB cluster snapshot to be copied. This
#'     identifier must be in the Amazon Resource Name (ARN) format for the
#'     source Amazon Web Services Region. For example, if you are copying
#'     an encrypted DB cluster snapshot from the us-west-2 Amazon Web
#'     Services Region, then your `SourceDBClusterSnapshotIdentifier` looks
#'     like the following example:
#'     `arn:aws:rds:us-west-2:123456789012:cluster-snapshot:aurora-cluster1-snapshot-20161115`.
#' 
#' To learn how to generate a Signature Version 4 signed request, see
#' [Authenticating Requests: Using Query Parameters (Amazon Web Services
#' Signature Version
#' 4)](https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html)
#' and [Signature Version 4 Signing
#' Process](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html).
#' 
#' If you are using an Amazon Web Services SDK tool or the CLI, you can
#' specify `SourceRegion` (or `--source-region` for the CLI) instead of
#' specifying `PreSignedUrl` manually. Specifying `SourceRegion`
#' autogenerates a presigned URL that is a valid request for the operation
#' that can run in the source Amazon Web Services Region.
#' 
#' If you supply a value for this operation's `SourceRegion` parameter, a
#' pre-signed URL will be calculated on your behalf.
#' @param CopyTags A value that indicates whether to copy all tags from the source DB
#' cluster snapshot to the target DB cluster snapshot. By default, tags are
#' not copied.
#' @param Tags 
#' @param SourceRegion The ID of the region that contains the snapshot to be copied.
#'
#' @keywords internal
#'
#' @rdname rds_copy_db_cluster_snapshot
rds_copy_db_cluster_snapshot <- function(SourceDBClusterSnapshotIdentifier, TargetDBClusterSnapshotIdentifier, KmsKeyId = NULL, PreSignedUrl = NULL, CopyTags = NULL, Tags = NULL, SourceRegion = NULL) {
  op <- new_operation(
    name = "CopyDBClusterSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$copy_db_cluster_snapshot_input(SourceDBClusterSnapshotIdentifier = SourceDBClusterSnapshotIdentifier, TargetDBClusterSnapshotIdentifier = TargetDBClusterSnapshotIdentifier, KmsKeyId = KmsKeyId, PreSignedUrl = PreSignedUrl, CopyTags = CopyTags, Tags = Tags, SourceRegion = SourceRegion)
  output <- .rds$copy_db_cluster_snapshot_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$copy_db_cluster_snapshot <- rds_copy_db_cluster_snapshot

#' Copies the specified DB parameter group
#'
#' @description
#' Copies the specified DB parameter group.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_copy_db_parameter_group/](https://www.paws-r-sdk.com/docs/rds_copy_db_parameter_group/) for full documentation.
#'
#' @param SourceDBParameterGroupIdentifier &#91;required&#93; The identifier or ARN for the source DB parameter group. For information
#' about creating an ARN, see [Constructing an ARN for Amazon
#' RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing)
#' in the *Amazon RDS User Guide*.
#' 
#' Constraints:
#' 
#' -   Must specify a valid DB parameter group.
#' @param TargetDBParameterGroupIdentifier &#91;required&#93; The identifier for the copied DB parameter group.
#' 
#' Constraints:
#' 
#' -   Can't be null, empty, or blank
#' 
#' -   Must contain from 1 to 255 letters, numbers, or hyphens
#' 
#' -   First character must be a letter
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens
#' 
#' Example: `my-db-parameter-group`
#' @param TargetDBParameterGroupDescription &#91;required&#93; A description for the copied DB parameter group.
#' @param Tags 
#'
#' @keywords internal
#'
#' @rdname rds_copy_db_parameter_group
rds_copy_db_parameter_group <- function(SourceDBParameterGroupIdentifier, TargetDBParameterGroupIdentifier, TargetDBParameterGroupDescription, Tags = NULL) {
  op <- new_operation(
    name = "CopyDBParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$copy_db_parameter_group_input(SourceDBParameterGroupIdentifier = SourceDBParameterGroupIdentifier, TargetDBParameterGroupIdentifier = TargetDBParameterGroupIdentifier, TargetDBParameterGroupDescription = TargetDBParameterGroupDescription, Tags = Tags)
  output <- .rds$copy_db_parameter_group_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$copy_db_parameter_group <- rds_copy_db_parameter_group

#' Copies the specified DB snapshot
#'
#' @description
#' Copies the specified DB snapshot. The source DB snapshot must be in the `available` state.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_copy_db_snapshot/](https://www.paws-r-sdk.com/docs/rds_copy_db_snapshot/) for full documentation.
#'
#' @param SourceDBSnapshotIdentifier &#91;required&#93; The identifier for the source DB snapshot.
#' 
#' If the source snapshot is in the same Amazon Web Services Region as the
#' copy, specify a valid DB snapshot identifier. For example, you might
#' specify `rds:mysql-instance1-snapshot-20130805`.
#' 
#' If the source snapshot is in a different Amazon Web Services Region than
#' the copy, specify a valid DB snapshot ARN. For example, you might
#' specify
#' `arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805`.
#' 
#' If you are copying from a shared manual DB snapshot, this parameter must
#' be the Amazon Resource Name (ARN) of the shared DB snapshot.
#' 
#' If you are copying an encrypted snapshot this parameter must be in the
#' ARN format for the source Amazon Web Services Region.
#' 
#' Constraints:
#' 
#' -   Must specify a valid system snapshot in the "available" state.
#' 
#' Example: `rds:mydb-2012-04-02-00-01`
#' 
#' Example:
#' `arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805`
#' @param TargetDBSnapshotIdentifier &#91;required&#93; The identifier for the copy of the snapshot.
#' 
#' Constraints:
#' 
#' -   Can't be null, empty, or blank
#' 
#' -   Must contain from 1 to 255 letters, numbers, or hyphens
#' 
#' -   First character must be a letter
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens
#' 
#' Example: `my-db-snapshot`
#' @param KmsKeyId The Amazon Web Services KMS key identifier for an encrypted DB snapshot.
#' The Amazon Web Services KMS key identifier is the key ARN, key ID, alias
#' ARN, or alias name for the KMS key.
#' 
#' If you copy an encrypted DB snapshot from your Amazon Web Services
#' account, you can specify a value for this parameter to encrypt the copy
#' with a new KMS key. If you don't specify a value for this parameter,
#' then the copy of the DB snapshot is encrypted with the same Amazon Web
#' Services KMS key as the source DB snapshot.
#' 
#' If you copy an encrypted DB snapshot that is shared from another Amazon
#' Web Services account, then you must specify a value for this parameter.
#' 
#' If you specify this parameter when you copy an unencrypted snapshot, the
#' copy is encrypted.
#' 
#' If you copy an encrypted snapshot to a different Amazon Web Services
#' Region, then you must specify an Amazon Web Services KMS key identifier
#' for the destination Amazon Web Services Region. KMS keys are specific to
#' the Amazon Web Services Region that they are created in, and you can't
#' use KMS keys from one Amazon Web Services Region in another Amazon Web
#' Services Region.
#' @param Tags 
#' @param CopyTags A value that indicates whether to copy all tags from the source DB
#' snapshot to the target DB snapshot. By default, tags aren't copied.
#' @param PreSignedUrl When you are copying a snapshot from one Amazon Web Services GovCloud
#' (US) Region to another, the URL that contains a Signature Version 4
#' signed request for the [`copy_db_snapshot`][rds_copy_db_snapshot] API
#' operation in the source Amazon Web Services Region that contains the
#' source DB snapshot to copy.
#' 
#' This setting applies only to Amazon Web Services GovCloud (US) Regions.
#' It's ignored in other Amazon Web Services Regions.
#' 
#' You must specify this parameter when you copy an encrypted DB snapshot
#' from another Amazon Web Services Region by using the Amazon RDS API.
#' Don't specify `PreSignedUrl` when you are copying an encrypted DB
#' snapshot in the same Amazon Web Services Region.
#' 
#' The presigned URL must be a valid request for the
#' [`copy_db_cluster_snapshot`][rds_copy_db_cluster_snapshot] API operation
#' that can run in the source Amazon Web Services Region that contains the
#' encrypted DB cluster snapshot to copy. The presigned URL request must
#' contain the following parameter values:
#' 
#' -   `DestinationRegion` - The Amazon Web Services Region that the
#'     encrypted DB snapshot is copied to. This Amazon Web Services Region
#'     is the same one where the [`copy_db_snapshot`][rds_copy_db_snapshot]
#'     operation is called that contains this presigned URL.
#' 
#'     For example, if you copy an encrypted DB snapshot from the us-west-2
#'     Amazon Web Services Region to the us-east-1 Amazon Web Services
#'     Region, then you call the [`copy_db_snapshot`][rds_copy_db_snapshot]
#'     operation in the us-east-1 Amazon Web Services Region and provide a
#'     presigned URL that contains a call to the
#'     [`copy_db_snapshot`][rds_copy_db_snapshot] operation in the
#'     us-west-2 Amazon Web Services Region. For this example, the
#'     `DestinationRegion` in the presigned URL must be set to the
#'     us-east-1 Amazon Web Services Region.
#' 
#' -   `KmsKeyId` - The KMS key identifier for the KMS key to use to
#'     encrypt the copy of the DB snapshot in the destination Amazon Web
#'     Services Region. This is the same identifier for both the
#'     [`copy_db_snapshot`][rds_copy_db_snapshot] operation that is called
#'     in the destination Amazon Web Services Region, and the operation
#'     contained in the presigned URL.
#' 
#' -   `SourceDBSnapshotIdentifier` - The DB snapshot identifier for the
#'     encrypted snapshot to be copied. This identifier must be in the
#'     Amazon Resource Name (ARN) format for the source Amazon Web Services
#'     Region. For example, if you are copying an encrypted DB snapshot
#'     from the us-west-2 Amazon Web Services Region, then your
#'     `SourceDBSnapshotIdentifier` looks like the following example:
#'     `arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20161115`.
#' 
#' To learn how to generate a Signature Version 4 signed request, see
#' [Authenticating Requests: Using Query Parameters (Amazon Web Services
#' Signature Version
#' 4)](https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html)
#' and [Signature Version 4 Signing
#' Process](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html).
#' 
#' If you are using an Amazon Web Services SDK tool or the CLI, you can
#' specify `SourceRegion` (or `--source-region` for the CLI) instead of
#' specifying `PreSignedUrl` manually. Specifying `SourceRegion`
#' autogenerates a presigned URL that is a valid request for the operation
#' that can run in the source Amazon Web Services Region.
#' 
#' If you supply a value for this operation's `SourceRegion` parameter, a
#' pre-signed URL will be calculated on your behalf.
#' @param OptionGroupName The name of an option group to associate with the copy of the snapshot.
#' 
#' Specify this option if you are copying a snapshot from one Amazon Web
#' Services Region to another, and your DB instance uses a nondefault
#' option group. If your source DB instance uses Transparent Data
#' Encryption for Oracle or Microsoft SQL Server, you must specify this
#' option when copying across Amazon Web Services Regions. For more
#' information, see [Option group
#' considerations](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopySnapshot.Options)
#' in the *Amazon RDS User Guide*.
#' @param TargetCustomAvailabilityZone The external custom Availability Zone (CAZ) identifier for the target
#' CAZ.
#' 
#' Example: `rds-caz-aiqhTgQv`.
#' @param CopyOptionGroup A value that indicates whether to copy the DB option group associated
#' with the source DB snapshot to the target Amazon Web Services account
#' and associate with the target DB snapshot. The associated option group
#' can be copied only with cross-account snapshot copy calls.
#' @param SourceRegion The ID of the region that contains the snapshot to be copied.
#'
#' @keywords internal
#'
#' @rdname rds_copy_db_snapshot
rds_copy_db_snapshot <- function(SourceDBSnapshotIdentifier, TargetDBSnapshotIdentifier, KmsKeyId = NULL, Tags = NULL, CopyTags = NULL, PreSignedUrl = NULL, OptionGroupName = NULL, TargetCustomAvailabilityZone = NULL, CopyOptionGroup = NULL, SourceRegion = NULL) {
  op <- new_operation(
    name = "CopyDBSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$copy_db_snapshot_input(SourceDBSnapshotIdentifier = SourceDBSnapshotIdentifier, TargetDBSnapshotIdentifier = TargetDBSnapshotIdentifier, KmsKeyId = KmsKeyId, Tags = Tags, CopyTags = CopyTags, PreSignedUrl = PreSignedUrl, OptionGroupName = OptionGroupName, TargetCustomAvailabilityZone = TargetCustomAvailabilityZone, CopyOptionGroup = CopyOptionGroup, SourceRegion = SourceRegion)
  output <- .rds$copy_db_snapshot_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$copy_db_snapshot <- rds_copy_db_snapshot

#' Copies the specified option group
#'
#' @description
#' Copies the specified option group.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_copy_option_group/](https://www.paws-r-sdk.com/docs/rds_copy_option_group/) for full documentation.
#'
#' @param SourceOptionGroupIdentifier &#91;required&#93; The identifier for the source option group.
#' 
#' Constraints:
#' 
#' -   Must specify a valid option group.
#' @param TargetOptionGroupIdentifier &#91;required&#93; The identifier for the copied option group.
#' 
#' Constraints:
#' 
#' -   Can't be null, empty, or blank
#' 
#' -   Must contain from 1 to 255 letters, numbers, or hyphens
#' 
#' -   First character must be a letter
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens
#' 
#' Example: `my-option-group`
#' @param TargetOptionGroupDescription &#91;required&#93; The description for the copied option group.
#' @param Tags 
#'
#' @keywords internal
#'
#' @rdname rds_copy_option_group
rds_copy_option_group <- function(SourceOptionGroupIdentifier, TargetOptionGroupIdentifier, TargetOptionGroupDescription, Tags = NULL) {
  op <- new_operation(
    name = "CopyOptionGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$copy_option_group_input(SourceOptionGroupIdentifier = SourceOptionGroupIdentifier, TargetOptionGroupIdentifier = TargetOptionGroupIdentifier, TargetOptionGroupDescription = TargetOptionGroupDescription, Tags = Tags)
  output <- .rds$copy_option_group_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$copy_option_group <- rds_copy_option_group

#' Creates a blue/green deployment
#'
#' @description
#' Creates a blue/green deployment.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_create_blue_green_deployment/](https://www.paws-r-sdk.com/docs/rds_create_blue_green_deployment/) for full documentation.
#'
#' @param BlueGreenDeploymentName &#91;required&#93; The name of the blue/green deployment.
#' 
#' Constraints:
#' 
#' -   Can't be the same as an existing blue/green deployment name in the
#'     same account and Amazon Web Services Region.
#' @param Source &#91;required&#93; The Amazon Resource Name (ARN) of the source production database.
#' 
#' Specify the database that you want to clone. The blue/green deployment
#' creates this database in the green environment. You can make updates to
#' the database in the green environment, such as an engine version
#' upgrade. When you are ready, you can switch the database in the green
#' environment to be the production database.
#' @param TargetEngineVersion The engine version of the database in the green environment.
#' 
#' Specify the engine version to upgrade to in the green environment.
#' @param TargetDBParameterGroupName The DB parameter group associated with the DB instance in the green
#' environment.
#' 
#' To test parameter changes, specify a DB parameter group that is
#' different from the one associated with the source DB instance.
#' @param TargetDBClusterParameterGroupName The DB cluster parameter group associated with the Aurora DB cluster in
#' the green environment.
#' 
#' To test parameter changes, specify a DB cluster parameter group that is
#' different from the one associated with the source DB cluster.
#' @param Tags Tags to assign to the blue/green deployment.
#'
#' @keywords internal
#'
#' @rdname rds_create_blue_green_deployment
rds_create_blue_green_deployment <- function(BlueGreenDeploymentName, Source, TargetEngineVersion = NULL, TargetDBParameterGroupName = NULL, TargetDBClusterParameterGroupName = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateBlueGreenDeployment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$create_blue_green_deployment_input(BlueGreenDeploymentName = BlueGreenDeploymentName, Source = Source, TargetEngineVersion = TargetEngineVersion, TargetDBParameterGroupName = TargetDBParameterGroupName, TargetDBClusterParameterGroupName = TargetDBClusterParameterGroupName, Tags = Tags)
  output <- .rds$create_blue_green_deployment_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$create_blue_green_deployment <- rds_create_blue_green_deployment

#' Creates a custom DB engine version (CEV)
#'
#' @description
#' Creates a custom DB engine version (CEV).
#'
#' See [https://www.paws-r-sdk.com/docs/rds_create_custom_db_engine_version/](https://www.paws-r-sdk.com/docs/rds_create_custom_db_engine_version/) for full documentation.
#'
#' @param Engine &#91;required&#93; The database engine to use for your custom engine version (CEV). The
#' only supported value is `custom-oracle-ee`.
#' @param EngineVersion &#91;required&#93; The name of your CEV. The name format is 19.*customized_string*. For
#' example, a valid CEV name is `19.my_cev1`. This setting is required for
#' RDS Custom for Oracle, but optional for Amazon RDS. The combination of
#' `Engine` and `EngineVersion` is unique per customer per Region.
#' @param DatabaseInstallationFilesS3BucketName The name of an Amazon S3 bucket that contains database installation
#' files for your CEV. For example, a valid bucket name is
#' `my-custom-installation-files`.
#' @param DatabaseInstallationFilesS3Prefix The Amazon S3 directory that contains the database installation files
#' for your CEV. For example, a valid bucket name is `123456789012/cev1`.
#' If this setting isn't specified, no prefix is assumed.
#' @param ImageId The ID of the Amazon Machine Image (AMI). For RDS Custom for SQL Server,
#' an AMI ID is required to create a CEV. For RDS Custom for Oracle, the
#' default is the most recent AMI available, but you can specify an AMI ID
#' that was used in a different Oracle CEV. Find the AMIs used by your CEVs
#' by calling the
#' [`describe_db_engine_versions`][rds_describe_db_engine_versions]
#' operation.
#' @param KMSKeyId The Amazon Web Services KMS key identifier for an encrypted CEV. A
#' symmetric encryption KMS key is required for RDS Custom, but optional
#' for Amazon RDS.
#' 
#' If you have an existing symmetric encryption KMS key in your account,
#' you can use it with RDS Custom. No further action is necessary. If you
#' don't already have a symmetric encryption KMS key in your account,
#' follow the instructions in [Creating a symmetric encryption KMS
#' key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html#create-symmetric-cmk)
#' in the *Amazon Web Services Key Management Service Developer Guide*.
#' 
#' You can choose the same symmetric encryption key when you create a CEV
#' and a DB instance, or choose different keys.
#' @param Description An optional description of your CEV.
#' @param Manifest The CEV manifest, which is a JSON document that describes the
#' installation .zip files stored in Amazon S3. Specify the name/value
#' pairs in a file or a quoted string. RDS Custom applies the patches in
#' the order in which they are listed.
#' 
#' The following JSON fields are valid:
#' 
#' **MediaImportTemplateVersion**
#' 
#' Version of the CEV manifest. The date is in the format `YYYY-MM-DD`.
#' 
#' **databaseInstallationFileNames**
#' 
#' Ordered list of installation files for the CEV.
#' 
#' **opatchFileNames**
#' 
#' Ordered list of OPatch installers used for the Oracle DB engine.
#' 
#' **psuRuPatchFileNames**
#' 
#' The PSU and RU patches for this CEV.
#' 
#' **OtherPatchFileNames**
#' 
#' The patches that are not in the list of PSU and RU patches. Amazon RDS
#' applies these patches after applying the PSU and RU patches.
#' 
#' For more information, see [Creating the CEV
#' manifest](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.preparing.manifest)
#' in the *Amazon RDS User Guide*.
#' @param Tags 
#' @param SourceCustomDbEngineVersionIdentifier Reserved for future use.
#' @param UseAwsProvidedLatestImage Reserved for future use.
#'
#' @keywords internal
#'
#' @rdname rds_create_custom_db_engine_version
rds_create_custom_db_engine_version <- function(Engine, EngineVersion, DatabaseInstallationFilesS3BucketName = NULL, DatabaseInstallationFilesS3Prefix = NULL, ImageId = NULL, KMSKeyId = NULL, Description = NULL, Manifest = NULL, Tags = NULL, SourceCustomDbEngineVersionIdentifier = NULL, UseAwsProvidedLatestImage = NULL) {
  op <- new_operation(
    name = "CreateCustomDBEngineVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$create_custom_db_engine_version_input(Engine = Engine, EngineVersion = EngineVersion, DatabaseInstallationFilesS3BucketName = DatabaseInstallationFilesS3BucketName, DatabaseInstallationFilesS3Prefix = DatabaseInstallationFilesS3Prefix, ImageId = ImageId, KMSKeyId = KMSKeyId, Description = Description, Manifest = Manifest, Tags = Tags, SourceCustomDbEngineVersionIdentifier = SourceCustomDbEngineVersionIdentifier, UseAwsProvidedLatestImage = UseAwsProvidedLatestImage)
  output <- .rds$create_custom_db_engine_version_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$create_custom_db_engine_version <- rds_create_custom_db_engine_version

#' Creates a new Amazon Aurora DB cluster or Multi-AZ DB cluster
#'
#' @description
#' Creates a new Amazon Aurora DB cluster or Multi-AZ DB cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_create_db_cluster/](https://www.paws-r-sdk.com/docs/rds_create_db_cluster/) for full documentation.
#'
#' @param AvailabilityZones A list of Availability Zones (AZs) where DB instances in the DB cluster
#' can be created.
#' 
#' For information on Amazon Web Services Regions and Availability Zones,
#' see [Choosing the Regions and Availability
#' Zones](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html)
#' in the *Amazon Aurora User Guide*.
#' 
#' Valid for Cluster Type: Aurora DB clusters only
#' @param BackupRetentionPeriod The number of days for which automated backups are retained.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' 
#' Default: `1`
#' 
#' Constraints:
#' 
#' -   Must be a value from 1 to 35.
#' @param CharacterSetName The name of the character set (`CharacterSet`) to associate the DB
#' cluster with.
#' 
#' Valid for Cluster Type: Aurora DB clusters only
#' @param DatabaseName The name for your database of up to 64 alphanumeric characters. If you
#' don't provide a name, Amazon RDS doesn't create a database in the DB
#' cluster you are creating.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' @param DBClusterIdentifier &#91;required&#93; The identifier for this DB cluster. This parameter is stored as a
#' lowercase string.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-cluster1`
#' @param DBClusterParameterGroupName The name of the DB cluster parameter group to associate with this DB
#' cluster. If you don't specify a value, then the default DB cluster
#' parameter group for the specified DB engine and version is used.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing DB cluster parameter
#'     group.
#' @param VpcSecurityGroupIds A list of EC2 VPC security groups to associate with this DB cluster.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' @param DBSubnetGroupName A DB subnet group to associate with this DB cluster.
#' 
#' This setting is required to create a Multi-AZ DB cluster.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' 
#' Constraints:
#' 
#' -   Must match the name of an existing DB subnet group.
#' 
#' -   Must not be `default`.
#' 
#' Example: `mydbsubnetgroup`
#' @param Engine &#91;required&#93; The database engine to use for this DB cluster.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' 
#' Valid Values: `aurora-mysql | aurora-postgresql | mysql | postgres`
#' @param EngineVersion The version number of the database engine to use.
#' 
#' To list all of the available engine versions for Aurora MySQL version 2
#' (5.7-compatible) and version 3 (MySQL 8.0-compatible), use the following
#' command:
#' 
#' `aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"`
#' 
#' You can supply either `5.7` or `8.0` to use the default engine version
#' for Aurora MySQL version 2 or version 3, respectively.
#' 
#' To list all of the available engine versions for Aurora PostgreSQL, use
#' the following command:
#' 
#' `aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"`
#' 
#' To list all of the available engine versions for RDS for MySQL, use the
#' following command:
#' 
#' `aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"`
#' 
#' To list all of the available engine versions for RDS for PostgreSQL, use
#' the following command:
#' 
#' `aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"`
#' 
#' For information about a specific engine, see the following topics:
#' 
#' -   Aurora MySQL - see [Database engine updates for Amazon Aurora
#'     MySQL](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html)
#'     in the *Amazon Aurora User Guide*.
#' 
#' -   Aurora PostgreSQL - see [Amazon Aurora PostgreSQL releases and
#'     engine
#'     versions](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.20180305.html)
#'     in the *Amazon Aurora User Guide*.
#' 
#' -   RDS for MySQL - see [Amazon RDS for
#'     MySQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt)
#'     in the *Amazon RDS User Guide*.
#' 
#' -   RDS for PostgreSQL - see [Amazon RDS for
#'     PostgreSQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts)
#'     in the *Amazon RDS User Guide*.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' @param Port The port number on which the instances in the DB cluster accept
#' connections.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' 
#' Valid Values: `1150-65535`
#' 
#' Default:
#' 
#' -   RDS for MySQL and Aurora MySQL - `3306`
#' 
#' -   RDS for PostgreSQL and Aurora PostgreSQL - `5432`
#' @param MasterUsername The name of the master user for the DB cluster.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' 
#' Constraints:
#' 
#' -   Must be 1 to 16 letters or numbers.
#' 
#' -   First character must be a letter.
#' 
#' -   Can't be a reserved word for the chosen database engine.
#' @param MasterUserPassword The password for the master database user.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' 
#' Constraints:
#' 
#' -   Must contain from 8 to 41 characters.
#' 
#' -   Can contain any printable ASCII character except "/", """, or "@@".
#' 
#' -   Can't be specified if `ManageMasterUserPassword` is turned on.
#' @param OptionGroupName The option group to associate the DB cluster with.
#' 
#' DB clusters are associated with a default option group that can't be
#' modified.
#' @param PreferredBackupWindow The daily time range during which automated backups are created if
#' automated backups are enabled using the `BackupRetentionPeriod`
#' parameter.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each Amazon Web Services Region. To view the time
#' blocks available, see [Backup
#' window](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow)
#' in the *Amazon Aurora User Guide*.
#' 
#' Constraints:
#' 
#' -   Must be in the format `hh24:mi-hh24:mi`.
#' 
#' -   Must be in Universal Coordinated Time (UTC).
#' 
#' -   Must not conflict with the preferred maintenance window.
#' 
#' -   Must be at least 30 minutes.
#' @param PreferredMaintenanceWindow The weekly time range during which system maintenance can occur.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each Amazon Web Services Region, occurring on a random
#' day of the week. To see the time blocks available, see [Adjusting the
#' Preferred DB Cluster Maintenance
#' Window](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora)
#' in the *Amazon Aurora User Guide*.
#' 
#' Constraints:
#' 
#' -   Must be in the format `ddd:hh24:mi-ddd:hh24:mi`.
#' 
#' -   Days must be one of `Mon | Tue | Wed | Thu | Fri | Sat | Sun`.
#' 
#' -   Must be in Universal Coordinated Time (UTC).
#' 
#' -   Must be at least 30 minutes.
#' @param ReplicationSourceIdentifier The Amazon Resource Name (ARN) of the source DB instance or DB cluster
#' if this DB cluster is created as a read replica.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' @param Tags Tags to assign to the DB cluster.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' @param StorageEncrypted Specifies whether the DB cluster is encrypted.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' @param KmsKeyId The Amazon Web Services KMS key identifier for an encrypted DB cluster.
#' 
#' The Amazon Web Services KMS key identifier is the key ARN, key ID, alias
#' ARN, or alias name for the KMS key. To use a KMS key in a different
#' Amazon Web Services account, specify the key ARN or alias ARN.
#' 
#' When a KMS key isn't specified in `KmsKeyId`:
#' 
#' -   If `ReplicationSourceIdentifier` identifies an encrypted source,
#'     then Amazon RDS uses the KMS key used to encrypt the source.
#'     Otherwise, Amazon RDS uses your default KMS key.
#' 
#' -   If the `StorageEncrypted` parameter is enabled and
#'     `ReplicationSourceIdentifier` isn't specified, then Amazon RDS uses
#'     your default KMS key.
#' 
#' There is a default KMS key for your Amazon Web Services account. Your
#' Amazon Web Services account has a different default KMS key for each
#' Amazon Web Services Region.
#' 
#' If you create a read replica of an encrypted DB cluster in another
#' Amazon Web Services Region, make sure to set `KmsKeyId` to a KMS key
#' identifier that is valid in the destination Amazon Web Services Region.
#' This KMS key is used to encrypt the read replica in that Amazon Web
#' Services Region.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' @param PreSignedUrl When you are replicating a DB cluster from one Amazon Web Services
#' GovCloud (US) Region to another, an URL that contains a Signature
#' Version 4 signed request for the
#' [`create_db_cluster`][rds_create_db_cluster] operation to be called in
#' the source Amazon Web Services Region where the DB cluster is replicated
#' from. Specify `PreSignedUrl` only when you are performing cross-Region
#' replication from an encrypted DB cluster.
#' 
#' The presigned URL must be a valid request for the
#' [`create_db_cluster`][rds_create_db_cluster] API operation that can run
#' in the source Amazon Web Services Region that contains the encrypted DB
#' cluster to copy.
#' 
#' The presigned URL request must contain the following parameter values:
#' 
#' -   `KmsKeyId` - The KMS key identifier for the KMS key to use to
#'     encrypt the copy of the DB cluster in the destination Amazon Web
#'     Services Region. This should refer to the same KMS key for both the
#'     [`create_db_cluster`][rds_create_db_cluster] operation that is
#'     called in the destination Amazon Web Services Region, and the
#'     operation contained in the presigned URL.
#' 
#' -   `DestinationRegion` - The name of the Amazon Web Services Region
#'     that Aurora read replica will be created in.
#' 
#' -   `ReplicationSourceIdentifier` - The DB cluster identifier for the
#'     encrypted DB cluster to be copied. This identifier must be in the
#'     Amazon Resource Name (ARN) format for the source Amazon Web Services
#'     Region. For example, if you are copying an encrypted DB cluster from
#'     the us-west-2 Amazon Web Services Region, then your
#'     `ReplicationSourceIdentifier` would look like Example:
#'     `arn:aws:rds:us-west-2:123456789012:cluster:aurora-cluster1`.
#' 
#' To learn how to generate a Signature Version 4 signed request, see
#' [Authenticating Requests: Using Query Parameters (Amazon Web Services
#' Signature Version
#' 4)](https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html)
#' and [Signature Version 4 Signing
#' Process](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html).
#' 
#' If you are using an Amazon Web Services SDK tool or the CLI, you can
#' specify `SourceRegion` (or `--source-region` for the CLI) instead of
#' specifying `PreSignedUrl` manually. Specifying `SourceRegion`
#' autogenerates a presigned URL that is a valid request for the operation
#' that can run in the source Amazon Web Services Region.
#' 
#' Valid for Cluster Type: Aurora DB clusters only
#' 
#' If you supply a value for this operation's `SourceRegion` parameter, a
#' pre-signed URL will be calculated on your behalf.
#' @param EnableIAMDatabaseAuthentication Specifies whether to enable mapping of Amazon Web Services Identity and
#' Access Management (IAM) accounts to database accounts. By default,
#' mapping isn't enabled.
#' 
#' For more information, see [IAM Database
#' Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html)
#' in the *Amazon Aurora User Guide*.
#' 
#' Valid for Cluster Type: Aurora DB clusters only
#' @param BacktrackWindow The target backtrack window, in seconds. To disable backtracking, set
#' this value to `0`.
#' 
#' Valid for Cluster Type: Aurora MySQL DB clusters only
#' 
#' Default: `0`
#' 
#' Constraints:
#' 
#' -   If specified, this value must be set to a number from 0 to 259,200
#'     (72 hours).
#' @param EnableCloudwatchLogsExports The list of log types that need to be enabled for exporting to
#' CloudWatch Logs.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' 
#' The following values are valid for each DB engine:
#' 
#' -   Aurora MySQL - `audit | error | general | slowquery`
#' 
#' -   Aurora PostgreSQL - `postgresql`
#' 
#' -   RDS for MySQL - `error | general | slowquery`
#' 
#' -   RDS for PostgreSQL - `postgresql | upgrade`
#' 
#' For more information about exporting CloudWatch Logs for Amazon RDS, see
#' [Publishing Database Logs to Amazon CloudWatch
#' Logs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch)
#' in the *Amazon RDS User Guide*.
#' 
#' For more information about exporting CloudWatch Logs for Amazon Aurora,
#' see [Publishing Database Logs to Amazon CloudWatch
#' Logs](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch)
#' in the *Amazon Aurora User Guide*.
#' @param EngineMode The DB engine mode of the DB cluster, either `provisioned` or
#' `serverless`.
#' 
#' The `serverless` engine mode only applies for Aurora Serverless v1 DB
#' clusters.
#' 
#' For information about limitations and requirements for Serverless DB
#' clusters, see the following sections in the *Amazon Aurora User Guide*:
#' 
#' -   [Limitations of Aurora Serverless
#'     v1](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations)
#' 
#' -   [Requirements for Aurora Serverless
#'     v2](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.requirements.html)
#' 
#' Valid for Cluster Type: Aurora DB clusters only
#' @param ScalingConfiguration For DB clusters in `serverless` DB engine mode, the scaling properties
#' of the DB cluster.
#' 
#' Valid for Cluster Type: Aurora DB clusters only
#' @param DeletionProtection Specifies whether the DB cluster has deletion protection enabled. The
#' database can't be deleted when deletion protection is enabled. By
#' default, deletion protection isn't enabled.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' @param GlobalClusterIdentifier The global cluster ID of an Aurora cluster that becomes the primary
#' cluster in the new global database cluster.
#' 
#' Valid for Cluster Type: Aurora DB clusters only
#' @param EnableHttpEndpoint Specifies whether to enable the HTTP endpoint for an Aurora Serverless
#' v1 DB cluster. By default, the HTTP endpoint is disabled.
#' 
#' When enabled, the HTTP endpoint provides a connectionless web service
#' API for running SQL queries on the Aurora Serverless v1 DB cluster. You
#' can also query your database from inside the RDS console with the query
#' editor.
#' 
#' For more information, see [Using the Data API for Aurora Serverless
#' v1](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html)
#' in the *Amazon Aurora User Guide*.
#' 
#' Valid for Cluster Type: Aurora DB clusters only
#' @param CopyTagsToSnapshot Specifies whether to copy all tags from the DB cluster to snapshots of
#' the DB cluster. The default is not to copy them.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' @param Domain The Active Directory directory ID to create the DB cluster in.
#' 
#' For Amazon Aurora DB clusters, Amazon RDS can use Kerberos
#' authentication to authenticate users that connect to the DB cluster.
#' 
#' For more information, see [Kerberos
#' authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/database-authentication.html)
#' in the *Amazon Aurora User Guide*.
#' 
#' Valid for Cluster Type: Aurora DB clusters only
#' @param DomainIAMRoleName The name of the IAM role to use when making API calls to the Directory
#' Service.
#' 
#' Valid for Cluster Type: Aurora DB clusters only
#' @param EnableGlobalWriteForwarding Specifies whether to enable this DB cluster to forward write operations
#' to the primary cluster of a global cluster (Aurora global database). By
#' default, write operations are not allowed on Aurora DB clusters that are
#' secondary clusters in an Aurora global database.
#' 
#' You can set this value only on Aurora DB clusters that are members of an
#' Aurora global database. With this parameter enabled, a secondary cluster
#' can forward writes to the current primary cluster, and the resulting
#' changes are replicated back to this cluster. For the primary DB cluster
#' of an Aurora global database, this value is used immediately if the
#' primary is demoted by a global cluster API operation, but it does
#' nothing until then.
#' 
#' Valid for Cluster Type: Aurora DB clusters only
#' @param DBClusterInstanceClass The compute and memory capacity of each DB instance in the Multi-AZ DB
#' cluster, for example `db.m6gd.xlarge`. Not all DB instance classes are
#' available in all Amazon Web Services Regions, or for all database
#' engines.
#' 
#' For the full list of DB instance classes and availability for your
#' engine, see [DB instance
#' class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html)
#' in the *Amazon RDS User Guide*.
#' 
#' This setting is required to create a Multi-AZ DB cluster.
#' 
#' Valid for Cluster Type: Multi-AZ DB clusters only
#' @param AllocatedStorage The amount of storage in gibibytes (GiB) to allocate to each DB instance
#' in the Multi-AZ DB cluster.
#' 
#' Valid for Cluster Type: Multi-AZ DB clusters only
#' 
#' This setting is required to create a Multi-AZ DB cluster.
#' @param StorageType The storage type to associate with the DB cluster.
#' 
#' For information on storage types for Aurora DB clusters, see [Storage
#' configurations for Amazon Aurora DB
#' clusters](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Overview.StorageReliability.html#aurora-storage-type).
#' For information on storage types for Multi-AZ DB clusters, see [Settings
#' for creating Multi-AZ DB
#' clusters](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/create-multi-az-db-cluster.html#create-multi-az-db-cluster-settings).
#' 
#' This setting is required to create a Multi-AZ DB cluster.
#' 
#' When specified for a Multi-AZ DB cluster, a value for the `Iops`
#' parameter is required.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' 
#' Valid Values:
#' 
#' -   Aurora DB clusters - `aurora | aurora-iopt1`
#' 
#' -   Multi-AZ DB clusters - `io1`
#' 
#' Default:
#' 
#' -   Aurora DB clusters - `aurora`
#' 
#' -   Multi-AZ DB clusters - `io1`
#' 
#' When you create an Aurora DB cluster with the storage type set to
#' `aurora-iopt1`, the storage type is returned in the response. The
#' storage type isn't returned when you set it to `aurora`.
#' @param Iops The amount of Provisioned IOPS (input/output operations per second) to
#' be initially allocated for each DB instance in the Multi-AZ DB cluster.
#' 
#' For information about valid IOPS values, see [Provisioned IOPS
#' storage](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS)
#' in the *Amazon RDS User Guide*.
#' 
#' This setting is required to create a Multi-AZ DB cluster.
#' 
#' Valid for Cluster Type: Multi-AZ DB clusters only
#' 
#' Constraints:
#' 
#' -   Must be a multiple between .5 and 50 of the storage amount for the
#'     DB cluster.
#' @param PubliclyAccessible Specifies whether the DB cluster is publicly accessible.
#' 
#' When the DB cluster is publicly accessible, its Domain Name System (DNS)
#' endpoint resolves to the private IP address from within the DB cluster's
#' virtual private cloud (VPC). It resolves to the public IP address from
#' outside of the DB cluster's VPC. Access to the DB cluster is ultimately
#' controlled by the security group it uses. That public access isn't
#' permitted if the security group assigned to the DB cluster doesn't
#' permit it.
#' 
#' When the DB cluster isn't publicly accessible, it is an internal DB
#' cluster with a DNS name that resolves to a private IP address.
#' 
#' Valid for Cluster Type: Multi-AZ DB clusters only
#' 
#' Default: The default behavior varies depending on whether
#' `DBSubnetGroupName` is specified.
#' 
#' If `DBSubnetGroupName` isn't specified, and `PubliclyAccessible` isn't
#' specified, the following applies:
#' 
#' -   If the default VPC in the target Region doesn’t have an internet
#'     gateway attached to it, the DB cluster is private.
#' 
#' -   If the default VPC in the target Region has an internet gateway
#'     attached to it, the DB cluster is public.
#' 
#' If `DBSubnetGroupName` is specified, and `PubliclyAccessible` isn't
#' specified, the following applies:
#' 
#' -   If the subnets are part of a VPC that doesn’t have an internet
#'     gateway attached to it, the DB cluster is private.
#' 
#' -   If the subnets are part of a VPC that has an internet gateway
#'     attached to it, the DB cluster is public.
#' @param AutoMinorVersionUpgrade Specifies whether minor engine upgrades are applied automatically to the
#' DB cluster during the maintenance window. By default, minor engine
#' upgrades are applied automatically.
#' 
#' Valid for Cluster Type: Multi-AZ DB clusters only
#' @param MonitoringInterval The interval, in seconds, between points when Enhanced Monitoring
#' metrics are collected for the DB cluster. To turn off collecting
#' Enhanced Monitoring metrics, specify `0`.
#' 
#' If `MonitoringRoleArn` is specified, also set `MonitoringInterval` to a
#' value other than `0`.
#' 
#' Valid for Cluster Type: Multi-AZ DB clusters only
#' 
#' Valid Values: `0 | 1 | 5 | 10 | 15 | 30 | 60`
#' 
#' Default: `0`
#' @param MonitoringRoleArn The Amazon Resource Name (ARN) for the IAM role that permits RDS to send
#' Enhanced Monitoring metrics to Amazon CloudWatch Logs. An example is
#' `arn:aws:iam:123456789012:role/emaccess`. For information on creating a
#' monitoring role, see [Setting up and enabling Enhanced
#' Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling)
#' in the *Amazon RDS User Guide*.
#' 
#' If `MonitoringInterval` is set to a value other than `0`, supply a
#' `MonitoringRoleArn` value.
#' 
#' Valid for Cluster Type: Multi-AZ DB clusters only
#' @param EnablePerformanceInsights Specifies whether to turn on Performance Insights for the DB cluster.
#' 
#' For more information, see [Using Amazon Performance
#' Insights](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html)
#' in the *Amazon RDS User Guide*.
#' 
#' Valid for Cluster Type: Multi-AZ DB clusters only
#' @param PerformanceInsightsKMSKeyId The Amazon Web Services KMS key identifier for encryption of Performance
#' Insights data.
#' 
#' The Amazon Web Services KMS key identifier is the key ARN, key ID, alias
#' ARN, or alias name for the KMS key.
#' 
#' If you don't specify a value for `PerformanceInsightsKMSKeyId`, then
#' Amazon RDS uses your default KMS key. There is a default KMS key for
#' your Amazon Web Services account. Your Amazon Web Services account has a
#' different default KMS key for each Amazon Web Services Region.
#' 
#' Valid for Cluster Type: Multi-AZ DB clusters only
#' @param PerformanceInsightsRetentionPeriod The number of days to retain Performance Insights data.
#' 
#' Valid for Cluster Type: Multi-AZ DB clusters only
#' 
#' Valid Values:
#' 
#' -   `7`
#' 
#' -   *month* * 31, where *month* is a number of months from 1-23.
#'     Examples: `93` (3 months * 31), `341` (11 months * 31), `589` (19
#'     months * 31)
#' 
#' -   `731`
#' 
#' Default: `7` days
#' 
#' If you specify a retention period that isn't valid, such as `94`, Amazon
#' RDS issues an error.
#' @param ServerlessV2ScalingConfiguration 
#' @param NetworkType The network type of the DB cluster.
#' 
#' The network type is determined by the `DBSubnetGroup` specified for the
#' DB cluster. A `DBSubnetGroup` can support only the IPv4 protocol or the
#' IPv4 and the IPv6 protocols (`DUAL`).
#' 
#' For more information, see [Working with a DB instance in a
#' VPC](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html)
#' in the *Amazon Aurora User Guide.*
#' 
#' Valid for Cluster Type: Aurora DB clusters only
#' 
#' Valid Values: `IPV4 | DUAL`
#' @param DBSystemId Reserved for future use.
#' @param ManageMasterUserPassword Specifies whether to manage the master user password with Amazon Web
#' Services Secrets Manager.
#' 
#' For more information, see [Password management with Amazon Web Services
#' Secrets
#' Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html)
#' in the *Amazon RDS User Guide* and [Password management with Amazon Web
#' Services Secrets
#' Manager](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html)
#' in the *Amazon Aurora User Guide.*
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' 
#' Constraints:
#' 
#' -   Can't manage the master user password with Amazon Web Services
#'     Secrets Manager if `MasterUserPassword` is specified.
#' @param MasterUserSecretKmsKeyId The Amazon Web Services KMS key identifier to encrypt a secret that is
#' automatically generated and managed in Amazon Web Services Secrets
#' Manager.
#' 
#' This setting is valid only if the master user password is managed by RDS
#' in Amazon Web Services Secrets Manager for the DB cluster.
#' 
#' The Amazon Web Services KMS key identifier is the key ARN, key ID, alias
#' ARN, or alias name for the KMS key. To use a KMS key in a different
#' Amazon Web Services account, specify the key ARN or alias ARN.
#' 
#' If you don't specify `MasterUserSecretKmsKeyId`, then the
#' `aws/secretsmanager` KMS key is used to encrypt the secret. If the
#' secret is in a different Amazon Web Services account, then you can't use
#' the `aws/secretsmanager` KMS key to encrypt the secret, and you must use
#' a customer managed KMS key.
#' 
#' There is a default KMS key for your Amazon Web Services account. Your
#' Amazon Web Services account has a different default KMS key for each
#' Amazon Web Services Region.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' @param EnableLocalWriteForwarding Specifies whether read replicas can forward write operations to the
#' writer DB instance in the DB cluster. By default, write operations
#' aren't allowed on reader DB instances.
#' 
#' Valid for: Aurora DB clusters only
#' @param SourceRegion The ID of the region that contains the source for the read replica.
#'
#' @keywords internal
#'
#' @rdname rds_create_db_cluster
rds_create_db_cluster <- function(AvailabilityZones = NULL, BackupRetentionPeriod = NULL, CharacterSetName = NULL, DatabaseName = NULL, DBClusterIdentifier, DBClusterParameterGroupName = NULL, VpcSecurityGroupIds = NULL, DBSubnetGroupName = NULL, Engine, EngineVersion = NULL, Port = NULL, MasterUsername = NULL, MasterUserPassword = NULL, OptionGroupName = NULL, PreferredBackupWindow = NULL, PreferredMaintenanceWindow = NULL, ReplicationSourceIdentifier = NULL, Tags = NULL, StorageEncrypted = NULL, KmsKeyId = NULL, PreSignedUrl = NULL, EnableIAMDatabaseAuthentication = NULL, BacktrackWindow = NULL, EnableCloudwatchLogsExports = NULL, EngineMode = NULL, ScalingConfiguration = NULL, DeletionProtection = NULL, GlobalClusterIdentifier = NULL, EnableHttpEndpoint = NULL, CopyTagsToSnapshot = NULL, Domain = NULL, DomainIAMRoleName = NULL, EnableGlobalWriteForwarding = NULL, DBClusterInstanceClass = NULL, AllocatedStorage = NULL, StorageType = NULL, Iops = NULL, PubliclyAccessible = NULL, AutoMinorVersionUpgrade = NULL, MonitoringInterval = NULL, MonitoringRoleArn = NULL, EnablePerformanceInsights = NULL, PerformanceInsightsKMSKeyId = NULL, PerformanceInsightsRetentionPeriod = NULL, ServerlessV2ScalingConfiguration = NULL, NetworkType = NULL, DBSystemId = NULL, ManageMasterUserPassword = NULL, MasterUserSecretKmsKeyId = NULL, EnableLocalWriteForwarding = NULL, SourceRegion = NULL) {
  op <- new_operation(
    name = "CreateDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$create_db_cluster_input(AvailabilityZones = AvailabilityZones, BackupRetentionPeriod = BackupRetentionPeriod, CharacterSetName = CharacterSetName, DatabaseName = DatabaseName, DBClusterIdentifier = DBClusterIdentifier, DBClusterParameterGroupName = DBClusterParameterGroupName, VpcSecurityGroupIds = VpcSecurityGroupIds, DBSubnetGroupName = DBSubnetGroupName, Engine = Engine, EngineVersion = EngineVersion, Port = Port, MasterUsername = MasterUsername, MasterUserPassword = MasterUserPassword, OptionGroupName = OptionGroupName, PreferredBackupWindow = PreferredBackupWindow, PreferredMaintenanceWindow = PreferredMaintenanceWindow, ReplicationSourceIdentifier = ReplicationSourceIdentifier, Tags = Tags, StorageEncrypted = StorageEncrypted, KmsKeyId = KmsKeyId, PreSignedUrl = PreSignedUrl, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, BacktrackWindow = BacktrackWindow, EnableCloudwatchLogsExports = EnableCloudwatchLogsExports, EngineMode = EngineMode, ScalingConfiguration = ScalingConfiguration, DeletionProtection = DeletionProtection, GlobalClusterIdentifier = GlobalClusterIdentifier, EnableHttpEndpoint = EnableHttpEndpoint, CopyTagsToSnapshot = CopyTagsToSnapshot, Domain = Domain, DomainIAMRoleName = DomainIAMRoleName, EnableGlobalWriteForwarding = EnableGlobalWriteForwarding, DBClusterInstanceClass = DBClusterInstanceClass, AllocatedStorage = AllocatedStorage, StorageType = StorageType, Iops = Iops, PubliclyAccessible = PubliclyAccessible, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, MonitoringInterval = MonitoringInterval, MonitoringRoleArn = MonitoringRoleArn, EnablePerformanceInsights = EnablePerformanceInsights, PerformanceInsightsKMSKeyId = PerformanceInsightsKMSKeyId, PerformanceInsightsRetentionPeriod = PerformanceInsightsRetentionPeriod, ServerlessV2ScalingConfiguration = ServerlessV2ScalingConfiguration, NetworkType = NetworkType, DBSystemId = DBSystemId, ManageMasterUserPassword = ManageMasterUserPassword, MasterUserSecretKmsKeyId = MasterUserSecretKmsKeyId, EnableLocalWriteForwarding = EnableLocalWriteForwarding, SourceRegion = SourceRegion)
  output <- .rds$create_db_cluster_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$create_db_cluster <- rds_create_db_cluster

#' Creates a new custom endpoint and associates it with an Amazon Aurora DB
#' cluster
#'
#' @description
#' Creates a new custom endpoint and associates it with an Amazon Aurora DB cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_create_db_cluster_endpoint/](https://www.paws-r-sdk.com/docs/rds_create_db_cluster_endpoint/) for full documentation.
#'
#' @param DBClusterIdentifier &#91;required&#93; The DB cluster identifier of the DB cluster associated with the
#' endpoint. This parameter is stored as a lowercase string.
#' @param DBClusterEndpointIdentifier &#91;required&#93; The identifier to use for the new endpoint. This parameter is stored as
#' a lowercase string.
#' @param EndpointType &#91;required&#93; The type of the endpoint, one of: `READER`, `WRITER`, `ANY`.
#' @param StaticMembers List of DB instance identifiers that are part of the custom endpoint
#' group.
#' @param ExcludedMembers List of DB instance identifiers that aren't part of the custom endpoint
#' group. All other eligible instances are reachable through the custom
#' endpoint. This parameter is relevant only if the list of static members
#' is empty.
#' @param Tags The tags to be assigned to the Amazon RDS resource.
#'
#' @keywords internal
#'
#' @rdname rds_create_db_cluster_endpoint
rds_create_db_cluster_endpoint <- function(DBClusterIdentifier, DBClusterEndpointIdentifier, EndpointType, StaticMembers = NULL, ExcludedMembers = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateDBClusterEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$create_db_cluster_endpoint_input(DBClusterIdentifier = DBClusterIdentifier, DBClusterEndpointIdentifier = DBClusterEndpointIdentifier, EndpointType = EndpointType, StaticMembers = StaticMembers, ExcludedMembers = ExcludedMembers, Tags = Tags)
  output <- .rds$create_db_cluster_endpoint_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$create_db_cluster_endpoint <- rds_create_db_cluster_endpoint

#' Creates a new DB cluster parameter group
#'
#' @description
#' Creates a new DB cluster parameter group.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_create_db_cluster_parameter_group/](https://www.paws-r-sdk.com/docs/rds_create_db_cluster_parameter_group/) for full documentation.
#'
#' @param DBClusterParameterGroupName &#91;required&#93; The name of the DB cluster parameter group.
#' 
#' Constraints:
#' 
#' -   Must not match the name of an existing DB cluster parameter group.
#' 
#' This value is stored as a lowercase string.
#' @param DBParameterGroupFamily &#91;required&#93; The DB cluster parameter group family name. A DB cluster parameter group
#' can be associated with one and only one DB cluster parameter group
#' family, and can be applied only to a DB cluster running a database
#' engine and engine version compatible with that DB cluster parameter
#' group family.
#' 
#' **Aurora MySQL**
#' 
#' Example: `aurora-mysql5.7`, `aurora-mysql8.0`
#' 
#' **Aurora PostgreSQL**
#' 
#' Example: `aurora-postgresql14`
#' 
#' **RDS for MySQL**
#' 
#' Example: `mysql8.0`
#' 
#' **RDS for PostgreSQL**
#' 
#' Example: `postgres12`
#' 
#' To list all of the available parameter group families for a DB engine,
#' use the following command:
#' 
#' `aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine <engine>`
#' 
#' For example, to list all of the available parameter group families for
#' the Aurora PostgreSQL DB engine, use the following command:
#' 
#' `aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine aurora-postgresql`
#' 
#' The output contains duplicates.
#' 
#' The following are the valid DB engine values:
#' 
#' -   `aurora-mysql`
#' 
#' -   `aurora-postgresql`
#' 
#' -   `mysql`
#' 
#' -   `postgres`
#' @param Description &#91;required&#93; The description for the DB cluster parameter group.
#' @param Tags Tags to assign to the DB cluster parameter group.
#'
#' @keywords internal
#'
#' @rdname rds_create_db_cluster_parameter_group
rds_create_db_cluster_parameter_group <- function(DBClusterParameterGroupName, DBParameterGroupFamily, Description, Tags = NULL) {
  op <- new_operation(
    name = "CreateDBClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$create_db_cluster_parameter_group_input(DBClusterParameterGroupName = DBClusterParameterGroupName, DBParameterGroupFamily = DBParameterGroupFamily, Description = Description, Tags = Tags)
  output <- .rds$create_db_cluster_parameter_group_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$create_db_cluster_parameter_group <- rds_create_db_cluster_parameter_group

#' Creates a snapshot of a DB cluster
#'
#' @description
#' Creates a snapshot of a DB cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_create_db_cluster_snapshot/](https://www.paws-r-sdk.com/docs/rds_create_db_cluster_snapshot/) for full documentation.
#'
#' @param DBClusterSnapshotIdentifier &#91;required&#93; The identifier of the DB cluster snapshot. This parameter is stored as a
#' lowercase string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-cluster1-snapshot1`
#' @param DBClusterIdentifier &#91;required&#93; The identifier of the DB cluster to create a snapshot for. This
#' parameter isn't case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DBCluster.
#' 
#' Example: `my-cluster1`
#' @param Tags The tags to be assigned to the DB cluster snapshot.
#'
#' @keywords internal
#'
#' @rdname rds_create_db_cluster_snapshot
rds_create_db_cluster_snapshot <- function(DBClusterSnapshotIdentifier, DBClusterIdentifier, Tags = NULL) {
  op <- new_operation(
    name = "CreateDBClusterSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$create_db_cluster_snapshot_input(DBClusterSnapshotIdentifier = DBClusterSnapshotIdentifier, DBClusterIdentifier = DBClusterIdentifier, Tags = Tags)
  output <- .rds$create_db_cluster_snapshot_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$create_db_cluster_snapshot <- rds_create_db_cluster_snapshot

#' Creates a new DB instance
#'
#' @description
#' Creates a new DB instance.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_create_db_instance/](https://www.paws-r-sdk.com/docs/rds_create_db_instance/) for full documentation.
#'
#' @param DBName The meaning of this parameter differs according to the database engine
#' you use.
#' 
#' **MySQL**
#' 
#' The name of the database to create when the DB instance is created. If
#' this parameter isn't specified, no database is created in the DB
#' instance.
#' 
#' Constraints:
#' 
#' -   Must contain 1 to 64 letters or numbers.
#' 
#' -   Must begin with a letter. Subsequent characters can be letters,
#'     underscores, or digits (0-9).
#' 
#' -   Can't be a word reserved by the specified database engine
#' 
#' **MariaDB**
#' 
#' The name of the database to create when the DB instance is created. If
#' this parameter isn't specified, no database is created in the DB
#' instance.
#' 
#' Constraints:
#' 
#' -   Must contain 1 to 64 letters or numbers.
#' 
#' -   Must begin with a letter. Subsequent characters can be letters,
#'     underscores, or digits (0-9).
#' 
#' -   Can't be a word reserved by the specified database engine
#' 
#' **PostgreSQL**
#' 
#' The name of the database to create when the DB instance is created. If
#' this parameter isn't specified, a database named `postgres` is created
#' in the DB instance.
#' 
#' Constraints:
#' 
#' -   Must contain 1 to 63 letters, numbers, or underscores.
#' 
#' -   Must begin with a letter. Subsequent characters can be letters,
#'     underscores, or digits (0-9).
#' 
#' -   Can't be a word reserved by the specified database engine
#' 
#' **Oracle**
#' 
#' The Oracle System ID (SID) of the created DB instance. If you don't
#' specify a value, the default value is `ORCL`. You can't specify the
#' string `null`, or any other reserved word, for `DBName`.
#' 
#' Default: `ORCL`
#' 
#' Constraints:
#' 
#' -   Can't be longer than 8 characters
#' 
#' **Amazon RDS Custom for Oracle**
#' 
#' The Oracle System ID (SID) of the created RDS Custom DB instance. If you
#' don't specify a value, the default value is `ORCL` for non-CDBs and
#' `RDSCDB` for CDBs.
#' 
#' Default: `ORCL`
#' 
#' Constraints:
#' 
#' -   It must contain 1 to 8 alphanumeric characters.
#' 
#' -   It must contain a letter.
#' 
#' -   It can't be a word reserved by the database engine.
#' 
#' **Amazon RDS Custom for SQL Server**
#' 
#' Not applicable. Must be null.
#' 
#' **SQL Server**
#' 
#' Not applicable. Must be null.
#' 
#' **Amazon Aurora MySQL**
#' 
#' The name of the database to create when the primary DB instance of the
#' Aurora MySQL DB cluster is created. If this parameter isn't specified
#' for an Aurora MySQL DB cluster, no database is created in the DB
#' cluster.
#' 
#' Constraints:
#' 
#' -   It must contain 1 to 64 alphanumeric characters.
#' 
#' -   It can't be a word reserved by the database engine.
#' 
#' **Amazon Aurora PostgreSQL**
#' 
#' The name of the database to create when the primary DB instance of the
#' Aurora PostgreSQL DB cluster is created. If this parameter isn't
#' specified for an Aurora PostgreSQL DB cluster, a database named
#' `postgres` is created in the DB cluster.
#' 
#' Constraints:
#' 
#' -   It must contain 1 to 63 alphanumeric characters.
#' 
#' -   It must begin with a letter. Subsequent characters can be letters,
#'     underscores, or digits (0 to 9).
#' 
#' -   It can't be a word reserved by the database engine.
#' @param DBInstanceIdentifier &#91;required&#93; The identifier for this DB instance. This parameter is stored as a
#' lowercase string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `mydbinstance`
#' @param AllocatedStorage The amount of storage in gibibytes (GiB) to allocate for the DB
#' instance.
#' 
#' This setting doesn't apply to Amazon Aurora DB instances. Aurora cluster
#' volumes automatically grow as the amount of data in your database
#' increases, though you are only charged for the space that you use in an
#' Aurora cluster volume.
#' 
#' **Amazon RDS Custom**
#' 
#' Constraints to the amount of storage for each storage type are the
#' following:
#' 
#' -   General Purpose (SSD) storage (gp2, gp3): Must be an integer from 40
#'     to 65536 for RDS Custom for Oracle, 16384 for RDS Custom for SQL
#'     Server.
#' 
#' -   Provisioned IOPS storage (io1): Must be an integer from 40 to 65536
#'     for RDS Custom for Oracle, 16384 for RDS Custom for SQL Server.
#' 
#' **RDS for MariaDB**
#' 
#' Constraints to the amount of storage for each storage type are the
#' following:
#' 
#' -   General Purpose (SSD) storage (gp2, gp3): Must be an integer from 20
#'     to 65536.
#' 
#' -   Provisioned IOPS storage (io1): Must be an integer from 100 to
#'     65536.
#' 
#' -   Magnetic storage (standard): Must be an integer from 5 to 3072.
#' 
#' **RDS for MySQL**
#' 
#' Constraints to the amount of storage for each storage type are the
#' following:
#' 
#' -   General Purpose (SSD) storage (gp2, gp3): Must be an integer from 20
#'     to 65536.
#' 
#' -   Provisioned IOPS storage (io1): Must be an integer from 100 to
#'     65536.
#' 
#' -   Magnetic storage (standard): Must be an integer from 5 to 3072.
#' 
#' **RDS for Oracle**
#' 
#' Constraints to the amount of storage for each storage type are the
#' following:
#' 
#' -   General Purpose (SSD) storage (gp2, gp3): Must be an integer from 20
#'     to 65536.
#' 
#' -   Provisioned IOPS storage (io1): Must be an integer from 100 to
#'     65536.
#' 
#' -   Magnetic storage (standard): Must be an integer from 10 to 3072.
#' 
#' **RDS for PostgreSQL**
#' 
#' Constraints to the amount of storage for each storage type are the
#' following:
#' 
#' -   General Purpose (SSD) storage (gp2, gp3): Must be an integer from 20
#'     to 65536.
#' 
#' -   Provisioned IOPS storage (io1): Must be an integer from 100 to
#'     65536.
#' 
#' -   Magnetic storage (standard): Must be an integer from 5 to 3072.
#' 
#' **RDS for SQL Server**
#' 
#' Constraints to the amount of storage for each storage type are the
#' following:
#' 
#' -   General Purpose (SSD) storage (gp2, gp3):
#' 
#'     -   Enterprise and Standard editions: Must be an integer from 20 to
#'         16384.
#' 
#'     -   Web and Express editions: Must be an integer from 20 to 16384.
#' 
#' -   Provisioned IOPS storage (io1):
#' 
#'     -   Enterprise and Standard editions: Must be an integer from 100 to
#'         16384.
#' 
#'     -   Web and Express editions: Must be an integer from 100 to 16384.
#' 
#' -   Magnetic storage (standard):
#' 
#'     -   Enterprise and Standard editions: Must be an integer from 20 to
#'         1024.
#' 
#'     -   Web and Express editions: Must be an integer from 20 to 1024.
#' @param DBInstanceClass &#91;required&#93; The compute and memory capacity of the DB instance, for example
#' `db.m5.large`. Not all DB instance classes are available in all Amazon
#' Web Services Regions, or for all database engines. For the full list of
#' DB instance classes, and availability for your engine, see [DB instance
#' classes](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html)
#' in the *Amazon RDS User Guide* or [Aurora DB instance
#' classes](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.DBInstanceClass.html)
#' in the *Amazon Aurora User Guide*.
#' @param Engine &#91;required&#93; The database engine to use for this DB instance.
#' 
#' Not every database engine is available in every Amazon Web Services
#' Region.
#' 
#' Valid Values:
#' 
#' -   `aurora-mysql` (for Aurora MySQL DB instances)
#' 
#' -   `aurora-postgresql` (for Aurora PostgreSQL DB instances)
#' 
#' -   `custom-oracle-ee` (for RDS Custom for Oracle DB instances)
#' 
#' -   `custom-oracle-ee-cdb` (for RDS Custom for Oracle DB instances)
#' 
#' -   `custom-sqlserver-ee` (for RDS Custom for SQL Server DB instances)
#' 
#' -   `custom-sqlserver-se` (for RDS Custom for SQL Server DB instances)
#' 
#' -   `custom-sqlserver-web` (for RDS Custom for SQL Server DB instances)
#' 
#' -   `mariadb`
#' 
#' -   `mysql`
#' 
#' -   `oracle-ee`
#' 
#' -   `oracle-ee-cdb`
#' 
#' -   `oracle-se2`
#' 
#' -   `oracle-se2-cdb`
#' 
#' -   `postgres`
#' 
#' -   `sqlserver-ee`
#' 
#' -   `sqlserver-se`
#' 
#' -   `sqlserver-ex`
#' 
#' -   `sqlserver-web`
#' @param MasterUsername The name for the master user.
#' 
#' This setting doesn't apply to Amazon Aurora DB instances. The name for
#' the master user is managed by the DB cluster.
#' 
#' This setting is required for RDS DB instances.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 16 letters, numbers, or underscores.
#' 
#' -   First character must be a letter.
#' 
#' -   Can't be a reserved word for the chosen database engine.
#' @param MasterUserPassword The password for the master user.
#' 
#' This setting doesn't apply to Amazon Aurora DB instances. The password
#' for the master user is managed by the DB cluster.
#' 
#' Constraints:
#' 
#' -   Can't be specified if `ManageMasterUserPassword` is turned on.
#' 
#' -   Can include any printable ASCII character except "/", """, or "@@".
#' 
#' Length Constraints:
#' 
#' -   RDS for MariaDB - Must contain from 8 to 41 characters.
#' 
#' -   RDS for Microsoft SQL Server - Must contain from 8 to 128
#'     characters.
#' 
#' -   RDS for MySQL - Must contain from 8 to 41 characters.
#' 
#' -   RDS for Oracle - Must contain from 8 to 30 characters.
#' 
#' -   RDS for PostgreSQL - Must contain from 8 to 128 characters.
#' @param DBSecurityGroups A list of DB security groups to associate with this DB instance.
#' 
#' This setting applies to the legacy EC2-Classic platform, which is no
#' longer used to create new DB instances. Use the `VpcSecurityGroupIds`
#' setting instead.
#' @param VpcSecurityGroupIds A list of Amazon EC2 VPC security groups to associate with this DB
#' instance.
#' 
#' This setting doesn't apply to Amazon Aurora DB instances. The associated
#' list of EC2 VPC security groups is managed by the DB cluster.
#' 
#' Default: The default EC2 VPC security group for the DB subnet group's
#' VPC.
#' @param AvailabilityZone The Availability Zone (AZ) where the database will be created. For
#' information on Amazon Web Services Regions and Availability Zones, see
#' [Regions and Availability
#' Zones](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html).
#' 
#' For Amazon Aurora, each Aurora DB cluster hosts copies of its storage in
#' three separate Availability Zones. Specify one of these Availability
#' Zones. Aurora automatically chooses an appropriate Availability Zone if
#' you don't specify one.
#' 
#' Default: A random, system-chosen Availability Zone in the endpoint's
#' Amazon Web Services Region.
#' 
#' Constraints:
#' 
#' -   The `AvailabilityZone` parameter can't be specified if the DB
#'     instance is a Multi-AZ deployment.
#' 
#' -   The specified Availability Zone must be in the same Amazon Web
#'     Services Region as the current endpoint.
#' 
#' Example: `us-east-1d`
#' @param DBSubnetGroupName A DB subnet group to associate with this DB instance.
#' 
#' Constraints:
#' 
#' -   Must match the name of an existing DB subnet group.
#' 
#' -   Must not be `default`.
#' 
#' Example: `mydbsubnetgroup`
#' @param PreferredMaintenanceWindow The time range each week during which system maintenance can occur. For
#' more information, see [Amazon RDS Maintenance
#' Window](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance)
#' in the *Amazon RDS User Guide.*
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each Amazon Web Services Region, occurring on a random
#' day of the week.
#' 
#' Constraints:
#' 
#' -   Must be in the format `ddd:hh24:mi-ddd:hh24:mi`.
#' 
#' -   The day values must be `mon | tue | wed | thu | fri | sat | sun`.
#' 
#' -   Must be in Universal Coordinated Time (UTC).
#' 
#' -   Must not conflict with the preferred backup window.
#' 
#' -   Must be at least 30 minutes.
#' @param DBParameterGroupName The name of the DB parameter group to associate with this DB instance.
#' If you don't specify a value, then Amazon RDS uses the default DB
#' parameter group for the specified DB engine and version.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 255 letters, numbers, or hyphens.
#' 
#' -   The first character must be a letter.
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens.
#' @param BackupRetentionPeriod The number of days for which automated backups are retained. Setting
#' this parameter to a positive number enables backups. Setting this
#' parameter to `0` disables automated backups.
#' 
#' This setting doesn't apply to Amazon Aurora DB instances. The retention
#' period for automated backups is managed by the DB cluster.
#' 
#' Default: `1`
#' 
#' Constraints:
#' 
#' -   Must be a value from 0 to 35.
#' 
#' -   Can't be set to 0 if the DB instance is a source to read replicas.
#' 
#' -   Can't be set to 0 for an RDS Custom for Oracle DB instance.
#' @param PreferredBackupWindow The daily time range during which automated backups are created if
#' automated backups are enabled, using the `BackupRetentionPeriod`
#' parameter. The default is a 30-minute window selected at random from an
#' 8-hour block of time for each Amazon Web Services Region. For more
#' information, see [Backup
#' window](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow)
#' in the *Amazon RDS User Guide*.
#' 
#' This setting doesn't apply to Amazon Aurora DB instances. The daily time
#' range for creating automated backups is managed by the DB cluster.
#' 
#' Constraints:
#' 
#' -   Must be in the format `hh24:mi-hh24:mi`.
#' 
#' -   Must be in Universal Coordinated Time (UTC).
#' 
#' -   Must not conflict with the preferred maintenance window.
#' 
#' -   Must be at least 30 minutes.
#' @param Port The port number on which the database accepts connections.
#' 
#' This setting doesn't apply to Aurora DB instances. The port number is
#' managed by the cluster.
#' 
#' Valid Values: `1150-65535`
#' 
#' Default:
#' 
#' -   RDS for MariaDB - `3306`
#' 
#' -   RDS for Microsoft SQL Server - `1433`
#' 
#' -   RDS for MySQL - `3306`
#' 
#' -   RDS for Oracle - `1521`
#' 
#' -   RDS for PostgreSQL - `5432`
#' 
#' Constraints:
#' 
#' -   For RDS for Microsoft SQL Server, the value can't be `1234`, `1434`,
#'     `3260`, `3343`, `3389`, `47001`, or `49152-49156`.
#' @param MultiAZ Specifies whether the DB instance is a Multi-AZ deployment. You can't
#' set the `AvailabilityZone` parameter if the DB instance is a Multi-AZ
#' deployment.
#' 
#' This setting doesn't apply to the following DB instances:
#' 
#' -   Amazon Aurora (DB instance Availability Zones (AZs) are managed by
#'     the DB cluster.)
#' 
#' -   RDS Custom
#' @param EngineVersion The version number of the database engine to use.
#' 
#' This setting doesn't apply to Amazon Aurora DB instances. The version
#' number of the database engine the DB instance uses is managed by the DB
#' cluster.
#' 
#' For a list of valid engine versions, use the
#' [`describe_db_engine_versions`][rds_describe_db_engine_versions]
#' operation.
#' 
#' The following are the database engines and links to information about
#' the major and minor versions that are available with Amazon RDS. Not
#' every database engine is available for every Amazon Web Services Region.
#' 
#' **Amazon RDS Custom for Oracle**
#' 
#' A custom engine version (CEV) that you have previously created. This
#' setting is required for RDS Custom for Oracle. The CEV name has the
#' following format: 19.*customized_string*. A valid CEV name is
#' `19.my_cev1`. For more information, see [Creating an RDS Custom for
#' Oracle DB
#' instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-creating.html#custom-creating.create)
#' in the *Amazon RDS User Guide*.
#' 
#' **Amazon RDS Custom for SQL Server**
#' 
#' See [RDS Custom for SQL Server general
#' requirements](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-reqs-limits-MS.html)
#' in the *Amazon RDS User Guide*.
#' 
#' **RDS for MariaDB**
#' 
#' For information, see [MariaDB on Amazon RDS
#' versions](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt)
#' in the *Amazon RDS User Guide*.
#' 
#' **RDS for Microsoft SQL Server**
#' 
#' For information, see [Microsoft SQL Server versions on Amazon
#' RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport)
#' in the *Amazon RDS User Guide*.
#' 
#' **RDS for MySQL**
#' 
#' For information, see [MySQL on Amazon RDS
#' versions](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt)
#' in the *Amazon RDS User Guide*.
#' 
#' **RDS for Oracle**
#' 
#' For information, see [Oracle Database Engine release
#' notes](https://docs.aws.amazon.com/AmazonRDS/latest/OracleReleaseNotes/Welcome.html)
#' in the *Amazon RDS User Guide*.
#' 
#' **RDS for PostgreSQL**
#' 
#' For information, see [Amazon RDS for PostgreSQL versions and
#' extensions](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts)
#' in the *Amazon RDS User Guide*.
#' @param AutoMinorVersionUpgrade Specifies whether minor engine upgrades are applied automatically to the
#' DB instance during the maintenance window. By default, minor engine
#' upgrades are applied automatically.
#' 
#' If you create an RDS Custom DB instance, you must set
#' `AutoMinorVersionUpgrade` to `false`.
#' @param LicenseModel The license model information for this DB instance.
#' 
#' This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
#' 
#' Valid Values:
#' 
#' -   RDS for MariaDB - `general-public-license`
#' 
#' -   RDS for Microsoft SQL Server - `license-included`
#' 
#' -   RDS for MySQL - `general-public-license`
#' 
#' -   RDS for Oracle - `bring-your-own-license | license-included`
#' 
#' -   RDS for PostgreSQL - `postgresql-license`
#' @param Iops The amount of Provisioned IOPS (input/output operations per second) to
#' initially allocate for the DB instance. For information about valid IOPS
#' values, see [Amazon RDS DB instance
#' storage](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html)
#' in the *Amazon RDS User Guide*.
#' 
#' This setting doesn't apply to Amazon Aurora DB instances. Storage is
#' managed by the DB cluster.
#' 
#' Constraints:
#' 
#' -   For RDS for MariaDB, MySQL, Oracle, and PostgreSQL - Must be a
#'     multiple between .5 and 50 of the storage amount for the DB
#'     instance.
#' 
#' -   For RDS for SQL Server - Must be a multiple between 1 and 50 of the
#'     storage amount for the DB instance.
#' @param OptionGroupName The option group to associate the DB instance with.
#' 
#' Permanent options, such as the TDE option for Oracle Advanced Security
#' TDE, can't be removed from an option group. Also, that option group
#' can't be removed from a DB instance after it is associated with a DB
#' instance.
#' 
#' This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
#' @param CharacterSetName For supported engines, the character set (`CharacterSet`) to associate
#' the DB instance with.
#' 
#' This setting doesn't apply to the following DB instances:
#' 
#' -   Amazon Aurora - The character set is managed by the DB cluster. For
#'     more information, see [`create_db_cluster`][rds_create_db_cluster].
#' 
#' -   RDS Custom - However, if you need to change the character set, you
#'     can change it on the database itself.
#' @param NcharCharacterSetName The name of the NCHAR character set for the Oracle DB instance.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' @param PubliclyAccessible Specifies whether the DB instance is publicly accessible.
#' 
#' When the DB instance is publicly accessible, its Domain Name System
#' (DNS) endpoint resolves to the private IP address from within the DB
#' instance's virtual private cloud (VPC). It resolves to the public IP
#' address from outside of the DB instance's VPC. Access to the DB instance
#' is ultimately controlled by the security group it uses. That public
#' access is not permitted if the security group assigned to the DB
#' instance doesn't permit it.
#' 
#' When the DB instance isn't publicly accessible, it is an internal DB
#' instance with a DNS name that resolves to a private IP address.
#' 
#' Default: The default behavior varies depending on whether
#' `DBSubnetGroupName` is specified.
#' 
#' If `DBSubnetGroupName` isn't specified, and `PubliclyAccessible` isn't
#' specified, the following applies:
#' 
#' -   If the default VPC in the target Region doesn’t have an internet
#'     gateway attached to it, the DB instance is private.
#' 
#' -   If the default VPC in the target Region has an internet gateway
#'     attached to it, the DB instance is public.
#' 
#' If `DBSubnetGroupName` is specified, and `PubliclyAccessible` isn't
#' specified, the following applies:
#' 
#' -   If the subnets are part of a VPC that doesn’t have an internet
#'     gateway attached to it, the DB instance is private.
#' 
#' -   If the subnets are part of a VPC that has an internet gateway
#'     attached to it, the DB instance is public.
#' @param Tags Tags to assign to the DB instance.
#' @param DBClusterIdentifier The identifier of the DB cluster that this DB instance will belong to.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' @param StorageType The storage type to associate with the DB instance.
#' 
#' If you specify `io1` or `gp3`, you must also include a value for the
#' `Iops` parameter.
#' 
#' This setting doesn't apply to Amazon Aurora DB instances. Storage is
#' managed by the DB cluster.
#' 
#' Valid Values: `gp2 | gp3 | io1 | standard`
#' 
#' Default: `io1`, if the `Iops` parameter is specified. Otherwise, `gp2`.
#' @param TdeCredentialArn The ARN from the key store with which to associate the instance for TDE
#' encryption.
#' 
#' This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
#' @param TdeCredentialPassword The password for the given ARN from the key store in order to access the
#' device.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' @param StorageEncrypted Specifes whether the DB instance is encrypted. By default, it isn't
#' encrypted.
#' 
#' For RDS Custom DB instances, either enable this setting or leave it
#' unset. Otherwise, Amazon RDS reports an error.
#' 
#' This setting doesn't apply to Amazon Aurora DB instances. The encryption
#' for DB instances is managed by the DB cluster.
#' @param KmsKeyId The Amazon Web Services KMS key identifier for an encrypted DB instance.
#' 
#' The Amazon Web Services KMS key identifier is the key ARN, key ID, alias
#' ARN, or alias name for the KMS key. To use a KMS key in a different
#' Amazon Web Services account, specify the key ARN or alias ARN.
#' 
#' This setting doesn't apply to Amazon Aurora DB instances. The Amazon Web
#' Services KMS key identifier is managed by the DB cluster. For more
#' information, see [`create_db_cluster`][rds_create_db_cluster].
#' 
#' If `StorageEncrypted` is enabled, and you do not specify a value for the
#' `KmsKeyId` parameter, then Amazon RDS uses your default KMS key. There
#' is a default KMS key for your Amazon Web Services account. Your Amazon
#' Web Services account has a different default KMS key for each Amazon Web
#' Services Region.
#' 
#' For Amazon RDS Custom, a KMS key is required for DB instances. For most
#' RDS engines, if you leave this parameter empty while enabling
#' `StorageEncrypted`, the engine uses the default KMS key. However, RDS
#' Custom doesn't use the default key when this parameter is empty. You
#' must explicitly specify a key.
#' @param Domain The Active Directory directory ID to create the DB instance in.
#' Currently, only Microsoft SQL Server, MySQL, Oracle, and PostgreSQL DB
#' instances can be created in an Active Directory Domain.
#' 
#' For more information, see [Kerberos
#' Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/database-authentication.html)
#' in the *Amazon RDS User Guide*.
#' 
#' This setting doesn't apply to the following DB instances:
#' 
#' -   Amazon Aurora (The domain is managed by the DB cluster.)
#' 
#' -   RDS Custom
#' @param DomainFqdn The fully qualified domain name (FQDN) of an Active Directory domain.
#' 
#' Constraints:
#' 
#' -   Can't be longer than 64 characters.
#' 
#' Example: `mymanagedADtest.mymanagedAD.mydomain`
#' @param DomainOu The Active Directory organizational unit for your DB instance to join.
#' 
#' Constraints:
#' 
#' -   Must be in the distinguished name format.
#' 
#' -   Can't be longer than 64 characters.
#' 
#' Example:
#' `OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain`
#' @param DomainAuthSecretArn The ARN for the Secrets Manager secret with the credentials for the user
#' joining the domain.
#' 
#' Example:
#' `arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456`
#' @param DomainDnsIps The IPv4 DNS IP addresses of your primary and secondary Active Directory
#' domain controllers.
#' 
#' Constraints:
#' 
#' -   Two IP addresses must be provided. If there isn't a secondary domain
#'     controller, use the IP address of the primary domain controller for
#'     both entries in the list.
#' 
#' Example: `123.124.125.126,234.235.236.237`
#' @param CopyTagsToSnapshot Specifies whether to copy tags from the DB instance to snapshots of the
#' DB instance. By default, tags are not copied.
#' 
#' This setting doesn't apply to Amazon Aurora DB instances. Copying tags
#' to snapshots is managed by the DB cluster. Setting this value for an
#' Aurora DB instance has no effect on the DB cluster setting.
#' @param MonitoringInterval The interval, in seconds, between points when Enhanced Monitoring
#' metrics are collected for the DB instance. To disable collection of
#' Enhanced Monitoring metrics, specify `0`.
#' 
#' If `MonitoringRoleArn` is specified, then you must set
#' `MonitoringInterval` to a value other than `0`.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' 
#' Valid Values: `0 | 1 | 5 | 10 | 15 | 30 | 60`
#' 
#' Default: `0`
#' @param MonitoringRoleArn The ARN for the IAM role that permits RDS to send enhanced monitoring
#' metrics to Amazon CloudWatch Logs. For example,
#' `arn:aws:iam:123456789012:role/emaccess`. For information on creating a
#' monitoring role, see [Setting Up and Enabling Enhanced
#' Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling)
#' in the *Amazon RDS User Guide*.
#' 
#' If `MonitoringInterval` is set to a value other than `0`, then you must
#' supply a `MonitoringRoleArn` value.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' @param DomainIAMRoleName The name of the IAM role to use when making API calls to the Directory
#' Service.
#' 
#' This setting doesn't apply to the following DB instances:
#' 
#' -   Amazon Aurora (The domain is managed by the DB cluster.)
#' 
#' -   RDS Custom
#' @param PromotionTier The order of priority in which an Aurora Replica is promoted to the
#' primary instance after a failure of the existing primary instance. For
#' more information, see [Fault Tolerance for an Aurora DB
#' Cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.AuroraHighAvailability.html#Aurora.Managing.FaultTolerance)
#' in the *Amazon Aurora User Guide*.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' 
#' Default: `1`
#' 
#' Valid Values: `0 - 15`
#' @param Timezone The time zone of the DB instance. The time zone parameter is currently
#' supported only by [Microsoft SQL
#' Server](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone).
#' @param EnableIAMDatabaseAuthentication Specifies whether to enable mapping of Amazon Web Services Identity and
#' Access Management (IAM) accounts to database accounts. By default,
#' mapping isn't enabled.
#' 
#' For more information, see [IAM Database Authentication for MySQL and
#' PostgreSQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html)
#' in the *Amazon RDS User Guide*.
#' 
#' This setting doesn't apply to the following DB instances:
#' 
#' -   Amazon Aurora (Mapping Amazon Web Services IAM accounts to database
#'     accounts is managed by the DB cluster.)
#' 
#' -   RDS Custom
#' @param EnablePerformanceInsights Specifies whether to enable Performance Insights for the DB instance.
#' For more information, see [Using Amazon Performance
#' Insights](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html)
#' in the *Amazon RDS User Guide*.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' @param PerformanceInsightsKMSKeyId The Amazon Web Services KMS key identifier for encryption of Performance
#' Insights data.
#' 
#' The Amazon Web Services KMS key identifier is the key ARN, key ID, alias
#' ARN, or alias name for the KMS key.
#' 
#' If you don't specify a value for `PerformanceInsightsKMSKeyId`, then
#' Amazon RDS uses your default KMS key. There is a default KMS key for
#' your Amazon Web Services account. Your Amazon Web Services account has a
#' different default KMS key for each Amazon Web Services Region.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' @param PerformanceInsightsRetentionPeriod The number of days to retain Performance Insights data.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' 
#' Valid Values:
#' 
#' -   `7`
#' 
#' -   *month* * 31, where *month* is a number of months from 1-23.
#'     Examples: `93` (3 months * 31), `341` (11 months * 31), `589` (19
#'     months * 31)
#' 
#' -   `731`
#' 
#' Default: `7` days
#' 
#' If you specify a retention period that isn't valid, such as `94`, Amazon
#' RDS returns an error.
#' @param EnableCloudwatchLogsExports The list of log types that need to be enabled for exporting to
#' CloudWatch Logs. For more information, see [Publishing Database Logs to
#' Amazon CloudWatch
#' Logs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch)
#' in the *Amazon RDS User Guide*.
#' 
#' This setting doesn't apply to the following DB instances:
#' 
#' -   Amazon Aurora (CloudWatch Logs exports are managed by the DB
#'     cluster.)
#' 
#' -   RDS Custom
#' 
#' The following values are valid for each DB engine:
#' 
#' -   RDS for MariaDB - `audit | error | general | slowquery`
#' 
#' -   RDS for Microsoft SQL Server - `agent | error`
#' 
#' -   RDS for MySQL - `audit | error | general | slowquery`
#' 
#' -   RDS for Oracle - `alert | audit | listener | trace | oemagent`
#' 
#' -   RDS for PostgreSQL - `postgresql | upgrade`
#' @param ProcessorFeatures The number of CPU cores and the number of threads per core for the DB
#' instance class of the DB instance.
#' 
#' This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
#' @param DeletionProtection Specifies whether the DB instance has deletion protection enabled. The
#' database can't be deleted when deletion protection is enabled. By
#' default, deletion protection isn't enabled. For more information, see
#' [Deleting a DB
#' Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html).
#' 
#' This setting doesn't apply to Amazon Aurora DB instances. You can enable
#' or disable deletion protection for the DB cluster. For more information,
#' see [`create_db_cluster`][rds_create_db_cluster]. DB instances in a DB
#' cluster can be deleted even when deletion protection is enabled for the
#' DB cluster.
#' @param MaxAllocatedStorage The upper limit in gibibytes (GiB) to which Amazon RDS can automatically
#' scale the storage of the DB instance.
#' 
#' For more information about this setting, including limitations that
#' apply to it, see [Managing capacity automatically with Amazon RDS
#' storage
#' autoscaling](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling)
#' in the *Amazon RDS User Guide*.
#' 
#' This setting doesn't apply to the following DB instances:
#' 
#' -   Amazon Aurora (Storage is managed by the DB cluster.)
#' 
#' -   RDS Custom
#' @param EnableCustomerOwnedIp Specifies whether to enable a customer-owned IP address (CoIP) for an
#' RDS on Outposts DB instance.
#' 
#' A *CoIP* provides local or external connectivity to resources in your
#' Outpost subnets through your on-premises network. For some use cases, a
#' CoIP can provide lower latency for connections to the DB instance from
#' outside of its virtual private cloud (VPC) on your local network.
#' 
#' For more information about RDS on Outposts, see [Working with Amazon RDS
#' on Amazon Web Services
#' Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html)
#' in the *Amazon RDS User Guide*.
#' 
#' For more information about CoIPs, see [Customer-owned IP
#' addresses](https://docs.aws.amazon.com/outposts/latest/userguide/routing.html#ip-addressing)
#' in the *Amazon Web Services Outposts User Guide*.
#' @param CustomIamInstanceProfile The instance profile associated with the underlying Amazon EC2 instance
#' of an RDS Custom DB instance.
#' 
#' This setting is required for RDS Custom.
#' 
#' Constraints:
#' 
#' -   The profile must exist in your account.
#' 
#' -   The profile must have an IAM role that Amazon EC2 has permissions to
#'     assume.
#' 
#' -   The instance profile name and the associated IAM role name must
#'     start with the prefix `AWSRDSCustom`.
#' 
#' For the list of permissions required for the IAM role, see [Configure
#' IAM and your
#' VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc)
#' in the *Amazon RDS User Guide*.
#' @param BackupTarget The location for storing automated backups and manual snapshots.
#' 
#' Valie Values:
#' 
#' -   `outposts` (Amazon Web Services Outposts)
#' 
#' -   `region` (Amazon Web Services Region)
#' 
#' Default: `region`
#' 
#' For more information, see [Working with Amazon RDS on Amazon Web
#' Services
#' Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html)
#' in the *Amazon RDS User Guide*.
#' @param NetworkType The network type of the DB instance.
#' 
#' The network type is determined by the `DBSubnetGroup` specified for the
#' DB instance. A `DBSubnetGroup` can support only the IPv4 protocol or the
#' IPv4 and the IPv6 protocols (`DUAL`).
#' 
#' For more information, see [Working with a DB instance in a
#' VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html)
#' in the *Amazon RDS User Guide.*
#' 
#' Valid Values: `IPV4 | DUAL`
#' @param StorageThroughput The storage throughput value for the DB instance.
#' 
#' This setting applies only to the `gp3` storage type.
#' 
#' This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
#' @param ManageMasterUserPassword Specifies whether to manage the master user password with Amazon Web
#' Services Secrets Manager.
#' 
#' For more information, see [Password management with Amazon Web Services
#' Secrets
#' Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html)
#' in the *Amazon RDS User Guide.*
#' 
#' Constraints:
#' 
#' -   Can't manage the master user password with Amazon Web Services
#'     Secrets Manager if `MasterUserPassword` is specified.
#' @param MasterUserSecretKmsKeyId The Amazon Web Services KMS key identifier to encrypt a secret that is
#' automatically generated and managed in Amazon Web Services Secrets
#' Manager.
#' 
#' This setting is valid only if the master user password is managed by RDS
#' in Amazon Web Services Secrets Manager for the DB instance.
#' 
#' The Amazon Web Services KMS key identifier is the key ARN, key ID, alias
#' ARN, or alias name for the KMS key. To use a KMS key in a different
#' Amazon Web Services account, specify the key ARN or alias ARN.
#' 
#' If you don't specify `MasterUserSecretKmsKeyId`, then the
#' `aws/secretsmanager` KMS key is used to encrypt the secret. If the
#' secret is in a different Amazon Web Services account, then you can't use
#' the `aws/secretsmanager` KMS key to encrypt the secret, and you must use
#' a customer managed KMS key.
#' 
#' There is a default KMS key for your Amazon Web Services account. Your
#' Amazon Web Services account has a different default KMS key for each
#' Amazon Web Services Region.
#' @param CACertificateIdentifier The CA certificate identifier to use for the DB instance's server
#' certificate.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' 
#' For more information, see [Using SSL/TLS to encrypt a connection to a DB
#' instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html)
#' in the *Amazon RDS User Guide* and [Using SSL/TLS to encrypt a
#' connection to a DB
#' cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html)
#' in the *Amazon Aurora User Guide*.
#' @param DBSystemId The Oracle system identifier (SID), which is the name of the Oracle
#' database instance that manages your database files. In this context, the
#' term "Oracle database instance" refers exclusively to the system global
#' area (SGA) and Oracle background processes. If you don't specify a SID,
#' the value defaults to `RDSCDB`. The Oracle SID is also the name of your
#' CDB.
#'
#' @keywords internal
#'
#' @rdname rds_create_db_instance
rds_create_db_instance <- function(DBName = NULL, DBInstanceIdentifier, AllocatedStorage = NULL, DBInstanceClass, Engine, MasterUsername = NULL, MasterUserPassword = NULL, DBSecurityGroups = NULL, VpcSecurityGroupIds = NULL, AvailabilityZone = NULL, DBSubnetGroupName = NULL, PreferredMaintenanceWindow = NULL, DBParameterGroupName = NULL, BackupRetentionPeriod = NULL, PreferredBackupWindow = NULL, Port = NULL, MultiAZ = NULL, EngineVersion = NULL, AutoMinorVersionUpgrade = NULL, LicenseModel = NULL, Iops = NULL, OptionGroupName = NULL, CharacterSetName = NULL, NcharCharacterSetName = NULL, PubliclyAccessible = NULL, Tags = NULL, DBClusterIdentifier = NULL, StorageType = NULL, TdeCredentialArn = NULL, TdeCredentialPassword = NULL, StorageEncrypted = NULL, KmsKeyId = NULL, Domain = NULL, DomainFqdn = NULL, DomainOu = NULL, DomainAuthSecretArn = NULL, DomainDnsIps = NULL, CopyTagsToSnapshot = NULL, MonitoringInterval = NULL, MonitoringRoleArn = NULL, DomainIAMRoleName = NULL, PromotionTier = NULL, Timezone = NULL, EnableIAMDatabaseAuthentication = NULL, EnablePerformanceInsights = NULL, PerformanceInsightsKMSKeyId = NULL, PerformanceInsightsRetentionPeriod = NULL, EnableCloudwatchLogsExports = NULL, ProcessorFeatures = NULL, DeletionProtection = NULL, MaxAllocatedStorage = NULL, EnableCustomerOwnedIp = NULL, CustomIamInstanceProfile = NULL, BackupTarget = NULL, NetworkType = NULL, StorageThroughput = NULL, ManageMasterUserPassword = NULL, MasterUserSecretKmsKeyId = NULL, CACertificateIdentifier = NULL, DBSystemId = NULL) {
  op <- new_operation(
    name = "CreateDBInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$create_db_instance_input(DBName = DBName, DBInstanceIdentifier = DBInstanceIdentifier, AllocatedStorage = AllocatedStorage, DBInstanceClass = DBInstanceClass, Engine = Engine, MasterUsername = MasterUsername, MasterUserPassword = MasterUserPassword, DBSecurityGroups = DBSecurityGroups, VpcSecurityGroupIds = VpcSecurityGroupIds, AvailabilityZone = AvailabilityZone, DBSubnetGroupName = DBSubnetGroupName, PreferredMaintenanceWindow = PreferredMaintenanceWindow, DBParameterGroupName = DBParameterGroupName, BackupRetentionPeriod = BackupRetentionPeriod, PreferredBackupWindow = PreferredBackupWindow, Port = Port, MultiAZ = MultiAZ, EngineVersion = EngineVersion, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, LicenseModel = LicenseModel, Iops = Iops, OptionGroupName = OptionGroupName, CharacterSetName = CharacterSetName, NcharCharacterSetName = NcharCharacterSetName, PubliclyAccessible = PubliclyAccessible, Tags = Tags, DBClusterIdentifier = DBClusterIdentifier, StorageType = StorageType, TdeCredentialArn = TdeCredentialArn, TdeCredentialPassword = TdeCredentialPassword, StorageEncrypted = StorageEncrypted, KmsKeyId = KmsKeyId, Domain = Domain, DomainFqdn = DomainFqdn, DomainOu = DomainOu, DomainAuthSecretArn = DomainAuthSecretArn, DomainDnsIps = DomainDnsIps, CopyTagsToSnapshot = CopyTagsToSnapshot, MonitoringInterval = MonitoringInterval, MonitoringRoleArn = MonitoringRoleArn, DomainIAMRoleName = DomainIAMRoleName, PromotionTier = PromotionTier, Timezone = Timezone, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, EnablePerformanceInsights = EnablePerformanceInsights, PerformanceInsightsKMSKeyId = PerformanceInsightsKMSKeyId, PerformanceInsightsRetentionPeriod = PerformanceInsightsRetentionPeriod, EnableCloudwatchLogsExports = EnableCloudwatchLogsExports, ProcessorFeatures = ProcessorFeatures, DeletionProtection = DeletionProtection, MaxAllocatedStorage = MaxAllocatedStorage, EnableCustomerOwnedIp = EnableCustomerOwnedIp, CustomIamInstanceProfile = CustomIamInstanceProfile, BackupTarget = BackupTarget, NetworkType = NetworkType, StorageThroughput = StorageThroughput, ManageMasterUserPassword = ManageMasterUserPassword, MasterUserSecretKmsKeyId = MasterUserSecretKmsKeyId, CACertificateIdentifier = CACertificateIdentifier, DBSystemId = DBSystemId)
  output <- .rds$create_db_instance_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$create_db_instance <- rds_create_db_instance

#' Creates a new DB instance that acts as a read replica for an existing
#' source DB instance or Multi-AZ DB cluster
#'
#' @description
#' Creates a new DB instance that acts as a read replica for an existing source DB instance or Multi-AZ DB cluster. You can create a read replica for a DB instance running MySQL, MariaDB, Oracle, PostgreSQL, or SQL Server. You can create a read replica for a Multi-AZ DB cluster running MySQL or PostgreSQL. For more information, see [Working with read replicas](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReadRepl.html) and [Migrating from a Multi-AZ DB cluster to a DB instance using a read replica](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html#multi-az-db-clusters-migrating-to-instance-with-read-replica) in the *Amazon RDS User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_create_db_instance_read_replica/](https://www.paws-r-sdk.com/docs/rds_create_db_instance_read_replica/) for full documentation.
#'
#' @param DBInstanceIdentifier &#91;required&#93; The DB instance identifier of the read replica. This identifier is the
#' unique key that identifies a DB instance. This parameter is stored as a
#' lowercase string.
#' @param SourceDBInstanceIdentifier The identifier of the DB instance that will act as the source for the
#' read replica. Each DB instance can have up to 15 read replicas, with the
#' exception of Oracle and SQL Server, which can have up to five.
#' 
#' Constraints:
#' 
#' -   Must be the identifier of an existing MySQL, MariaDB, Oracle,
#'     PostgreSQL, or SQL Server DB instance.
#' 
#' -   Can't be specified if the `SourceDBClusterIdentifier` parameter is
#'     also specified.
#' 
#' -   For the limitations of Oracle read replicas, see [Version and
#'     licensing considerations for RDS for Oracle
#'     replicas](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.limitations.html#oracle-read-replicas.limitations.versions-and-licenses)
#'     in the *Amazon RDS User Guide*.
#' 
#' -   For the limitations of SQL Server read replicas, see [Read replica
#'     limitations with SQL
#'     Server](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/SQLServer.ReadReplicas.html#SQLServer.ReadReplicas.Limitations)
#'     in the *Amazon RDS User Guide*.
#' 
#' -   The specified DB instance must have automatic backups enabled, that
#'     is, its backup retention period must be greater than 0.
#' 
#' -   If the source DB instance is in the same Amazon Web Services Region
#'     as the read replica, specify a valid DB instance identifier.
#' 
#' -   If the source DB instance is in a different Amazon Web Services
#'     Region from the read replica, specify a valid DB instance ARN. For
#'     more information, see [Constructing an ARN for Amazon
#'     RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing)
#'     in the *Amazon RDS User Guide*. This doesn't apply to SQL Server or
#'     RDS Custom, which don't support cross-Region replicas.
#' @param DBInstanceClass The compute and memory capacity of the read replica, for example
#' db.m4.large. Not all DB instance classes are available in all Amazon Web
#' Services Regions, or for all database engines. For the full list of DB
#' instance classes, and availability for your engine, see [DB Instance
#' Class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html)
#' in the *Amazon RDS User Guide*.
#' 
#' Default: Inherits from the source DB instance.
#' @param AvailabilityZone The Availability Zone (AZ) where the read replica will be created.
#' 
#' Default: A random, system-chosen Availability Zone in the endpoint's
#' Amazon Web Services Region.
#' 
#' Example: `us-east-1d`
#' @param Port The port number that the DB instance uses for connections.
#' 
#' Default: Inherits from the source DB instance
#' 
#' Valid Values: `1150-65535`
#' @param MultiAZ A value that indicates whether the read replica is in a Multi-AZ
#' deployment.
#' 
#' You can create a read replica as a Multi-AZ DB instance. RDS creates a
#' standby of your replica in another Availability Zone for failover
#' support for the replica. Creating your read replica as a Multi-AZ DB
#' instance is independent of whether the source is a Multi-AZ DB instance
#' or a Multi-AZ DB cluster.
#' 
#' This setting doesn't apply to RDS Custom.
#' @param AutoMinorVersionUpgrade A value that indicates whether minor engine upgrades are applied
#' automatically to the read replica during the maintenance window.
#' 
#' This setting doesn't apply to RDS Custom.
#' 
#' Default: Inherits from the source DB instance
#' @param Iops The amount of Provisioned IOPS (input/output operations per second) to
#' be initially allocated for the DB instance.
#' @param OptionGroupName The option group the DB instance is associated with. If omitted, the
#' option group associated with the source instance or cluster is used.
#' 
#' For SQL Server, you must use the option group associated with the
#' source.
#' 
#' This setting doesn't apply to RDS Custom.
#' @param DBParameterGroupName The name of the DB parameter group to associate with this DB instance.
#' 
#' If you do not specify a value for `DBParameterGroupName`, then Amazon
#' RDS uses the `DBParameterGroup` of source DB instance for a same Region
#' read replica, or the default `DBParameterGroup` for the specified DB
#' engine for a cross-Region read replica.
#' 
#' Specifying a parameter group for this operation is only supported for
#' MySQL and Oracle DB instances. It isn't supported for RDS Custom.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 255 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens
#' @param PubliclyAccessible A value that indicates whether the DB instance is publicly accessible.
#' 
#' When the DB cluster is publicly accessible, its Domain Name System (DNS)
#' endpoint resolves to the private IP address from within the DB cluster's
#' virtual private cloud (VPC). It resolves to the public IP address from
#' outside of the DB cluster's VPC. Access to the DB cluster is ultimately
#' controlled by the security group it uses. That public access isn't
#' permitted if the security group assigned to the DB cluster doesn't
#' permit it.
#' 
#' When the DB instance isn't publicly accessible, it is an internal DB
#' instance with a DNS name that resolves to a private IP address.
#' 
#' For more information, see
#' [`create_db_instance`][rds_create_db_instance].
#' @param Tags 
#' @param DBSubnetGroupName Specifies a DB subnet group for the DB instance. The new DB instance is
#' created in the VPC associated with the DB subnet group. If no DB subnet
#' group is specified, then the new DB instance isn't created in a VPC.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing DBSubnetGroup.
#' 
#' -   The specified DB subnet group must be in the same Amazon Web
#'     Services Region in which the operation is running.
#' 
#' -   All read replicas in one Amazon Web Services Region that are created
#'     from the same source DB instance must either:\>
#' 
#'     -   Specify DB subnet groups from the same VPC. All these read
#'         replicas are created in the same VPC.
#' 
#'     -   Not specify a DB subnet group. All these read replicas are
#'         created outside of any VPC.
#' 
#' Example: `mydbsubnetgroup`
#' @param VpcSecurityGroupIds A list of Amazon EC2 VPC security groups to associate with the read
#' replica.
#' 
#' This setting doesn't apply to RDS Custom.
#' 
#' Default: The default EC2 VPC security group for the DB subnet group's
#' VPC.
#' @param StorageType Specifies the storage type to be associated with the read replica.
#' 
#' Valid values: `gp2 | gp3 | io1 | standard`
#' 
#' If you specify `io1` or `gp3`, you must also include a value for the
#' `Iops` parameter.
#' 
#' Default: `io1` if the `Iops` parameter is specified, otherwise `gp2`
#' @param CopyTagsToSnapshot A value that indicates whether to copy all tags from the read replica to
#' snapshots of the read replica. By default, tags are not copied.
#' @param MonitoringInterval The interval, in seconds, between points when Enhanced Monitoring
#' metrics are collected for the read replica. To disable collecting
#' Enhanced Monitoring metrics, specify 0. The default is 0.
#' 
#' If `MonitoringRoleArn` is specified, then you must also set
#' `MonitoringInterval` to a value other than 0.
#' 
#' This setting doesn't apply to RDS Custom.
#' 
#' Valid Values: `0, 1, 5, 10, 15, 30, 60`
#' @param MonitoringRoleArn The ARN for the IAM role that permits RDS to send enhanced monitoring
#' metrics to Amazon CloudWatch Logs. For example,
#' `arn:aws:iam:123456789012:role/emaccess`. For information on creating a
#' monitoring role, go to [To create an IAM role for Amazon RDS Enhanced
#' Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole)
#' in the *Amazon RDS User Guide*.
#' 
#' If `MonitoringInterval` is set to a value other than 0, then you must
#' supply a `MonitoringRoleArn` value.
#' 
#' This setting doesn't apply to RDS Custom.
#' @param KmsKeyId The Amazon Web Services KMS key identifier for an encrypted read
#' replica.
#' 
#' The Amazon Web Services KMS key identifier is the key ARN, key ID, alias
#' ARN, or alias name for the KMS key.
#' 
#' If you create an encrypted read replica in the same Amazon Web Services
#' Region as the source DB instance or Multi-AZ DB cluster, don't specify a
#' value for this parameter. A read replica in the same Amazon Web Services
#' Region is always encrypted with the same KMS key as the source DB
#' instance or cluster.
#' 
#' If you create an encrypted read replica in a different Amazon Web
#' Services Region, then you must specify a KMS key identifier for the
#' destination Amazon Web Services Region. KMS keys are specific to the
#' Amazon Web Services Region that they are created in, and you can't use
#' KMS keys from one Amazon Web Services Region in another Amazon Web
#' Services Region.
#' 
#' You can't create an encrypted read replica from an unencrypted DB
#' instance or Multi-AZ DB cluster.
#' 
#' This setting doesn't apply to RDS Custom, which uses the same KMS key as
#' the primary replica.
#' @param PreSignedUrl When you are creating a read replica from one Amazon Web Services
#' GovCloud (US) Region to another or from one China Amazon Web Services
#' Region to another, the URL that contains a Signature Version 4 signed
#' request for the
#' [`create_db_instance_read_replica`][rds_create_db_instance_read_replica]
#' API operation in the source Amazon Web Services Region that contains the
#' source DB instance.
#' 
#' This setting applies only to Amazon Web Services GovCloud (US) Regions
#' and China Amazon Web Services Regions. It's ignored in other Amazon Web
#' Services Regions.
#' 
#' This setting applies only when replicating from a source DB *instance*.
#' Source DB clusters aren't supported in Amazon Web Services GovCloud (US)
#' Regions and China Amazon Web Services Regions.
#' 
#' You must specify this parameter when you create an encrypted read
#' replica from another Amazon Web Services Region by using the Amazon RDS
#' API. Don't specify `PreSignedUrl` when you are creating an encrypted
#' read replica in the same Amazon Web Services Region.
#' 
#' The presigned URL must be a valid request for the
#' [`create_db_instance_read_replica`][rds_create_db_instance_read_replica]
#' API operation that can run in the source Amazon Web Services Region that
#' contains the encrypted source DB instance. The presigned URL request
#' must contain the following parameter values:
#' 
#' -   `DestinationRegion` - The Amazon Web Services Region that the
#'     encrypted read replica is created in. This Amazon Web Services
#'     Region is the same one where the
#'     [`create_db_instance_read_replica`][rds_create_db_instance_read_replica]
#'     operation is called that contains this presigned URL.
#' 
#'     For example, if you create an encrypted DB instance in the us-west-1
#'     Amazon Web Services Region, from a source DB instance in the
#'     us-east-2 Amazon Web Services Region, then you call the
#'     [`create_db_instance_read_replica`][rds_create_db_instance_read_replica]
#'     operation in the us-east-1 Amazon Web Services Region and provide a
#'     presigned URL that contains a call to the
#'     [`create_db_instance_read_replica`][rds_create_db_instance_read_replica]
#'     operation in the us-west-2 Amazon Web Services Region. For this
#'     example, the `DestinationRegion` in the presigned URL must be set to
#'     the us-east-1 Amazon Web Services Region.
#' 
#' -   `KmsKeyId` - The KMS key identifier for the key to use to encrypt
#'     the read replica in the destination Amazon Web Services Region. This
#'     is the same identifier for both the
#'     [`create_db_instance_read_replica`][rds_create_db_instance_read_replica]
#'     operation that is called in the destination Amazon Web Services
#'     Region, and the operation contained in the presigned URL.
#' 
#' -   `SourceDBInstanceIdentifier` - The DB instance identifier for the
#'     encrypted DB instance to be replicated. This identifier must be in
#'     the Amazon Resource Name (ARN) format for the source Amazon Web
#'     Services Region. For example, if you are creating an encrypted read
#'     replica from a DB instance in the us-west-2 Amazon Web Services
#'     Region, then your `SourceDBInstanceIdentifier` looks like the
#'     following example:
#'     `arn:aws:rds:us-west-2:123456789012:instance:mysql-instance1-20161115`.
#' 
#' To learn how to generate a Signature Version 4 signed request, see
#' [Authenticating Requests: Using Query Parameters (Amazon Web Services
#' Signature Version
#' 4)](https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html)
#' and [Signature Version 4 Signing
#' Process](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html).
#' 
#' If you are using an Amazon Web Services SDK tool or the CLI, you can
#' specify `SourceRegion` (or `--source-region` for the CLI) instead of
#' specifying `PreSignedUrl` manually. Specifying `SourceRegion`
#' autogenerates a presigned URL that is a valid request for the operation
#' that can run in the source Amazon Web Services Region.
#' 
#' `SourceRegion` isn't supported for SQL Server, because Amazon RDS for
#' SQL Server doesn't support cross-Region read replicas.
#' 
#' This setting doesn't apply to RDS Custom.
#' 
#' If you supply a value for this operation's `SourceRegion` parameter, a
#' pre-signed URL will be calculated on your behalf.
#' @param EnableIAMDatabaseAuthentication A value that indicates whether to enable mapping of Amazon Web Services
#' Identity and Access Management (IAM) accounts to database accounts. By
#' default, mapping isn't enabled.
#' 
#' For more information about IAM database authentication, see [IAM
#' Database Authentication for MySQL and
#' PostgreSQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html)
#' in the *Amazon RDS User Guide*.
#' 
#' This setting doesn't apply to RDS Custom.
#' @param EnablePerformanceInsights A value that indicates whether to enable Performance Insights for the
#' read replica.
#' 
#' For more information, see [Using Amazon Performance
#' Insights](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html)
#' in the *Amazon RDS User Guide*.
#' 
#' This setting doesn't apply to RDS Custom.
#' @param PerformanceInsightsKMSKeyId The Amazon Web Services KMS key identifier for encryption of Performance
#' Insights data.
#' 
#' The Amazon Web Services KMS key identifier is the key ARN, key ID, alias
#' ARN, or alias name for the KMS key.
#' 
#' If you do not specify a value for `PerformanceInsightsKMSKeyId`, then
#' Amazon RDS uses your default KMS key. There is a default KMS key for
#' your Amazon Web Services account. Your Amazon Web Services account has a
#' different default KMS key for each Amazon Web Services Region.
#' 
#' This setting doesn't apply to RDS Custom.
#' @param PerformanceInsightsRetentionPeriod The number of days to retain Performance Insights data. The default is 7
#' days. The following values are valid:
#' 
#' -   7
#' 
#' -   *month* * 31, where *month* is a number of months from 1-23
#' 
#' -   731
#' 
#' For example, the following values are valid:
#' 
#' -   93 (3 months * 31)
#' 
#' -   341 (11 months * 31)
#' 
#' -   589 (19 months * 31)
#' 
#' -   731
#' 
#' If you specify a retention period such as 94, which isn't a valid value,
#' RDS issues an error.
#' 
#' This setting doesn't apply to RDS Custom.
#' @param EnableCloudwatchLogsExports The list of logs that the new DB instance is to export to CloudWatch
#' Logs. The values in the list depend on the DB engine being used. For
#' more information, see [Publishing Database Logs to Amazon CloudWatch
#' Logs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch)
#' in the *Amazon RDS User Guide*.
#' 
#' This setting doesn't apply to RDS Custom.
#' @param ProcessorFeatures The number of CPU cores and the number of threads per core for the DB
#' instance class of the DB instance.
#' 
#' This setting doesn't apply to RDS Custom.
#' @param UseDefaultProcessorFeatures A value that indicates whether the DB instance class of the DB instance
#' uses its default processor features.
#' 
#' This setting doesn't apply to RDS Custom.
#' @param DeletionProtection A value that indicates whether the DB instance has deletion protection
#' enabled. The database can't be deleted when deletion protection is
#' enabled. By default, deletion protection isn't enabled. For more
#' information, see [Deleting a DB
#' Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html).
#' @param Domain The Active Directory directory ID to create the DB instance in.
#' Currently, only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB
#' instances can be created in an Active Directory Domain.
#' 
#' For more information, see [Kerberos
#' Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/database-authentication.html)
#' in the *Amazon RDS User Guide*.
#' 
#' This setting doesn't apply to RDS Custom.
#' @param DomainIAMRoleName The name of the IAM role to be used when making API calls to the
#' Directory Service.
#' 
#' This setting doesn't apply to RDS Custom.
#' @param DomainFqdn The fully qualified domain name (FQDN) of an Active Directory domain.
#' 
#' Constraints:
#' 
#' -   Can't be longer than 64 characters.
#' 
#' Example: `mymanagedADtest.mymanagedAD.mydomain`
#' @param DomainOu The Active Directory organizational unit for your DB instance to join.
#' 
#' Constraints:
#' 
#' -   Must be in the distinguished name format.
#' 
#' -   Can't be longer than 64 characters.
#' 
#' Example:
#' `OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain`
#' @param DomainAuthSecretArn The ARN for the Secrets Manager secret with the credentials for the user
#' joining the domain.
#' 
#' Example:
#' `arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456`
#' @param DomainDnsIps The IPv4 DNS IP addresses of your primary and secondary Active Directory
#' domain controllers.
#' 
#' Constraints:
#' 
#' -   Two IP addresses must be provided. If there isn't a secondary domain
#'     controller, use the IP address of the primary domain controller for
#'     both entries in the list.
#' 
#' Example: `123.124.125.126,234.235.236.237`
#' @param ReplicaMode The open mode of the replica database: mounted or read-only.
#' 
#' This parameter is only supported for Oracle DB instances.
#' 
#' Mounted DB replicas are included in Oracle Database Enterprise Edition.
#' The main use case for mounted replicas is cross-Region disaster
#' recovery. The primary database doesn't use Active Data Guard to transmit
#' information to the mounted replica. Because it doesn't accept user
#' connections, a mounted replica can't serve a read-only workload.
#' 
#' You can create a combination of mounted and read-only DB replicas for
#' the same primary DB instance. For more information, see [Working with
#' Oracle Read Replicas for Amazon
#' RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html)
#' in the *Amazon RDS User Guide*.
#' 
#' For RDS Custom, you must specify this parameter and set it to `mounted`.
#' The value won't be set by default. After replica creation, you can
#' manage the open mode manually.
#' @param MaxAllocatedStorage The upper limit in gibibytes (GiB) to which Amazon RDS can automatically
#' scale the storage of the DB instance.
#' 
#' For more information about this setting, including limitations that
#' apply to it, see [Managing capacity automatically with Amazon RDS
#' storage
#' autoscaling](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling)
#' in the *Amazon RDS User Guide*.
#' @param CustomIamInstanceProfile The instance profile associated with the underlying Amazon EC2 instance
#' of an RDS Custom DB instance. The instance profile must meet the
#' following requirements:
#' 
#' -   The profile must exist in your account.
#' 
#' -   The profile must have an IAM role that Amazon EC2 has permissions to
#'     assume.
#' 
#' -   The instance profile name and the associated IAM role name must
#'     start with the prefix `AWSRDSCustom`.
#' 
#' For the list of permissions required for the IAM role, see [Configure
#' IAM and your
#' VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc)
#' in the *Amazon RDS User Guide*.
#' 
#' This setting is required for RDS Custom.
#' @param NetworkType The network type of the DB instance.
#' 
#' Valid values:
#' 
#' -   `IPV4`
#' 
#' -   `DUAL`
#' 
#' The network type is determined by the `DBSubnetGroup` specified for read
#' replica. A `DBSubnetGroup` can support only the IPv4 protocol or the
#' IPv4 and the IPv6 protocols (`DUAL`).
#' 
#' For more information, see [Working with a DB instance in a
#' VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html)
#' in the *Amazon RDS User Guide.*
#' @param StorageThroughput Specifies the storage throughput value for the read replica.
#' 
#' This setting doesn't apply to RDS Custom or Amazon Aurora.
#' @param EnableCustomerOwnedIp A value that indicates whether to enable a customer-owned IP address
#' (CoIP) for an RDS on Outposts read replica.
#' 
#' A *CoIP* provides local or external connectivity to resources in your
#' Outpost subnets through your on-premises network. For some use cases, a
#' CoIP can provide lower latency for connections to the read replica from
#' outside of its virtual private cloud (VPC) on your local network.
#' 
#' For more information about RDS on Outposts, see [Working with Amazon RDS
#' on Amazon Web Services
#' Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html)
#' in the *Amazon RDS User Guide*.
#' 
#' For more information about CoIPs, see [Customer-owned IP
#' addresses](https://docs.aws.amazon.com/outposts/latest/userguide/routing.html#ip-addressing)
#' in the *Amazon Web Services Outposts User Guide*.
#' @param AllocatedStorage The amount of storage (in gibibytes) to allocate initially for the read
#' replica. Follow the allocation rules specified in
#' [`create_db_instance`][rds_create_db_instance].
#' 
#' Be sure to allocate enough storage for your read replica so that the
#' create operation can succeed. You can also allocate additional storage
#' for future growth.
#' @param SourceDBClusterIdentifier The identifier of the Multi-AZ DB cluster that will act as the source
#' for the read replica. Each DB cluster can have up to 15 read replicas.
#' 
#' Constraints:
#' 
#' -   Must be the identifier of an existing Multi-AZ DB cluster.
#' 
#' -   Can't be specified if the `SourceDBInstanceIdentifier` parameter is
#'     also specified.
#' 
#' -   The specified DB cluster must have automatic backups enabled, that
#'     is, its backup retention period must be greater than 0.
#' 
#' -   The source DB cluster must be in the same Amazon Web Services Region
#'     as the read replica. Cross-Region replication isn't supported.
#' @param SourceRegion The ID of the region that contains the source for the read replica.
#'
#' @keywords internal
#'
#' @rdname rds_create_db_instance_read_replica
rds_create_db_instance_read_replica <- function(DBInstanceIdentifier, SourceDBInstanceIdentifier = NULL, DBInstanceClass = NULL, AvailabilityZone = NULL, Port = NULL, MultiAZ = NULL, AutoMinorVersionUpgrade = NULL, Iops = NULL, OptionGroupName = NULL, DBParameterGroupName = NULL, PubliclyAccessible = NULL, Tags = NULL, DBSubnetGroupName = NULL, VpcSecurityGroupIds = NULL, StorageType = NULL, CopyTagsToSnapshot = NULL, MonitoringInterval = NULL, MonitoringRoleArn = NULL, KmsKeyId = NULL, PreSignedUrl = NULL, EnableIAMDatabaseAuthentication = NULL, EnablePerformanceInsights = NULL, PerformanceInsightsKMSKeyId = NULL, PerformanceInsightsRetentionPeriod = NULL, EnableCloudwatchLogsExports = NULL, ProcessorFeatures = NULL, UseDefaultProcessorFeatures = NULL, DeletionProtection = NULL, Domain = NULL, DomainIAMRoleName = NULL, DomainFqdn = NULL, DomainOu = NULL, DomainAuthSecretArn = NULL, DomainDnsIps = NULL, ReplicaMode = NULL, MaxAllocatedStorage = NULL, CustomIamInstanceProfile = NULL, NetworkType = NULL, StorageThroughput = NULL, EnableCustomerOwnedIp = NULL, AllocatedStorage = NULL, SourceDBClusterIdentifier = NULL, SourceRegion = NULL) {
  op <- new_operation(
    name = "CreateDBInstanceReadReplica",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$create_db_instance_read_replica_input(DBInstanceIdentifier = DBInstanceIdentifier, SourceDBInstanceIdentifier = SourceDBInstanceIdentifier, DBInstanceClass = DBInstanceClass, AvailabilityZone = AvailabilityZone, Port = Port, MultiAZ = MultiAZ, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, Iops = Iops, OptionGroupName = OptionGroupName, DBParameterGroupName = DBParameterGroupName, PubliclyAccessible = PubliclyAccessible, Tags = Tags, DBSubnetGroupName = DBSubnetGroupName, VpcSecurityGroupIds = VpcSecurityGroupIds, StorageType = StorageType, CopyTagsToSnapshot = CopyTagsToSnapshot, MonitoringInterval = MonitoringInterval, MonitoringRoleArn = MonitoringRoleArn, KmsKeyId = KmsKeyId, PreSignedUrl = PreSignedUrl, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, EnablePerformanceInsights = EnablePerformanceInsights, PerformanceInsightsKMSKeyId = PerformanceInsightsKMSKeyId, PerformanceInsightsRetentionPeriod = PerformanceInsightsRetentionPeriod, EnableCloudwatchLogsExports = EnableCloudwatchLogsExports, ProcessorFeatures = ProcessorFeatures, UseDefaultProcessorFeatures = UseDefaultProcessorFeatures, DeletionProtection = DeletionProtection, Domain = Domain, DomainIAMRoleName = DomainIAMRoleName, DomainFqdn = DomainFqdn, DomainOu = DomainOu, DomainAuthSecretArn = DomainAuthSecretArn, DomainDnsIps = DomainDnsIps, ReplicaMode = ReplicaMode, MaxAllocatedStorage = MaxAllocatedStorage, CustomIamInstanceProfile = CustomIamInstanceProfile, NetworkType = NetworkType, StorageThroughput = StorageThroughput, EnableCustomerOwnedIp = EnableCustomerOwnedIp, AllocatedStorage = AllocatedStorage, SourceDBClusterIdentifier = SourceDBClusterIdentifier, SourceRegion = SourceRegion)
  output <- .rds$create_db_instance_read_replica_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$create_db_instance_read_replica <- rds_create_db_instance_read_replica

#' Creates a new DB parameter group
#'
#' @description
#' Creates a new DB parameter group.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_create_db_parameter_group/](https://www.paws-r-sdk.com/docs/rds_create_db_parameter_group/) for full documentation.
#'
#' @param DBParameterGroupName &#91;required&#93; The name of the DB parameter group.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 255 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens
#' 
#' This value is stored as a lowercase string.
#' @param DBParameterGroupFamily &#91;required&#93; The DB parameter group family name. A DB parameter group can be
#' associated with one and only one DB parameter group family, and can be
#' applied only to a DB instance running a database engine and engine
#' version compatible with that DB parameter group family.
#' 
#' To list all of the available parameter group families for a DB engine,
#' use the following command:
#' 
#' `aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine <engine>`
#' 
#' For example, to list all of the available parameter group families for
#' the MySQL DB engine, use the following command:
#' 
#' `aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine mysql`
#' 
#' The output contains duplicates.
#' 
#' The following are the valid DB engine values:
#' 
#' -   `aurora-mysql`
#' 
#' -   `aurora-postgresql`
#' 
#' -   `mariadb`
#' 
#' -   `mysql`
#' 
#' -   `oracle-ee`
#' 
#' -   `oracle-ee-cdb`
#' 
#' -   `oracle-se2`
#' 
#' -   `oracle-se2-cdb`
#' 
#' -   `postgres`
#' 
#' -   `sqlserver-ee`
#' 
#' -   `sqlserver-se`
#' 
#' -   `sqlserver-ex`
#' 
#' -   `sqlserver-web`
#' @param Description &#91;required&#93; The description for the DB parameter group.
#' @param Tags Tags to assign to the DB parameter group.
#'
#' @keywords internal
#'
#' @rdname rds_create_db_parameter_group
rds_create_db_parameter_group <- function(DBParameterGroupName, DBParameterGroupFamily, Description, Tags = NULL) {
  op <- new_operation(
    name = "CreateDBParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$create_db_parameter_group_input(DBParameterGroupName = DBParameterGroupName, DBParameterGroupFamily = DBParameterGroupFamily, Description = Description, Tags = Tags)
  output <- .rds$create_db_parameter_group_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$create_db_parameter_group <- rds_create_db_parameter_group

#' Creates a new DB proxy
#'
#' @description
#' Creates a new DB proxy.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_create_db_proxy/](https://www.paws-r-sdk.com/docs/rds_create_db_proxy/) for full documentation.
#'
#' @param DBProxyName &#91;required&#93; The identifier for the proxy. This name must be unique for all proxies
#' owned by your Amazon Web Services account in the specified Amazon Web
#' Services Region. An identifier must begin with a letter and must contain
#' only ASCII letters, digits, and hyphens; it can't end with a hyphen or
#' contain two consecutive hyphens.
#' @param EngineFamily &#91;required&#93; The kinds of databases that the proxy can connect to. This value
#' determines which database network protocol the proxy recognizes when it
#' interprets network traffic to and from the database. For Aurora MySQL,
#' RDS for MariaDB, and RDS for MySQL databases, specify `MYSQL`. For
#' Aurora PostgreSQL and RDS for PostgreSQL databases, specify
#' `POSTGRESQL`. For RDS for Microsoft SQL Server, specify `SQLSERVER`.
#' @param Auth &#91;required&#93; The authorization mechanism that the proxy uses.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role that the proxy uses to
#' access secrets in Amazon Web Services Secrets Manager.
#' @param VpcSubnetIds &#91;required&#93; One or more VPC subnet IDs to associate with the new proxy.
#' @param VpcSecurityGroupIds One or more VPC security group IDs to associate with the new proxy.
#' @param RequireTLS A Boolean parameter that specifies whether Transport Layer Security
#' (TLS) encryption is required for connections to the proxy. By enabling
#' this setting, you can enforce encrypted TLS connections to the proxy.
#' @param IdleClientTimeout The number of seconds that a connection to the proxy can be inactive
#' before the proxy disconnects it. You can set this value higher or lower
#' than the connection timeout limit for the associated database.
#' @param DebugLogging Whether the proxy includes detailed information about SQL statements in
#' its logs. This information helps you to debug issues involving SQL
#' behavior or the performance and scalability of the proxy connections.
#' The debug information includes the text of SQL statements that you
#' submit through the proxy. Thus, only enable this setting when needed for
#' debugging, and only when you have security measures in place to
#' safeguard any sensitive information that appears in the logs.
#' @param Tags An optional set of key-value pairs to associate arbitrary data of your
#' choosing with the proxy.
#'
#' @keywords internal
#'
#' @rdname rds_create_db_proxy
rds_create_db_proxy <- function(DBProxyName, EngineFamily, Auth, RoleArn, VpcSubnetIds, VpcSecurityGroupIds = NULL, RequireTLS = NULL, IdleClientTimeout = NULL, DebugLogging = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateDBProxy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$create_db_proxy_input(DBProxyName = DBProxyName, EngineFamily = EngineFamily, Auth = Auth, RoleArn = RoleArn, VpcSubnetIds = VpcSubnetIds, VpcSecurityGroupIds = VpcSecurityGroupIds, RequireTLS = RequireTLS, IdleClientTimeout = IdleClientTimeout, DebugLogging = DebugLogging, Tags = Tags)
  output <- .rds$create_db_proxy_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$create_db_proxy <- rds_create_db_proxy

#' Creates a DBProxyEndpoint
#'
#' @description
#' Creates a `DBProxyEndpoint`. Only applies to proxies that are associated with Aurora DB clusters. You can use DB proxy endpoints to specify read/write or read-only access to the DB cluster. You can also use DB proxy endpoints to access a DB proxy through a different VPC than the proxy's default VPC.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_create_db_proxy_endpoint/](https://www.paws-r-sdk.com/docs/rds_create_db_proxy_endpoint/) for full documentation.
#'
#' @param DBProxyName &#91;required&#93; The name of the DB proxy associated with the DB proxy endpoint that you
#' create.
#' @param DBProxyEndpointName &#91;required&#93; The name of the DB proxy endpoint to create.
#' @param VpcSubnetIds &#91;required&#93; The VPC subnet IDs for the DB proxy endpoint that you create. You can
#' specify a different set of subnet IDs than for the original DB proxy.
#' @param VpcSecurityGroupIds The VPC security group IDs for the DB proxy endpoint that you create.
#' You can specify a different set of security group IDs than for the
#' original DB proxy. The default is the default security group for the
#' VPC.
#' @param TargetRole A value that indicates whether the DB proxy endpoint can be used for
#' read/write or read-only operations. The default is `READ_WRITE`. The
#' only role that proxies for RDS for Microsoft SQL Server support is
#' `READ_WRITE`.
#' @param Tags 
#'
#' @keywords internal
#'
#' @rdname rds_create_db_proxy_endpoint
rds_create_db_proxy_endpoint <- function(DBProxyName, DBProxyEndpointName, VpcSubnetIds, VpcSecurityGroupIds = NULL, TargetRole = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateDBProxyEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$create_db_proxy_endpoint_input(DBProxyName = DBProxyName, DBProxyEndpointName = DBProxyEndpointName, VpcSubnetIds = VpcSubnetIds, VpcSecurityGroupIds = VpcSecurityGroupIds, TargetRole = TargetRole, Tags = Tags)
  output <- .rds$create_db_proxy_endpoint_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$create_db_proxy_endpoint <- rds_create_db_proxy_endpoint

#' Creates a new DB security group
#'
#' @description
#' Creates a new DB security group. DB security groups control access to a DB instance.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_create_db_security_group/](https://www.paws-r-sdk.com/docs/rds_create_db_security_group/) for full documentation.
#'
#' @param DBSecurityGroupName &#91;required&#93; The name for the DB security group. This value is stored as a lowercase
#' string.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 255 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens
#' 
#' -   Must not be "Default"
#' 
#' Example: `mysecuritygroup`
#' @param DBSecurityGroupDescription &#91;required&#93; The description for the DB security group.
#' @param Tags Tags to assign to the DB security group.
#'
#' @keywords internal
#'
#' @rdname rds_create_db_security_group
rds_create_db_security_group <- function(DBSecurityGroupName, DBSecurityGroupDescription, Tags = NULL) {
  op <- new_operation(
    name = "CreateDBSecurityGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$create_db_security_group_input(DBSecurityGroupName = DBSecurityGroupName, DBSecurityGroupDescription = DBSecurityGroupDescription, Tags = Tags)
  output <- .rds$create_db_security_group_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$create_db_security_group <- rds_create_db_security_group

#' Creates a snapshot of a DB instance
#'
#' @description
#' Creates a snapshot of a DB instance. The source DB instance must be in the `available` or `storage-optimization` state.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_create_db_snapshot/](https://www.paws-r-sdk.com/docs/rds_create_db_snapshot/) for full documentation.
#'
#' @param DBSnapshotIdentifier &#91;required&#93; The identifier for the DB snapshot.
#' 
#' Constraints:
#' 
#' -   Can't be null, empty, or blank
#' 
#' -   Must contain from 1 to 255 letters, numbers, or hyphens
#' 
#' -   First character must be a letter
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens
#' 
#' Example: `my-snapshot-id`
#' @param DBInstanceIdentifier &#91;required&#93; The identifier of the DB instance that you want to create the snapshot
#' of.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DBInstance.
#' @param Tags 
#'
#' @keywords internal
#'
#' @rdname rds_create_db_snapshot
rds_create_db_snapshot <- function(DBSnapshotIdentifier, DBInstanceIdentifier, Tags = NULL) {
  op <- new_operation(
    name = "CreateDBSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$create_db_snapshot_input(DBSnapshotIdentifier = DBSnapshotIdentifier, DBInstanceIdentifier = DBInstanceIdentifier, Tags = Tags)
  output <- .rds$create_db_snapshot_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$create_db_snapshot <- rds_create_db_snapshot

#' Creates a new DB subnet group
#'
#' @description
#' Creates a new DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_create_db_subnet_group/](https://www.paws-r-sdk.com/docs/rds_create_db_subnet_group/) for full documentation.
#'
#' @param DBSubnetGroupName &#91;required&#93; The name for the DB subnet group. This value is stored as a lowercase
#' string.
#' 
#' Constraints:
#' 
#' -   Must contain no more than 255 letters, numbers, periods,
#'     underscores, spaces, or hyphens.
#' 
#' -   Must not be default.
#' 
#' -   First character must be a letter.
#' 
#' Example: `mydbsubnetgroup`
#' @param DBSubnetGroupDescription &#91;required&#93; The description for the DB subnet group.
#' @param SubnetIds &#91;required&#93; The EC2 Subnet IDs for the DB subnet group.
#' @param Tags Tags to assign to the DB subnet group.
#'
#' @keywords internal
#'
#' @rdname rds_create_db_subnet_group
rds_create_db_subnet_group <- function(DBSubnetGroupName, DBSubnetGroupDescription, SubnetIds, Tags = NULL) {
  op <- new_operation(
    name = "CreateDBSubnetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$create_db_subnet_group_input(DBSubnetGroupName = DBSubnetGroupName, DBSubnetGroupDescription = DBSubnetGroupDescription, SubnetIds = SubnetIds, Tags = Tags)
  output <- .rds$create_db_subnet_group_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$create_db_subnet_group <- rds_create_db_subnet_group

#' Creates an RDS event notification subscription
#'
#' @description
#' Creates an RDS event notification subscription. This operation requires a topic Amazon Resource Name (ARN) created by either the RDS console, the SNS console, or the SNS API. To obtain an ARN with SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the SNS console.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_create_event_subscription/](https://www.paws-r-sdk.com/docs/rds_create_event_subscription/) for full documentation.
#'
#' @param SubscriptionName &#91;required&#93; The name of the subscription.
#' 
#' Constraints: The name must be less than 255 characters.
#' @param SnsTopicArn &#91;required&#93; The Amazon Resource Name (ARN) of the SNS topic created for event
#' notification. The ARN is created by Amazon SNS when you create a topic
#' and subscribe to it.
#' @param SourceType The type of source that is generating the events. For example, if you
#' want to be notified of events generated by a DB instance, you set this
#' parameter to `db-instance`. For RDS Proxy events, specify `db-proxy`. If
#' this value isn't specified, all events are returned.
#' 
#' Valid values: `db-instance` | `db-cluster` | `db-parameter-group` |
#' `db-security-group` | `db-snapshot` | `db-cluster-snapshot` | `db-proxy`
#' @param EventCategories A list of event categories for a particular source type (`SourceType`)
#' that you want to subscribe to. You can see a list of the categories for
#' a given source type in the "Amazon RDS event categories and event
#' messages" section of the [*Amazon RDS User
#' Guide*](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Messages.html)
#' or the [*Amazon Aurora User
#' Guide*](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Messages.html)
#' . You can also see this list by using the
#' [`describe_event_categories`][rds_describe_event_categories] operation.
#' @param SourceIds The list of identifiers of the event sources for which events are
#' returned. If not specified, then all sources are included in the
#' response. An identifier must begin with a letter and must contain only
#' ASCII letters, digits, and hyphens. It can't end with a hyphen or
#' contain two consecutive hyphens.
#' 
#' Constraints:
#' 
#' -   If `SourceIds` are supplied, `SourceType` must also be provided.
#' 
#' -   If the source type is a DB instance, a `DBInstanceIdentifier` value
#'     must be supplied.
#' 
#' -   If the source type is a DB cluster, a `DBClusterIdentifier` value
#'     must be supplied.
#' 
#' -   If the source type is a DB parameter group, a `DBParameterGroupName`
#'     value must be supplied.
#' 
#' -   If the source type is a DB security group, a `DBSecurityGroupName`
#'     value must be supplied.
#' 
#' -   If the source type is a DB snapshot, a `DBSnapshotIdentifier` value
#'     must be supplied.
#' 
#' -   If the source type is a DB cluster snapshot, a
#'     `DBClusterSnapshotIdentifier` value must be supplied.
#' 
#' -   If the source type is an RDS Proxy, a `DBProxyName` value must be
#'     supplied.
#' @param Enabled A value that indicates whether to activate the subscription. If the
#' event notification subscription isn't activated, the subscription is
#' created but not active.
#' @param Tags 
#'
#' @keywords internal
#'
#' @rdname rds_create_event_subscription
rds_create_event_subscription <- function(SubscriptionName, SnsTopicArn, SourceType = NULL, EventCategories = NULL, SourceIds = NULL, Enabled = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateEventSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$create_event_subscription_input(SubscriptionName = SubscriptionName, SnsTopicArn = SnsTopicArn, SourceType = SourceType, EventCategories = EventCategories, SourceIds = SourceIds, Enabled = Enabled, Tags = Tags)
  output <- .rds$create_event_subscription_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$create_event_subscription <- rds_create_event_subscription

#' Creates an Aurora global database spread across multiple Amazon Web
#' Services Regions
#'
#' @description
#' Creates an Aurora global database spread across multiple Amazon Web Services Regions. The global database contains a single primary cluster with read-write capability, and a read-only secondary cluster that receives data from the primary cluster through high-speed replication performed by the Aurora storage subsystem.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_create_global_cluster/](https://www.paws-r-sdk.com/docs/rds_create_global_cluster/) for full documentation.
#'
#' @param GlobalClusterIdentifier The cluster identifier for this global database cluster. This parameter
#' is stored as a lowercase string.
#' @param SourceDBClusterIdentifier The Amazon Resource Name (ARN) to use as the primary cluster of the
#' global database.
#' 
#' If you provide a value for this parameter, don't specify values for the
#' following settings because Amazon Aurora uses the values from the
#' specified source DB cluster:
#' 
#' -   `DatabaseName`
#' 
#' -   `Engine`
#' 
#' -   `EngineVersion`
#' 
#' -   `StorageEncrypted`
#' @param Engine The database engine to use for this global database cluster.
#' 
#' Valid Values: `aurora-mysql | aurora-postgresql`
#' 
#' Constraints:
#' 
#' -   Can't be specified if `SourceDBClusterIdentifier` is specified. In
#'     this case, Amazon Aurora uses the engine of the source DB cluster.
#' @param EngineVersion The engine version to use for this global database cluster.
#' 
#' Constraints:
#' 
#' -   Can't be specified if `SourceDBClusterIdentifier` is specified. In
#'     this case, Amazon Aurora uses the engine version of the source DB
#'     cluster.
#' @param DeletionProtection Specifies whether to enable deletion protection for the new global
#' database cluster. The global database can't be deleted when deletion
#' protection is enabled.
#' @param DatabaseName The name for your database of up to 64 alphanumeric characters. If you
#' don't specify a name, Amazon Aurora doesn't create a database in the
#' global database cluster.
#' 
#' Constraints:
#' 
#' -   Can't be specified if `SourceDBClusterIdentifier` is specified. In
#'     this case, Amazon Aurora uses the database name from the source DB
#'     cluster.
#' @param StorageEncrypted Specifies whether to enable storage encryption for the new global
#' database cluster.
#' 
#' Constraints:
#' 
#' -   Can't be specified if `SourceDBClusterIdentifier` is specified. In
#'     this case, Amazon Aurora uses the setting from the source DB
#'     cluster.
#'
#' @keywords internal
#'
#' @rdname rds_create_global_cluster
rds_create_global_cluster <- function(GlobalClusterIdentifier = NULL, SourceDBClusterIdentifier = NULL, Engine = NULL, EngineVersion = NULL, DeletionProtection = NULL, DatabaseName = NULL, StorageEncrypted = NULL) {
  op <- new_operation(
    name = "CreateGlobalCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$create_global_cluster_input(GlobalClusterIdentifier = GlobalClusterIdentifier, SourceDBClusterIdentifier = SourceDBClusterIdentifier, Engine = Engine, EngineVersion = EngineVersion, DeletionProtection = DeletionProtection, DatabaseName = DatabaseName, StorageEncrypted = StorageEncrypted)
  output <- .rds$create_global_cluster_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$create_global_cluster <- rds_create_global_cluster

#' Creates a new option group
#'
#' @description
#' Creates a new option group. You can create up to 20 option groups.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_create_option_group/](https://www.paws-r-sdk.com/docs/rds_create_option_group/) for full documentation.
#'
#' @param OptionGroupName &#91;required&#93; Specifies the name of the option group to be created.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 255 letters, numbers, or hyphens
#' 
#' -   First character must be a letter
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens
#' 
#' Example: `myoptiongroup`
#' @param EngineName &#91;required&#93; Specifies the name of the engine that this option group should be
#' associated with.
#' 
#' Valid Values:
#' 
#' -   `mariadb`
#' 
#' -   `mysql`
#' 
#' -   `oracle-ee`
#' 
#' -   `oracle-ee-cdb`
#' 
#' -   `oracle-se2`
#' 
#' -   `oracle-se2-cdb`
#' 
#' -   `postgres`
#' 
#' -   `sqlserver-ee`
#' 
#' -   `sqlserver-se`
#' 
#' -   `sqlserver-ex`
#' 
#' -   `sqlserver-web`
#' @param MajorEngineVersion &#91;required&#93; Specifies the major version of the engine that this option group should
#' be associated with.
#' @param OptionGroupDescription &#91;required&#93; The description of the option group.
#' @param Tags Tags to assign to the option group.
#'
#' @keywords internal
#'
#' @rdname rds_create_option_group
rds_create_option_group <- function(OptionGroupName, EngineName, MajorEngineVersion, OptionGroupDescription, Tags = NULL) {
  op <- new_operation(
    name = "CreateOptionGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$create_option_group_input(OptionGroupName = OptionGroupName, EngineName = EngineName, MajorEngineVersion = MajorEngineVersion, OptionGroupDescription = OptionGroupDescription, Tags = Tags)
  output <- .rds$create_option_group_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$create_option_group <- rds_create_option_group

#' Deletes a blue/green deployment
#'
#' @description
#' Deletes a blue/green deployment.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_delete_blue_green_deployment/](https://www.paws-r-sdk.com/docs/rds_delete_blue_green_deployment/) for full documentation.
#'
#' @param BlueGreenDeploymentIdentifier &#91;required&#93; The unique identifier of the blue/green deployment to delete. This
#' parameter isn't case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must match an existing blue/green deployment identifier.
#' @param DeleteTarget Specifies whether to delete the resources in the green environment. You
#' can't specify this option if the blue/green deployment
#' [status](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_BlueGreenDeployment.html)
#' is `SWITCHOVER_COMPLETED`.
#'
#' @keywords internal
#'
#' @rdname rds_delete_blue_green_deployment
rds_delete_blue_green_deployment <- function(BlueGreenDeploymentIdentifier, DeleteTarget = NULL) {
  op <- new_operation(
    name = "DeleteBlueGreenDeployment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$delete_blue_green_deployment_input(BlueGreenDeploymentIdentifier = BlueGreenDeploymentIdentifier, DeleteTarget = DeleteTarget)
  output <- .rds$delete_blue_green_deployment_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$delete_blue_green_deployment <- rds_delete_blue_green_deployment

#' Deletes a custom engine version
#'
#' @description
#' Deletes a custom engine version. To run this command, make sure you meet the following prerequisites:
#'
#' See [https://www.paws-r-sdk.com/docs/rds_delete_custom_db_engine_version/](https://www.paws-r-sdk.com/docs/rds_delete_custom_db_engine_version/) for full documentation.
#'
#' @param Engine &#91;required&#93; The database engine. The only supported engines are `custom-oracle-ee`
#' and `custom-oracle-ee-cdb`.
#' @param EngineVersion &#91;required&#93; The custom engine version (CEV) for your DB instance. This option is
#' required for RDS Custom, but optional for Amazon RDS. The combination of
#' `Engine` and `EngineVersion` is unique per customer per Amazon Web
#' Services Region.
#'
#' @keywords internal
#'
#' @rdname rds_delete_custom_db_engine_version
rds_delete_custom_db_engine_version <- function(Engine, EngineVersion) {
  op <- new_operation(
    name = "DeleteCustomDBEngineVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$delete_custom_db_engine_version_input(Engine = Engine, EngineVersion = EngineVersion)
  output <- .rds$delete_custom_db_engine_version_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$delete_custom_db_engine_version <- rds_delete_custom_db_engine_version

#' The DeleteDBCluster action deletes a previously provisioned DB cluster
#'
#' @description
#' The DeleteDBCluster action deletes a previously provisioned DB cluster. When you delete a DB cluster, all automated backups for that DB cluster are deleted and can't be recovered. Manual DB cluster snapshots of the specified DB cluster are not deleted.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_delete_db_cluster/](https://www.paws-r-sdk.com/docs/rds_delete_db_cluster/) for full documentation.
#'
#' @param DBClusterIdentifier &#91;required&#93; The DB cluster identifier for the DB cluster to be deleted. This
#' parameter isn't case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must match an existing DBClusterIdentifier.
#' @param SkipFinalSnapshot A value that indicates whether to skip the creation of a final DB
#' cluster snapshot before the DB cluster is deleted. If skip is specified,
#' no DB cluster snapshot is created. If skip isn't specified, a DB cluster
#' snapshot is created before the DB cluster is deleted. By default, skip
#' isn't specified, and the DB cluster snapshot is created. By default,
#' this parameter is disabled.
#' 
#' You must specify a `FinalDBSnapshotIdentifier` parameter if
#' `SkipFinalSnapshot` is disabled.
#' @param FinalDBSnapshotIdentifier The DB cluster snapshot identifier of the new DB cluster snapshot
#' created when `SkipFinalSnapshot` is disabled.
#' 
#' Specifying this parameter and also skipping the creation of a final DB
#' cluster snapshot with the `SkipFinalShapshot` parameter results in an
#' error.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 255 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens
#' @param DeleteAutomatedBackups A value that indicates whether to remove automated backups immediately
#' after the DB cluster is deleted. This parameter isn't case-sensitive.
#' The default is to remove automated backups immediately after the DB
#' cluster is deleted.
#'
#' @keywords internal
#'
#' @rdname rds_delete_db_cluster
rds_delete_db_cluster <- function(DBClusterIdentifier, SkipFinalSnapshot = NULL, FinalDBSnapshotIdentifier = NULL, DeleteAutomatedBackups = NULL) {
  op <- new_operation(
    name = "DeleteDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$delete_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier, SkipFinalSnapshot = SkipFinalSnapshot, FinalDBSnapshotIdentifier = FinalDBSnapshotIdentifier, DeleteAutomatedBackups = DeleteAutomatedBackups)
  output <- .rds$delete_db_cluster_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$delete_db_cluster <- rds_delete_db_cluster

#' Deletes automated backups using the DbClusterResourceId value of the
#' source DB cluster or the Amazon Resource Name (ARN) of the automated
#' backups
#'
#' @description
#' Deletes automated backups using the `DbClusterResourceId` value of the source DB cluster or the Amazon Resource Name (ARN) of the automated backups.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_delete_db_cluster_automated_backup/](https://www.paws-r-sdk.com/docs/rds_delete_db_cluster_automated_backup/) for full documentation.
#'
#' @param DbClusterResourceId &#91;required&#93; The identifier for the source DB cluster, which can't be changed and
#' which is unique to an Amazon Web Services Region.
#'
#' @keywords internal
#'
#' @rdname rds_delete_db_cluster_automated_backup
rds_delete_db_cluster_automated_backup <- function(DbClusterResourceId) {
  op <- new_operation(
    name = "DeleteDBClusterAutomatedBackup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$delete_db_cluster_automated_backup_input(DbClusterResourceId = DbClusterResourceId)
  output <- .rds$delete_db_cluster_automated_backup_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$delete_db_cluster_automated_backup <- rds_delete_db_cluster_automated_backup

#' Deletes a custom endpoint and removes it from an Amazon Aurora DB
#' cluster
#'
#' @description
#' Deletes a custom endpoint and removes it from an Amazon Aurora DB cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_delete_db_cluster_endpoint/](https://www.paws-r-sdk.com/docs/rds_delete_db_cluster_endpoint/) for full documentation.
#'
#' @param DBClusterEndpointIdentifier &#91;required&#93; The identifier associated with the custom endpoint. This parameter is
#' stored as a lowercase string.
#'
#' @keywords internal
#'
#' @rdname rds_delete_db_cluster_endpoint
rds_delete_db_cluster_endpoint <- function(DBClusterEndpointIdentifier) {
  op <- new_operation(
    name = "DeleteDBClusterEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$delete_db_cluster_endpoint_input(DBClusterEndpointIdentifier = DBClusterEndpointIdentifier)
  output <- .rds$delete_db_cluster_endpoint_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$delete_db_cluster_endpoint <- rds_delete_db_cluster_endpoint

#' Deletes a specified DB cluster parameter group
#'
#' @description
#' Deletes a specified DB cluster parameter group. The DB cluster parameter group to be deleted can't be associated with any DB clusters.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_delete_db_cluster_parameter_group/](https://www.paws-r-sdk.com/docs/rds_delete_db_cluster_parameter_group/) for full documentation.
#'
#' @param DBClusterParameterGroupName &#91;required&#93; The name of the DB cluster parameter group.
#' 
#' Constraints:
#' 
#' -   Must be the name of an existing DB cluster parameter group.
#' 
#' -   You can't delete a default DB cluster parameter group.
#' 
#' -   Can't be associated with any DB clusters.
#'
#' @keywords internal
#'
#' @rdname rds_delete_db_cluster_parameter_group
rds_delete_db_cluster_parameter_group <- function(DBClusterParameterGroupName) {
  op <- new_operation(
    name = "DeleteDBClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$delete_db_cluster_parameter_group_input(DBClusterParameterGroupName = DBClusterParameterGroupName)
  output <- .rds$delete_db_cluster_parameter_group_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$delete_db_cluster_parameter_group <- rds_delete_db_cluster_parameter_group

#' Deletes a DB cluster snapshot
#'
#' @description
#' Deletes a DB cluster snapshot. If the snapshot is being copied, the copy operation is terminated.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_delete_db_cluster_snapshot/](https://www.paws-r-sdk.com/docs/rds_delete_db_cluster_snapshot/) for full documentation.
#'
#' @param DBClusterSnapshotIdentifier &#91;required&#93; The identifier of the DB cluster snapshot to delete.
#' 
#' Constraints: Must be the name of an existing DB cluster snapshot in the
#' `available` state.
#'
#' @keywords internal
#'
#' @rdname rds_delete_db_cluster_snapshot
rds_delete_db_cluster_snapshot <- function(DBClusterSnapshotIdentifier) {
  op <- new_operation(
    name = "DeleteDBClusterSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$delete_db_cluster_snapshot_input(DBClusterSnapshotIdentifier = DBClusterSnapshotIdentifier)
  output <- .rds$delete_db_cluster_snapshot_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$delete_db_cluster_snapshot <- rds_delete_db_cluster_snapshot

#' The DeleteDBInstance action deletes a previously provisioned DB instance
#'
#' @description
#' The DeleteDBInstance action deletes a previously provisioned DB instance. When you delete a DB instance, all automated backups for that instance are deleted and can't be recovered. Manual DB snapshots of the DB instance to be deleted by [`delete_db_instance`][rds_delete_db_instance] are not deleted.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_delete_db_instance/](https://www.paws-r-sdk.com/docs/rds_delete_db_instance/) for full documentation.
#'
#' @param DBInstanceIdentifier &#91;required&#93; The DB instance identifier for the DB instance to be deleted. This
#' parameter isn't case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must match the name of an existing DB instance.
#' @param SkipFinalSnapshot A value that indicates whether to skip the creation of a final DB
#' snapshot before deleting the instance. If you enable this parameter, RDS
#' doesn't create a DB snapshot. If you don't enable this parameter, RDS
#' creates a DB snapshot before the DB instance is deleted. By default,
#' skip isn't enabled, and the DB snapshot is created.
#' 
#' If you don't enable this parameter, you must specify the
#' `FinalDBSnapshotIdentifier` parameter.
#' 
#' When a DB instance is in a failure state and has a status of `failed`,
#' `incompatible-restore`, or `incompatible-network`, RDS can delete the
#' instance only if you enable this parameter.
#' 
#' If you delete a read replica or an RDS Custom instance, you must enable
#' this setting.
#' 
#' This setting is required for RDS Custom.
#' @param FinalDBSnapshotIdentifier The `DBSnapshotIdentifier` of the new `DBSnapshot` created when the
#' `SkipFinalSnapshot` parameter is disabled.
#' 
#' If you enable this parameter and also enable SkipFinalShapshot, the
#' command results in an error.
#' 
#' This setting doesn't apply to RDS Custom.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 255 letters or numbers.
#' 
#' -   First character must be a letter.
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens.
#' 
#' -   Can't be specified when deleting a read replica.
#' @param DeleteAutomatedBackups A value that indicates whether to remove automated backups immediately
#' after the DB instance is deleted. This parameter isn't case-sensitive.
#' The default is to remove automated backups immediately after the DB
#' instance is deleted.
#'
#' @keywords internal
#'
#' @rdname rds_delete_db_instance
rds_delete_db_instance <- function(DBInstanceIdentifier, SkipFinalSnapshot = NULL, FinalDBSnapshotIdentifier = NULL, DeleteAutomatedBackups = NULL) {
  op <- new_operation(
    name = "DeleteDBInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$delete_db_instance_input(DBInstanceIdentifier = DBInstanceIdentifier, SkipFinalSnapshot = SkipFinalSnapshot, FinalDBSnapshotIdentifier = FinalDBSnapshotIdentifier, DeleteAutomatedBackups = DeleteAutomatedBackups)
  output <- .rds$delete_db_instance_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$delete_db_instance <- rds_delete_db_instance

#' Deletes automated backups using the DbiResourceId value of the source DB
#' instance or the Amazon Resource Name (ARN) of the automated backups
#'
#' @description
#' Deletes automated backups using the `DbiResourceId` value of the source DB instance or the Amazon Resource Name (ARN) of the automated backups.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_delete_db_instance_automated_backup/](https://www.paws-r-sdk.com/docs/rds_delete_db_instance_automated_backup/) for full documentation.
#'
#' @param DbiResourceId The identifier for the source DB instance, which can't be changed and
#' which is unique to an Amazon Web Services Region.
#' @param DBInstanceAutomatedBackupsArn The Amazon Resource Name (ARN) of the automated backups to delete, for
#' example,
#' `arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE`.
#' 
#' This setting doesn't apply to RDS Custom.
#'
#' @keywords internal
#'
#' @rdname rds_delete_db_instance_automated_backup
rds_delete_db_instance_automated_backup <- function(DbiResourceId = NULL, DBInstanceAutomatedBackupsArn = NULL) {
  op <- new_operation(
    name = "DeleteDBInstanceAutomatedBackup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$delete_db_instance_automated_backup_input(DbiResourceId = DbiResourceId, DBInstanceAutomatedBackupsArn = DBInstanceAutomatedBackupsArn)
  output <- .rds$delete_db_instance_automated_backup_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$delete_db_instance_automated_backup <- rds_delete_db_instance_automated_backup

#' Deletes a specified DB parameter group
#'
#' @description
#' Deletes a specified DB parameter group. The DB parameter group to be deleted can't be associated with any DB instances.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_delete_db_parameter_group/](https://www.paws-r-sdk.com/docs/rds_delete_db_parameter_group/) for full documentation.
#'
#' @param DBParameterGroupName &#91;required&#93; The name of the DB parameter group.
#' 
#' Constraints:
#' 
#' -   Must be the name of an existing DB parameter group
#' 
#' -   You can't delete a default DB parameter group
#' 
#' -   Can't be associated with any DB instances
#'
#' @keywords internal
#'
#' @rdname rds_delete_db_parameter_group
rds_delete_db_parameter_group <- function(DBParameterGroupName) {
  op <- new_operation(
    name = "DeleteDBParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$delete_db_parameter_group_input(DBParameterGroupName = DBParameterGroupName)
  output <- .rds$delete_db_parameter_group_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$delete_db_parameter_group <- rds_delete_db_parameter_group

#' Deletes an existing DB proxy
#'
#' @description
#' Deletes an existing DB proxy.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_delete_db_proxy/](https://www.paws-r-sdk.com/docs/rds_delete_db_proxy/) for full documentation.
#'
#' @param DBProxyName &#91;required&#93; The name of the DB proxy to delete.
#'
#' @keywords internal
#'
#' @rdname rds_delete_db_proxy
rds_delete_db_proxy <- function(DBProxyName) {
  op <- new_operation(
    name = "DeleteDBProxy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$delete_db_proxy_input(DBProxyName = DBProxyName)
  output <- .rds$delete_db_proxy_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$delete_db_proxy <- rds_delete_db_proxy

#' Deletes a DBProxyEndpoint
#'
#' @description
#' Deletes a `DBProxyEndpoint`. Doing so removes the ability to access the DB proxy using the endpoint that you defined. The endpoint that you delete might have provided capabilities such as read/write or read-only operations, or using a different VPC than the DB proxy's default VPC.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_delete_db_proxy_endpoint/](https://www.paws-r-sdk.com/docs/rds_delete_db_proxy_endpoint/) for full documentation.
#'
#' @param DBProxyEndpointName &#91;required&#93; The name of the DB proxy endpoint to delete.
#'
#' @keywords internal
#'
#' @rdname rds_delete_db_proxy_endpoint
rds_delete_db_proxy_endpoint <- function(DBProxyEndpointName) {
  op <- new_operation(
    name = "DeleteDBProxyEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$delete_db_proxy_endpoint_input(DBProxyEndpointName = DBProxyEndpointName)
  output <- .rds$delete_db_proxy_endpoint_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$delete_db_proxy_endpoint <- rds_delete_db_proxy_endpoint

#' Deletes a DB security group
#'
#' @description
#' Deletes a DB security group.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_delete_db_security_group/](https://www.paws-r-sdk.com/docs/rds_delete_db_security_group/) for full documentation.
#'
#' @param DBSecurityGroupName &#91;required&#93; The name of the DB security group to delete.
#' 
#' You can't delete the default DB security group.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 255 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens
#' 
#' -   Must not be "Default"
#'
#' @keywords internal
#'
#' @rdname rds_delete_db_security_group
rds_delete_db_security_group <- function(DBSecurityGroupName) {
  op <- new_operation(
    name = "DeleteDBSecurityGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$delete_db_security_group_input(DBSecurityGroupName = DBSecurityGroupName)
  output <- .rds$delete_db_security_group_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$delete_db_security_group <- rds_delete_db_security_group

#' Deletes a DB snapshot
#'
#' @description
#' Deletes a DB snapshot. If the snapshot is being copied, the copy operation is terminated.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_delete_db_snapshot/](https://www.paws-r-sdk.com/docs/rds_delete_db_snapshot/) for full documentation.
#'
#' @param DBSnapshotIdentifier &#91;required&#93; The DB snapshot identifier.
#' 
#' Constraints: Must be the name of an existing DB snapshot in the
#' `available` state.
#'
#' @keywords internal
#'
#' @rdname rds_delete_db_snapshot
rds_delete_db_snapshot <- function(DBSnapshotIdentifier) {
  op <- new_operation(
    name = "DeleteDBSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$delete_db_snapshot_input(DBSnapshotIdentifier = DBSnapshotIdentifier)
  output <- .rds$delete_db_snapshot_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$delete_db_snapshot <- rds_delete_db_snapshot

#' Deletes a DB subnet group
#'
#' @description
#' Deletes a DB subnet group.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_delete_db_subnet_group/](https://www.paws-r-sdk.com/docs/rds_delete_db_subnet_group/) for full documentation.
#'
#' @param DBSubnetGroupName &#91;required&#93; The name of the database subnet group to delete.
#' 
#' You can't delete the default subnet group.
#' 
#' Constraints: Must match the name of an existing DBSubnetGroup. Must not
#' be default.
#' 
#' Example: `mydbsubnetgroup`
#'
#' @keywords internal
#'
#' @rdname rds_delete_db_subnet_group
rds_delete_db_subnet_group <- function(DBSubnetGroupName) {
  op <- new_operation(
    name = "DeleteDBSubnetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$delete_db_subnet_group_input(DBSubnetGroupName = DBSubnetGroupName)
  output <- .rds$delete_db_subnet_group_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$delete_db_subnet_group <- rds_delete_db_subnet_group

#' Deletes an RDS event notification subscription
#'
#' @description
#' Deletes an RDS event notification subscription.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_delete_event_subscription/](https://www.paws-r-sdk.com/docs/rds_delete_event_subscription/) for full documentation.
#'
#' @param SubscriptionName &#91;required&#93; The name of the RDS event notification subscription you want to delete.
#'
#' @keywords internal
#'
#' @rdname rds_delete_event_subscription
rds_delete_event_subscription <- function(SubscriptionName) {
  op <- new_operation(
    name = "DeleteEventSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$delete_event_subscription_input(SubscriptionName = SubscriptionName)
  output <- .rds$delete_event_subscription_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$delete_event_subscription <- rds_delete_event_subscription

#' Deletes a global database cluster
#'
#' @description
#' Deletes a global database cluster. The primary and secondary clusters must already be detached or destroyed first.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_delete_global_cluster/](https://www.paws-r-sdk.com/docs/rds_delete_global_cluster/) for full documentation.
#'
#' @param GlobalClusterIdentifier &#91;required&#93; The cluster identifier of the global database cluster being deleted.
#'
#' @keywords internal
#'
#' @rdname rds_delete_global_cluster
rds_delete_global_cluster <- function(GlobalClusterIdentifier) {
  op <- new_operation(
    name = "DeleteGlobalCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$delete_global_cluster_input(GlobalClusterIdentifier = GlobalClusterIdentifier)
  output <- .rds$delete_global_cluster_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$delete_global_cluster <- rds_delete_global_cluster

#' Deletes an existing option group
#'
#' @description
#' Deletes an existing option group.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_delete_option_group/](https://www.paws-r-sdk.com/docs/rds_delete_option_group/) for full documentation.
#'
#' @param OptionGroupName &#91;required&#93; The name of the option group to be deleted.
#' 
#' You can't delete default option groups.
#'
#' @keywords internal
#'
#' @rdname rds_delete_option_group
rds_delete_option_group <- function(OptionGroupName) {
  op <- new_operation(
    name = "DeleteOptionGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$delete_option_group_input(OptionGroupName = OptionGroupName)
  output <- .rds$delete_option_group_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$delete_option_group <- rds_delete_option_group

#' Remove the association between one or more DBProxyTarget data structures
#' and a DBProxyTargetGroup
#'
#' @description
#' Remove the association between one or more `DBProxyTarget` data structures and a `DBProxyTargetGroup`.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_deregister_db_proxy_targets/](https://www.paws-r-sdk.com/docs/rds_deregister_db_proxy_targets/) for full documentation.
#'
#' @param DBProxyName &#91;required&#93; The identifier of the `DBProxy` that is associated with the
#' `DBProxyTargetGroup`.
#' @param TargetGroupName The identifier of the `DBProxyTargetGroup`.
#' @param DBInstanceIdentifiers One or more DB instance identifiers.
#' @param DBClusterIdentifiers One or more DB cluster identifiers.
#'
#' @keywords internal
#'
#' @rdname rds_deregister_db_proxy_targets
rds_deregister_db_proxy_targets <- function(DBProxyName, TargetGroupName = NULL, DBInstanceIdentifiers = NULL, DBClusterIdentifiers = NULL) {
  op <- new_operation(
    name = "DeregisterDBProxyTargets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$deregister_db_proxy_targets_input(DBProxyName = DBProxyName, TargetGroupName = TargetGroupName, DBInstanceIdentifiers = DBInstanceIdentifiers, DBClusterIdentifiers = DBClusterIdentifiers)
  output <- .rds$deregister_db_proxy_targets_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$deregister_db_proxy_targets <- rds_deregister_db_proxy_targets

#' Lists all of the attributes for a customer account
#'
#' @description
#' Lists all of the attributes for a customer account. The attributes include Amazon RDS quotas for the account, such as the number of DB instances allowed. The description for a quota includes the quota name, current usage toward that quota, and the quota's maximum value.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_account_attributes/](https://www.paws-r-sdk.com/docs/rds_describe_account_attributes/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname rds_describe_account_attributes
rds_describe_account_attributes <- function() {
  op <- new_operation(
    name = "DescribeAccountAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_account_attributes_input()
  output <- .rds$describe_account_attributes_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_account_attributes <- rds_describe_account_attributes

#' Describes one or more blue/green deployments
#'
#' @description
#' Describes one or more blue/green deployments.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_blue_green_deployments/](https://www.paws-r-sdk.com/docs/rds_describe_blue_green_deployments/) for full documentation.
#'
#' @param BlueGreenDeploymentIdentifier The blue/green deployment identifier. If you specify this parameter, the
#' response only includes information about the specific blue/green
#' deployment. This parameter isn't case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must match an existing blue/green deployment identifier.
#' @param Filters A filter that specifies one or more blue/green deployments to describe.
#' 
#' Valid Values:
#' 
#' -   `blue-green-deployment-identifier` - Accepts system-generated
#'     identifiers for blue/green deployments. The results list only
#'     includes information about the blue/green deployments with the
#'     specified identifiers.
#' 
#' -   `blue-green-deployment-name` - Accepts user-supplied names for
#'     blue/green deployments. The results list only includes information
#'     about the blue/green deployments with the specified names.
#' 
#' -   `source` - Accepts source databases for a blue/green deployment. The
#'     results list only includes information about the blue/green
#'     deployments with the specified source databases.
#' 
#' -   `target` - Accepts target databases for a blue/green deployment. The
#'     results list only includes information about the blue/green
#'     deployments with the specified target databases.
#' @param Marker An optional pagination token provided by a previous
#' [`describe_blue_green_deployments`][rds_describe_blue_green_deployments]
#' request. If you specify this parameter, the response only includes
#' records beyond the marker, up to the value specified by `MaxRecords`.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so you can retrieve the
#' remaining results.
#' 
#' Default: 100
#' 
#' Constraints:
#' 
#' -   Must be a minimum of 20.
#' 
#' -   Can't exceed 100.
#'
#' @keywords internal
#'
#' @rdname rds_describe_blue_green_deployments
rds_describe_blue_green_deployments <- function(BlueGreenDeploymentIdentifier = NULL, Filters = NULL, Marker = NULL, MaxRecords = NULL) {
  op <- new_operation(
    name = "DescribeBlueGreenDeployments",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "BlueGreenDeployments")
  )
  input <- .rds$describe_blue_green_deployments_input(BlueGreenDeploymentIdentifier = BlueGreenDeploymentIdentifier, Filters = Filters, Marker = Marker, MaxRecords = MaxRecords)
  output <- .rds$describe_blue_green_deployments_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_blue_green_deployments <- rds_describe_blue_green_deployments

#' Lists the set of CA certificates provided by Amazon RDS for this Amazon
#' Web Services account
#'
#' @description
#' Lists the set of CA certificates provided by Amazon RDS for this Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_certificates/](https://www.paws-r-sdk.com/docs/rds_describe_certificates/) for full documentation.
#'
#' @param CertificateIdentifier The user-supplied certificate identifier. If this parameter is
#' specified, information for only the identified certificate is returned.
#' This parameter isn't case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must match an existing CertificateIdentifier.
#' @param Filters This parameter isn't currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so you can retrieve the
#' remaining results.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' [`describe_certificates`][rds_describe_certificates] request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname rds_describe_certificates
rds_describe_certificates <- function(CertificateIdentifier = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeCertificates",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "Certificates")
  )
  input <- .rds$describe_certificates_input(CertificateIdentifier = CertificateIdentifier, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_certificates_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_certificates <- rds_describe_certificates

#' Displays backups for both current and deleted DB clusters
#'
#' @description
#' Displays backups for both current and deleted DB clusters. For example, use this operation to find details about automated backups for previously deleted clusters. Current clusters are returned for both the [`describe_db_cluster_automated_backups`][rds_describe_db_cluster_automated_backups] and [`describe_db_clusters`][rds_describe_db_clusters] operations.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_db_cluster_automated_backups/](https://www.paws-r-sdk.com/docs/rds_describe_db_cluster_automated_backups/) for full documentation.
#'
#' @param DbClusterResourceId The resource ID of the DB cluster that is the source of the automated
#' backup. This parameter isn't case-sensitive.
#' @param DBClusterIdentifier (Optional) The user-supplied DB cluster identifier. If this parameter is
#' specified, it must match the identifier of an existing DB cluster. It
#' returns information from the specific DB cluster's automated backup.
#' This parameter isn't case-sensitive.
#' @param Filters A filter that specifies which resources to return based on status.
#' 
#' Supported filters are the following:
#' 
#' -   `status`
#' 
#'     -   `retained` - Automated backups for deleted clusters and after
#'         backup replication is stopped.
#' 
#' -   `db-cluster-id` - Accepts DB cluster identifiers and Amazon Resource
#'     Names (ARNs). The results list includes only information about the
#'     DB cluster automated backups identified by these ARNs.
#' 
#' -   `db-cluster-resource-id` - Accepts DB resource identifiers and
#'     Amazon Resource Names (ARNs). The results list includes only
#'     information about the DB cluster resources identified by these ARNs.
#' 
#' Returns all resources by default. The status for each resource is
#' specified in the response.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that you can retrieve the
#' remaining results.
#' @param Marker The pagination token provided in the previous request. If this parameter
#' is specified the response includes only records beyond the marker, up to
#' `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_cluster_automated_backups
rds_describe_db_cluster_automated_backups <- function(DbClusterResourceId = NULL, DBClusterIdentifier = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBClusterAutomatedBackups",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "DBClusterAutomatedBackups")
  )
  input <- .rds$describe_db_cluster_automated_backups_input(DbClusterResourceId = DbClusterResourceId, DBClusterIdentifier = DBClusterIdentifier, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_db_cluster_automated_backups_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_cluster_automated_backups <- rds_describe_db_cluster_automated_backups

#' Returns information about backtracks for a DB cluster
#'
#' @description
#' Returns information about backtracks for a DB cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_db_cluster_backtracks/](https://www.paws-r-sdk.com/docs/rds_describe_db_cluster_backtracks/) for full documentation.
#'
#' @param DBClusterIdentifier &#91;required&#93; The DB cluster identifier of the DB cluster to be described. This
#' parameter is stored as a lowercase string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 alphanumeric characters or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-cluster1`
#' @param BacktrackIdentifier If specified, this value is the backtrack identifier of the backtrack to
#' be described.
#' 
#' Constraints:
#' 
#' -   Must contain a valid universally unique identifier (UUID). For more
#'     information about UUIDs, see [Universally unique
#'     identifier](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' Example: `123e4567-e89b-12d3-a456-426655440000`
#' @param Filters A filter that specifies one or more DB clusters to describe. Supported
#' filters include the following:
#' 
#' -   `db-cluster-backtrack-id` - Accepts backtrack identifiers. The
#'     results list includes information about only the backtracks
#'     identified by these identifiers.
#' 
#' -   `db-cluster-backtrack-status` - Accepts any of the following
#'     backtrack status values:
#' 
#'     -   `applying`
#' 
#'     -   `completed`
#' 
#'     -   `failed`
#' 
#'     -   `pending`
#' 
#'     The results list includes information about only the backtracks
#'     identified by these values.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so you can retrieve the
#' remaining results.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' [`describe_db_cluster_backtracks`][rds_describe_db_cluster_backtracks]
#' request. If this parameter is specified, the response includes only
#' records beyond the marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_cluster_backtracks
rds_describe_db_cluster_backtracks <- function(DBClusterIdentifier, BacktrackIdentifier = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBClusterBacktracks",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "DBClusterBacktracks")
  )
  input <- .rds$describe_db_cluster_backtracks_input(DBClusterIdentifier = DBClusterIdentifier, BacktrackIdentifier = BacktrackIdentifier, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_db_cluster_backtracks_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_cluster_backtracks <- rds_describe_db_cluster_backtracks

#' Returns information about endpoints for an Amazon Aurora DB cluster
#'
#' @description
#' Returns information about endpoints for an Amazon Aurora DB cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_db_cluster_endpoints/](https://www.paws-r-sdk.com/docs/rds_describe_db_cluster_endpoints/) for full documentation.
#'
#' @param DBClusterIdentifier The DB cluster identifier of the DB cluster associated with the
#' endpoint. This parameter is stored as a lowercase string.
#' @param DBClusterEndpointIdentifier The identifier of the endpoint to describe. This parameter is stored as
#' a lowercase string.
#' @param Filters A set of name-value pairs that define which endpoints to include in the
#' output. The filters are specified as name-value pairs, in the format
#' `Name=endpoint_type,Values=endpoint_type1,endpoint_type2,...`. `Name`
#' can be one of: `db-cluster-endpoint-type`,
#' `db-cluster-endpoint-custom-type`, `db-cluster-endpoint-id`,
#' `db-cluster-endpoint-status`. `Values` for the
#' ` db-cluster-endpoint-type` filter can be one or more of: `reader`,
#' `writer`, `custom`. `Values` for the `db-cluster-endpoint-custom-type`
#' filter can be one or more of: `reader`, `any`. `Values` for the
#' `db-cluster-endpoint-status` filter can be one or more of: `available`,
#' `creating`, `deleting`, `inactive`, `modifying`.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so you can retrieve the
#' remaining results.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' [`describe_db_cluster_endpoints`][rds_describe_db_cluster_endpoints]
#' request. If this parameter is specified, the response includes only
#' records beyond the marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_cluster_endpoints
rds_describe_db_cluster_endpoints <- function(DBClusterIdentifier = NULL, DBClusterEndpointIdentifier = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBClusterEndpoints",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "DBClusterEndpoints")
  )
  input <- .rds$describe_db_cluster_endpoints_input(DBClusterIdentifier = DBClusterIdentifier, DBClusterEndpointIdentifier = DBClusterEndpointIdentifier, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_db_cluster_endpoints_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_cluster_endpoints <- rds_describe_db_cluster_endpoints

#' Returns a list of DBClusterParameterGroup descriptions
#'
#' @description
#' Returns a list of `DBClusterParameterGroup` descriptions. If a `DBClusterParameterGroupName` parameter is specified, the list will contain only the description of the specified DB cluster parameter group.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_db_cluster_parameter_groups/](https://www.paws-r-sdk.com/docs/rds_describe_db_cluster_parameter_groups/) for full documentation.
#'
#' @param DBClusterParameterGroupName The name of a specific DB cluster parameter group to return details for.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing
#'     DBClusterParameterGroup.
#' @param Filters This parameter isn't currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so you can retrieve the
#' remaining results.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' [`describe_db_cluster_parameter_groups`][rds_describe_db_cluster_parameter_groups]
#' request. If this parameter is specified, the response includes only
#' records beyond the marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_cluster_parameter_groups
rds_describe_db_cluster_parameter_groups <- function(DBClusterParameterGroupName = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBClusterParameterGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "DBClusterParameterGroups")
  )
  input <- .rds$describe_db_cluster_parameter_groups_input(DBClusterParameterGroupName = DBClusterParameterGroupName, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_db_cluster_parameter_groups_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_cluster_parameter_groups <- rds_describe_db_cluster_parameter_groups

#' Returns the detailed parameter list for a particular DB cluster
#' parameter group
#'
#' @description
#' Returns the detailed parameter list for a particular DB cluster parameter group.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_db_cluster_parameters/](https://www.paws-r-sdk.com/docs/rds_describe_db_cluster_parameters/) for full documentation.
#'
#' @param DBClusterParameterGroupName &#91;required&#93; The name of a specific DB cluster parameter group to return parameter
#' details for.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing
#'     DBClusterParameterGroup.
#' @param Source A value that indicates to return only parameters for a specific source.
#' Parameter sources can be `engine`, `service`, or `customer`.
#' @param Filters This parameter isn't currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so you can retrieve the
#' remaining results.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' [`describe_db_cluster_parameters`][rds_describe_db_cluster_parameters]
#' request. If this parameter is specified, the response includes only
#' records beyond the marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_cluster_parameters
rds_describe_db_cluster_parameters <- function(DBClusterParameterGroupName, Source = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBClusterParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "Parameters")
  )
  input <- .rds$describe_db_cluster_parameters_input(DBClusterParameterGroupName = DBClusterParameterGroupName, Source = Source, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_db_cluster_parameters_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_cluster_parameters <- rds_describe_db_cluster_parameters

#' Returns a list of DB cluster snapshot attribute names and values for a
#' manual DB cluster snapshot
#'
#' @description
#' Returns a list of DB cluster snapshot attribute names and values for a manual DB cluster snapshot.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_db_cluster_snapshot_attributes/](https://www.paws-r-sdk.com/docs/rds_describe_db_cluster_snapshot_attributes/) for full documentation.
#'
#' @param DBClusterSnapshotIdentifier &#91;required&#93; The identifier for the DB cluster snapshot to describe the attributes
#' for.
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_cluster_snapshot_attributes
rds_describe_db_cluster_snapshot_attributes <- function(DBClusterSnapshotIdentifier) {
  op <- new_operation(
    name = "DescribeDBClusterSnapshotAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_db_cluster_snapshot_attributes_input(DBClusterSnapshotIdentifier = DBClusterSnapshotIdentifier)
  output <- .rds$describe_db_cluster_snapshot_attributes_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_cluster_snapshot_attributes <- rds_describe_db_cluster_snapshot_attributes

#' Returns information about DB cluster snapshots
#'
#' @description
#' Returns information about DB cluster snapshots. This API action supports pagination.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_db_cluster_snapshots/](https://www.paws-r-sdk.com/docs/rds_describe_db_cluster_snapshots/) for full documentation.
#'
#' @param DBClusterIdentifier The ID of the DB cluster to retrieve the list of DB cluster snapshots
#' for. This parameter can't be used in conjunction with the
#' `DBClusterSnapshotIdentifier` parameter. This parameter isn't
#' case-sensitive.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the identifier of an existing DBCluster.
#' @param DBClusterSnapshotIdentifier A specific DB cluster snapshot identifier to describe. This parameter
#' can't be used in conjunction with the `DBClusterIdentifier` parameter.
#' This value is stored as a lowercase string.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the identifier of an existing
#'     DBClusterSnapshot.
#' 
#' -   If this identifier is for an automated snapshot, the `SnapshotType`
#'     parameter must also be specified.
#' @param SnapshotType The type of DB cluster snapshots to be returned. You can specify one of
#' the following values:
#' 
#' -   `automated` - Return all DB cluster snapshots that have been
#'     automatically taken by Amazon RDS for my Amazon Web Services
#'     account.
#' 
#' -   `manual` - Return all DB cluster snapshots that have been taken by
#'     my Amazon Web Services account.
#' 
#' -   `shared` - Return all manual DB cluster snapshots that have been
#'     shared to my Amazon Web Services account.
#' 
#' -   `public` - Return all DB cluster snapshots that have been marked as
#'     public.
#' 
#' If you don't specify a `SnapshotType` value, then both automated and
#' manual DB cluster snapshots are returned. You can include shared DB
#' cluster snapshots with these results by enabling the `IncludeShared`
#' parameter. You can include public DB cluster snapshots with these
#' results by enabling the `IncludePublic` parameter.
#' 
#' The `IncludeShared` and `IncludePublic` parameters don't apply for
#' `SnapshotType` values of `manual` or `automated`. The `IncludePublic`
#' parameter doesn't apply when `SnapshotType` is set to `shared`. The
#' `IncludeShared` parameter doesn't apply when `SnapshotType` is set to
#' `public`.
#' @param Filters A filter that specifies one or more DB cluster snapshots to describe.
#' 
#' Supported filters:
#' 
#' -   `db-cluster-id` - Accepts DB cluster identifiers and DB cluster
#'     Amazon Resource Names (ARNs).
#' 
#' -   `db-cluster-snapshot-id` - Accepts DB cluster snapshot identifiers.
#' 
#' -   `snapshot-type` - Accepts types of DB cluster snapshots.
#' 
#' -   `engine` - Accepts names of database engines.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so you can retrieve the
#' remaining results.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' [`describe_db_cluster_snapshots`][rds_describe_db_cluster_snapshots]
#' request. If this parameter is specified, the response includes only
#' records beyond the marker, up to the value specified by `MaxRecords`.
#' @param IncludeShared A value that indicates whether to include shared manual DB cluster
#' snapshots from other Amazon Web Services accounts that this Amazon Web
#' Services account has been given permission to copy or restore. By
#' default, these snapshots are not included.
#' 
#' You can give an Amazon Web Services account permission to restore a
#' manual DB cluster snapshot from another Amazon Web Services account by
#' the
#' [`modify_db_cluster_snapshot_attribute`][rds_modify_db_cluster_snapshot_attribute]
#' API action.
#' @param IncludePublic A value that indicates whether to include manual DB cluster snapshots
#' that are public and can be copied or restored by any Amazon Web Services
#' account. By default, the public snapshots are not included.
#' 
#' You can share a manual DB cluster snapshot as public by using the
#' [`modify_db_cluster_snapshot_attribute`][rds_modify_db_cluster_snapshot_attribute]
#' API action.
#' @param DbClusterResourceId A specific DB cluster resource ID to describe.
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_cluster_snapshots
rds_describe_db_cluster_snapshots <- function(DBClusterIdentifier = NULL, DBClusterSnapshotIdentifier = NULL, SnapshotType = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL, IncludeShared = NULL, IncludePublic = NULL, DbClusterResourceId = NULL) {
  op <- new_operation(
    name = "DescribeDBClusterSnapshots",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "DBClusterSnapshots")
  )
  input <- .rds$describe_db_cluster_snapshots_input(DBClusterIdentifier = DBClusterIdentifier, DBClusterSnapshotIdentifier = DBClusterSnapshotIdentifier, SnapshotType = SnapshotType, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker, IncludeShared = IncludeShared, IncludePublic = IncludePublic, DbClusterResourceId = DbClusterResourceId)
  output <- .rds$describe_db_cluster_snapshots_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_cluster_snapshots <- rds_describe_db_cluster_snapshots

#' Describes existing Amazon Aurora DB clusters and Multi-AZ DB clusters
#'
#' @description
#' Describes existing Amazon Aurora DB clusters and Multi-AZ DB clusters. This API supports pagination.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_db_clusters/](https://www.paws-r-sdk.com/docs/rds_describe_db_clusters/) for full documentation.
#'
#' @param DBClusterIdentifier The user-supplied DB cluster identifier or the Amazon Resource Name
#' (ARN) of the DB cluster. If this parameter is specified, information for
#' only the specific DB cluster is returned. This parameter isn't
#' case-sensitive.
#' 
#' Constraints:
#' 
#' -   If supplied, must match an existing DB cluster identifier.
#' @param Filters A filter that specifies one or more DB clusters to describe.
#' 
#' Supported Filters:
#' 
#' -   `clone-group-id` - Accepts clone group identifiers. The results list
#'     only includes information about the DB clusters associated with
#'     these clone groups.
#' 
#' -   `db-cluster-id` - Accepts DB cluster identifiers and DB cluster
#'     Amazon Resource Names (ARNs). The results list only includes
#'     information about the DB clusters identified by these ARNs.
#' 
#' -   `db-cluster-resource-id` - Accepts DB cluster resource identifiers.
#'     The results list will only include information about the DB clusters
#'     identified by these DB cluster resource identifiers.
#' 
#' -   `domain` - Accepts Active Directory directory IDs. The results list
#'     only includes information about the DB clusters associated with
#'     these domains.
#' 
#' -   `engine` - Accepts engine names. The results list only includes
#'     information about the DB clusters for these engines.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so you can retrieve the
#' remaining results.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' [`describe_db_clusters`][rds_describe_db_clusters] request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#' @param IncludeShared Specifies whether the output includes information about clusters shared
#' from other Amazon Web Services accounts.
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_clusters
rds_describe_db_clusters <- function(DBClusterIdentifier = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL, IncludeShared = NULL) {
  op <- new_operation(
    name = "DescribeDBClusters",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "DBClusters")
  )
  input <- .rds$describe_db_clusters_input(DBClusterIdentifier = DBClusterIdentifier, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker, IncludeShared = IncludeShared)
  output <- .rds$describe_db_clusters_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_clusters <- rds_describe_db_clusters

#' Returns a list of the available DB engines
#'
#' @description
#' Returns a list of the available DB engines.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_db_engine_versions/](https://www.paws-r-sdk.com/docs/rds_describe_db_engine_versions/) for full documentation.
#'
#' @param Engine The database engine to return.
#' 
#' Valid Values:
#' 
#' -   `aurora-mysql`
#' 
#' -   `aurora-postgresql`
#' 
#' -   `custom-oracle-ee`
#' 
#' -   `mariadb`
#' 
#' -   `mysql`
#' 
#' -   `oracle-ee`
#' 
#' -   `oracle-ee-cdb`
#' 
#' -   `oracle-se2`
#' 
#' -   `oracle-se2-cdb`
#' 
#' -   `postgres`
#' 
#' -   `sqlserver-ee`
#' 
#' -   `sqlserver-se`
#' 
#' -   `sqlserver-ex`
#' 
#' -   `sqlserver-web`
#' @param EngineVersion The database engine version to return.
#' 
#' Example: `5.1.49`
#' @param DBParameterGroupFamily The name of a specific DB parameter group family to return details for.
#' 
#' Constraints:
#' 
#' -   If supplied, must match an existing DBParameterGroupFamily.
#' @param Filters A filter that specifies one or more DB engine versions to describe.
#' 
#' Supported filters:
#' 
#' -   `db-parameter-group-family` - Accepts parameter groups family names.
#'     The results list only includes information about the DB engine
#'     versions for these parameter group families.
#' 
#' -   `engine` - Accepts engine names. The results list only includes
#'     information about the DB engine versions for these engines.
#' 
#' -   `engine-mode` - Accepts DB engine modes. The results list only
#'     includes information about the DB engine versions for these engine
#'     modes. Valid DB engine modes are the following:
#' 
#'     -   `global`
#' 
#'     -   `multimaster`
#' 
#'     -   `parallelquery`
#' 
#'     -   `provisioned`
#' 
#'     -   `serverless`
#' 
#' -   `engine-version` - Accepts engine versions. The results list only
#'     includes information about the DB engine versions for these engine
#'     versions.
#' 
#' -   `status` - Accepts engine version statuses. The results list only
#'     includes information about the DB engine versions for these
#'     statuses. Valid statuses are the following:
#' 
#'     -   `available`
#' 
#'     -   `deprecated`
#' @param MaxRecords The maximum number of records to include in the response. If more than
#' the `MaxRecords` value is available, a pagination token called a marker
#' is included in the response so you can retrieve the remaining results.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#' @param DefaultOnly A value that indicates whether only the default version of the specified
#' engine or engine and major version combination is returned.
#' @param ListSupportedCharacterSets A value that indicates whether to list the supported character sets for
#' each engine version.
#' 
#' If this parameter is enabled and the requested engine supports the
#' `CharacterSetName` parameter for
#' [`create_db_instance`][rds_create_db_instance], the response includes a
#' list of supported character sets for each engine version.
#' 
#' For RDS Custom, the default is not to list supported character sets. If
#' you set `ListSupportedCharacterSets` to `true`, RDS Custom returns no
#' results.
#' @param ListSupportedTimezones A value that indicates whether to list the supported time zones for each
#' engine version.
#' 
#' If this parameter is enabled and the requested engine supports the
#' `TimeZone` parameter for [`create_db_instance`][rds_create_db_instance],
#' the response includes a list of supported time zones for each engine
#' version.
#' 
#' For RDS Custom, the default is not to list supported time zones. If you
#' set `ListSupportedTimezones` to `true`, RDS Custom returns no results.
#' @param IncludeAll A value that indicates whether to include engine versions that aren't
#' available in the list. The default is to list only available engine
#' versions.
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_engine_versions
rds_describe_db_engine_versions <- function(Engine = NULL, EngineVersion = NULL, DBParameterGroupFamily = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL, DefaultOnly = NULL, ListSupportedCharacterSets = NULL, ListSupportedTimezones = NULL, IncludeAll = NULL) {
  op <- new_operation(
    name = "DescribeDBEngineVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "DBEngineVersions")
  )
  input <- .rds$describe_db_engine_versions_input(Engine = Engine, EngineVersion = EngineVersion, DBParameterGroupFamily = DBParameterGroupFamily, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker, DefaultOnly = DefaultOnly, ListSupportedCharacterSets = ListSupportedCharacterSets, ListSupportedTimezones = ListSupportedTimezones, IncludeAll = IncludeAll)
  output <- .rds$describe_db_engine_versions_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_engine_versions <- rds_describe_db_engine_versions

#' Displays backups for both current and deleted instances
#'
#' @description
#' Displays backups for both current and deleted instances. For example, use this operation to find details about automated backups for previously deleted instances. Current instances with retention periods greater than zero (0) are returned for both the [`describe_db_instance_automated_backups`][rds_describe_db_instance_automated_backups] and [`describe_db_instances`][rds_describe_db_instances] operations.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_db_instance_automated_backups/](https://www.paws-r-sdk.com/docs/rds_describe_db_instance_automated_backups/) for full documentation.
#'
#' @param DbiResourceId The resource ID of the DB instance that is the source of the automated
#' backup. This parameter isn't case-sensitive.
#' @param DBInstanceIdentifier (Optional) The user-supplied instance identifier. If this parameter is
#' specified, it must match the identifier of an existing DB instance. It
#' returns information from the specific DB instance's automated backup.
#' This parameter isn't case-sensitive.
#' @param Filters A filter that specifies which resources to return based on status.
#' 
#' Supported filters are the following:
#' 
#' -   `status`
#' 
#'     -   `active` - Automated backups for current instances.
#' 
#'     -   `creating` - Automated backups that are waiting for the first
#'         automated snapshot to be available.
#' 
#'     -   `retained` - Automated backups for deleted instances and after
#'         backup replication is stopped.
#' 
#' -   `db-instance-id` - Accepts DB instance identifiers and Amazon
#'     Resource Names (ARNs). The results list includes only information
#'     about the DB instance automated backups identified by these ARNs.
#' 
#' -   `dbi-resource-id` - Accepts DB resource identifiers and Amazon
#'     Resource Names (ARNs). The results list includes only information
#'     about the DB instance resources identified by these ARNs.
#' 
#' Returns all resources by default. The status for each resource is
#' specified in the response.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that you can retrieve the
#' remaining results.
#' @param Marker The pagination token provided in the previous request. If this parameter
#' is specified the response includes only records beyond the marker, up to
#' `MaxRecords`.
#' @param DBInstanceAutomatedBackupsArn The Amazon Resource Name (ARN) of the replicated automated backups, for
#' example,
#' `arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE`.
#' 
#' This setting doesn't apply to RDS Custom.
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_instance_automated_backups
rds_describe_db_instance_automated_backups <- function(DbiResourceId = NULL, DBInstanceIdentifier = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL, DBInstanceAutomatedBackupsArn = NULL) {
  op <- new_operation(
    name = "DescribeDBInstanceAutomatedBackups",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "DBInstanceAutomatedBackups")
  )
  input <- .rds$describe_db_instance_automated_backups_input(DbiResourceId = DbiResourceId, DBInstanceIdentifier = DBInstanceIdentifier, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker, DBInstanceAutomatedBackupsArn = DBInstanceAutomatedBackupsArn)
  output <- .rds$describe_db_instance_automated_backups_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_instance_automated_backups <- rds_describe_db_instance_automated_backups

#' Describes provisioned RDS instances
#'
#' @description
#' Describes provisioned RDS instances. This API supports pagination.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_db_instances/](https://www.paws-r-sdk.com/docs/rds_describe_db_instances/) for full documentation.
#'
#' @param DBInstanceIdentifier The user-supplied instance identifier or the Amazon Resource Name (ARN)
#' of the DB instance. If this parameter is specified, information from
#' only the specific DB instance is returned. This parameter isn't
#' case-sensitive.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the identifier of an existing DB instance.
#' @param Filters A filter that specifies one or more DB instances to describe.
#' 
#' Supported Filters:
#' 
#' -   `db-cluster-id` - Accepts DB cluster identifiers and DB cluster
#'     Amazon Resource Names (ARNs). The results list only includes
#'     information about the DB instances associated with the DB clusters
#'     identified by these ARNs.
#' 
#' -   `db-instance-id` - Accepts DB instance identifiers and DB instance
#'     Amazon Resource Names (ARNs). The results list only includes
#'     information about the DB instances identified by these ARNs.
#' 
#' -   `dbi-resource-id` - Accepts DB instance resource identifiers. The
#'     results list only includes information about the DB instances
#'     identified by these DB instance resource identifiers.
#' 
#' -   `domain` - Accepts Active Directory directory IDs. The results list
#'     only includes information about the DB instances associated with
#'     these domains.
#' 
#' -   `engine` - Accepts engine names. The results list only includes
#'     information about the DB instances for these engines.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that you can retrieve the
#' remaining results.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' [`describe_db_instances`][rds_describe_db_instances] request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_instances
rds_describe_db_instances <- function(DBInstanceIdentifier = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "DBInstances")
  )
  input <- .rds$describe_db_instances_input(DBInstanceIdentifier = DBInstanceIdentifier, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_db_instances_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_instances <- rds_describe_db_instances

#' Returns a list of DB log files for the DB instance
#'
#' @description
#' Returns a list of DB log files for the DB instance.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_db_log_files/](https://www.paws-r-sdk.com/docs/rds_describe_db_log_files/) for full documentation.
#'
#' @param DBInstanceIdentifier &#91;required&#93; The customer-assigned name of the DB instance that contains the log
#' files you want to list.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DBInstance.
#' @param FilenameContains Filters the available log files for log file names that contain the
#' specified string.
#' @param FileLastWritten Filters the available log files for files written since the specified
#' date, in POSIX timestamp format with milliseconds.
#' @param FileSize Filters the available log files for files larger than the specified
#' size.
#' @param Filters This parameter isn't currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified MaxRecords value, a pagination token
#' called a marker is included in the response so you can retrieve the
#' remaining results.
#' @param Marker The pagination token provided in the previous request. If this parameter
#' is specified the response includes only records beyond the marker, up to
#' MaxRecords.
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_log_files
rds_describe_db_log_files <- function(DBInstanceIdentifier, FilenameContains = NULL, FileLastWritten = NULL, FileSize = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBLogFiles",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "DescribeDBLogFiles")
  )
  input <- .rds$describe_db_log_files_input(DBInstanceIdentifier = DBInstanceIdentifier, FilenameContains = FilenameContains, FileLastWritten = FileLastWritten, FileSize = FileSize, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_db_log_files_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_log_files <- rds_describe_db_log_files

#' Returns a list of DBParameterGroup descriptions
#'
#' @description
#' Returns a list of `DBParameterGroup` descriptions. If a `DBParameterGroupName` is specified, the list will contain only the description of the specified DB parameter group.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_db_parameter_groups/](https://www.paws-r-sdk.com/docs/rds_describe_db_parameter_groups/) for full documentation.
#'
#' @param DBParameterGroupName The name of a specific DB parameter group to return details for.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing
#'     DBClusterParameterGroup.
#' @param Filters This parameter isn't currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that you can retrieve the
#' remaining results.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' [`describe_db_parameter_groups`][rds_describe_db_parameter_groups]
#' request. If this parameter is specified, the response includes only
#' records beyond the marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_parameter_groups
rds_describe_db_parameter_groups <- function(DBParameterGroupName = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBParameterGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "DBParameterGroups")
  )
  input <- .rds$describe_db_parameter_groups_input(DBParameterGroupName = DBParameterGroupName, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_db_parameter_groups_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_parameter_groups <- rds_describe_db_parameter_groups

#' Returns the detailed parameter list for a particular DB parameter group
#'
#' @description
#' Returns the detailed parameter list for a particular DB parameter group.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_db_parameters/](https://www.paws-r-sdk.com/docs/rds_describe_db_parameters/) for full documentation.
#'
#' @param DBParameterGroupName &#91;required&#93; The name of a specific DB parameter group to return details for.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing DBParameterGroup.
#' @param Source The parameter types to return.
#' 
#' Default: All parameter types returned
#' 
#' Valid Values: `user | system | engine-default`
#' @param Filters This parameter isn't currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that you can retrieve the
#' remaining results.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' [`describe_db_parameters`][rds_describe_db_parameters] request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_parameters
rds_describe_db_parameters <- function(DBParameterGroupName, Source = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "Parameters")
  )
  input <- .rds$describe_db_parameters_input(DBParameterGroupName = DBParameterGroupName, Source = Source, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_db_parameters_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_parameters <- rds_describe_db_parameters

#' Returns information about DB proxies
#'
#' @description
#' Returns information about DB proxies.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_db_proxies/](https://www.paws-r-sdk.com/docs/rds_describe_db_proxies/) for full documentation.
#'
#' @param DBProxyName The name of the DB proxy. If you omit this parameter, the output
#' includes information about all DB proxies owned by your Amazon Web
#' Services account ID.
#' @param Filters This parameter is not currently supported.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_proxies
rds_describe_db_proxies <- function(DBProxyName = NULL, Filters = NULL, Marker = NULL, MaxRecords = NULL) {
  op <- new_operation(
    name = "DescribeDBProxies",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "DBProxies")
  )
  input <- .rds$describe_db_proxies_input(DBProxyName = DBProxyName, Filters = Filters, Marker = Marker, MaxRecords = MaxRecords)
  output <- .rds$describe_db_proxies_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_proxies <- rds_describe_db_proxies

#' Returns information about DB proxy endpoints
#'
#' @description
#' Returns information about DB proxy endpoints.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_db_proxy_endpoints/](https://www.paws-r-sdk.com/docs/rds_describe_db_proxy_endpoints/) for full documentation.
#'
#' @param DBProxyName The name of the DB proxy whose endpoints you want to describe. If you
#' omit this parameter, the output includes information about all DB proxy
#' endpoints associated with all your DB proxies.
#' @param DBProxyEndpointName The name of a DB proxy endpoint to describe. If you omit this parameter,
#' the output includes information about all DB proxy endpoints associated
#' with the specified proxy.
#' @param Filters This parameter is not currently supported.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_proxy_endpoints
rds_describe_db_proxy_endpoints <- function(DBProxyName = NULL, DBProxyEndpointName = NULL, Filters = NULL, Marker = NULL, MaxRecords = NULL) {
  op <- new_operation(
    name = "DescribeDBProxyEndpoints",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "DBProxyEndpoints")
  )
  input <- .rds$describe_db_proxy_endpoints_input(DBProxyName = DBProxyName, DBProxyEndpointName = DBProxyEndpointName, Filters = Filters, Marker = Marker, MaxRecords = MaxRecords)
  output <- .rds$describe_db_proxy_endpoints_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_proxy_endpoints <- rds_describe_db_proxy_endpoints

#' Returns information about DB proxy target groups, represented by
#' DBProxyTargetGroup data structures
#'
#' @description
#' Returns information about DB proxy target groups, represented by `DBProxyTargetGroup` data structures.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_db_proxy_target_groups/](https://www.paws-r-sdk.com/docs/rds_describe_db_proxy_target_groups/) for full documentation.
#'
#' @param DBProxyName &#91;required&#93; The identifier of the `DBProxy` associated with the target group.
#' @param TargetGroupName The identifier of the `DBProxyTargetGroup` to describe.
#' @param Filters This parameter is not currently supported.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_proxy_target_groups
rds_describe_db_proxy_target_groups <- function(DBProxyName, TargetGroupName = NULL, Filters = NULL, Marker = NULL, MaxRecords = NULL) {
  op <- new_operation(
    name = "DescribeDBProxyTargetGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "TargetGroups")
  )
  input <- .rds$describe_db_proxy_target_groups_input(DBProxyName = DBProxyName, TargetGroupName = TargetGroupName, Filters = Filters, Marker = Marker, MaxRecords = MaxRecords)
  output <- .rds$describe_db_proxy_target_groups_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_proxy_target_groups <- rds_describe_db_proxy_target_groups

#' Returns information about DBProxyTarget objects
#'
#' @description
#' Returns information about `DBProxyTarget` objects. This API supports pagination.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_db_proxy_targets/](https://www.paws-r-sdk.com/docs/rds_describe_db_proxy_targets/) for full documentation.
#'
#' @param DBProxyName &#91;required&#93; The identifier of the `DBProxyTarget` to describe.
#' @param TargetGroupName The identifier of the `DBProxyTargetGroup` to describe.
#' @param Filters This parameter is not currently supported.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_proxy_targets
rds_describe_db_proxy_targets <- function(DBProxyName, TargetGroupName = NULL, Filters = NULL, Marker = NULL, MaxRecords = NULL) {
  op <- new_operation(
    name = "DescribeDBProxyTargets",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "Targets")
  )
  input <- .rds$describe_db_proxy_targets_input(DBProxyName = DBProxyName, TargetGroupName = TargetGroupName, Filters = Filters, Marker = Marker, MaxRecords = MaxRecords)
  output <- .rds$describe_db_proxy_targets_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_proxy_targets <- rds_describe_db_proxy_targets

#' Returns a list of DBSecurityGroup descriptions
#'
#' @description
#' Returns a list of `DBSecurityGroup` descriptions. If a `DBSecurityGroupName` is specified, the list will contain only the descriptions of the specified DB security group.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_db_security_groups/](https://www.paws-r-sdk.com/docs/rds_describe_db_security_groups/) for full documentation.
#'
#' @param DBSecurityGroupName The name of the DB security group to return details for.
#' @param Filters This parameter isn't currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that you can retrieve the
#' remaining results.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' [`describe_db_security_groups`][rds_describe_db_security_groups]
#' request. If this parameter is specified, the response includes only
#' records beyond the marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_security_groups
rds_describe_db_security_groups <- function(DBSecurityGroupName = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBSecurityGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "DBSecurityGroups")
  )
  input <- .rds$describe_db_security_groups_input(DBSecurityGroupName = DBSecurityGroupName, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_db_security_groups_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_security_groups <- rds_describe_db_security_groups

#' Returns a list of DB snapshot attribute names and values for a manual DB
#' snapshot
#'
#' @description
#' Returns a list of DB snapshot attribute names and values for a manual DB snapshot.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_db_snapshot_attributes/](https://www.paws-r-sdk.com/docs/rds_describe_db_snapshot_attributes/) for full documentation.
#'
#' @param DBSnapshotIdentifier &#91;required&#93; The identifier for the DB snapshot to describe the attributes for.
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_snapshot_attributes
rds_describe_db_snapshot_attributes <- function(DBSnapshotIdentifier) {
  op <- new_operation(
    name = "DescribeDBSnapshotAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_db_snapshot_attributes_input(DBSnapshotIdentifier = DBSnapshotIdentifier)
  output <- .rds$describe_db_snapshot_attributes_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_snapshot_attributes <- rds_describe_db_snapshot_attributes

#' Returns information about DB snapshots
#'
#' @description
#' Returns information about DB snapshots. This API action supports pagination.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_db_snapshots/](https://www.paws-r-sdk.com/docs/rds_describe_db_snapshots/) for full documentation.
#'
#' @param DBInstanceIdentifier The ID of the DB instance to retrieve the list of DB snapshots for. This
#' parameter isn't case-sensitive.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the identifier of an existing DBInstance.
#' @param DBSnapshotIdentifier A specific DB snapshot identifier to describe. This value is stored as a
#' lowercase string.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the identifier of an existing DBSnapshot.
#' 
#' -   If this identifier is for an automated snapshot, the `SnapshotType`
#'     parameter must also be specified.
#' @param SnapshotType The type of snapshots to be returned. You can specify one of the
#' following values:
#' 
#' -   `automated` - Return all DB snapshots that have been automatically
#'     taken by Amazon RDS for my Amazon Web Services account.
#' 
#' -   `manual` - Return all DB snapshots that have been taken by my Amazon
#'     Web Services account.
#' 
#' -   `shared` - Return all manual DB snapshots that have been shared to
#'     my Amazon Web Services account.
#' 
#' -   `public` - Return all DB snapshots that have been marked as public.
#' 
#' -   `awsbackup` - Return the DB snapshots managed by the Amazon Web
#'     Services Backup service.
#' 
#'     For information about Amazon Web Services Backup, see the [*Amazon
#'     Web Services Backup Developer
#'     Guide.*](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html)
#' 
#'     The `awsbackup` type does not apply to Aurora.
#' 
#' If you don't specify a `SnapshotType` value, then both automated and
#' manual snapshots are returned. Shared and public DB snapshots are not
#' included in the returned results by default. You can include shared
#' snapshots with these results by enabling the `IncludeShared` parameter.
#' You can include public snapshots with these results by enabling the
#' `IncludePublic` parameter.
#' 
#' The `IncludeShared` and `IncludePublic` parameters don't apply for
#' `SnapshotType` values of `manual` or `automated`. The `IncludePublic`
#' parameter doesn't apply when `SnapshotType` is set to `shared`. The
#' `IncludeShared` parameter doesn't apply when `SnapshotType` is set to
#' `public`.
#' @param Filters A filter that specifies one or more DB snapshots to describe.
#' 
#' Supported filters:
#' 
#' -   `db-instance-id` - Accepts DB instance identifiers and DB instance
#'     Amazon Resource Names (ARNs).
#' 
#' -   `db-snapshot-id` - Accepts DB snapshot identifiers.
#' 
#' -   `dbi-resource-id` - Accepts identifiers of source DB instances.
#' 
#' -   `snapshot-type` - Accepts types of DB snapshots.
#' 
#' -   `engine` - Accepts names of database engines.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that you can retrieve the
#' remaining results.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' [`describe_db_snapshots`][rds_describe_db_snapshots] request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#' @param IncludeShared A value that indicates whether to include shared manual DB cluster
#' snapshots from other Amazon Web Services accounts that this Amazon Web
#' Services account has been given permission to copy or restore. By
#' default, these snapshots are not included.
#' 
#' You can give an Amazon Web Services account permission to restore a
#' manual DB snapshot from another Amazon Web Services account by using the
#' [`modify_db_snapshot_attribute`][rds_modify_db_snapshot_attribute] API
#' action.
#' 
#' This setting doesn't apply to RDS Custom.
#' @param IncludePublic A value that indicates whether to include manual DB cluster snapshots
#' that are public and can be copied or restored by any Amazon Web Services
#' account. By default, the public snapshots are not included.
#' 
#' You can share a manual DB snapshot as public by using the
#' [`modify_db_snapshot_attribute`][rds_modify_db_snapshot_attribute] API.
#' 
#' This setting doesn't apply to RDS Custom.
#' @param DbiResourceId A specific DB resource ID to describe.
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_snapshots
rds_describe_db_snapshots <- function(DBInstanceIdentifier = NULL, DBSnapshotIdentifier = NULL, SnapshotType = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL, IncludeShared = NULL, IncludePublic = NULL, DbiResourceId = NULL) {
  op <- new_operation(
    name = "DescribeDBSnapshots",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "DBSnapshots")
  )
  input <- .rds$describe_db_snapshots_input(DBInstanceIdentifier = DBInstanceIdentifier, DBSnapshotIdentifier = DBSnapshotIdentifier, SnapshotType = SnapshotType, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker, IncludeShared = IncludeShared, IncludePublic = IncludePublic, DbiResourceId = DbiResourceId)
  output <- .rds$describe_db_snapshots_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_snapshots <- rds_describe_db_snapshots

#' Returns a list of DBSubnetGroup descriptions
#'
#' @description
#' Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the descriptions of the specified DBSubnetGroup.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_db_subnet_groups/](https://www.paws-r-sdk.com/docs/rds_describe_db_subnet_groups/) for full documentation.
#'
#' @param DBSubnetGroupName The name of the DB subnet group to return details for.
#' @param Filters This parameter isn't currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that you can retrieve the
#' remaining results.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' DescribeDBSubnetGroups request. If this parameter is specified, the
#' response includes only records beyond the marker, up to the value
#' specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_subnet_groups
rds_describe_db_subnet_groups <- function(DBSubnetGroupName = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBSubnetGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "DBSubnetGroups")
  )
  input <- .rds$describe_db_subnet_groups_input(DBSubnetGroupName = DBSubnetGroupName, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_db_subnet_groups_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_subnet_groups <- rds_describe_db_subnet_groups

#' Returns the default engine and system parameter information for the
#' cluster database engine
#'
#' @description
#' Returns the default engine and system parameter information for the cluster database engine.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_engine_default_cluster_parameters/](https://www.paws-r-sdk.com/docs/rds_describe_engine_default_cluster_parameters/) for full documentation.
#'
#' @param DBParameterGroupFamily &#91;required&#93; The name of the DB cluster parameter group family to return engine
#' parameter information for.
#' @param Filters This parameter isn't currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so you can retrieve the
#' remaining results.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' [`describe_engine_default_cluster_parameters`][rds_describe_engine_default_cluster_parameters]
#' request. If this parameter is specified, the response includes only
#' records beyond the marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname rds_describe_engine_default_cluster_parameters
rds_describe_engine_default_cluster_parameters <- function(DBParameterGroupFamily, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeEngineDefaultClusterParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_engine_default_cluster_parameters_input(DBParameterGroupFamily = DBParameterGroupFamily, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_engine_default_cluster_parameters_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_engine_default_cluster_parameters <- rds_describe_engine_default_cluster_parameters

#' Returns the default engine and system parameter information for the
#' specified database engine
#'
#' @description
#' Returns the default engine and system parameter information for the specified database engine.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_engine_default_parameters/](https://www.paws-r-sdk.com/docs/rds_describe_engine_default_parameters/) for full documentation.
#'
#' @param DBParameterGroupFamily &#91;required&#93; The name of the DB parameter group family.
#' 
#' Valid Values:
#' 
#' -   `aurora-mysql5.7`
#' 
#' -   `aurora-mysql8.0`
#' 
#' -   `aurora-postgresql10`
#' 
#' -   `aurora-postgresql11`
#' 
#' -   `aurora-postgresql12`
#' 
#' -   `aurora-postgresql13`
#' 
#' -   `aurora-postgresql14`
#' 
#' -   `custom-oracle-ee-19`
#' 
#' -   `mariadb10.2`
#' 
#' -   `mariadb10.3`
#' 
#' -   `mariadb10.4`
#' 
#' -   `mariadb10.5`
#' 
#' -   `mariadb10.6`
#' 
#' -   `mysql5.7`
#' 
#' -   `mysql8.0`
#' 
#' -   `oracle-ee-19`
#' 
#' -   `oracle-ee-cdb-19`
#' 
#' -   `oracle-ee-cdb-21`
#' 
#' -   `oracle-se2-19`
#' 
#' -   `oracle-se2-cdb-19`
#' 
#' -   `oracle-se2-cdb-21`
#' 
#' -   `postgres10`
#' 
#' -   `postgres11`
#' 
#' -   `postgres12`
#' 
#' -   `postgres13`
#' 
#' -   `postgres14`
#' 
#' -   `sqlserver-ee-11.0`
#' 
#' -   `sqlserver-ee-12.0`
#' 
#' -   `sqlserver-ee-13.0`
#' 
#' -   `sqlserver-ee-14.0`
#' 
#' -   `sqlserver-ee-15.0`
#' 
#' -   `sqlserver-ex-11.0`
#' 
#' -   `sqlserver-ex-12.0`
#' 
#' -   `sqlserver-ex-13.0`
#' 
#' -   `sqlserver-ex-14.0`
#' 
#' -   `sqlserver-ex-15.0`
#' 
#' -   `sqlserver-se-11.0`
#' 
#' -   `sqlserver-se-12.0`
#' 
#' -   `sqlserver-se-13.0`
#' 
#' -   `sqlserver-se-14.0`
#' 
#' -   `sqlserver-se-15.0`
#' 
#' -   `sqlserver-web-11.0`
#' 
#' -   `sqlserver-web-12.0`
#' 
#' -   `sqlserver-web-13.0`
#' 
#' -   `sqlserver-web-14.0`
#' 
#' -   `sqlserver-web-15.0`
#' @param Filters This parameter isn't currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so you can retrieve the
#' remaining results.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' [`describe_engine_default_parameters`][rds_describe_engine_default_parameters]
#' request. If this parameter is specified, the response includes only
#' records beyond the marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname rds_describe_engine_default_parameters
rds_describe_engine_default_parameters <- function(DBParameterGroupFamily, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeEngineDefaultParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "EngineDefaults.Marker", result_key = "EngineDefaults.Parameters")
  )
  input <- .rds$describe_engine_default_parameters_input(DBParameterGroupFamily = DBParameterGroupFamily, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_engine_default_parameters_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_engine_default_parameters <- rds_describe_engine_default_parameters

#' Displays a list of categories for all event source types, or, if
#' specified, for a specified source type
#'
#' @description
#' Displays a list of categories for all event source types, or, if specified, for a specified source type. You can also see this list in the "Amazon RDS event categories and event messages" section of the [*Amazon RDS User Guide*](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Messages.html) or the [*Amazon Aurora User Guide*](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Messages.html) .
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_event_categories/](https://www.paws-r-sdk.com/docs/rds_describe_event_categories/) for full documentation.
#'
#' @param SourceType The type of source that is generating the events. For RDS Proxy events,
#' specify `db-proxy`.
#' 
#' Valid values: `db-instance` | `db-cluster` | `db-parameter-group` |
#' `db-security-group` | `db-snapshot` | `db-cluster-snapshot` | `db-proxy`
#' @param Filters This parameter isn't currently supported.
#'
#' @keywords internal
#'
#' @rdname rds_describe_event_categories
rds_describe_event_categories <- function(SourceType = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeEventCategories",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_event_categories_input(SourceType = SourceType, Filters = Filters)
  output <- .rds$describe_event_categories_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_event_categories <- rds_describe_event_categories

#' Lists all the subscription descriptions for a customer account
#'
#' @description
#' Lists all the subscription descriptions for a customer account. The description for a subscription includes `SubscriptionName`, `SNSTopicARN`, `CustomerID`, `SourceType`, `SourceID`, `CreationTime`, and `Status`.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_event_subscriptions/](https://www.paws-r-sdk.com/docs/rds_describe_event_subscriptions/) for full documentation.
#'
#' @param SubscriptionName The name of the RDS event notification subscription you want to
#' describe.
#' @param Filters This parameter isn't currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that you can retrieve the
#' remaining results.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' DescribeOrderableDBInstanceOptions request. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords` .
#'
#' @keywords internal
#'
#' @rdname rds_describe_event_subscriptions
rds_describe_event_subscriptions <- function(SubscriptionName = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeEventSubscriptions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "EventSubscriptionsList")
  )
  input <- .rds$describe_event_subscriptions_input(SubscriptionName = SubscriptionName, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_event_subscriptions_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_event_subscriptions <- rds_describe_event_subscriptions

#' Returns events related to DB instances, DB clusters, DB parameter
#' groups, DB security groups, DB snapshots, DB cluster snapshots, and RDS
#' Proxies for the past 14 days
#'
#' @description
#' Returns events related to DB instances, DB clusters, DB parameter groups, DB security groups, DB snapshots, DB cluster snapshots, and RDS Proxies for the past 14 days. Events specific to a particular DB instance, DB cluster, DB parameter group, DB security group, DB snapshot, DB cluster snapshot group, or RDS Proxy can be obtained by providing the name as a parameter.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_events/](https://www.paws-r-sdk.com/docs/rds_describe_events/) for full documentation.
#'
#' @param SourceIdentifier The identifier of the event source for which events are returned. If not
#' specified, then all sources are included in the response.
#' 
#' Constraints:
#' 
#' -   If `SourceIdentifier` is supplied, `SourceType` must also be
#'     provided.
#' 
#' -   If the source type is a DB instance, a `DBInstanceIdentifier` value
#'     must be supplied.
#' 
#' -   If the source type is a DB cluster, a `DBClusterIdentifier` value
#'     must be supplied.
#' 
#' -   If the source type is a DB parameter group, a `DBParameterGroupName`
#'     value must be supplied.
#' 
#' -   If the source type is a DB security group, a `DBSecurityGroupName`
#'     value must be supplied.
#' 
#' -   If the source type is a DB snapshot, a `DBSnapshotIdentifier` value
#'     must be supplied.
#' 
#' -   If the source type is a DB cluster snapshot, a
#'     `DBClusterSnapshotIdentifier` value must be supplied.
#' 
#' -   If the source type is an RDS Proxy, a `DBProxyName` value must be
#'     supplied.
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens.
#' @param SourceType The event source to retrieve events for. If no value is specified, all
#' events are returned.
#' @param StartTime The beginning of the time interval to retrieve events for, specified in
#' ISO 8601 format. For more information about ISO 8601, go to the [ISO8601
#' Wikipedia page.](https://en.wikipedia.org/wiki/ISO_8601)
#' 
#' Example: 2009-07-08T18:00Z
#' @param EndTime The end of the time interval for which to retrieve events, specified in
#' ISO 8601 format. For more information about ISO 8601, go to the [ISO8601
#' Wikipedia page.](https://en.wikipedia.org/wiki/ISO_8601)
#' 
#' Example: 2009-07-08T18:00Z
#' @param Duration The number of minutes to retrieve events for.
#' 
#' Default: 60
#' @param EventCategories A list of event categories that trigger notifications for a event
#' notification subscription.
#' @param Filters This parameter isn't currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that you can retrieve the
#' remaining results.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous DescribeEvents
#' request. If this parameter is specified, the response includes only
#' records beyond the marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname rds_describe_events
rds_describe_events <- function(SourceIdentifier = NULL, SourceType = NULL, StartTime = NULL, EndTime = NULL, Duration = NULL, EventCategories = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "Events")
  )
  input <- .rds$describe_events_input(SourceIdentifier = SourceIdentifier, SourceType = SourceType, StartTime = StartTime, EndTime = EndTime, Duration = Duration, EventCategories = EventCategories, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_events_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_events <- rds_describe_events

#' Returns information about a snapshot or cluster export to Amazon S3
#'
#' @description
#' Returns information about a snapshot or cluster export to Amazon S3. This API operation supports pagination.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_export_tasks/](https://www.paws-r-sdk.com/docs/rds_describe_export_tasks/) for full documentation.
#'
#' @param ExportTaskIdentifier The identifier of the snapshot or cluster export task to be described.
#' @param SourceArn The Amazon Resource Name (ARN) of the snapshot or cluster exported to
#' Amazon S3.
#' @param Filters Filters specify one or more snapshot or cluster exports to describe. The
#' filters are specified as name-value pairs that define what to include in
#' the output. Filter names and values are case-sensitive.
#' 
#' Supported filters include the following:
#' 
#' -   `export-task-identifier` - An identifier for the snapshot or cluster
#'     export task.
#' 
#' -   `s3-bucket` - The Amazon S3 bucket the data is exported to.
#' 
#' -   `source-arn` - The Amazon Resource Name (ARN) of the snapshot or
#'     cluster exported to Amazon S3.
#' 
#' -   `status` - The status of the export task. Must be lowercase. Valid
#'     statuses are the following:
#' 
#'     -   `canceled`
#' 
#'     -   `canceling`
#' 
#'     -   `complete`
#' 
#'     -   `failed`
#' 
#'     -   `in_progress`
#' 
#'     -   `starting`
#' @param Marker An optional pagination token provided by a previous
#' [`describe_export_tasks`][rds_describe_export_tasks] request. If you
#' specify this parameter, the response includes only records beyond the
#' marker, up to the value specified by the `MaxRecords` parameter.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified value, a pagination token called a
#' marker is included in the response. You can use the marker in a later
#' [`describe_export_tasks`][rds_describe_export_tasks] request to retrieve
#' the remaining results.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param SourceType The type of source for the export.
#'
#' @keywords internal
#'
#' @rdname rds_describe_export_tasks
rds_describe_export_tasks <- function(ExportTaskIdentifier = NULL, SourceArn = NULL, Filters = NULL, Marker = NULL, MaxRecords = NULL, SourceType = NULL) {
  op <- new_operation(
    name = "DescribeExportTasks",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "ExportTasks")
  )
  input <- .rds$describe_export_tasks_input(ExportTaskIdentifier = ExportTaskIdentifier, SourceArn = SourceArn, Filters = Filters, Marker = Marker, MaxRecords = MaxRecords, SourceType = SourceType)
  output <- .rds$describe_export_tasks_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_export_tasks <- rds_describe_export_tasks

#' Returns information about Aurora global database clusters
#'
#' @description
#' Returns information about Aurora global database clusters. This API supports pagination.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_global_clusters/](https://www.paws-r-sdk.com/docs/rds_describe_global_clusters/) for full documentation.
#'
#' @param GlobalClusterIdentifier The user-supplied DB cluster identifier. If this parameter is specified,
#' information from only the specific DB cluster is returned. This
#' parameter isn't case-sensitive.
#' 
#' Constraints:
#' 
#' -   If supplied, must match an existing DBClusterIdentifier.
#' @param Filters This parameter isn't currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that you can retrieve the
#' remaining results.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' [`describe_global_clusters`][rds_describe_global_clusters] request. If
#' this parameter is specified, the response includes only records beyond
#' the marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname rds_describe_global_clusters
rds_describe_global_clusters <- function(GlobalClusterIdentifier = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeGlobalClusters",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "GlobalClusters")
  )
  input <- .rds$describe_global_clusters_input(GlobalClusterIdentifier = GlobalClusterIdentifier, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_global_clusters_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_global_clusters <- rds_describe_global_clusters

#' Describes all available options
#'
#' @description
#' Describes all available options.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_option_group_options/](https://www.paws-r-sdk.com/docs/rds_describe_option_group_options/) for full documentation.
#'
#' @param EngineName &#91;required&#93; A required parameter. Options available for the given engine name are
#' described.
#' 
#' Valid Values:
#' 
#' -   `mariadb`
#' 
#' -   `mysql`
#' 
#' -   `oracle-ee`
#' 
#' -   `oracle-ee-cdb`
#' 
#' -   `oracle-se2`
#' 
#' -   `oracle-se2-cdb`
#' 
#' -   `postgres`
#' 
#' -   `sqlserver-ee`
#' 
#' -   `sqlserver-se`
#' 
#' -   `sqlserver-ex`
#' 
#' -   `sqlserver-web`
#' @param MajorEngineVersion If specified, filters the results to include only options for the
#' specified major engine version.
#' @param Filters This parameter isn't currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that you can retrieve the
#' remaining results.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname rds_describe_option_group_options
rds_describe_option_group_options <- function(EngineName, MajorEngineVersion = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeOptionGroupOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "OptionGroupOptions")
  )
  input <- .rds$describe_option_group_options_input(EngineName = EngineName, MajorEngineVersion = MajorEngineVersion, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_option_group_options_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_option_group_options <- rds_describe_option_group_options

#' Describes the available option groups
#'
#' @description
#' Describes the available option groups.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_option_groups/](https://www.paws-r-sdk.com/docs/rds_describe_option_groups/) for full documentation.
#'
#' @param OptionGroupName The name of the option group to describe. Can't be supplied together
#' with EngineName or MajorEngineVersion.
#' @param Filters This parameter isn't currently supported.
#' @param Marker An optional pagination token provided by a previous DescribeOptionGroups
#' request. If this parameter is specified, the response includes only
#' records beyond the marker, up to the value specified by `MaxRecords`.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that you can retrieve the
#' remaining results.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param EngineName Filters the list of option groups to only include groups associated with
#' a specific database engine.
#' 
#' Valid Values:
#' 
#' -   `mariadb`
#' 
#' -   `mysql`
#' 
#' -   `oracle-ee`
#' 
#' -   `oracle-ee-cdb`
#' 
#' -   `oracle-se2`
#' 
#' -   `oracle-se2-cdb`
#' 
#' -   `postgres`
#' 
#' -   `sqlserver-ee`
#' 
#' -   `sqlserver-se`
#' 
#' -   `sqlserver-ex`
#' 
#' -   `sqlserver-web`
#' @param MajorEngineVersion Filters the list of option groups to only include groups associated with
#' a specific database engine version. If specified, then EngineName must
#' also be specified.
#'
#' @keywords internal
#'
#' @rdname rds_describe_option_groups
rds_describe_option_groups <- function(OptionGroupName = NULL, Filters = NULL, Marker = NULL, MaxRecords = NULL, EngineName = NULL, MajorEngineVersion = NULL) {
  op <- new_operation(
    name = "DescribeOptionGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "OptionGroupsList")
  )
  input <- .rds$describe_option_groups_input(OptionGroupName = OptionGroupName, Filters = Filters, Marker = Marker, MaxRecords = MaxRecords, EngineName = EngineName, MajorEngineVersion = MajorEngineVersion)
  output <- .rds$describe_option_groups_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_option_groups <- rds_describe_option_groups

#' Returns a list of orderable DB instance options for the specified DB
#' engine, DB engine version, and DB instance class
#'
#' @description
#' Returns a list of orderable DB instance options for the specified DB engine, DB engine version, and DB instance class.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_orderable_db_instance_options/](https://www.paws-r-sdk.com/docs/rds_describe_orderable_db_instance_options/) for full documentation.
#'
#' @param Engine &#91;required&#93; The name of the engine to retrieve DB instance options for.
#' 
#' Valid Values:
#' 
#' -   `aurora-mysql`
#' 
#' -   `aurora-postgresql`
#' 
#' -   `custom-oracle-ee`
#' 
#' -   `mariadb`
#' 
#' -   `mysql`
#' 
#' -   `oracle-ee`
#' 
#' -   `oracle-ee-cdb`
#' 
#' -   `oracle-se2`
#' 
#' -   `oracle-se2-cdb`
#' 
#' -   `postgres`
#' 
#' -   `sqlserver-ee`
#' 
#' -   `sqlserver-se`
#' 
#' -   `sqlserver-ex`
#' 
#' -   `sqlserver-web`
#' @param EngineVersion The engine version filter value. Specify this parameter to show only the
#' available offerings matching the specified engine version.
#' @param DBInstanceClass The DB instance class filter value. Specify this parameter to show only
#' the available offerings matching the specified DB instance class.
#' @param LicenseModel The license model filter value. Specify this parameter to show only the
#' available offerings matching the specified license model.
#' 
#' RDS Custom supports only the BYOL licensing model.
#' @param AvailabilityZoneGroup The Availability Zone group associated with a Local Zone. Specify this
#' parameter to retrieve available offerings for the Local Zones in the
#' group.
#' 
#' Omit this parameter to show the available offerings in the specified
#' Amazon Web Services Region.
#' 
#' This setting doesn't apply to RDS Custom.
#' @param Vpc A value that indicates whether to show only VPC or non-VPC offerings.
#' RDS Custom supports only VPC offerings.
#' 
#' RDS Custom supports only VPC offerings. If you describe non-VPC
#' offerings for RDS Custom, the output shows VPC offerings.
#' @param Filters This parameter isn't currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that you can retrieve the
#' remaining results.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 10000.
#' @param Marker An optional pagination token provided by a previous
#' DescribeOrderableDBInstanceOptions request. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname rds_describe_orderable_db_instance_options
rds_describe_orderable_db_instance_options <- function(Engine, EngineVersion = NULL, DBInstanceClass = NULL, LicenseModel = NULL, AvailabilityZoneGroup = NULL, Vpc = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeOrderableDBInstanceOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "OrderableDBInstanceOptions")
  )
  input <- .rds$describe_orderable_db_instance_options_input(Engine = Engine, EngineVersion = EngineVersion, DBInstanceClass = DBInstanceClass, LicenseModel = LicenseModel, AvailabilityZoneGroup = AvailabilityZoneGroup, Vpc = Vpc, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_orderable_db_instance_options_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_orderable_db_instance_options <- rds_describe_orderable_db_instance_options

#' Returns a list of resources (for example, DB instances) that have at
#' least one pending maintenance action
#'
#' @description
#' Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_pending_maintenance_actions/](https://www.paws-r-sdk.com/docs/rds_describe_pending_maintenance_actions/) for full documentation.
#'
#' @param ResourceIdentifier The ARN of a resource to return pending maintenance actions for.
#' @param Filters A filter that specifies one or more resources to return pending
#' maintenance actions for.
#' 
#' Supported filters:
#' 
#' -   `db-cluster-id` - Accepts DB cluster identifiers and DB cluster
#'     Amazon Resource Names (ARNs). The results list only includes pending
#'     maintenance actions for the DB clusters identified by these ARNs.
#' 
#' -   `db-instance-id` - Accepts DB instance identifiers and DB instance
#'     ARNs. The results list only includes pending maintenance actions for
#'     the DB instances identified by these ARNs.
#' @param Marker An optional pagination token provided by a previous
#' [`describe_pending_maintenance_actions`][rds_describe_pending_maintenance_actions]
#' request. If this parameter is specified, the response includes only
#' records beyond the marker, up to a number of records specified by
#' `MaxRecords`.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that you can retrieve the
#' remaining results.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#'
#' @keywords internal
#'
#' @rdname rds_describe_pending_maintenance_actions
rds_describe_pending_maintenance_actions <- function(ResourceIdentifier = NULL, Filters = NULL, Marker = NULL, MaxRecords = NULL) {
  op <- new_operation(
    name = "DescribePendingMaintenanceActions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "PendingMaintenanceActions")
  )
  input <- .rds$describe_pending_maintenance_actions_input(ResourceIdentifier = ResourceIdentifier, Filters = Filters, Marker = Marker, MaxRecords = MaxRecords)
  output <- .rds$describe_pending_maintenance_actions_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_pending_maintenance_actions <- rds_describe_pending_maintenance_actions

#' Returns information about reserved DB instances for this account, or
#' about a specified reserved DB instance
#'
#' @description
#' Returns information about reserved DB instances for this account, or about a specified reserved DB instance.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_reserved_db_instances/](https://www.paws-r-sdk.com/docs/rds_describe_reserved_db_instances/) for full documentation.
#'
#' @param ReservedDBInstanceId The reserved DB instance identifier filter value. Specify this parameter
#' to show only the reservation that matches the specified reservation ID.
#' @param ReservedDBInstancesOfferingId The offering identifier filter value. Specify this parameter to show
#' only purchased reservations matching the specified offering identifier.
#' @param DBInstanceClass The DB instance class filter value. Specify this parameter to show only
#' those reservations matching the specified DB instances class.
#' @param Duration The duration filter value, specified in years or seconds. Specify this
#' parameter to show only reservations for this duration.
#' 
#' Valid Values: `1 | 3 | 31536000 | 94608000`
#' @param ProductDescription The product description filter value. Specify this parameter to show
#' only those reservations matching the specified product description.
#' @param OfferingType The offering type filter value. Specify this parameter to show only the
#' available offerings matching the specified offering type.
#' 
#' Valid Values: `"Partial Upfront" | "All Upfront" | "No Upfront" `
#' @param MultiAZ A value that indicates whether to show only those reservations that
#' support Multi-AZ.
#' @param LeaseId The lease identifier filter value. Specify this parameter to show only
#' the reservation that matches the specified lease ID.
#' 
#' Amazon Web Services Support might request the lease ID for an issue
#' related to a reserved DB instance.
#' @param Filters This parameter isn't currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more than
#' the `MaxRecords` value is available, a pagination token called a marker
#' is included in the response so you can retrieve the remaining results.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname rds_describe_reserved_db_instances
rds_describe_reserved_db_instances <- function(ReservedDBInstanceId = NULL, ReservedDBInstancesOfferingId = NULL, DBInstanceClass = NULL, Duration = NULL, ProductDescription = NULL, OfferingType = NULL, MultiAZ = NULL, LeaseId = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeReservedDBInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "ReservedDBInstances")
  )
  input <- .rds$describe_reserved_db_instances_input(ReservedDBInstanceId = ReservedDBInstanceId, ReservedDBInstancesOfferingId = ReservedDBInstancesOfferingId, DBInstanceClass = DBInstanceClass, Duration = Duration, ProductDescription = ProductDescription, OfferingType = OfferingType, MultiAZ = MultiAZ, LeaseId = LeaseId, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_reserved_db_instances_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_reserved_db_instances <- rds_describe_reserved_db_instances

#' Lists available reserved DB instance offerings
#'
#' @description
#' Lists available reserved DB instance offerings.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_reserved_db_instances_offerings/](https://www.paws-r-sdk.com/docs/rds_describe_reserved_db_instances_offerings/) for full documentation.
#'
#' @param ReservedDBInstancesOfferingId The offering identifier filter value. Specify this parameter to show
#' only the available offering that matches the specified reservation
#' identifier.
#' 
#' Example: `438012d3-4052-4cc7-b2e3-8d3372e0e706`
#' @param DBInstanceClass The DB instance class filter value. Specify this parameter to show only
#' the available offerings matching the specified DB instance class.
#' @param Duration Duration filter value, specified in years or seconds. Specify this
#' parameter to show only reservations for this duration.
#' 
#' Valid Values: `1 | 3 | 31536000 | 94608000`
#' @param ProductDescription Product description filter value. Specify this parameter to show only
#' the available offerings that contain the specified product description.
#' 
#' The results show offerings that partially match the filter value.
#' @param OfferingType The offering type filter value. Specify this parameter to show only the
#' available offerings matching the specified offering type.
#' 
#' Valid Values: `"Partial Upfront" | "All Upfront" | "No Upfront" `
#' @param MultiAZ A value that indicates whether to show only those reservations that
#' support Multi-AZ.
#' @param Filters This parameter isn't currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more than
#' the `MaxRecords` value is available, a pagination token called a marker
#' is included in the response so you can retrieve the remaining results.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname rds_describe_reserved_db_instances_offerings
rds_describe_reserved_db_instances_offerings <- function(ReservedDBInstancesOfferingId = NULL, DBInstanceClass = NULL, Duration = NULL, ProductDescription = NULL, OfferingType = NULL, MultiAZ = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeReservedDBInstancesOfferings",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "ReservedDBInstancesOfferings")
  )
  input <- .rds$describe_reserved_db_instances_offerings_input(ReservedDBInstancesOfferingId = ReservedDBInstancesOfferingId, DBInstanceClass = DBInstanceClass, Duration = Duration, ProductDescription = ProductDescription, OfferingType = OfferingType, MultiAZ = MultiAZ, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_reserved_db_instances_offerings_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_reserved_db_instances_offerings <- rds_describe_reserved_db_instances_offerings

#' Returns a list of the source Amazon Web Services Regions where the
#' current Amazon Web Services Region can create a read replica, copy a DB
#' snapshot from, or replicate automated backups from
#'
#' @description
#' Returns a list of the source Amazon Web Services Regions where the current Amazon Web Services Region can create a read replica, copy a DB snapshot from, or replicate automated backups from.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_source_regions/](https://www.paws-r-sdk.com/docs/rds_describe_source_regions/) for full documentation.
#'
#' @param RegionName The source Amazon Web Services Region name. For example, `us-east-1`.
#' 
#' Constraints:
#' 
#' -   Must specify a valid Amazon Web Services Region name.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so you can retrieve the
#' remaining results.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' [`describe_source_regions`][rds_describe_source_regions] request. If
#' this parameter is specified, the response includes only records beyond
#' the marker, up to the value specified by `MaxRecords`.
#' @param Filters This parameter isn't currently supported.
#'
#' @keywords internal
#'
#' @rdname rds_describe_source_regions
rds_describe_source_regions <- function(RegionName = NULL, MaxRecords = NULL, Marker = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeSourceRegions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "SourceRegions")
  )
  input <- .rds$describe_source_regions_input(RegionName = RegionName, MaxRecords = MaxRecords, Marker = Marker, Filters = Filters)
  output <- .rds$describe_source_regions_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_source_regions <- rds_describe_source_regions

#' You can call DescribeValidDBInstanceModifications to learn what
#' modifications you can make to your DB instance
#'
#' @description
#' You can call [`describe_valid_db_instance_modifications`][rds_describe_valid_db_instance_modifications] to learn what modifications you can make to your DB instance. You can use this information when you call [`modify_db_instance`][rds_modify_db_instance].
#'
#' See [https://www.paws-r-sdk.com/docs/rds_describe_valid_db_instance_modifications/](https://www.paws-r-sdk.com/docs/rds_describe_valid_db_instance_modifications/) for full documentation.
#'
#' @param DBInstanceIdentifier &#91;required&#93; The customer identifier or the ARN of your DB instance.
#'
#' @keywords internal
#'
#' @rdname rds_describe_valid_db_instance_modifications
rds_describe_valid_db_instance_modifications <- function(DBInstanceIdentifier) {
  op <- new_operation(
    name = "DescribeValidDBInstanceModifications",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_valid_db_instance_modifications_input(DBInstanceIdentifier = DBInstanceIdentifier)
  output <- .rds$describe_valid_db_instance_modifications_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_valid_db_instance_modifications <- rds_describe_valid_db_instance_modifications

#' Downloads all or a portion of the specified log file, up to 1 MB in size
#'
#' @description
#' Downloads all or a portion of the specified log file, up to 1 MB in size.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_download_db_log_file_portion/](https://www.paws-r-sdk.com/docs/rds_download_db_log_file_portion/) for full documentation.
#'
#' @param DBInstanceIdentifier &#91;required&#93; The customer-assigned name of the DB instance that contains the log
#' files you want to list.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DBInstance.
#' @param LogFileName &#91;required&#93; The name of the log file to be downloaded.
#' @param Marker The pagination token provided in the previous request or "0". If the
#' Marker parameter is specified the response includes only records beyond
#' the marker until the end of the file or up to NumberOfLines.
#' @param NumberOfLines The number of lines to download. If the number of lines specified
#' results in a file over 1 MB in size, the file is truncated at 1 MB in
#' size.
#' 
#' If the NumberOfLines parameter is specified, then the block of lines
#' returned can be from the beginning or the end of the log file, depending
#' on the value of the Marker parameter.
#' 
#' -   If neither Marker or NumberOfLines are specified, the entire log
#'     file is returned up to a maximum of 10000 lines, starting with the
#'     most recent log entries first.
#' 
#' -   If NumberOfLines is specified and Marker isn't specified, then the
#'     most recent lines from the end of the log file are returned.
#' 
#' -   If Marker is specified as "0", then the specified number of lines
#'     from the beginning of the log file are returned.
#' 
#' -   You can download the log file in blocks of lines by specifying the
#'     size of the block using the NumberOfLines parameter, and by
#'     specifying a value of "0" for the Marker parameter in your first
#'     request. Include the Marker value returned in the response as the
#'     Marker value for the next request, continuing until the
#'     AdditionalDataPending response element returns false.
#'
#' @keywords internal
#'
#' @rdname rds_download_db_log_file_portion
rds_download_db_log_file_portion <- function(DBInstanceIdentifier, LogFileName, Marker = NULL, NumberOfLines = NULL) {
  op <- new_operation(
    name = "DownloadDBLogFilePortion",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "Marker", limit_key = "NumberOfLines", more_results = "AdditionalDataPending", output_token = "Marker", result_key = "LogFileData")
  )
  input <- .rds$download_db_log_file_portion_input(DBInstanceIdentifier = DBInstanceIdentifier, LogFileName = LogFileName, Marker = Marker, NumberOfLines = NumberOfLines)
  output <- .rds$download_db_log_file_portion_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$download_db_log_file_portion <- rds_download_db_log_file_portion

#' Forces a failover for a DB cluster
#'
#' @description
#' Forces a failover for a DB cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_failover_db_cluster/](https://www.paws-r-sdk.com/docs/rds_failover_db_cluster/) for full documentation.
#'
#' @param DBClusterIdentifier &#91;required&#93; A DB cluster identifier to force a failover for. This parameter isn't
#' case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DBCluster.
#' @param TargetDBInstanceIdentifier The name of the DB instance to promote to the primary DB instance.
#' 
#' Specify the DB instance identifier for an Aurora Replica or a Multi-AZ
#' readable standby in the DB cluster, for example `mydbcluster-replica1`.
#' 
#' This setting isn't supported for RDS for MySQL Multi-AZ DB clusters.
#'
#' @keywords internal
#'
#' @rdname rds_failover_db_cluster
rds_failover_db_cluster <- function(DBClusterIdentifier, TargetDBInstanceIdentifier = NULL) {
  op <- new_operation(
    name = "FailoverDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$failover_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier, TargetDBInstanceIdentifier = TargetDBInstanceIdentifier)
  output <- .rds$failover_db_cluster_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$failover_db_cluster <- rds_failover_db_cluster

#' Promotes the specified secondary DB cluster to be the primary DB cluster
#' in the global database cluster to fail over or switch over a global
#' database
#'
#' @description
#' Promotes the specified secondary DB cluster to be the primary DB cluster in the global database cluster to fail over or switch over a global database. Switchover operations were previously called "managed planned failovers."
#'
#' See [https://www.paws-r-sdk.com/docs/rds_failover_global_cluster/](https://www.paws-r-sdk.com/docs/rds_failover_global_cluster/) for full documentation.
#'
#' @param GlobalClusterIdentifier &#91;required&#93; The identifier of the global database cluster (Aurora global database)
#' this operation should apply to. The identifier is the unique key
#' assigned by the user when the Aurora global database is created. In
#' other words, it's the name of the Aurora global database.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing global database cluster.
#' @param TargetDbClusterIdentifier &#91;required&#93; The identifier of the secondary Aurora DB cluster that you want to
#' promote to the primary for the global database cluster. Use the Amazon
#' Resource Name (ARN) for the identifier so that Aurora can locate the
#' cluster in its Amazon Web Services Region.
#' @param AllowDataLoss Specifies whether to allow data loss for this global database cluster
#' operation. Allowing data loss triggers a global failover operation.
#' 
#' If you don't specify `AllowDataLoss`, the global database cluster
#' operation defaults to a switchover.
#' 
#' Constraints:
#' 
#' -   Can't be specified together with the `Switchover` parameter.
#' @param Switchover Specifies whether to switch over this global database cluster.
#' 
#' Constraints:
#' 
#' -   Can't be specified together with the `AllowDataLoss` parameter.
#'
#' @keywords internal
#'
#' @rdname rds_failover_global_cluster
rds_failover_global_cluster <- function(GlobalClusterIdentifier, TargetDbClusterIdentifier, AllowDataLoss = NULL, Switchover = NULL) {
  op <- new_operation(
    name = "FailoverGlobalCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$failover_global_cluster_input(GlobalClusterIdentifier = GlobalClusterIdentifier, TargetDbClusterIdentifier = TargetDbClusterIdentifier, AllowDataLoss = AllowDataLoss, Switchover = Switchover)
  output <- .rds$failover_global_cluster_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$failover_global_cluster <- rds_failover_global_cluster

#' Lists all tags on an Amazon RDS resource
#'
#' @description
#' Lists all tags on an Amazon RDS resource.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/rds_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceName &#91;required&#93; The Amazon RDS resource with tags to be listed. This value is an Amazon
#' Resource Name (ARN). For information about creating an ARN, see
#' [Constructing an ARN for Amazon
#' RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing)
#' in the *Amazon RDS User Guide*.
#' @param Filters This parameter isn't currently supported.
#'
#' @keywords internal
#'
#' @rdname rds_list_tags_for_resource
rds_list_tags_for_resource <- function(ResourceName, Filters = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list(result_key = "TagList")
  )
  input <- .rds$list_tags_for_resource_input(ResourceName = ResourceName, Filters = Filters)
  output <- .rds$list_tags_for_resource_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$list_tags_for_resource <- rds_list_tags_for_resource

#' Changes the audit policy state of a database activity stream to either
#' locked (default) or unlocked
#'
#' @description
#' Changes the audit policy state of a database activity stream to either locked (default) or unlocked. A locked policy is read-only, whereas an unlocked policy is read/write. If your activity stream is started and locked, you can unlock it, customize your audit policy, and then lock your activity stream. Restarting the activity stream isn't required. For more information, see [Modifying a database activity stream](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/DBActivityStreams.Modifying.html) in the *Amazon RDS User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_modify_activity_stream/](https://www.paws-r-sdk.com/docs/rds_modify_activity_stream/) for full documentation.
#'
#' @param ResourceArn The Amazon Resource Name (ARN) of the RDS for Oracle or Microsoft SQL
#' Server DB instance. For example,
#' `arn:aws:rds:us-east-1:12345667890:instance:my-orcl-db`.
#' @param AuditPolicyState The audit policy state. When a policy is unlocked, it is read/write.
#' When it is locked, it is read-only. You can edit your audit policy only
#' when the activity stream is unlocked or stopped.
#'
#' @keywords internal
#'
#' @rdname rds_modify_activity_stream
rds_modify_activity_stream <- function(ResourceArn = NULL, AuditPolicyState = NULL) {
  op <- new_operation(
    name = "ModifyActivityStream",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$modify_activity_stream_input(ResourceArn = ResourceArn, AuditPolicyState = AuditPolicyState)
  output <- .rds$modify_activity_stream_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$modify_activity_stream <- rds_modify_activity_stream

#' Override the system-default Secure Sockets Layer/Transport Layer
#' Security (SSL/TLS) certificate for Amazon RDS for new DB instances, or
#' remove the override
#'
#' @description
#' Override the system-default Secure Sockets Layer/Transport Layer Security (SSL/TLS) certificate for Amazon RDS for new DB instances, or remove the override.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_modify_certificates/](https://www.paws-r-sdk.com/docs/rds_modify_certificates/) for full documentation.
#'
#' @param CertificateIdentifier The new default certificate identifier to override the current one with.
#' 
#' To determine the valid values, use the `describe-certificates` CLI
#' command or the [`describe_certificates`][rds_describe_certificates] API
#' operation.
#' @param RemoveCustomerOverride A value that indicates whether to remove the override for the default
#' certificate. If the override is removed, the default certificate is the
#' system default.
#'
#' @keywords internal
#'
#' @rdname rds_modify_certificates
rds_modify_certificates <- function(CertificateIdentifier = NULL, RemoveCustomerOverride = NULL) {
  op <- new_operation(
    name = "ModifyCertificates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$modify_certificates_input(CertificateIdentifier = CertificateIdentifier, RemoveCustomerOverride = RemoveCustomerOverride)
  output <- .rds$modify_certificates_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$modify_certificates <- rds_modify_certificates

#' Set the capacity of an Aurora Serverless v1 DB cluster to a specific
#' value
#'
#' @description
#' Set the capacity of an Aurora Serverless v1 DB cluster to a specific value.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_modify_current_db_cluster_capacity/](https://www.paws-r-sdk.com/docs/rds_modify_current_db_cluster_capacity/) for full documentation.
#'
#' @param DBClusterIdentifier &#91;required&#93; The DB cluster identifier for the cluster being modified. This parameter
#' isn't case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DB cluster.
#' @param Capacity The DB cluster capacity.
#' 
#' When you change the capacity of a paused Aurora Serverless v1 DB
#' cluster, it automatically resumes.
#' 
#' Constraints:
#' 
#' -   For Aurora MySQL, valid capacity values are `1`, `2`, `4`, `8`,
#'     `16`, `32`, `64`, `128`, and `256`.
#' 
#' -   For Aurora PostgreSQL, valid capacity values are `2`, `4`, `8`,
#'     `16`, `32`, `64`, `192`, and `384`.
#' @param SecondsBeforeTimeout The amount of time, in seconds, that Aurora Serverless v1 tries to find
#' a scaling point to perform seamless scaling before enforcing the timeout
#' action. The default is 300.
#' 
#' Specify a value between 10 and 600 seconds.
#' @param TimeoutAction The action to take when the timeout is reached, either
#' `ForceApplyCapacityChange` or `RollbackCapacityChange`.
#' 
#' `ForceApplyCapacityChange`, the default, sets the capacity to the
#' specified value as soon as possible.
#' 
#' `RollbackCapacityChange` ignores the capacity change if a scaling point
#' isn't found in the timeout period.
#'
#' @keywords internal
#'
#' @rdname rds_modify_current_db_cluster_capacity
rds_modify_current_db_cluster_capacity <- function(DBClusterIdentifier, Capacity = NULL, SecondsBeforeTimeout = NULL, TimeoutAction = NULL) {
  op <- new_operation(
    name = "ModifyCurrentDBClusterCapacity",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$modify_current_db_cluster_capacity_input(DBClusterIdentifier = DBClusterIdentifier, Capacity = Capacity, SecondsBeforeTimeout = SecondsBeforeTimeout, TimeoutAction = TimeoutAction)
  output <- .rds$modify_current_db_cluster_capacity_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$modify_current_db_cluster_capacity <- rds_modify_current_db_cluster_capacity

#' Modifies the status of a custom engine version (CEV)
#'
#' @description
#' Modifies the status of a custom engine version (CEV). You can find CEVs to modify by calling [`describe_db_engine_versions`][rds_describe_db_engine_versions].
#'
#' See [https://www.paws-r-sdk.com/docs/rds_modify_custom_db_engine_version/](https://www.paws-r-sdk.com/docs/rds_modify_custom_db_engine_version/) for full documentation.
#'
#' @param Engine &#91;required&#93; The DB engine. The only supported values are `custom-oracle-ee` and
#' `custom-oracle-ee-cdb`.
#' @param EngineVersion &#91;required&#93; The custom engine version (CEV) that you want to modify. This option is
#' required for RDS Custom for Oracle, but optional for Amazon RDS. The
#' combination of `Engine` and `EngineVersion` is unique per customer per
#' Amazon Web Services Region.
#' @param Description An optional description of your CEV.
#' @param Status The availability status to be assigned to the CEV. Valid values are as
#' follows:
#' 
#' **available**
#' 
#' You can use this CEV to create a new RDS Custom DB instance.
#' 
#' **inactive**
#' 
#' You can create a new RDS Custom instance by restoring a DB snapshot with
#' this CEV. You can't patch or create new instances with this CEV.
#' 
#' You can change any status to any status. A typical reason to change
#' status is to prevent the accidental use of a CEV, or to make a
#' deprecated CEV eligible for use again. For example, you might change the
#' status of your CEV from `available` to `inactive`, and from `inactive`
#' back to `available`. To change the availability status of the CEV, it
#' must not currently be in use by an RDS Custom instance, snapshot, or
#' automated backup.
#'
#' @keywords internal
#'
#' @rdname rds_modify_custom_db_engine_version
rds_modify_custom_db_engine_version <- function(Engine, EngineVersion, Description = NULL, Status = NULL) {
  op <- new_operation(
    name = "ModifyCustomDBEngineVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$modify_custom_db_engine_version_input(Engine = Engine, EngineVersion = EngineVersion, Description = Description, Status = Status)
  output <- .rds$modify_custom_db_engine_version_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$modify_custom_db_engine_version <- rds_modify_custom_db_engine_version

#' Modifies the settings of an Amazon Aurora DB cluster or a Multi-AZ DB
#' cluster
#'
#' @description
#' Modifies the settings of an Amazon Aurora DB cluster or a Multi-AZ DB cluster. You can change one or more settings by specifying these parameters and the new values in the request.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_modify_db_cluster/](https://www.paws-r-sdk.com/docs/rds_modify_db_cluster/) for full documentation.
#'
#' @param DBClusterIdentifier &#91;required&#93; The DB cluster identifier for the cluster being modified. This parameter
#' isn't case-sensitive.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DB cluster.
#' @param NewDBClusterIdentifier The new DB cluster identifier for the DB cluster when renaming a DB
#' cluster. This value is stored as a lowercase string.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   The first character must be a letter.
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-cluster2`
#' @param ApplyImmediately Specifies whether the modifications in this request and any pending
#' modifications are asynchronously applied as soon as possible, regardless
#' of the `PreferredMaintenanceWindow` setting for the DB cluster. If this
#' parameter is disabled, changes to the DB cluster are applied during the
#' next maintenance window.
#' 
#' Most modifications can be applied immediately or during the next
#' scheduled maintenance window. Some modifications, such as turning on
#' deletion protection and changing the master password, are applied
#' immediately—regardless of when you choose to apply them.
#' 
#' By default, this parameter is disabled.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' @param BackupRetentionPeriod The number of days for which automated backups are retained. Specify a
#' minimum value of `1`.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' 
#' Default: `1`
#' 
#' Constraints:
#' 
#' -   Must be a value from 1 to 35.
#' @param DBClusterParameterGroupName The name of the DB cluster parameter group to use for the DB cluster.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' @param VpcSecurityGroupIds A list of EC2 VPC security groups to associate with this DB cluster.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' @param Port The port number on which the DB cluster accepts connections.
#' 
#' Valid for Cluster Type: Aurora DB clusters only
#' 
#' Valid Values: `1150-65535`
#' 
#' Default: The same port as the original DB cluster.
#' @param MasterUserPassword The new password for the master database user.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' 
#' Constraints:
#' 
#' -   Must contain from 8 to 41 characters.
#' 
#' -   Can contain any printable ASCII character except "/", """, or "@@".
#' 
#' -   Can't be specified if `ManageMasterUserPassword` is turned on.
#' @param OptionGroupName The option group to associate the DB cluster with.
#' 
#' DB clusters are associated with a default option group that can't be
#' modified.
#' @param PreferredBackupWindow The daily time range during which automated backups are created if
#' automated backups are enabled, using the `BackupRetentionPeriod`
#' parameter.
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each Amazon Web Services Region. To view the time
#' blocks available, see [Backup
#' window](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow)
#' in the *Amazon Aurora User Guide*.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' 
#' Constraints:
#' 
#' -   Must be in the format `hh24:mi-hh24:mi`.
#' 
#' -   Must be in Universal Coordinated Time (UTC).
#' 
#' -   Must not conflict with the preferred maintenance window.
#' 
#' -   Must be at least 30 minutes.
#' @param PreferredMaintenanceWindow The weekly time range during which system maintenance can occur, in
#' Universal Coordinated Time (UTC).
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each Amazon Web Services Region, occurring on a random
#' day of the week. To see the time blocks available, see [Adjusting the
#' Preferred DB Cluster Maintenance
#' Window](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora)
#' in the *Amazon Aurora User Guide*.
#' 
#' Constraints:
#' 
#' -   Must be in the format `ddd:hh24:mi-ddd:hh24:mi`.
#' 
#' -   Days must be one of `Mon | Tue | Wed | Thu | Fri | Sat | Sun`.
#' 
#' -   Must be in Universal Coordinated Time (UTC).
#' 
#' -   Must be at least 30 minutes.
#' @param EnableIAMDatabaseAuthentication Specifies whether to enable mapping of Amazon Web Services Identity and
#' Access Management (IAM) accounts to database accounts. By default,
#' mapping isn't enabled.
#' 
#' For more information, see [IAM Database
#' Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html)
#' in the *Amazon Aurora User Guide*.
#' 
#' Valid for Cluster Type: Aurora DB clusters only
#' @param BacktrackWindow The target backtrack window, in seconds. To disable backtracking, set
#' this value to `0`.
#' 
#' Valid for Cluster Type: Aurora MySQL DB clusters only
#' 
#' Default: `0`
#' 
#' Constraints:
#' 
#' -   If specified, this value must be set to a number from 0 to 259,200
#'     (72 hours).
#' @param CloudwatchLogsExportConfiguration The configuration setting for the log types to be enabled for export to
#' CloudWatch Logs for a specific DB cluster.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' 
#' The following values are valid for each DB engine:
#' 
#' -   Aurora MySQL - `audit | error | general | slowquery`
#' 
#' -   Aurora PostgreSQL - `postgresql`
#' 
#' -   RDS for MySQL - `error | general | slowquery`
#' 
#' -   RDS for PostgreSQL - `postgresql | upgrade`
#' 
#' For more information about exporting CloudWatch Logs for Amazon RDS, see
#' [Publishing Database Logs to Amazon CloudWatch
#' Logs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch)
#' in the *Amazon RDS User Guide*.
#' 
#' For more information about exporting CloudWatch Logs for Amazon Aurora,
#' see [Publishing Database Logs to Amazon CloudWatch
#' Logs](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch)
#' in the *Amazon Aurora User Guide*.
#' @param EngineVersion The version number of the database engine to which you want to upgrade.
#' Changing this parameter results in an outage. The change is applied
#' during the next maintenance window unless `ApplyImmediately` is enabled.
#' 
#' If the cluster that you're modifying has one or more read replicas, all
#' replicas must be running an engine version that's the same or later than
#' the version you specify.
#' 
#' To list all of the available engine versions for Aurora MySQL, use the
#' following command:
#' 
#' `aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"`
#' 
#' To list all of the available engine versions for Aurora PostgreSQL, use
#' the following command:
#' 
#' `aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"`
#' 
#' To list all of the available engine versions for RDS for MySQL, use the
#' following command:
#' 
#' `aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"`
#' 
#' To list all of the available engine versions for RDS for PostgreSQL, use
#' the following command:
#' 
#' `aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"`
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' @param AllowMajorVersionUpgrade Specifies whether major version upgrades are allowed.
#' 
#' Valid for Cluster Type: Aurora DB clusters only
#' 
#' Constraints:
#' 
#' -   You must allow major version upgrades when specifying a value for
#'     the `EngineVersion` parameter that is a different major version than
#'     the DB cluster's current version.
#' @param DBInstanceParameterGroupName The name of the DB parameter group to apply to all instances of the DB
#' cluster.
#' 
#' When you apply a parameter group using the
#' `DBInstanceParameterGroupName` parameter, the DB cluster isn't rebooted
#' automatically. Also, parameter changes are applied immediately rather
#' than during the next maintenance window.
#' 
#' Valid for Cluster Type: Aurora DB clusters only
#' 
#' Default: The existing name setting
#' 
#' Constraints:
#' 
#' -   The DB parameter group must be in the same DB parameter group family
#'     as this DB cluster.
#' 
#' -   The `DBInstanceParameterGroupName` parameter is valid in combination
#'     with the `AllowMajorVersionUpgrade` parameter for a major version
#'     upgrade only.
#' @param Domain The Active Directory directory ID to move the DB cluster to. Specify
#' `none` to remove the cluster from its current domain. The domain must be
#' created prior to this operation.
#' 
#' For more information, see [Kerberos
#' Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/database-authentication.html)
#' in the *Amazon Aurora User Guide*.
#' 
#' Valid for Cluster Type: Aurora DB clusters only
#' @param DomainIAMRoleName The name of the IAM role to use when making API calls to the Directory
#' Service.
#' 
#' Valid for Cluster Type: Aurora DB clusters only
#' @param ScalingConfiguration The scaling properties of the DB cluster. You can only modify scaling
#' properties for DB clusters in `serverless` DB engine mode.
#' 
#' Valid for Cluster Type: Aurora DB clusters only
#' @param DeletionProtection Specifies whether the DB cluster has deletion protection enabled. The
#' database can't be deleted when deletion protection is enabled. By
#' default, deletion protection isn't enabled.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' @param EnableHttpEndpoint Specifies whether to enable the HTTP endpoint for an Aurora Serverless
#' v1 DB cluster. By default, the HTTP endpoint is disabled.
#' 
#' When enabled, the HTTP endpoint provides a connectionless web service
#' API for running SQL queries on the Aurora Serverless v1 DB cluster. You
#' can also query your database from inside the RDS console with the query
#' editor.
#' 
#' For more information, see [Using the Data API for Aurora Serverless
#' v1](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html)
#' in the *Amazon Aurora User Guide*.
#' 
#' Valid for Cluster Type: Aurora DB clusters only
#' @param CopyTagsToSnapshot Specifies whether to copy all tags from the DB cluster to snapshots of
#' the DB cluster. The default is not to copy them.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' @param EnableGlobalWriteForwarding Specifies whether to enable this DB cluster to forward write operations
#' to the primary cluster of a global cluster (Aurora global database). By
#' default, write operations are not allowed on Aurora DB clusters that are
#' secondary clusters in an Aurora global database.
#' 
#' You can set this value only on Aurora DB clusters that are members of an
#' Aurora global database. With this parameter enabled, a secondary cluster
#' can forward writes to the current primary cluster, and the resulting
#' changes are replicated back to this cluster. For the primary DB cluster
#' of an Aurora global database, this value is used immediately if the
#' primary is demoted by a global cluster API operation, but it does
#' nothing until then.
#' 
#' Valid for Cluster Type: Aurora DB clusters only
#' @param DBClusterInstanceClass The compute and memory capacity of each DB instance in the Multi-AZ DB
#' cluster, for example `db.m6gd.xlarge`. Not all DB instance classes are
#' available in all Amazon Web Services Regions, or for all database
#' engines.
#' 
#' For the full list of DB instance classes and availability for your
#' engine, see [DB Instance
#' Class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html)
#' in the *Amazon RDS User Guide*.
#' 
#' Valid for Cluster Type: Multi-AZ DB clusters only
#' @param AllocatedStorage The amount of storage in gibibytes (GiB) to allocate to each DB instance
#' in the Multi-AZ DB cluster.
#' 
#' Valid for Cluster Type: Multi-AZ DB clusters only
#' @param StorageType The storage type to associate with the DB cluster.
#' 
#' For information on storage types for Aurora DB clusters, see [Storage
#' configurations for Amazon Aurora DB
#' clusters](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Overview.StorageReliability.html#aurora-storage-type).
#' For information on storage types for Multi-AZ DB clusters, see [Settings
#' for creating Multi-AZ DB
#' clusters](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/create-multi-az-db-cluster.html#create-multi-az-db-cluster-settings).
#' 
#' When specified for a Multi-AZ DB cluster, a value for the `Iops`
#' parameter is required.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' 
#' Valid Values:
#' 
#' -   Aurora DB clusters - `aurora | aurora-iopt1`
#' 
#' -   Multi-AZ DB clusters - `io1`
#' 
#' Default:
#' 
#' -   Aurora DB clusters - `aurora`
#' 
#' -   Multi-AZ DB clusters - `io1`
#' @param Iops The amount of Provisioned IOPS (input/output operations per second) to
#' be initially allocated for each DB instance in the Multi-AZ DB cluster.
#' 
#' For information about valid IOPS values, see [Amazon RDS Provisioned
#' IOPS
#' storage](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS)
#' in the *Amazon RDS User Guide*.
#' 
#' Valid for Cluster Type: Multi-AZ DB clusters only
#' 
#' Constraints:
#' 
#' -   Must be a multiple between .5 and 50 of the storage amount for the
#'     DB cluster.
#' @param AutoMinorVersionUpgrade Specifies whether minor engine upgrades are applied automatically to the
#' DB cluster during the maintenance window. By default, minor engine
#' upgrades are applied automatically.
#' 
#' Valid for Cluster Type: Multi-AZ DB clusters only
#' @param MonitoringInterval The interval, in seconds, between points when Enhanced Monitoring
#' metrics are collected for the DB cluster. To turn off collecting
#' Enhanced Monitoring metrics, specify `0`.
#' 
#' If `MonitoringRoleArn` is specified, also set `MonitoringInterval` to a
#' value other than `0`.
#' 
#' Valid for Cluster Type: Multi-AZ DB clusters only
#' 
#' Valid Values: `0 | 1 | 5 | 10 | 15 | 30 | 60`
#' 
#' Default: `0`
#' @param MonitoringRoleArn The Amazon Resource Name (ARN) for the IAM role that permits RDS to send
#' Enhanced Monitoring metrics to Amazon CloudWatch Logs. An example is
#' `arn:aws:iam:123456789012:role/emaccess`. For information on creating a
#' monitoring role, see [To create an IAM role for Amazon RDS Enhanced
#' Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole)
#' in the *Amazon RDS User Guide.*
#' 
#' If `MonitoringInterval` is set to a value other than `0`, supply a
#' `MonitoringRoleArn` value.
#' 
#' Valid for Cluster Type: Multi-AZ DB clusters only
#' @param EnablePerformanceInsights Specifies whether to turn on Performance Insights for the DB cluster.
#' 
#' For more information, see [Using Amazon Performance
#' Insights](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html)
#' in the *Amazon RDS User Guide*.
#' 
#' Valid for Cluster Type: Multi-AZ DB clusters only
#' @param PerformanceInsightsKMSKeyId The Amazon Web Services KMS key identifier for encryption of Performance
#' Insights data.
#' 
#' The Amazon Web Services KMS key identifier is the key ARN, key ID, alias
#' ARN, or alias name for the KMS key.
#' 
#' If you don't specify a value for `PerformanceInsightsKMSKeyId`, then
#' Amazon RDS uses your default KMS key. There is a default KMS key for
#' your Amazon Web Services account. Your Amazon Web Services account has a
#' different default KMS key for each Amazon Web Services Region.
#' 
#' Valid for Cluster Type: Multi-AZ DB clusters only
#' @param PerformanceInsightsRetentionPeriod The number of days to retain Performance Insights data.
#' 
#' Valid for Cluster Type: Multi-AZ DB clusters only
#' 
#' Valid Values:
#' 
#' -   `7`
#' 
#' -   *month* * 31, where *month* is a number of months from 1-23.
#'     Examples: `93` (3 months * 31), `341` (11 months * 31), `589` (19
#'     months * 31)
#' 
#' -   `731`
#' 
#' Default: `7` days
#' 
#' If you specify a retention period that isn't valid, such as `94`, Amazon
#' RDS issues an error.
#' @param ServerlessV2ScalingConfiguration 
#' @param NetworkType The network type of the DB cluster.
#' 
#' The network type is determined by the `DBSubnetGroup` specified for the
#' DB cluster. A `DBSubnetGroup` can support only the IPv4 protocol or the
#' IPv4 and the IPv6 protocols (`DUAL`).
#' 
#' For more information, see [Working with a DB instance in a
#' VPC](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html)
#' in the *Amazon Aurora User Guide.*
#' 
#' Valid for Cluster Type: Aurora DB clusters only
#' 
#' Valid Values: `IPV4 | DUAL`
#' @param ManageMasterUserPassword Specifies whether to manage the master user password with Amazon Web
#' Services Secrets Manager.
#' 
#' If the DB cluster doesn't manage the master user password with Amazon
#' Web Services Secrets Manager, you can turn on this management. In this
#' case, you can't specify `MasterUserPassword`.
#' 
#' If the DB cluster already manages the master user password with Amazon
#' Web Services Secrets Manager, and you specify that the master user
#' password is not managed with Amazon Web Services Secrets Manager, then
#' you must specify `MasterUserPassword`. In this case, RDS deletes the
#' secret and uses the new password for the master user specified by
#' `MasterUserPassword`.
#' 
#' For more information, see [Password management with Amazon Web Services
#' Secrets
#' Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html)
#' in the *Amazon RDS User Guide* and [Password management with Amazon Web
#' Services Secrets
#' Manager](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html)
#' in the *Amazon Aurora User Guide.*
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' @param RotateMasterUserPassword Specifies whether to rotate the secret managed by Amazon Web Services
#' Secrets Manager for the master user password.
#' 
#' This setting is valid only if the master user password is managed by RDS
#' in Amazon Web Services Secrets Manager for the DB cluster. The secret
#' value contains the updated password.
#' 
#' For more information, see [Password management with Amazon Web Services
#' Secrets
#' Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html)
#' in the *Amazon RDS User Guide* and [Password management with Amazon Web
#' Services Secrets
#' Manager](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html)
#' in the *Amazon Aurora User Guide.*
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' 
#' Constraints:
#' 
#' -   You must apply the change immediately when rotating the master user
#'     password.
#' @param MasterUserSecretKmsKeyId The Amazon Web Services KMS key identifier to encrypt a secret that is
#' automatically generated and managed in Amazon Web Services Secrets
#' Manager.
#' 
#' This setting is valid only if both of the following conditions are met:
#' 
#' -   The DB cluster doesn't manage the master user password in Amazon Web
#'     Services Secrets Manager.
#' 
#'     If the DB cluster already manages the master user password in Amazon
#'     Web Services Secrets Manager, you can't change the KMS key that is
#'     used to encrypt the secret.
#' 
#' -   You are turning on `ManageMasterUserPassword` to manage the master
#'     user password in Amazon Web Services Secrets Manager.
#' 
#'     If you are turning on `ManageMasterUserPassword` and don't specify
#'     `MasterUserSecretKmsKeyId`, then the `aws/secretsmanager` KMS key is
#'     used to encrypt the secret. If the secret is in a different Amazon
#'     Web Services account, then you can't use the `aws/secretsmanager`
#'     KMS key to encrypt the secret, and you must use a customer managed
#'     KMS key.
#' 
#' The Amazon Web Services KMS key identifier is the key ARN, key ID, alias
#' ARN, or alias name for the KMS key. To use a KMS key in a different
#' Amazon Web Services account, specify the key ARN or alias ARN.
#' 
#' There is a default KMS key for your Amazon Web Services account. Your
#' Amazon Web Services account has a different default KMS key for each
#' Amazon Web Services Region.
#' 
#' Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
#' @param EngineMode The DB engine mode of the DB cluster, either `provisioned` or
#' `serverless`.
#' 
#' The DB engine mode can be modified only from `serverless` to
#' `provisioned`.
#' 
#' For more information, see
#' [CreateDBCluster](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html).
#' 
#' Valid for Cluster Type: Aurora DB clusters only
#' @param AllowEngineModeChange Specifies whether engine mode changes from `serverless` to `provisioned`
#' are allowed.
#' 
#' Valid for Cluster Type: Aurora Serverless v1 DB clusters only
#' 
#' Constraints:
#' 
#' -   You must allow engine mode changes when specifying a different value
#'     for the `EngineMode` parameter from the DB cluster's current engine
#'     mode.
#' @param EnableLocalWriteForwarding Specifies whether read replicas can forward write operations to the
#' writer DB instance in the DB cluster. By default, write operations
#' aren't allowed on reader DB instances.
#' 
#' Valid for: Aurora DB clusters only
#'
#' @keywords internal
#'
#' @rdname rds_modify_db_cluster
rds_modify_db_cluster <- function(DBClusterIdentifier, NewDBClusterIdentifier = NULL, ApplyImmediately = NULL, BackupRetentionPeriod = NULL, DBClusterParameterGroupName = NULL, VpcSecurityGroupIds = NULL, Port = NULL, MasterUserPassword = NULL, OptionGroupName = NULL, PreferredBackupWindow = NULL, PreferredMaintenanceWindow = NULL, EnableIAMDatabaseAuthentication = NULL, BacktrackWindow = NULL, CloudwatchLogsExportConfiguration = NULL, EngineVersion = NULL, AllowMajorVersionUpgrade = NULL, DBInstanceParameterGroupName = NULL, Domain = NULL, DomainIAMRoleName = NULL, ScalingConfiguration = NULL, DeletionProtection = NULL, EnableHttpEndpoint = NULL, CopyTagsToSnapshot = NULL, EnableGlobalWriteForwarding = NULL, DBClusterInstanceClass = NULL, AllocatedStorage = NULL, StorageType = NULL, Iops = NULL, AutoMinorVersionUpgrade = NULL, MonitoringInterval = NULL, MonitoringRoleArn = NULL, EnablePerformanceInsights = NULL, PerformanceInsightsKMSKeyId = NULL, PerformanceInsightsRetentionPeriod = NULL, ServerlessV2ScalingConfiguration = NULL, NetworkType = NULL, ManageMasterUserPassword = NULL, RotateMasterUserPassword = NULL, MasterUserSecretKmsKeyId = NULL, EngineMode = NULL, AllowEngineModeChange = NULL, EnableLocalWriteForwarding = NULL) {
  op <- new_operation(
    name = "ModifyDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$modify_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier, NewDBClusterIdentifier = NewDBClusterIdentifier, ApplyImmediately = ApplyImmediately, BackupRetentionPeriod = BackupRetentionPeriod, DBClusterParameterGroupName = DBClusterParameterGroupName, VpcSecurityGroupIds = VpcSecurityGroupIds, Port = Port, MasterUserPassword = MasterUserPassword, OptionGroupName = OptionGroupName, PreferredBackupWindow = PreferredBackupWindow, PreferredMaintenanceWindow = PreferredMaintenanceWindow, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, BacktrackWindow = BacktrackWindow, CloudwatchLogsExportConfiguration = CloudwatchLogsExportConfiguration, EngineVersion = EngineVersion, AllowMajorVersionUpgrade = AllowMajorVersionUpgrade, DBInstanceParameterGroupName = DBInstanceParameterGroupName, Domain = Domain, DomainIAMRoleName = DomainIAMRoleName, ScalingConfiguration = ScalingConfiguration, DeletionProtection = DeletionProtection, EnableHttpEndpoint = EnableHttpEndpoint, CopyTagsToSnapshot = CopyTagsToSnapshot, EnableGlobalWriteForwarding = EnableGlobalWriteForwarding, DBClusterInstanceClass = DBClusterInstanceClass, AllocatedStorage = AllocatedStorage, StorageType = StorageType, Iops = Iops, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, MonitoringInterval = MonitoringInterval, MonitoringRoleArn = MonitoringRoleArn, EnablePerformanceInsights = EnablePerformanceInsights, PerformanceInsightsKMSKeyId = PerformanceInsightsKMSKeyId, PerformanceInsightsRetentionPeriod = PerformanceInsightsRetentionPeriod, ServerlessV2ScalingConfiguration = ServerlessV2ScalingConfiguration, NetworkType = NetworkType, ManageMasterUserPassword = ManageMasterUserPassword, RotateMasterUserPassword = RotateMasterUserPassword, MasterUserSecretKmsKeyId = MasterUserSecretKmsKeyId, EngineMode = EngineMode, AllowEngineModeChange = AllowEngineModeChange, EnableLocalWriteForwarding = EnableLocalWriteForwarding)
  output <- .rds$modify_db_cluster_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$modify_db_cluster <- rds_modify_db_cluster

#' Modifies the properties of an endpoint in an Amazon Aurora DB cluster
#'
#' @description
#' Modifies the properties of an endpoint in an Amazon Aurora DB cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_modify_db_cluster_endpoint/](https://www.paws-r-sdk.com/docs/rds_modify_db_cluster_endpoint/) for full documentation.
#'
#' @param DBClusterEndpointIdentifier &#91;required&#93; The identifier of the endpoint to modify. This parameter is stored as a
#' lowercase string.
#' @param EndpointType The type of the endpoint. One of: `READER`, `WRITER`, `ANY`.
#' @param StaticMembers List of DB instance identifiers that are part of the custom endpoint
#' group.
#' @param ExcludedMembers List of DB instance identifiers that aren't part of the custom endpoint
#' group. All other eligible instances are reachable through the custom
#' endpoint. Only relevant if the list of static members is empty.
#'
#' @keywords internal
#'
#' @rdname rds_modify_db_cluster_endpoint
rds_modify_db_cluster_endpoint <- function(DBClusterEndpointIdentifier, EndpointType = NULL, StaticMembers = NULL, ExcludedMembers = NULL) {
  op <- new_operation(
    name = "ModifyDBClusterEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$modify_db_cluster_endpoint_input(DBClusterEndpointIdentifier = DBClusterEndpointIdentifier, EndpointType = EndpointType, StaticMembers = StaticMembers, ExcludedMembers = ExcludedMembers)
  output <- .rds$modify_db_cluster_endpoint_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$modify_db_cluster_endpoint <- rds_modify_db_cluster_endpoint

#' Modifies the parameters of a DB cluster parameter group
#'
#' @description
#' Modifies the parameters of a DB cluster parameter group. To modify more than one parameter, submit a list of the following: `ParameterName`, `ParameterValue`, and `ApplyMethod`. A maximum of 20 parameters can be modified in a single request.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_modify_db_cluster_parameter_group/](https://www.paws-r-sdk.com/docs/rds_modify_db_cluster_parameter_group/) for full documentation.
#'
#' @param DBClusterParameterGroupName &#91;required&#93; The name of the DB cluster parameter group to modify.
#' @param Parameters &#91;required&#93; A list of parameters in the DB cluster parameter group to modify.
#' 
#' Valid Values (for the application method): `immediate | pending-reboot`
#' 
#' You can use the `immediate` value with dynamic parameters only. You can
#' use the `pending-reboot` value for both dynamic and static parameters.
#' 
#' When the application method is `immediate`, changes to dynamic
#' parameters are applied immediately to the DB clusters associated with
#' the parameter group. When the application method is `pending-reboot`,
#' changes to dynamic and static parameters are applied after a reboot
#' without failover to the DB clusters associated with the parameter group.
#'
#' @keywords internal
#'
#' @rdname rds_modify_db_cluster_parameter_group
rds_modify_db_cluster_parameter_group <- function(DBClusterParameterGroupName, Parameters) {
  op <- new_operation(
    name = "ModifyDBClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$modify_db_cluster_parameter_group_input(DBClusterParameterGroupName = DBClusterParameterGroupName, Parameters = Parameters)
  output <- .rds$modify_db_cluster_parameter_group_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$modify_db_cluster_parameter_group <- rds_modify_db_cluster_parameter_group

#' Adds an attribute and values to, or removes an attribute and values
#' from, a manual DB cluster snapshot
#'
#' @description
#' Adds an attribute and values to, or removes an attribute and values from, a manual DB cluster snapshot.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_modify_db_cluster_snapshot_attribute/](https://www.paws-r-sdk.com/docs/rds_modify_db_cluster_snapshot_attribute/) for full documentation.
#'
#' @param DBClusterSnapshotIdentifier &#91;required&#93; The identifier for the DB cluster snapshot to modify the attributes for.
#' @param AttributeName &#91;required&#93; The name of the DB cluster snapshot attribute to modify.
#' 
#' To manage authorization for other Amazon Web Services accounts to copy
#' or restore a manual DB cluster snapshot, set this value to `restore`.
#' 
#' To view the list of attributes available to modify, use the
#' [`describe_db_cluster_snapshot_attributes`][rds_describe_db_cluster_snapshot_attributes]
#' API operation.
#' @param ValuesToAdd A list of DB cluster snapshot attributes to add to the attribute
#' specified by `AttributeName`.
#' 
#' To authorize other Amazon Web Services accounts to copy or restore a
#' manual DB cluster snapshot, set this list to include one or more Amazon
#' Web Services account IDs, or `all` to make the manual DB cluster
#' snapshot restorable by any Amazon Web Services account. Do not add the
#' `all` value for any manual DB cluster snapshots that contain private
#' information that you don't want available to all Amazon Web Services
#' accounts.
#' @param ValuesToRemove A list of DB cluster snapshot attributes to remove from the attribute
#' specified by `AttributeName`.
#' 
#' To remove authorization for other Amazon Web Services accounts to copy
#' or restore a manual DB cluster snapshot, set this list to include one or
#' more Amazon Web Services account identifiers, or `all` to remove
#' authorization for any Amazon Web Services account to copy or restore the
#' DB cluster snapshot. If you specify `all`, an Amazon Web Services
#' account whose account ID is explicitly added to the `restore` attribute
#' can still copy or restore a manual DB cluster snapshot.
#'
#' @keywords internal
#'
#' @rdname rds_modify_db_cluster_snapshot_attribute
rds_modify_db_cluster_snapshot_attribute <- function(DBClusterSnapshotIdentifier, AttributeName, ValuesToAdd = NULL, ValuesToRemove = NULL) {
  op <- new_operation(
    name = "ModifyDBClusterSnapshotAttribute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$modify_db_cluster_snapshot_attribute_input(DBClusterSnapshotIdentifier = DBClusterSnapshotIdentifier, AttributeName = AttributeName, ValuesToAdd = ValuesToAdd, ValuesToRemove = ValuesToRemove)
  output <- .rds$modify_db_cluster_snapshot_attribute_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$modify_db_cluster_snapshot_attribute <- rds_modify_db_cluster_snapshot_attribute

#' Modifies settings for a DB instance
#'
#' @description
#' Modifies settings for a DB instance. You can change one or more database configuration parameters by specifying these parameters and the new values in the request. To learn what modifications you can make to your DB instance, call [`describe_valid_db_instance_modifications`][rds_describe_valid_db_instance_modifications] before you call [`modify_db_instance`][rds_modify_db_instance].
#'
#' See [https://www.paws-r-sdk.com/docs/rds_modify_db_instance/](https://www.paws-r-sdk.com/docs/rds_modify_db_instance/) for full documentation.
#'
#' @param DBInstanceIdentifier &#91;required&#93; The identifier of DB instance to modify. This value is stored as a
#' lowercase string.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DB instance.
#' @param AllocatedStorage The new amount of storage in gibibytes (GiB) to allocate for the DB
#' instance.
#' 
#' For RDS for MariaDB, RDS for MySQL, RDS for Oracle, and RDS for
#' PostgreSQL, the value supplied must be at least 10% greater than the
#' current value. Values that are not at least 10% greater than the
#' existing value are rounded up so that they are 10% greater than the
#' current value.
#' 
#' For the valid values for allocated storage for each engine, see
#' [`create_db_instance`][rds_create_db_instance].
#' @param DBInstanceClass The new compute and memory capacity of the DB instance, for example
#' `db.m4.large`. Not all DB instance classes are available in all Amazon
#' Web Services Regions, or for all database engines. For the full list of
#' DB instance classes, and availability for your engine, see [DB Instance
#' Class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html)
#' in the *Amazon RDS User Guide* or [Aurora DB instance
#' classes](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.DBInstanceClass.html)
#' in the *Amazon Aurora User Guide*. For RDS Custom, see [DB instance
#' class support for RDS Custom for
#' Oracle](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-reqs-limits.html#custom-reqs-limits.instances)
#' and [DB instance class support for RDS Custom for SQL
#' Server](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-reqs-limits-MS.html#custom-reqs-limits.instancesMS).
#' 
#' If you modify the DB instance class, an outage occurs during the change.
#' The change is applied during the next maintenance window, unless you
#' specify `ApplyImmediately` in your request.
#' 
#' Default: Uses existing setting
#' @param DBSubnetGroupName The new DB subnet group for the DB instance. You can use this parameter
#' to move your DB instance to a different VPC. If your DB instance isn't
#' in a VPC, you can also use this parameter to move your DB instance into
#' a VPC. For more information, see [Working with a DB instance in a
#' VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html#USER_VPC.Non-VPC2VPC)
#' in the *Amazon RDS User Guide*.
#' 
#' Changing the subnet group causes an outage during the change. The change
#' is applied during the next maintenance window, unless you enable
#' `ApplyImmediately`.
#' 
#' This parameter doesn't apply to RDS Custom DB instances.
#' 
#' Constraints:
#' 
#' -   If supplied, must match existing DB subnet group.
#' 
#' Example: `mydbsubnetgroup`
#' @param DBSecurityGroups A list of DB security groups to authorize on this DB instance. Changing
#' this setting doesn't result in an outage and the change is
#' asynchronously applied as soon as possible.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' 
#' Constraints:
#' 
#' -   If supplied, must match existing DB security groups.
#' @param VpcSecurityGroupIds A list of Amazon EC2 VPC security groups to associate with this DB
#' instance. This change is asynchronously applied as soon as possible.
#' 
#' This setting doesn't apply to the following DB instances:
#' 
#' -   Amazon Aurora (The associated list of EC2 VPC security groups is
#'     managed by the DB cluster. For more information, see
#'     [`modify_db_cluster`][rds_modify_db_cluster].)
#' 
#' -   RDS Custom
#' 
#' Constraints:
#' 
#' -   If supplied, must match existing VPC security group IDs.
#' @param ApplyImmediately Specifies whether the modifications in this request and any pending
#' modifications are asynchronously applied as soon as possible, regardless
#' of the `PreferredMaintenanceWindow` setting for the DB instance. By
#' default, this parameter is disabled.
#' 
#' If this parameter is disabled, changes to the DB instance are applied
#' during the next maintenance window. Some parameter changes can cause an
#' outage and are applied on the next call to
#' [`reboot_db_instance`][rds_reboot_db_instance], or the next failure
#' reboot. Review the table of parameters in [Modifying a DB
#' Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html)
#' in the *Amazon RDS User Guide* to see the impact of enabling or
#' disabling `ApplyImmediately` for each modified parameter and to
#' determine when the changes are applied.
#' @param MasterUserPassword The new password for the master user.
#' 
#' Changing this parameter doesn't result in an outage and the change is
#' asynchronously applied as soon as possible. Between the time of the
#' request and the completion of the request, the `MasterUserPassword`
#' element exists in the `PendingModifiedValues` element of the operation
#' response.
#' 
#' Amazon RDS API operations never return the password, so this action
#' provides a way to regain access to a primary instance user if the
#' password is lost. This includes restoring privileges that might have
#' been accidentally revoked.
#' 
#' This setting doesn't apply to the following DB instances:
#' 
#' -   Amazon Aurora (The password for the master user is managed by the DB
#'     cluster. For more information, see
#'     [`modify_db_cluster`][rds_modify_db_cluster].)
#' 
#' -   RDS Custom
#' 
#' Default: Uses existing setting
#' 
#' Constraints:
#' 
#' -   Can't be specified if `ManageMasterUserPassword` is turned on.
#' 
#' -   Can include any printable ASCII character except "/", """, or "@@".
#' 
#' Length Constraints:
#' 
#' -   RDS for MariaDB - Must contain from 8 to 41 characters.
#' 
#' -   RDS for Microsoft SQL Server - Must contain from 8 to 128
#'     characters.
#' 
#' -   RDS for MySQL - Must contain from 8 to 41 characters.
#' 
#' -   RDS for Oracle - Must contain from 8 to 30 characters.
#' 
#' -   RDS for PostgreSQL - Must contain from 8 to 128 characters.
#' @param DBParameterGroupName The name of the DB parameter group to apply to the DB instance.
#' 
#' Changing this setting doesn't result in an outage. The parameter group
#' name itself is changed immediately, but the actual parameter changes are
#' not applied until you reboot the instance without failover. In this
#' case, the DB instance isn't rebooted automatically, and the parameter
#' changes aren't applied during the next maintenance window. However, if
#' you modify dynamic parameters in the newly associated DB parameter
#' group, these changes are applied immediately without a reboot.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' 
#' Default: Uses existing setting
#' 
#' Constraints:
#' 
#' -   Must be in the same DB parameter group family as the DB instance.
#' @param BackupRetentionPeriod The number of days to retain automated backups. Setting this parameter
#' to a positive number enables backups. Setting this parameter to 0
#' disables automated backups.
#' 
#' Enabling and disabling backups can result in a brief I/O suspension that
#' lasts from a few seconds to a few minutes, depending on the size and
#' class of your DB instance.
#' 
#' These changes are applied during the next maintenance window unless the
#' `ApplyImmediately` parameter is enabled for this request. If you change
#' the parameter from one non-zero value to another non-zero value, the
#' change is asynchronously applied as soon as possible.
#' 
#' This setting doesn't apply to Amazon Aurora DB instances. The retention
#' period for automated backups is managed by the DB cluster. For more
#' information, see [`modify_db_cluster`][rds_modify_db_cluster].
#' 
#' Default: Uses existing setting
#' 
#' Constraints:
#' 
#' -   Must be a value from 0 to 35.
#' 
#' -   Can't be set to 0 if the DB instance is a source to read replicas.
#' 
#' -   Can't be set to 0 for an RDS Custom for Oracle DB instance.
#' @param PreferredBackupWindow The daily time range during which automated backups are created if
#' automated backups are enabled, as determined by the
#' `BackupRetentionPeriod` parameter. Changing this parameter doesn't
#' result in an outage and the change is asynchronously applied as soon as
#' possible. The default is a 30-minute window selected at random from an
#' 8-hour block of time for each Amazon Web Services Region. For more
#' information, see [Backup
#' window](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow)
#' in the *Amazon RDS User Guide*.
#' 
#' This setting doesn't apply to Amazon Aurora DB instances. The daily time
#' range for creating automated backups is managed by the DB cluster. For
#' more information, see [`modify_db_cluster`][rds_modify_db_cluster].
#' 
#' Constraints:
#' 
#' -   Must be in the format `hh24:mi-hh24:mi`.
#' 
#' -   Must be in Universal Coordinated Time (UTC).
#' 
#' -   Must not conflict with the preferred maintenance window.
#' 
#' -   Must be at least 30 minutes.
#' @param PreferredMaintenanceWindow The weekly time range during which system maintenance can occur, which
#' might result in an outage. Changing this parameter doesn't result in an
#' outage, except in the following situation, and the change is
#' asynchronously applied as soon as possible. If there are pending actions
#' that cause a reboot, and the maintenance window is changed to include
#' the current time, then changing this parameter causes a reboot of the DB
#' instance. If you change this window to the current time, there must be
#' at least 30 minutes between the current time and end of the window to
#' ensure pending changes are applied.
#' 
#' For more information, see [Amazon RDS Maintenance
#' Window](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance)
#' in the *Amazon RDS User Guide.*
#' 
#' Default: Uses existing setting
#' 
#' Constraints:
#' 
#' -   Must be in the format `ddd:hh24:mi-ddd:hh24:mi`.
#' 
#' -   The day values must be `mon | tue | wed | thu | fri | sat | sun`.
#' 
#' -   Must be in Universal Coordinated Time (UTC).
#' 
#' -   Must not conflict with the preferred backup window.
#' 
#' -   Must be at least 30 minutes.
#' @param MultiAZ Specifies whether the DB instance is a Multi-AZ deployment. Changing
#' this parameter doesn't result in an outage. The change is applied during
#' the next maintenance window unless the `ApplyImmediately` parameter is
#' enabled for this request.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' @param EngineVersion The version number of the database engine to upgrade to. Changing this
#' parameter results in an outage and the change is applied during the next
#' maintenance window unless the `ApplyImmediately` parameter is enabled
#' for this request.
#' 
#' For major version upgrades, if a nondefault DB parameter group is
#' currently in use, a new DB parameter group in the DB parameter group
#' family for the new engine version must be specified. The new DB
#' parameter group can be the default for that DB parameter group family.
#' 
#' If you specify only a major version, Amazon RDS updates the DB instance
#' to the default minor version if the current minor version is lower. For
#' information about valid engine versions, see
#' [`create_db_instance`][rds_create_db_instance], or call
#' [`describe_db_engine_versions`][rds_describe_db_engine_versions].
#' 
#' If the instance that you're modifying is acting as a read replica, the
#' engine version that you specify must be the same or higher than the
#' version that the source DB instance or cluster is running.
#' 
#' In RDS Custom for Oracle, this parameter is supported for read replicas
#' only if they are in the `PATCH_DB_FAILURE` lifecycle.
#' @param AllowMajorVersionUpgrade Specifies whether major version upgrades are allowed. Changing this
#' parameter doesn't result in an outage and the change is asynchronously
#' applied as soon as possible.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' 
#' Constraints:
#' 
#' -   Major version upgrades must be allowed when specifying a value for
#'     the `EngineVersion` parameter that's a different major version than
#'     the DB instance's current version.
#' @param AutoMinorVersionUpgrade Specifies whether minor version upgrades are applied automatically to
#' the DB instance during the maintenance window. An outage occurs when all
#' the following conditions are met:
#' 
#' -   The automatic upgrade is enabled for the maintenance window.
#' 
#' -   A newer minor version is available.
#' 
#' -   RDS has enabled automatic patching for the engine version.
#' 
#' If any of the preceding conditions isn't met, Amazon RDS applies the
#' change as soon as possible and doesn't cause an outage.
#' 
#' For an RDS Custom DB instance, don't enable this setting. Otherwise, the
#' operation returns an error.
#' @param LicenseModel The license model for the DB instance.
#' 
#' This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
#' 
#' Valid Values:
#' 
#' -   RDS for MariaDB - `general-public-license`
#' 
#' -   RDS for Microsoft SQL Server - `license-included`
#' 
#' -   RDS for MySQL - `general-public-license`
#' 
#' -   RDS for Oracle - `bring-your-own-license | license-included`
#' 
#' -   RDS for PostgreSQL - `postgresql-license`
#' @param Iops The new Provisioned IOPS (I/O operations per second) value for the RDS
#' instance.
#' 
#' Changing this setting doesn't result in an outage and the change is
#' applied during the next maintenance window unless the `ApplyImmediately`
#' parameter is enabled for this request. If you are migrating from
#' Provisioned IOPS to standard storage, set this value to 0. The DB
#' instance will require a reboot for the change in storage type to take
#' effect.
#' 
#' If you choose to migrate your DB instance from using standard storage to
#' using Provisioned IOPS, or from using Provisioned IOPS to using standard
#' storage, the process can take time. The duration of the migration
#' depends on several factors such as database load, storage size, storage
#' type (standard or Provisioned IOPS), amount of IOPS provisioned (if
#' any), and the number of prior scale storage operations. Typical
#' migration times are under 24 hours, but the process can take up to
#' several days in some cases. During the migration, the DB instance is
#' available for use, but might experience performance degradation. While
#' the migration takes place, nightly backups for the instance are
#' suspended. No other Amazon RDS operations can take place for the
#' instance, including modifying the instance, rebooting the instance,
#' deleting the instance, creating a read replica for the instance, and
#' creating a DB snapshot of the instance.
#' 
#' Constraints:
#' 
#' -   For RDS for MariaDB, RDS for MySQL, RDS for Oracle, and RDS for
#'     PostgreSQL - The value supplied must be at least 10% greater than
#'     the current value. Values that are not at least 10% greater than the
#'     existing value are rounded up so that they are 10% greater than the
#'     current value.
#' 
#' Default: Uses existing setting
#' @param OptionGroupName The option group to associate the DB instance with.
#' 
#' Changing this parameter doesn't result in an outage, with one exception.
#' If the parameter change results in an option group that enables OEM, it
#' can cause a brief period, lasting less than a second, during which new
#' connections are rejected but existing connections aren't interrupted.
#' 
#' The change is applied during the next maintenance window unless the
#' `ApplyImmediately` parameter is enabled for this request.
#' 
#' Permanent options, such as the TDE option for Oracle Advanced Security
#' TDE, can't be removed from an option group, and that option group can't
#' be removed from a DB instance after it is associated with a DB instance.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' @param NewDBInstanceIdentifier The new identifier for the DB instance when renaming a DB instance. When
#' you change the DB instance identifier, an instance reboot occurs
#' immediately if you enable `ApplyImmediately`, or will occur during the
#' next maintenance window if you disable `ApplyImmediately`. This value is
#' stored as a lowercase string.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   The first character must be a letter.
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `mydbinstance`
#' @param StorageType The storage type to associate with the DB instance.
#' 
#' If you specify Provisioned IOPS (`io1`), you must also include a value
#' for the `Iops` parameter.
#' 
#' If you choose to migrate your DB instance from using standard storage to
#' using Provisioned IOPS, or from using Provisioned IOPS to using standard
#' storage, the process can take time. The duration of the migration
#' depends on several factors such as database load, storage size, storage
#' type (standard or Provisioned IOPS), amount of IOPS provisioned (if
#' any), and the number of prior scale storage operations. Typical
#' migration times are under 24 hours, but the process can take up to
#' several days in some cases. During the migration, the DB instance is
#' available for use, but might experience performance degradation. While
#' the migration takes place, nightly backups for the instance are
#' suspended. No other Amazon RDS operations can take place for the
#' instance, including modifying the instance, rebooting the instance,
#' deleting the instance, creating a read replica for the instance, and
#' creating a DB snapshot of the instance.
#' 
#' Valid Values: `gp2 | gp3 | io1 | standard`
#' 
#' Default: `io1`, if the `Iops` parameter is specified. Otherwise, `gp2`.
#' @param TdeCredentialArn The ARN from the key store with which to associate the instance for TDE
#' encryption.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' @param TdeCredentialPassword The password for the given ARN from the key store in order to access the
#' device.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' @param CACertificateIdentifier The CA certificate identifier to use for the DB instance's server
#' certificate.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' 
#' For more information, see [Using SSL/TLS to encrypt a connection to a DB
#' instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html)
#' in the *Amazon RDS User Guide* and [Using SSL/TLS to encrypt a
#' connection to a DB
#' cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html)
#' in the *Amazon Aurora User Guide*.
#' @param Domain The Active Directory directory ID to move the DB instance to. Specify
#' `none` to remove the instance from its current domain. You must create
#' the domain before this operation. Currently, you can create only MySQL,
#' Microsoft SQL Server, Oracle, and PostgreSQL DB instances in an Active
#' Directory Domain.
#' 
#' For more information, see [Kerberos
#' Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/database-authentication.html)
#' in the *Amazon RDS User Guide*.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' @param DomainFqdn The fully qualified domain name (FQDN) of an Active Directory domain.
#' 
#' Constraints:
#' 
#' -   Can't be longer than 64 characters.
#' 
#' Example: `mymanagedADtest.mymanagedAD.mydomain`
#' @param DomainOu The Active Directory organizational unit for your DB instance to join.
#' 
#' Constraints:
#' 
#' -   Must be in the distinguished name format.
#' 
#' -   Can't be longer than 64 characters.
#' 
#' Example:
#' `OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain`
#' @param DomainAuthSecretArn The ARN for the Secrets Manager secret with the credentials for the user
#' joining the domain.
#' 
#' Example:
#' `arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456`
#' @param DomainDnsIps The IPv4 DNS IP addresses of your primary and secondary Active Directory
#' domain controllers.
#' 
#' Constraints:
#' 
#' -   Two IP addresses must be provided. If there isn't a secondary domain
#'     controller, use the IP address of the primary domain controller for
#'     both entries in the list.
#' 
#' Example: `123.124.125.126,234.235.236.237`
#' @param CopyTagsToSnapshot Specifies whether to copy all tags from the DB instance to snapshots of
#' the DB instance. By default, tags aren't copied.
#' 
#' This setting doesn't apply to Amazon Aurora DB instances. Copying tags
#' to snapshots is managed by the DB cluster. Setting this value for an
#' Aurora DB instance has no effect on the DB cluster setting. For more
#' information, see [`modify_db_cluster`][rds_modify_db_cluster].
#' @param MonitoringInterval The interval, in seconds, between points when Enhanced Monitoring
#' metrics are collected for the DB instance. To disable collection of
#' Enhanced Monitoring metrics, specify `0`.
#' 
#' If `MonitoringRoleArn` is specified, set `MonitoringInterval` to a value
#' other than `0`.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' 
#' Valid Values: `0 | 1 | 5 | 10 | 15 | 30 | 60`
#' 
#' Default: `0`
#' @param DBPortNumber The port number on which the database accepts connections.
#' 
#' The value of the `DBPortNumber` parameter must not match any of the port
#' values specified for options in the option group for the DB instance.
#' 
#' If you change the `DBPortNumber` value, your database restarts
#' regardless of the value of the `ApplyImmediately` parameter.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' 
#' Valid Values: `1150-65535`
#' 
#' Default:
#' 
#' -   Amazon Aurora - `3306`
#' 
#' -   RDS for MariaDB - `3306`
#' 
#' -   RDS for Microsoft SQL Server - `1433`
#' 
#' -   RDS for MySQL - `3306`
#' 
#' -   RDS for Oracle - `1521`
#' 
#' -   RDS for PostgreSQL - `5432`
#' 
#' Constraints:
#' 
#' -   For RDS for Microsoft SQL Server, the value can't be `1234`, `1434`,
#'     `3260`, `3343`, `3389`, `47001`, or `49152-49156`.
#' @param PubliclyAccessible Specifies whether the DB instance is publicly accessible.
#' 
#' When the DB cluster is publicly accessible, its Domain Name System (DNS)
#' endpoint resolves to the private IP address from within the DB cluster's
#' virtual private cloud (VPC). It resolves to the public IP address from
#' outside of the DB cluster's VPC. Access to the DB cluster is ultimately
#' controlled by the security group it uses. That public access isn't
#' permitted if the security group assigned to the DB cluster doesn't
#' permit it.
#' 
#' When the DB instance isn't publicly accessible, it is an internal DB
#' instance with a DNS name that resolves to a private IP address.
#' 
#' `PubliclyAccessible` only applies to DB instances in a VPC. The DB
#' instance must be part of a public subnet and `PubliclyAccessible` must
#' be enabled for it to be publicly accessible.
#' 
#' Changes to the `PubliclyAccessible` parameter are applied immediately
#' regardless of the value of the `ApplyImmediately` parameter.
#' @param MonitoringRoleArn The ARN for the IAM role that permits RDS to send enhanced monitoring
#' metrics to Amazon CloudWatch Logs. For example,
#' `arn:aws:iam:123456789012:role/emaccess`. For information on creating a
#' monitoring role, see [To create an IAM role for Amazon RDS Enhanced
#' Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole)
#' in the *Amazon RDS User Guide.*
#' 
#' If `MonitoringInterval` is set to a value other than `0`, supply a
#' `MonitoringRoleArn` value.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' @param DomainIAMRoleName The name of the IAM role to use when making API calls to the Directory
#' Service.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' @param DisableDomain Specifies whether to remove the DB instance from the Active Directory
#' domain.
#' @param PromotionTier The order of priority in which an Aurora Replica is promoted to the
#' primary instance after a failure of the existing primary instance. For
#' more information, see [Fault Tolerance for an Aurora DB
#' Cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.AuroraHighAvailability.html#Aurora.Managing.FaultTolerance)
#' in the *Amazon Aurora User Guide*.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' 
#' Default: `1`
#' 
#' Valid Values: `0 - 15`
#' @param EnableIAMDatabaseAuthentication Specifies whether to enable mapping of Amazon Web Services Identity and
#' Access Management (IAM) accounts to database accounts. By default,
#' mapping isn't enabled.
#' 
#' This setting doesn't apply to Amazon Aurora. Mapping Amazon Web Services
#' IAM accounts to database accounts is managed by the DB cluster.
#' 
#' For more information about IAM database authentication, see [IAM
#' Database Authentication for MySQL and
#' PostgreSQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html)
#' in the *Amazon RDS User Guide.*
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' @param EnablePerformanceInsights Specifies whether to enable Performance Insights for the DB instance.
#' 
#' For more information, see [Using Amazon Performance
#' Insights](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html)
#' in the *Amazon RDS User Guide*.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' @param PerformanceInsightsKMSKeyId The Amazon Web Services KMS key identifier for encryption of Performance
#' Insights data.
#' 
#' The Amazon Web Services KMS key identifier is the key ARN, key ID, alias
#' ARN, or alias name for the KMS key.
#' 
#' If you don't specify a value for `PerformanceInsightsKMSKeyId`, then
#' Amazon RDS uses your default KMS key. There is a default KMS key for
#' your Amazon Web Services account. Your Amazon Web Services account has a
#' different default KMS key for each Amazon Web Services Region.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' @param PerformanceInsightsRetentionPeriod The number of days to retain Performance Insights data.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' 
#' Valid Values:
#' 
#' -   `7`
#' 
#' -   *month* * 31, where *month* is a number of months from 1-23.
#'     Examples: `93` (3 months * 31), `341` (11 months * 31), `589` (19
#'     months * 31)
#' 
#' -   `731`
#' 
#' Default: `7` days
#' 
#' If you specify a retention period that isn't valid, such as `94`, Amazon
#' RDS returns an error.
#' @param CloudwatchLogsExportConfiguration The log types to be enabled for export to CloudWatch Logs for a specific
#' DB instance.
#' 
#' A change to the `CloudwatchLogsExportConfiguration` parameter is always
#' applied to the DB instance immediately. Therefore, the
#' `ApplyImmediately` parameter has no effect.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' @param ProcessorFeatures The number of CPU cores and the number of threads per core for the DB
#' instance class of the DB instance.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' @param UseDefaultProcessorFeatures Specifies whether the DB instance class of the DB instance uses its
#' default processor features.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' @param DeletionProtection Specifies whether the DB instance has deletion protection enabled. The
#' database can't be deleted when deletion protection is enabled. By
#' default, deletion protection isn't enabled. For more information, see
#' [Deleting a DB
#' Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html).
#' @param MaxAllocatedStorage The upper limit in gibibytes (GiB) to which Amazon RDS can automatically
#' scale the storage of the DB instance.
#' 
#' For more information about this setting, including limitations that
#' apply to it, see [Managing capacity automatically with Amazon RDS
#' storage
#' autoscaling](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling)
#' in the *Amazon RDS User Guide*.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' @param CertificateRotationRestart Specifies whether the DB instance is restarted when you rotate your
#' SSL/TLS certificate.
#' 
#' By default, the DB instance is restarted when you rotate your SSL/TLS
#' certificate. The certificate is not updated until the DB instance is
#' restarted.
#' 
#' Set this parameter only if you are *not* using SSL/TLS to connect to the
#' DB instance.
#' 
#' If you are using SSL/TLS to connect to the DB instance, follow the
#' appropriate instructions for your DB engine to rotate your SSL/TLS
#' certificate:
#' 
#' -   For more information about rotating your SSL/TLS certificate for RDS
#'     DB engines, see [Rotating Your SSL/TLS
#'     Certificate.](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html)
#'     in the *Amazon RDS User Guide.*
#' 
#' -   For more information about rotating your SSL/TLS certificate for
#'     Aurora DB engines, see [Rotating Your SSL/TLS
#'     Certificate](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html)
#'     in the *Amazon Aurora User Guide*.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' @param ReplicaMode A value that sets the open mode of a replica database to either mounted
#' or read-only.
#' 
#' Currently, this parameter is only supported for Oracle DB instances.
#' 
#' Mounted DB replicas are included in Oracle Enterprise Edition. The main
#' use case for mounted replicas is cross-Region disaster recovery. The
#' primary database doesn't use Active Data Guard to transmit information
#' to the mounted replica. Because it doesn't accept user connections, a
#' mounted replica can't serve a read-only workload. For more information,
#' see [Working with Oracle Read Replicas for Amazon
#' RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html)
#' in the *Amazon RDS User Guide*.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' @param EnableCustomerOwnedIp Specifies whether to enable a customer-owned IP address (CoIP) for an
#' RDS on Outposts DB instance.
#' 
#' A *CoIP* provides local or external connectivity to resources in your
#' Outpost subnets through your on-premises network. For some use cases, a
#' CoIP can provide lower latency for connections to the DB instance from
#' outside of its virtual private cloud (VPC) on your local network.
#' 
#' For more information about RDS on Outposts, see [Working with Amazon RDS
#' on Amazon Web Services
#' Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html)
#' in the *Amazon RDS User Guide*.
#' 
#' For more information about CoIPs, see [Customer-owned IP
#' addresses](https://docs.aws.amazon.com/outposts/latest/userguide/routing.html#ip-addressing)
#' in the *Amazon Web Services Outposts User Guide*.
#' @param AwsBackupRecoveryPointArn The Amazon Resource Name (ARN) of the recovery point in Amazon Web
#' Services Backup.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' @param AutomationMode The automation mode of the RDS Custom DB instance. If `full`, the DB
#' instance automates monitoring and instance recovery. If `all paused`,
#' the instance pauses automation for the duration set by
#' `ResumeFullAutomationModeMinutes`.
#' @param ResumeFullAutomationModeMinutes The number of minutes to pause the automation. When the time period
#' ends, RDS Custom resumes full automation.
#' 
#' Default: `60`
#' 
#' Constraints:
#' 
#' -   Must be at least 60.
#' 
#' -   Must be no more than 1,440.
#' @param NetworkType The network type of the DB instance.
#' 
#' The network type is determined by the `DBSubnetGroup` specified for the
#' DB instance. A `DBSubnetGroup` can support only the IPv4 protocol or the
#' IPv4 and the IPv6 protocols (`DUAL`).
#' 
#' For more information, see [Working with a DB instance in a
#' VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html)
#' in the *Amazon RDS User Guide.*
#' 
#' Valid Values: `IPV4 | DUAL`
#' @param StorageThroughput The storage throughput value for the DB instance.
#' 
#' This setting applies only to the `gp3` storage type.
#' 
#' This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
#' @param ManageMasterUserPassword Specifies whether to manage the master user password with Amazon Web
#' Services Secrets Manager.
#' 
#' If the DB instance doesn't manage the master user password with Amazon
#' Web Services Secrets Manager, you can turn on this management. In this
#' case, you can't specify `MasterUserPassword`.
#' 
#' If the DB instance already manages the master user password with Amazon
#' Web Services Secrets Manager, and you specify that the master user
#' password is not managed with Amazon Web Services Secrets Manager, then
#' you must specify `MasterUserPassword`. In this case, Amazon RDS deletes
#' the secret and uses the new password for the master user specified by
#' `MasterUserPassword`.
#' 
#' For more information, see [Password management with Amazon Web Services
#' Secrets
#' Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html)
#' in the *Amazon RDS User Guide.*
#' 
#' Constraints:
#' 
#' -   Can't manage the master user password with Amazon Web Services
#'     Secrets Manager if `MasterUserPassword` is specified.
#' @param RotateMasterUserPassword Specifies whether to rotate the secret managed by Amazon Web Services
#' Secrets Manager for the master user password.
#' 
#' This setting is valid only if the master user password is managed by RDS
#' in Amazon Web Services Secrets Manager for the DB cluster. The secret
#' value contains the updated password.
#' 
#' For more information, see [Password management with Amazon Web Services
#' Secrets
#' Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html)
#' in the *Amazon RDS User Guide.*
#' 
#' Constraints:
#' 
#' -   You must apply the change immediately when rotating the master user
#'     password.
#' @param MasterUserSecretKmsKeyId The Amazon Web Services KMS key identifier to encrypt a secret that is
#' automatically generated and managed in Amazon Web Services Secrets
#' Manager.
#' 
#' This setting is valid only if both of the following conditions are met:
#' 
#' -   The DB instance doesn't manage the master user password in Amazon
#'     Web Services Secrets Manager.
#' 
#'     If the DB instance already manages the master user password in
#'     Amazon Web Services Secrets Manager, you can't change the KMS key
#'     used to encrypt the secret.
#' 
#' -   You are turning on `ManageMasterUserPassword` to manage the master
#'     user password in Amazon Web Services Secrets Manager.
#' 
#'     If you are turning on `ManageMasterUserPassword` and don't specify
#'     `MasterUserSecretKmsKeyId`, then the `aws/secretsmanager` KMS key is
#'     used to encrypt the secret. If the secret is in a different Amazon
#'     Web Services account, then you can't use the `aws/secretsmanager`
#'     KMS key to encrypt the secret, and you must use a customer managed
#'     KMS key.
#' 
#' The Amazon Web Services KMS key identifier is the key ARN, key ID, alias
#' ARN, or alias name for the KMS key. To use a KMS key in a different
#' Amazon Web Services account, specify the key ARN or alias ARN.
#' 
#' There is a default KMS key for your Amazon Web Services account. Your
#' Amazon Web Services account has a different default KMS key for each
#' Amazon Web Services Region.
#' @param Engine The target Oracle DB engine when you convert a non-CDB to a CDB. This
#' intermediate step is necessary to upgrade an Oracle Database 19c non-CDB
#' to an Oracle Database 21c CDB.
#' 
#' Note the following requirements:
#' 
#' -   Make sure that you specify `oracle-ee-cdb` or `oracle-se2-cdb`.
#' 
#' -   Make sure that your DB engine runs Oracle Database 19c with an April
#'     2021 or later RU.
#' 
#' Note the following limitations:
#' 
#' -   You can't convert a CDB to a non-CDB.
#' 
#' -   You can't convert a replica database.
#' 
#' -   You can't convert a non-CDB to a CDB and upgrade the engine version
#'     in the same command.
#' 
#' -   You can't convert the existing custom parameter or option group when
#'     it has options or parameters that are permanent or persistent. In
#'     this situation, the DB instance reverts to the default option and
#'     parameter group. To avoid reverting to the default, specify a new
#'     parameter group with `--db-parameter-group-name` and a new option
#'     group with `--option-group-name`.
#'
#' @keywords internal
#'
#' @rdname rds_modify_db_instance
rds_modify_db_instance <- function(DBInstanceIdentifier, AllocatedStorage = NULL, DBInstanceClass = NULL, DBSubnetGroupName = NULL, DBSecurityGroups = NULL, VpcSecurityGroupIds = NULL, ApplyImmediately = NULL, MasterUserPassword = NULL, DBParameterGroupName = NULL, BackupRetentionPeriod = NULL, PreferredBackupWindow = NULL, PreferredMaintenanceWindow = NULL, MultiAZ = NULL, EngineVersion = NULL, AllowMajorVersionUpgrade = NULL, AutoMinorVersionUpgrade = NULL, LicenseModel = NULL, Iops = NULL, OptionGroupName = NULL, NewDBInstanceIdentifier = NULL, StorageType = NULL, TdeCredentialArn = NULL, TdeCredentialPassword = NULL, CACertificateIdentifier = NULL, Domain = NULL, DomainFqdn = NULL, DomainOu = NULL, DomainAuthSecretArn = NULL, DomainDnsIps = NULL, CopyTagsToSnapshot = NULL, MonitoringInterval = NULL, DBPortNumber = NULL, PubliclyAccessible = NULL, MonitoringRoleArn = NULL, DomainIAMRoleName = NULL, DisableDomain = NULL, PromotionTier = NULL, EnableIAMDatabaseAuthentication = NULL, EnablePerformanceInsights = NULL, PerformanceInsightsKMSKeyId = NULL, PerformanceInsightsRetentionPeriod = NULL, CloudwatchLogsExportConfiguration = NULL, ProcessorFeatures = NULL, UseDefaultProcessorFeatures = NULL, DeletionProtection = NULL, MaxAllocatedStorage = NULL, CertificateRotationRestart = NULL, ReplicaMode = NULL, EnableCustomerOwnedIp = NULL, AwsBackupRecoveryPointArn = NULL, AutomationMode = NULL, ResumeFullAutomationModeMinutes = NULL, NetworkType = NULL, StorageThroughput = NULL, ManageMasterUserPassword = NULL, RotateMasterUserPassword = NULL, MasterUserSecretKmsKeyId = NULL, Engine = NULL) {
  op <- new_operation(
    name = "ModifyDBInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$modify_db_instance_input(DBInstanceIdentifier = DBInstanceIdentifier, AllocatedStorage = AllocatedStorage, DBInstanceClass = DBInstanceClass, DBSubnetGroupName = DBSubnetGroupName, DBSecurityGroups = DBSecurityGroups, VpcSecurityGroupIds = VpcSecurityGroupIds, ApplyImmediately = ApplyImmediately, MasterUserPassword = MasterUserPassword, DBParameterGroupName = DBParameterGroupName, BackupRetentionPeriod = BackupRetentionPeriod, PreferredBackupWindow = PreferredBackupWindow, PreferredMaintenanceWindow = PreferredMaintenanceWindow, MultiAZ = MultiAZ, EngineVersion = EngineVersion, AllowMajorVersionUpgrade = AllowMajorVersionUpgrade, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, LicenseModel = LicenseModel, Iops = Iops, OptionGroupName = OptionGroupName, NewDBInstanceIdentifier = NewDBInstanceIdentifier, StorageType = StorageType, TdeCredentialArn = TdeCredentialArn, TdeCredentialPassword = TdeCredentialPassword, CACertificateIdentifier = CACertificateIdentifier, Domain = Domain, DomainFqdn = DomainFqdn, DomainOu = DomainOu, DomainAuthSecretArn = DomainAuthSecretArn, DomainDnsIps = DomainDnsIps, CopyTagsToSnapshot = CopyTagsToSnapshot, MonitoringInterval = MonitoringInterval, DBPortNumber = DBPortNumber, PubliclyAccessible = PubliclyAccessible, MonitoringRoleArn = MonitoringRoleArn, DomainIAMRoleName = DomainIAMRoleName, DisableDomain = DisableDomain, PromotionTier = PromotionTier, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, EnablePerformanceInsights = EnablePerformanceInsights, PerformanceInsightsKMSKeyId = PerformanceInsightsKMSKeyId, PerformanceInsightsRetentionPeriod = PerformanceInsightsRetentionPeriod, CloudwatchLogsExportConfiguration = CloudwatchLogsExportConfiguration, ProcessorFeatures = ProcessorFeatures, UseDefaultProcessorFeatures = UseDefaultProcessorFeatures, DeletionProtection = DeletionProtection, MaxAllocatedStorage = MaxAllocatedStorage, CertificateRotationRestart = CertificateRotationRestart, ReplicaMode = ReplicaMode, EnableCustomerOwnedIp = EnableCustomerOwnedIp, AwsBackupRecoveryPointArn = AwsBackupRecoveryPointArn, AutomationMode = AutomationMode, ResumeFullAutomationModeMinutes = ResumeFullAutomationModeMinutes, NetworkType = NetworkType, StorageThroughput = StorageThroughput, ManageMasterUserPassword = ManageMasterUserPassword, RotateMasterUserPassword = RotateMasterUserPassword, MasterUserSecretKmsKeyId = MasterUserSecretKmsKeyId, Engine = Engine)
  output <- .rds$modify_db_instance_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$modify_db_instance <- rds_modify_db_instance

#' Modifies the parameters of a DB parameter group
#'
#' @description
#' Modifies the parameters of a DB parameter group. To modify more than one parameter, submit a list of the following: `ParameterName`, `ParameterValue`, and `ApplyMethod`. A maximum of 20 parameters can be modified in a single request.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_modify_db_parameter_group/](https://www.paws-r-sdk.com/docs/rds_modify_db_parameter_group/) for full documentation.
#'
#' @param DBParameterGroupName &#91;required&#93; The name of the DB parameter group.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing `DBParameterGroup`.
#' @param Parameters &#91;required&#93; An array of parameter names, values, and the application methods for the
#' parameter update. At least one parameter name, value, and application
#' method must be supplied; later arguments are optional. A maximum of 20
#' parameters can be modified in a single request.
#' 
#' Valid Values (for the application method): `immediate | pending-reboot`
#' 
#' You can use the `immediate` value with dynamic parameters only. You can
#' use the `pending-reboot` value for both dynamic and static parameters.
#' 
#' When the application method is `immediate`, changes to dynamic
#' parameters are applied immediately to the DB instances associated with
#' the parameter group.
#' 
#' When the application method is `pending-reboot`, changes to dynamic and
#' static parameters are applied after a reboot without failover to the DB
#' instances associated with the parameter group.
#' 
#' You can't use `pending-reboot` with dynamic parameters on RDS for SQL
#' Server DB instances. Use `immediate`.
#' 
#' For more information on modifying DB parameters, see [Working with DB
#' parameter
#' groups](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html)
#' in the *Amazon RDS User Guide*.
#'
#' @keywords internal
#'
#' @rdname rds_modify_db_parameter_group
rds_modify_db_parameter_group <- function(DBParameterGroupName, Parameters) {
  op <- new_operation(
    name = "ModifyDBParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$modify_db_parameter_group_input(DBParameterGroupName = DBParameterGroupName, Parameters = Parameters)
  output <- .rds$modify_db_parameter_group_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$modify_db_parameter_group <- rds_modify_db_parameter_group

#' Changes the settings for an existing DB proxy
#'
#' @description
#' Changes the settings for an existing DB proxy.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_modify_db_proxy/](https://www.paws-r-sdk.com/docs/rds_modify_db_proxy/) for full documentation.
#'
#' @param DBProxyName &#91;required&#93; The identifier for the `DBProxy` to modify.
#' @param NewDBProxyName The new identifier for the `DBProxy`. An identifier must begin with a
#' letter and must contain only ASCII letters, digits, and hyphens; it
#' can't end with a hyphen or contain two consecutive hyphens.
#' @param Auth The new authentication settings for the `DBProxy`.
#' @param RequireTLS Whether Transport Layer Security (TLS) encryption is required for
#' connections to the proxy. By enabling this setting, you can enforce
#' encrypted TLS connections to the proxy, even if the associated database
#' doesn't use TLS.
#' @param IdleClientTimeout The number of seconds that a connection to the proxy can be inactive
#' before the proxy disconnects it. You can set this value higher or lower
#' than the connection timeout limit for the associated database.
#' @param DebugLogging Whether the proxy includes detailed information about SQL statements in
#' its logs. This information helps you to debug issues involving SQL
#' behavior or the performance and scalability of the proxy connections.
#' The debug information includes the text of SQL statements that you
#' submit through the proxy. Thus, only enable this setting when needed for
#' debugging, and only when you have security measures in place to
#' safeguard any sensitive information that appears in the logs.
#' @param RoleArn The Amazon Resource Name (ARN) of the IAM role that the proxy uses to
#' access secrets in Amazon Web Services Secrets Manager.
#' @param SecurityGroups The new list of security groups for the `DBProxy`.
#'
#' @keywords internal
#'
#' @rdname rds_modify_db_proxy
rds_modify_db_proxy <- function(DBProxyName, NewDBProxyName = NULL, Auth = NULL, RequireTLS = NULL, IdleClientTimeout = NULL, DebugLogging = NULL, RoleArn = NULL, SecurityGroups = NULL) {
  op <- new_operation(
    name = "ModifyDBProxy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$modify_db_proxy_input(DBProxyName = DBProxyName, NewDBProxyName = NewDBProxyName, Auth = Auth, RequireTLS = RequireTLS, IdleClientTimeout = IdleClientTimeout, DebugLogging = DebugLogging, RoleArn = RoleArn, SecurityGroups = SecurityGroups)
  output <- .rds$modify_db_proxy_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$modify_db_proxy <- rds_modify_db_proxy

#' Changes the settings for an existing DB proxy endpoint
#'
#' @description
#' Changes the settings for an existing DB proxy endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_modify_db_proxy_endpoint/](https://www.paws-r-sdk.com/docs/rds_modify_db_proxy_endpoint/) for full documentation.
#'
#' @param DBProxyEndpointName &#91;required&#93; The name of the DB proxy sociated with the DB proxy endpoint that you
#' want to modify.
#' @param NewDBProxyEndpointName The new identifier for the `DBProxyEndpoint`. An identifier must begin
#' with a letter and must contain only ASCII letters, digits, and hyphens;
#' it can't end with a hyphen or contain two consecutive hyphens.
#' @param VpcSecurityGroupIds The VPC security group IDs for the DB proxy endpoint. When the DB proxy
#' endpoint uses a different VPC than the original proxy, you also specify
#' a different set of security group IDs than for the original proxy.
#'
#' @keywords internal
#'
#' @rdname rds_modify_db_proxy_endpoint
rds_modify_db_proxy_endpoint <- function(DBProxyEndpointName, NewDBProxyEndpointName = NULL, VpcSecurityGroupIds = NULL) {
  op <- new_operation(
    name = "ModifyDBProxyEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$modify_db_proxy_endpoint_input(DBProxyEndpointName = DBProxyEndpointName, NewDBProxyEndpointName = NewDBProxyEndpointName, VpcSecurityGroupIds = VpcSecurityGroupIds)
  output <- .rds$modify_db_proxy_endpoint_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$modify_db_proxy_endpoint <- rds_modify_db_proxy_endpoint

#' Modifies the properties of a DBProxyTargetGroup
#'
#' @description
#' Modifies the properties of a `DBProxyTargetGroup`.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_modify_db_proxy_target_group/](https://www.paws-r-sdk.com/docs/rds_modify_db_proxy_target_group/) for full documentation.
#'
#' @param TargetGroupName &#91;required&#93; The name of the target group to modify.
#' @param DBProxyName &#91;required&#93; The name of the proxy.
#' @param ConnectionPoolConfig The settings that determine the size and behavior of the connection pool
#' for the target group.
#' @param NewName The new name for the modified `DBProxyTarget`. An identifier must begin
#' with a letter and must contain only ASCII letters, digits, and hyphens;
#' it can't end with a hyphen or contain two consecutive hyphens.
#'
#' @keywords internal
#'
#' @rdname rds_modify_db_proxy_target_group
rds_modify_db_proxy_target_group <- function(TargetGroupName, DBProxyName, ConnectionPoolConfig = NULL, NewName = NULL) {
  op <- new_operation(
    name = "ModifyDBProxyTargetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$modify_db_proxy_target_group_input(TargetGroupName = TargetGroupName, DBProxyName = DBProxyName, ConnectionPoolConfig = ConnectionPoolConfig, NewName = NewName)
  output <- .rds$modify_db_proxy_target_group_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$modify_db_proxy_target_group <- rds_modify_db_proxy_target_group

#' Updates a manual DB snapshot with a new engine version
#'
#' @description
#' Updates a manual DB snapshot with a new engine version. The snapshot can be encrypted or unencrypted, but not shared or public.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_modify_db_snapshot/](https://www.paws-r-sdk.com/docs/rds_modify_db_snapshot/) for full documentation.
#'
#' @param DBSnapshotIdentifier &#91;required&#93; The identifier of the DB snapshot to modify.
#' @param EngineVersion The engine version to upgrade the DB snapshot to.
#' 
#' The following are the database engines and engine versions that are
#' available when you upgrade a DB snapshot.
#' 
#' **MySQL**
#' 
#' -   `5.5.46` (supported for 5.1 DB snapshots)
#' 
#' **Oracle**
#' 
#' -   `19.0.0.0.ru-2022-01.rur-2022-01.r1` (supported for 12.2.0.1 DB
#'     snapshots)
#' 
#' -   `19.0.0.0.ru-2022-07.rur-2022-07.r1` (supported for 12.1.0.2 DB
#'     snapshots)
#' 
#' -   `12.1.0.2.v8` (supported for 12.1.0.1 DB snapshots)
#' 
#' -   `11.2.0.4.v12` (supported for 11.2.0.2 DB snapshots)
#' 
#' -   `11.2.0.4.v11` (supported for 11.2.0.3 DB snapshots)
#' 
#' **PostgreSQL**
#' 
#' For the list of engine versions that are available for upgrading a DB
#' snapshot, see [Upgrading the PostgreSQL DB Engine for Amazon
#' RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.PostgreSQL.html#USER_UpgradeDBInstance.PostgreSQL.MajorVersion).
#' @param OptionGroupName The option group to identify with the upgraded DB snapshot.
#' 
#' You can specify this parameter when you upgrade an Oracle DB snapshot.
#' The same option group considerations apply when upgrading a DB snapshot
#' as when upgrading a DB instance. For more information, see [Option group
#' considerations](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Oracle.html#USER_UpgradeDBInstance.Oracle.OGPG.OG)
#' in the *Amazon RDS User Guide.*
#'
#' @keywords internal
#'
#' @rdname rds_modify_db_snapshot
rds_modify_db_snapshot <- function(DBSnapshotIdentifier, EngineVersion = NULL, OptionGroupName = NULL) {
  op <- new_operation(
    name = "ModifyDBSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$modify_db_snapshot_input(DBSnapshotIdentifier = DBSnapshotIdentifier, EngineVersion = EngineVersion, OptionGroupName = OptionGroupName)
  output <- .rds$modify_db_snapshot_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$modify_db_snapshot <- rds_modify_db_snapshot

#' Adds an attribute and values to, or removes an attribute and values
#' from, a manual DB snapshot
#'
#' @description
#' Adds an attribute and values to, or removes an attribute and values from, a manual DB snapshot.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_modify_db_snapshot_attribute/](https://www.paws-r-sdk.com/docs/rds_modify_db_snapshot_attribute/) for full documentation.
#'
#' @param DBSnapshotIdentifier &#91;required&#93; The identifier for the DB snapshot to modify the attributes for.
#' @param AttributeName &#91;required&#93; The name of the DB snapshot attribute to modify.
#' 
#' To manage authorization for other Amazon Web Services accounts to copy
#' or restore a manual DB snapshot, set this value to `restore`.
#' 
#' To view the list of attributes available to modify, use the
#' [`describe_db_snapshot_attributes`][rds_describe_db_snapshot_attributes]
#' API operation.
#' @param ValuesToAdd A list of DB snapshot attributes to add to the attribute specified by
#' `AttributeName`.
#' 
#' To authorize other Amazon Web Services accounts to copy or restore a
#' manual snapshot, set this list to include one or more Amazon Web
#' Services account IDs, or `all` to make the manual DB snapshot restorable
#' by any Amazon Web Services account. Do not add the `all` value for any
#' manual DB snapshots that contain private information that you don't want
#' available to all Amazon Web Services accounts.
#' @param ValuesToRemove A list of DB snapshot attributes to remove from the attribute specified
#' by `AttributeName`.
#' 
#' To remove authorization for other Amazon Web Services accounts to copy
#' or restore a manual snapshot, set this list to include one or more
#' Amazon Web Services account identifiers, or `all` to remove
#' authorization for any Amazon Web Services account to copy or restore the
#' DB snapshot. If you specify `all`, an Amazon Web Services account whose
#' account ID is explicitly added to the `restore` attribute can still copy
#' or restore the manual DB snapshot.
#'
#' @keywords internal
#'
#' @rdname rds_modify_db_snapshot_attribute
rds_modify_db_snapshot_attribute <- function(DBSnapshotIdentifier, AttributeName, ValuesToAdd = NULL, ValuesToRemove = NULL) {
  op <- new_operation(
    name = "ModifyDBSnapshotAttribute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$modify_db_snapshot_attribute_input(DBSnapshotIdentifier = DBSnapshotIdentifier, AttributeName = AttributeName, ValuesToAdd = ValuesToAdd, ValuesToRemove = ValuesToRemove)
  output <- .rds$modify_db_snapshot_attribute_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$modify_db_snapshot_attribute <- rds_modify_db_snapshot_attribute

#' Modifies an existing DB subnet group
#'
#' @description
#' Modifies an existing DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_modify_db_subnet_group/](https://www.paws-r-sdk.com/docs/rds_modify_db_subnet_group/) for full documentation.
#'
#' @param DBSubnetGroupName &#91;required&#93; The name for the DB subnet group. This value is stored as a lowercase
#' string. You can't modify the default subnet group.
#' 
#' Constraints: Must match the name of an existing DBSubnetGroup. Must not
#' be default.
#' 
#' Example: `mydbsubnetgroup`
#' @param DBSubnetGroupDescription The description for the DB subnet group.
#' @param SubnetIds &#91;required&#93; The EC2 subnet IDs for the DB subnet group.
#'
#' @keywords internal
#'
#' @rdname rds_modify_db_subnet_group
rds_modify_db_subnet_group <- function(DBSubnetGroupName, DBSubnetGroupDescription = NULL, SubnetIds) {
  op <- new_operation(
    name = "ModifyDBSubnetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$modify_db_subnet_group_input(DBSubnetGroupName = DBSubnetGroupName, DBSubnetGroupDescription = DBSubnetGroupDescription, SubnetIds = SubnetIds)
  output <- .rds$modify_db_subnet_group_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$modify_db_subnet_group <- rds_modify_db_subnet_group

#' Modifies an existing RDS event notification subscription
#'
#' @description
#' Modifies an existing RDS event notification subscription. You can't modify the source identifiers using this call. To change source identifiers for a subscription, use the [`add_source_identifier_to_subscription`][rds_add_source_identifier_to_subscription] and [`remove_source_identifier_from_subscription`][rds_remove_source_identifier_from_subscription] calls.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_modify_event_subscription/](https://www.paws-r-sdk.com/docs/rds_modify_event_subscription/) for full documentation.
#'
#' @param SubscriptionName &#91;required&#93; The name of the RDS event notification subscription.
#' @param SnsTopicArn The Amazon Resource Name (ARN) of the SNS topic created for event
#' notification. The ARN is created by Amazon SNS when you create a topic
#' and subscribe to it.
#' @param SourceType The type of source that is generating the events. For example, if you
#' want to be notified of events generated by a DB instance, you would set
#' this parameter to db-instance. For RDS Proxy events, specify `db-proxy`.
#' If this value isn't specified, all events are returned.
#' 
#' Valid values: `db-instance` | `db-cluster` | `db-parameter-group` |
#' `db-security-group` | `db-snapshot` | `db-cluster-snapshot` | `db-proxy`
#' @param EventCategories A list of event categories for a source type (`SourceType`) that you
#' want to subscribe to. You can see a list of the categories for a given
#' source type in
#' [Events](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html)
#' in the *Amazon RDS User Guide* or by using the
#' [`describe_event_categories`][rds_describe_event_categories] operation.
#' @param Enabled A value that indicates whether to activate the subscription.
#'
#' @keywords internal
#'
#' @rdname rds_modify_event_subscription
rds_modify_event_subscription <- function(SubscriptionName, SnsTopicArn = NULL, SourceType = NULL, EventCategories = NULL, Enabled = NULL) {
  op <- new_operation(
    name = "ModifyEventSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$modify_event_subscription_input(SubscriptionName = SubscriptionName, SnsTopicArn = SnsTopicArn, SourceType = SourceType, EventCategories = EventCategories, Enabled = Enabled)
  output <- .rds$modify_event_subscription_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$modify_event_subscription <- rds_modify_event_subscription

#' Modifies a setting for an Amazon Aurora global database cluster
#'
#' @description
#' Modifies a setting for an Amazon Aurora global database cluster. You can change one or more database configuration parameters by specifying these parameters and the new values in the request. For more information on Amazon Aurora, see [What is Amazon Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html) in the *Amazon Aurora User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_modify_global_cluster/](https://www.paws-r-sdk.com/docs/rds_modify_global_cluster/) for full documentation.
#'
#' @param GlobalClusterIdentifier The cluster identifier for the global cluster to modify. This parameter
#' isn't case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing global database cluster.
#' @param NewGlobalClusterIdentifier The new cluster identifier for the global database cluster. This value
#' is stored as a lowercase string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   The first character must be a letter.
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-cluster2`
#' @param DeletionProtection Specifies whether to enable deletion protection for the global database
#' cluster. The global database cluster can't be deleted when deletion
#' protection is enabled.
#' @param EngineVersion The version number of the database engine to which you want to upgrade.
#' 
#' To list all of the available engine versions for `aurora-mysql` (for
#' MySQL-based Aurora global databases), use the following command:
#' 
#' `` aws rds describe-db-engine-versions --engine aurora-mysql --query '*[]|[?SupportsGlobalDatabases == `true`].[EngineVersion]' ``
#' 
#' To list all of the available engine versions for `aurora-postgresql`
#' (for PostgreSQL-based Aurora global databases), use the following
#' command:
#' 
#' `` aws rds describe-db-engine-versions --engine aurora-postgresql --query '*[]|[?SupportsGlobalDatabases == `true`].[EngineVersion]' ``
#' @param AllowMajorVersionUpgrade Specifies whether to allow major version upgrades.
#' 
#' Constraints: Must be enabled if you specify a value for the
#' `EngineVersion` parameter that's a different major version than the
#' global cluster's current version.
#' 
#' If you upgrade the major version of a global database, the cluster and
#' DB instance parameter groups are set to the default parameter groups for
#' the new version. Apply any custom parameter groups after completing the
#' upgrade.
#'
#' @keywords internal
#'
#' @rdname rds_modify_global_cluster
rds_modify_global_cluster <- function(GlobalClusterIdentifier = NULL, NewGlobalClusterIdentifier = NULL, DeletionProtection = NULL, EngineVersion = NULL, AllowMajorVersionUpgrade = NULL) {
  op <- new_operation(
    name = "ModifyGlobalCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$modify_global_cluster_input(GlobalClusterIdentifier = GlobalClusterIdentifier, NewGlobalClusterIdentifier = NewGlobalClusterIdentifier, DeletionProtection = DeletionProtection, EngineVersion = EngineVersion, AllowMajorVersionUpgrade = AllowMajorVersionUpgrade)
  output <- .rds$modify_global_cluster_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$modify_global_cluster <- rds_modify_global_cluster

#' Modifies an existing option group
#'
#' @description
#' Modifies an existing option group.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_modify_option_group/](https://www.paws-r-sdk.com/docs/rds_modify_option_group/) for full documentation.
#'
#' @param OptionGroupName &#91;required&#93; The name of the option group to be modified.
#' 
#' Permanent options, such as the TDE option for Oracle Advanced Security
#' TDE, can't be removed from an option group, and that option group can't
#' be removed from a DB instance once it is associated with a DB instance
#' @param OptionsToInclude Options in this list are added to the option group or, if already
#' present, the specified configuration is used to update the existing
#' configuration.
#' @param OptionsToRemove Options in this list are removed from the option group.
#' @param ApplyImmediately A value that indicates whether to apply the change immediately or during
#' the next maintenance window for each instance associated with the option
#' group.
#'
#' @keywords internal
#'
#' @rdname rds_modify_option_group
rds_modify_option_group <- function(OptionGroupName, OptionsToInclude = NULL, OptionsToRemove = NULL, ApplyImmediately = NULL) {
  op <- new_operation(
    name = "ModifyOptionGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$modify_option_group_input(OptionGroupName = OptionGroupName, OptionsToInclude = OptionsToInclude, OptionsToRemove = OptionsToRemove, ApplyImmediately = ApplyImmediately)
  output <- .rds$modify_option_group_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$modify_option_group <- rds_modify_option_group

#' Promotes a read replica DB instance to a standalone DB instance
#'
#' @description
#' Promotes a read replica DB instance to a standalone DB instance.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_promote_read_replica/](https://www.paws-r-sdk.com/docs/rds_promote_read_replica/) for full documentation.
#'
#' @param DBInstanceIdentifier &#91;required&#93; The DB instance identifier. This value is stored as a lowercase string.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing read replica DB instance.
#' 
#' Example: `mydbinstance`
#' @param BackupRetentionPeriod The number of days for which automated backups are retained. Setting
#' this parameter to a positive number enables backups. Setting this
#' parameter to 0 disables automated backups.
#' 
#' Default: 1
#' 
#' Constraints:
#' 
#' -   Must be a value from 0 to 35.
#' 
#' -   Can't be set to 0 if the DB instance is a source to read replicas.
#' @param PreferredBackupWindow The daily time range during which automated backups are created if
#' automated backups are enabled, using the `BackupRetentionPeriod`
#' parameter.
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each Amazon Web Services Region. To see the time
#' blocks available, see [Adjusting the Preferred Maintenance
#' Window](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/) in the
#' *Amazon RDS User Guide.*
#' 
#' Constraints:
#' 
#' -   Must be in the format `hh24:mi-hh24:mi`.
#' 
#' -   Must be in Universal Coordinated Time (UTC).
#' 
#' -   Must not conflict with the preferred maintenance window.
#' 
#' -   Must be at least 30 minutes.
#'
#' @keywords internal
#'
#' @rdname rds_promote_read_replica
rds_promote_read_replica <- function(DBInstanceIdentifier, BackupRetentionPeriod = NULL, PreferredBackupWindow = NULL) {
  op <- new_operation(
    name = "PromoteReadReplica",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$promote_read_replica_input(DBInstanceIdentifier = DBInstanceIdentifier, BackupRetentionPeriod = BackupRetentionPeriod, PreferredBackupWindow = PreferredBackupWindow)
  output <- .rds$promote_read_replica_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$promote_read_replica <- rds_promote_read_replica

#' Promotes a read replica DB cluster to a standalone DB cluster
#'
#' @description
#' Promotes a read replica DB cluster to a standalone DB cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_promote_read_replica_db_cluster/](https://www.paws-r-sdk.com/docs/rds_promote_read_replica_db_cluster/) for full documentation.
#'
#' @param DBClusterIdentifier &#91;required&#93; The identifier of the DB cluster read replica to promote. This parameter
#' isn't case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DB cluster read replica.
#' 
#' Example: `my-cluster-replica1`
#'
#' @keywords internal
#'
#' @rdname rds_promote_read_replica_db_cluster
rds_promote_read_replica_db_cluster <- function(DBClusterIdentifier) {
  op <- new_operation(
    name = "PromoteReadReplicaDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$promote_read_replica_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier)
  output <- .rds$promote_read_replica_db_cluster_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$promote_read_replica_db_cluster <- rds_promote_read_replica_db_cluster

#' Purchases a reserved DB instance offering
#'
#' @description
#' Purchases a reserved DB instance offering.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_purchase_reserved_db_instances_offering/](https://www.paws-r-sdk.com/docs/rds_purchase_reserved_db_instances_offering/) for full documentation.
#'
#' @param ReservedDBInstancesOfferingId &#91;required&#93; The ID of the Reserved DB instance offering to purchase.
#' 
#' Example: 438012d3-4052-4cc7-b2e3-8d3372e0e706
#' @param ReservedDBInstanceId Customer-specified identifier to track this reservation.
#' 
#' Example: myreservationID
#' @param DBInstanceCount The number of instances to reserve.
#' 
#' Default: `1`
#' @param Tags 
#'
#' @keywords internal
#'
#' @rdname rds_purchase_reserved_db_instances_offering
rds_purchase_reserved_db_instances_offering <- function(ReservedDBInstancesOfferingId, ReservedDBInstanceId = NULL, DBInstanceCount = NULL, Tags = NULL) {
  op <- new_operation(
    name = "PurchaseReservedDBInstancesOffering",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$purchase_reserved_db_instances_offering_input(ReservedDBInstancesOfferingId = ReservedDBInstancesOfferingId, ReservedDBInstanceId = ReservedDBInstanceId, DBInstanceCount = DBInstanceCount, Tags = Tags)
  output <- .rds$purchase_reserved_db_instances_offering_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$purchase_reserved_db_instances_offering <- rds_purchase_reserved_db_instances_offering

#' You might need to reboot your DB cluster, usually for maintenance
#' reasons
#'
#' @description
#' You might need to reboot your DB cluster, usually for maintenance reasons. For example, if you make certain modifications, or if you change the DB cluster parameter group associated with the DB cluster, reboot the DB cluster for the changes to take effect.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_reboot_db_cluster/](https://www.paws-r-sdk.com/docs/rds_reboot_db_cluster/) for full documentation.
#'
#' @param DBClusterIdentifier &#91;required&#93; The DB cluster identifier. This parameter is stored as a lowercase
#' string.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DBCluster.
#'
#' @keywords internal
#'
#' @rdname rds_reboot_db_cluster
rds_reboot_db_cluster <- function(DBClusterIdentifier) {
  op <- new_operation(
    name = "RebootDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$reboot_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier)
  output <- .rds$reboot_db_cluster_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$reboot_db_cluster <- rds_reboot_db_cluster

#' You might need to reboot your DB instance, usually for maintenance
#' reasons
#'
#' @description
#' You might need to reboot your DB instance, usually for maintenance reasons. For example, if you make certain modifications, or if you change the DB parameter group associated with the DB instance, you must reboot the instance for the changes to take effect.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_reboot_db_instance/](https://www.paws-r-sdk.com/docs/rds_reboot_db_instance/) for full documentation.
#'
#' @param DBInstanceIdentifier &#91;required&#93; The DB instance identifier. This parameter is stored as a lowercase
#' string.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DBInstance.
#' @param ForceFailover A value that indicates whether the reboot is conducted through a
#' Multi-AZ failover.
#' 
#' Constraint: You can't enable force failover if the instance isn't
#' configured for Multi-AZ.
#'
#' @keywords internal
#'
#' @rdname rds_reboot_db_instance
rds_reboot_db_instance <- function(DBInstanceIdentifier, ForceFailover = NULL) {
  op <- new_operation(
    name = "RebootDBInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$reboot_db_instance_input(DBInstanceIdentifier = DBInstanceIdentifier, ForceFailover = ForceFailover)
  output <- .rds$reboot_db_instance_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$reboot_db_instance <- rds_reboot_db_instance

#' Associate one or more DBProxyTarget data structures with a
#' DBProxyTargetGroup
#'
#' @description
#' Associate one or more `DBProxyTarget` data structures with a `DBProxyTargetGroup`.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_register_db_proxy_targets/](https://www.paws-r-sdk.com/docs/rds_register_db_proxy_targets/) for full documentation.
#'
#' @param DBProxyName &#91;required&#93; The identifier of the `DBProxy` that is associated with the
#' `DBProxyTargetGroup`.
#' @param TargetGroupName The identifier of the `DBProxyTargetGroup`.
#' @param DBInstanceIdentifiers One or more DB instance identifiers.
#' @param DBClusterIdentifiers One or more DB cluster identifiers.
#'
#' @keywords internal
#'
#' @rdname rds_register_db_proxy_targets
rds_register_db_proxy_targets <- function(DBProxyName, TargetGroupName = NULL, DBInstanceIdentifiers = NULL, DBClusterIdentifiers = NULL) {
  op <- new_operation(
    name = "RegisterDBProxyTargets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$register_db_proxy_targets_input(DBProxyName = DBProxyName, TargetGroupName = TargetGroupName, DBInstanceIdentifiers = DBInstanceIdentifiers, DBClusterIdentifiers = DBClusterIdentifiers)
  output <- .rds$register_db_proxy_targets_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$register_db_proxy_targets <- rds_register_db_proxy_targets

#' Detaches an Aurora secondary cluster from an Aurora global database
#' cluster
#'
#' @description
#' Detaches an Aurora secondary cluster from an Aurora global database cluster. The cluster becomes a standalone cluster with read-write capability instead of being read-only and receiving data from a primary cluster in a different Region.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_remove_from_global_cluster/](https://www.paws-r-sdk.com/docs/rds_remove_from_global_cluster/) for full documentation.
#'
#' @param GlobalClusterIdentifier The cluster identifier to detach from the Aurora global database
#' cluster.
#' @param DbClusterIdentifier The Amazon Resource Name (ARN) identifying the cluster that was detached
#' from the Aurora global database cluster.
#'
#' @keywords internal
#'
#' @rdname rds_remove_from_global_cluster
rds_remove_from_global_cluster <- function(GlobalClusterIdentifier = NULL, DbClusterIdentifier = NULL) {
  op <- new_operation(
    name = "RemoveFromGlobalCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$remove_from_global_cluster_input(GlobalClusterIdentifier = GlobalClusterIdentifier, DbClusterIdentifier = DbClusterIdentifier)
  output <- .rds$remove_from_global_cluster_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$remove_from_global_cluster <- rds_remove_from_global_cluster

#' Removes the asssociation of an Amazon Web Services Identity and Access
#' Management (IAM) role from a DB cluster
#'
#' @description
#' Removes the asssociation of an Amazon Web Services Identity and Access Management (IAM) role from a DB cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_remove_role_from_db_cluster/](https://www.paws-r-sdk.com/docs/rds_remove_role_from_db_cluster/) for full documentation.
#'
#' @param DBClusterIdentifier &#91;required&#93; The name of the DB cluster to disassociate the IAM role from.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role to disassociate from the
#' Aurora DB cluster, for example
#' `arn:aws:iam::123456789012:role/AuroraAccessRole`.
#' @param FeatureName The name of the feature for the DB cluster that the IAM role is to be
#' disassociated from. For information about supported feature names, see
#' DBEngineVersion.
#'
#' @keywords internal
#'
#' @rdname rds_remove_role_from_db_cluster
rds_remove_role_from_db_cluster <- function(DBClusterIdentifier, RoleArn, FeatureName = NULL) {
  op <- new_operation(
    name = "RemoveRoleFromDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$remove_role_from_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier, RoleArn = RoleArn, FeatureName = FeatureName)
  output <- .rds$remove_role_from_db_cluster_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$remove_role_from_db_cluster <- rds_remove_role_from_db_cluster

#' Disassociates an Amazon Web Services Identity and Access Management
#' (IAM) role from a DB instance
#'
#' @description
#' Disassociates an Amazon Web Services Identity and Access Management (IAM) role from a DB instance.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_remove_role_from_db_instance/](https://www.paws-r-sdk.com/docs/rds_remove_role_from_db_instance/) for full documentation.
#'
#' @param DBInstanceIdentifier &#91;required&#93; The name of the DB instance to disassociate the IAM role from.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role to disassociate from the
#' DB instance, for example, `arn:aws:iam::123456789012:role/AccessRole`.
#' @param FeatureName &#91;required&#93; The name of the feature for the DB instance that the IAM role is to be
#' disassociated from. For information about supported feature names, see
#' `DBEngineVersion`.
#'
#' @keywords internal
#'
#' @rdname rds_remove_role_from_db_instance
rds_remove_role_from_db_instance <- function(DBInstanceIdentifier, RoleArn, FeatureName) {
  op <- new_operation(
    name = "RemoveRoleFromDBInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$remove_role_from_db_instance_input(DBInstanceIdentifier = DBInstanceIdentifier, RoleArn = RoleArn, FeatureName = FeatureName)
  output <- .rds$remove_role_from_db_instance_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$remove_role_from_db_instance <- rds_remove_role_from_db_instance

#' Removes a source identifier from an existing RDS event notification
#' subscription
#'
#' @description
#' Removes a source identifier from an existing RDS event notification subscription.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_remove_source_identifier_from_subscription/](https://www.paws-r-sdk.com/docs/rds_remove_source_identifier_from_subscription/) for full documentation.
#'
#' @param SubscriptionName &#91;required&#93; The name of the RDS event notification subscription you want to remove a
#' source identifier from.
#' @param SourceIdentifier &#91;required&#93; The source identifier to be removed from the subscription, such as the
#' **DB instance identifier** for a DB instance or the name of a security
#' group.
#'
#' @keywords internal
#'
#' @rdname rds_remove_source_identifier_from_subscription
rds_remove_source_identifier_from_subscription <- function(SubscriptionName, SourceIdentifier) {
  op <- new_operation(
    name = "RemoveSourceIdentifierFromSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$remove_source_identifier_from_subscription_input(SubscriptionName = SubscriptionName, SourceIdentifier = SourceIdentifier)
  output <- .rds$remove_source_identifier_from_subscription_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$remove_source_identifier_from_subscription <- rds_remove_source_identifier_from_subscription

#' Removes metadata tags from an Amazon RDS resource
#'
#' @description
#' Removes metadata tags from an Amazon RDS resource.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_remove_tags_from_resource/](https://www.paws-r-sdk.com/docs/rds_remove_tags_from_resource/) for full documentation.
#'
#' @param ResourceName &#91;required&#93; The Amazon RDS resource that the tags are removed from. This value is an
#' Amazon Resource Name (ARN). For information about creating an ARN, see
#' [Constructing an ARN for Amazon
#' RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing)
#' in the *Amazon RDS User Guide.*
#' @param TagKeys &#91;required&#93; The tag key (name) of the tag to be removed.
#'
#' @keywords internal
#'
#' @rdname rds_remove_tags_from_resource
rds_remove_tags_from_resource <- function(ResourceName, TagKeys) {
  op <- new_operation(
    name = "RemoveTagsFromResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$remove_tags_from_resource_input(ResourceName = ResourceName, TagKeys = TagKeys)
  output <- .rds$remove_tags_from_resource_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$remove_tags_from_resource <- rds_remove_tags_from_resource

#' Modifies the parameters of a DB cluster parameter group to the default
#' value
#'
#' @description
#' Modifies the parameters of a DB cluster parameter group to the default value. To reset specific parameters submit a list of the following: `ParameterName` and `ApplyMethod`. To reset the entire DB cluster parameter group, specify the `DBClusterParameterGroupName` and `ResetAllParameters` parameters.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_reset_db_cluster_parameter_group/](https://www.paws-r-sdk.com/docs/rds_reset_db_cluster_parameter_group/) for full documentation.
#'
#' @param DBClusterParameterGroupName &#91;required&#93; The name of the DB cluster parameter group to reset.
#' @param ResetAllParameters A value that indicates whether to reset all parameters in the DB cluster
#' parameter group to their default values. You can't use this parameter if
#' there is a list of parameter names specified for the `Parameters`
#' parameter.
#' @param Parameters A list of parameter names in the DB cluster parameter group to reset to
#' the default values. You can't use this parameter if the
#' `ResetAllParameters` parameter is enabled.
#'
#' @keywords internal
#'
#' @rdname rds_reset_db_cluster_parameter_group
rds_reset_db_cluster_parameter_group <- function(DBClusterParameterGroupName, ResetAllParameters = NULL, Parameters = NULL) {
  op <- new_operation(
    name = "ResetDBClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$reset_db_cluster_parameter_group_input(DBClusterParameterGroupName = DBClusterParameterGroupName, ResetAllParameters = ResetAllParameters, Parameters = Parameters)
  output <- .rds$reset_db_cluster_parameter_group_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$reset_db_cluster_parameter_group <- rds_reset_db_cluster_parameter_group

#' Modifies the parameters of a DB parameter group to the engine/system
#' default value
#'
#' @description
#' Modifies the parameters of a DB parameter group to the engine/system default value. To reset specific parameters, provide a list of the following: `ParameterName` and `ApplyMethod`. To reset the entire DB parameter group, specify the `DBParameterGroup` name and `ResetAllParameters` parameters. When resetting the entire group, dynamic parameters are updated immediately and static parameters are set to `pending-reboot` to take effect on the next DB instance restart or [`reboot_db_instance`][rds_reboot_db_instance] request.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_reset_db_parameter_group/](https://www.paws-r-sdk.com/docs/rds_reset_db_parameter_group/) for full documentation.
#'
#' @param DBParameterGroupName &#91;required&#93; The name of the DB parameter group.
#' 
#' Constraints:
#' 
#' -   Must match the name of an existing `DBParameterGroup`.
#' @param ResetAllParameters A value that indicates whether to reset all parameters in the DB
#' parameter group to default values. By default, all parameters in the DB
#' parameter group are reset to default values.
#' @param Parameters To reset the entire DB parameter group, specify the `DBParameterGroup`
#' name and `ResetAllParameters` parameters. To reset specific parameters,
#' provide a list of the following: `ParameterName` and `ApplyMethod`. A
#' maximum of 20 parameters can be modified in a single request.
#' 
#' **MySQL**
#' 
#' Valid Values (for Apply method): `immediate` | `pending-reboot`
#' 
#' You can use the immediate value with dynamic parameters only. You can
#' use the `pending-reboot` value for both dynamic and static parameters,
#' and changes are applied when DB instance reboots.
#' 
#' **MariaDB**
#' 
#' Valid Values (for Apply method): `immediate` | `pending-reboot`
#' 
#' You can use the immediate value with dynamic parameters only. You can
#' use the `pending-reboot` value for both dynamic and static parameters,
#' and changes are applied when DB instance reboots.
#' 
#' **Oracle**
#' 
#' Valid Values (for Apply method): `pending-reboot`
#'
#' @keywords internal
#'
#' @rdname rds_reset_db_parameter_group
rds_reset_db_parameter_group <- function(DBParameterGroupName, ResetAllParameters = NULL, Parameters = NULL) {
  op <- new_operation(
    name = "ResetDBParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$reset_db_parameter_group_input(DBParameterGroupName = DBParameterGroupName, ResetAllParameters = ResetAllParameters, Parameters = Parameters)
  output <- .rds$reset_db_parameter_group_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$reset_db_parameter_group <- rds_reset_db_parameter_group

#' Creates an Amazon Aurora DB cluster from MySQL data stored in an Amazon
#' S3 bucket
#'
#' @description
#' Creates an Amazon Aurora DB cluster from MySQL data stored in an Amazon S3 bucket. Amazon RDS must be authorized to access the Amazon S3 bucket and the data must be created using the Percona XtraBackup utility as described in [Migrating Data from MySQL by Using an Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Migrating.ExtMySQL.html#AuroraMySQL.Migrating.ExtMySQL.S3) in the *Amazon Aurora User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_restore_db_cluster_from_s3/](https://www.paws-r-sdk.com/docs/rds_restore_db_cluster_from_s3/) for full documentation.
#'
#' @param AvailabilityZones A list of Availability Zones (AZs) where instances in the restored DB
#' cluster can be created.
#' @param BackupRetentionPeriod The number of days for which automated backups of the restored DB
#' cluster are retained. You must specify a minimum value of 1.
#' 
#' Default: 1
#' 
#' Constraints:
#' 
#' -   Must be a value from 1 to 35
#' @param CharacterSetName A value that indicates that the restored DB cluster should be associated
#' with the specified CharacterSet.
#' @param DatabaseName The database name for the restored DB cluster.
#' @param DBClusterIdentifier &#91;required&#93; The name of the DB cluster to create from the source data in the Amazon
#' S3 bucket. This parameter isn't case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-cluster1`
#' @param DBClusterParameterGroupName The name of the DB cluster parameter group to associate with the
#' restored DB cluster. If this argument is omitted, the default parameter
#' group for the engine version is used.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing
#'     DBClusterParameterGroup.
#' @param VpcSecurityGroupIds A list of EC2 VPC security groups to associate with the restored DB
#' cluster.
#' @param DBSubnetGroupName A DB subnet group to associate with the restored DB cluster.
#' 
#' Constraints: If supplied, must match the name of an existing
#' DBSubnetGroup.
#' 
#' Example: `mydbsubnetgroup`
#' @param Engine &#91;required&#93; The name of the database engine to be used for this DB cluster.
#' 
#' Valid Values: `aurora-mysql` (for Aurora MySQL)
#' @param EngineVersion The version number of the database engine to use.
#' 
#' To list all of the available engine versions for `aurora-mysql` (Aurora
#' MySQL), use the following command:
#' 
#' `aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"`
#' 
#' **Aurora MySQL**
#' 
#' Examples: `5.7.mysql_aurora.2.12.0`, `8.0.mysql_aurora.3.04.0`
#' @param Port The port number on which the instances in the restored DB cluster accept
#' connections.
#' 
#' Default: `3306`
#' @param MasterUsername &#91;required&#93; The name of the master user for the restored DB cluster.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 16 letters or numbers.
#' 
#' -   First character must be a letter.
#' 
#' -   Can't be a reserved word for the chosen database engine.
#' @param MasterUserPassword The password for the master database user. This password can contain any
#' printable ASCII character except "/", """, or "@@".
#' 
#' Constraints:
#' 
#' -   Must contain from 8 to 41 characters.
#' 
#' -   Can't be specified if `ManageMasterUserPassword` is turned on.
#' @param OptionGroupName A value that indicates that the restored DB cluster should be associated
#' with the specified option group.
#' 
#' Permanent options can't be removed from an option group. An option group
#' can't be removed from a DB cluster once it is associated with a DB
#' cluster.
#' @param PreferredBackupWindow The daily time range during which automated backups are created if
#' automated backups are enabled using the `BackupRetentionPeriod`
#' parameter.
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each Amazon Web Services Region. To view the time
#' blocks available, see [Backup
#' window](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow)
#' in the *Amazon Aurora User Guide*.
#' 
#' Constraints:
#' 
#' -   Must be in the format `hh24:mi-hh24:mi`.
#' 
#' -   Must be in Universal Coordinated Time (UTC).
#' 
#' -   Must not conflict with the preferred maintenance window.
#' 
#' -   Must be at least 30 minutes.
#' @param PreferredMaintenanceWindow The weekly time range during which system maintenance can occur, in
#' Universal Coordinated Time (UTC).
#' 
#' Format: `ddd:hh24:mi-ddd:hh24:mi`
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each Amazon Web Services Region, occurring on a random
#' day of the week. To see the time blocks available, see [Adjusting the
#' Preferred Maintenance
#' Window](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora)
#' in the *Amazon Aurora User Guide*.
#' 
#' Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
#' 
#' Constraints: Minimum 30-minute window.
#' @param Tags 
#' @param StorageEncrypted A value that indicates whether the restored DB cluster is encrypted.
#' @param KmsKeyId The Amazon Web Services KMS key identifier for an encrypted DB cluster.
#' 
#' The Amazon Web Services KMS key identifier is the key ARN, key ID, alias
#' ARN, or alias name for the KMS key. To use a KMS key in a different
#' Amazon Web Services account, specify the key ARN or alias ARN.
#' 
#' If the StorageEncrypted parameter is enabled, and you do not specify a
#' value for the `KmsKeyId` parameter, then Amazon RDS will use your
#' default KMS key. There is a default KMS key for your Amazon Web Services
#' account. Your Amazon Web Services account has a different default KMS
#' key for each Amazon Web Services Region.
#' @param EnableIAMDatabaseAuthentication A value that indicates whether to enable mapping of Amazon Web Services
#' Identity and Access Management (IAM) accounts to database accounts. By
#' default, mapping isn't enabled.
#' 
#' For more information, see [IAM Database
#' Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html)
#' in the *Amazon Aurora User Guide*.
#' @param SourceEngine &#91;required&#93; The identifier for the database engine that was backed up to create the
#' files stored in the Amazon S3 bucket.
#' 
#' Valid values: `mysql`
#' @param SourceEngineVersion &#91;required&#93; The version of the database that the backup files were created from.
#' 
#' MySQL versions 5.7 and 8.0 are supported.
#' 
#' Example: `5.7.40`, `8.0.28`
#' @param S3BucketName &#91;required&#93; The name of the Amazon S3 bucket that contains the data used to create
#' the Amazon Aurora DB cluster.
#' @param S3Prefix The prefix for all of the file names that contain the data used to
#' create the Amazon Aurora DB cluster. If you do not specify a
#' **SourceS3Prefix** value, then the Amazon Aurora DB cluster is created
#' by using all of the files in the Amazon S3 bucket.
#' @param S3IngestionRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the Amazon Web Services Identity and
#' Access Management (IAM) role that authorizes Amazon RDS to access the
#' Amazon S3 bucket on your behalf.
#' @param BacktrackWindow The target backtrack window, in seconds. To disable backtracking, set
#' this value to 0.
#' 
#' Currently, Backtrack is only supported for Aurora MySQL DB clusters.
#' 
#' Default: 0
#' 
#' Constraints:
#' 
#' -   If specified, this value must be set to a number from 0 to 259,200
#'     (72 hours).
#' @param EnableCloudwatchLogsExports The list of logs that the restored DB cluster is to export to CloudWatch
#' Logs. The values in the list depend on the DB engine being used.
#' 
#' **Aurora MySQL**
#' 
#' Possible values are `audit`, `error`, `general`, and `slowquery`.
#' 
#' For more information about exporting CloudWatch Logs for Amazon Aurora,
#' see [Publishing Database Logs to Amazon CloudWatch
#' Logs](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch)
#' in the *Amazon Aurora User Guide*.
#' @param DeletionProtection A value that indicates whether the DB cluster has deletion protection
#' enabled. The database can't be deleted when deletion protection is
#' enabled. By default, deletion protection isn't enabled.
#' @param CopyTagsToSnapshot A value that indicates whether to copy all tags from the restored DB
#' cluster to snapshots of the restored DB cluster. The default is not to
#' copy them.
#' @param Domain Specify the Active Directory directory ID to restore the DB cluster in.
#' The domain must be created prior to this operation.
#' 
#' For Amazon Aurora DB clusters, Amazon RDS can use Kerberos
#' Authentication to authenticate users that connect to the DB cluster. For
#' more information, see [Kerberos
#' Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/database-authentication.html)
#' in the *Amazon Aurora User Guide*.
#' @param DomainIAMRoleName Specify the name of the IAM role to be used when making API calls to the
#' Directory Service.
#' @param ServerlessV2ScalingConfiguration 
#' @param NetworkType The network type of the DB cluster.
#' 
#' Valid values:
#' 
#' -   `IPV4`
#' 
#' -   `DUAL`
#' 
#' The network type is determined by the `DBSubnetGroup` specified for the
#' DB cluster. A `DBSubnetGroup` can support only the IPv4 protocol or the
#' IPv4 and the IPv6 protocols (`DUAL`).
#' 
#' For more information, see [Working with a DB instance in a
#' VPC](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html)
#' in the *Amazon Aurora User Guide.*
#' @param ManageMasterUserPassword A value that indicates whether to manage the master user password with
#' Amazon Web Services Secrets Manager.
#' 
#' For more information, see [Password management with Amazon Web Services
#' Secrets
#' Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html)
#' in the *Amazon RDS User Guide* and [Password management with Amazon Web
#' Services Secrets
#' Manager](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html)
#' in the *Amazon Aurora User Guide.*
#' 
#' Constraints:
#' 
#' -   Can't manage the master user password with Amazon Web Services
#'     Secrets Manager if `MasterUserPassword` is specified.
#' @param MasterUserSecretKmsKeyId The Amazon Web Services KMS key identifier to encrypt a secret that is
#' automatically generated and managed in Amazon Web Services Secrets
#' Manager.
#' 
#' This setting is valid only if the master user password is managed by RDS
#' in Amazon Web Services Secrets Manager for the DB cluster.
#' 
#' The Amazon Web Services KMS key identifier is the key ARN, key ID, alias
#' ARN, or alias name for the KMS key. To use a KMS key in a different
#' Amazon Web Services account, specify the key ARN or alias ARN.
#' 
#' If you don't specify `MasterUserSecretKmsKeyId`, then the
#' `aws/secretsmanager` KMS key is used to encrypt the secret. If the
#' secret is in a different Amazon Web Services account, then you can't use
#' the `aws/secretsmanager` KMS key to encrypt the secret, and you must use
#' a customer managed KMS key.
#' 
#' There is a default KMS key for your Amazon Web Services account. Your
#' Amazon Web Services account has a different default KMS key for each
#' Amazon Web Services Region.
#' @param StorageType Specifies the storage type to be associated with the DB cluster.
#' 
#' Valid values: `aurora`, `aurora-iopt1`
#' 
#' Default: `aurora`
#' 
#' Valid for: Aurora DB clusters only
#'
#' @keywords internal
#'
#' @rdname rds_restore_db_cluster_from_s3
rds_restore_db_cluster_from_s3 <- function(AvailabilityZones = NULL, BackupRetentionPeriod = NULL, CharacterSetName = NULL, DatabaseName = NULL, DBClusterIdentifier, DBClusterParameterGroupName = NULL, VpcSecurityGroupIds = NULL, DBSubnetGroupName = NULL, Engine, EngineVersion = NULL, Port = NULL, MasterUsername, MasterUserPassword = NULL, OptionGroupName = NULL, PreferredBackupWindow = NULL, PreferredMaintenanceWindow = NULL, Tags = NULL, StorageEncrypted = NULL, KmsKeyId = NULL, EnableIAMDatabaseAuthentication = NULL, SourceEngine, SourceEngineVersion, S3BucketName, S3Prefix = NULL, S3IngestionRoleArn, BacktrackWindow = NULL, EnableCloudwatchLogsExports = NULL, DeletionProtection = NULL, CopyTagsToSnapshot = NULL, Domain = NULL, DomainIAMRoleName = NULL, ServerlessV2ScalingConfiguration = NULL, NetworkType = NULL, ManageMasterUserPassword = NULL, MasterUserSecretKmsKeyId = NULL, StorageType = NULL) {
  op <- new_operation(
    name = "RestoreDBClusterFromS3",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$restore_db_cluster_from_s3_input(AvailabilityZones = AvailabilityZones, BackupRetentionPeriod = BackupRetentionPeriod, CharacterSetName = CharacterSetName, DatabaseName = DatabaseName, DBClusterIdentifier = DBClusterIdentifier, DBClusterParameterGroupName = DBClusterParameterGroupName, VpcSecurityGroupIds = VpcSecurityGroupIds, DBSubnetGroupName = DBSubnetGroupName, Engine = Engine, EngineVersion = EngineVersion, Port = Port, MasterUsername = MasterUsername, MasterUserPassword = MasterUserPassword, OptionGroupName = OptionGroupName, PreferredBackupWindow = PreferredBackupWindow, PreferredMaintenanceWindow = PreferredMaintenanceWindow, Tags = Tags, StorageEncrypted = StorageEncrypted, KmsKeyId = KmsKeyId, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, SourceEngine = SourceEngine, SourceEngineVersion = SourceEngineVersion, S3BucketName = S3BucketName, S3Prefix = S3Prefix, S3IngestionRoleArn = S3IngestionRoleArn, BacktrackWindow = BacktrackWindow, EnableCloudwatchLogsExports = EnableCloudwatchLogsExports, DeletionProtection = DeletionProtection, CopyTagsToSnapshot = CopyTagsToSnapshot, Domain = Domain, DomainIAMRoleName = DomainIAMRoleName, ServerlessV2ScalingConfiguration = ServerlessV2ScalingConfiguration, NetworkType = NetworkType, ManageMasterUserPassword = ManageMasterUserPassword, MasterUserSecretKmsKeyId = MasterUserSecretKmsKeyId, StorageType = StorageType)
  output <- .rds$restore_db_cluster_from_s3_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$restore_db_cluster_from_s3 <- rds_restore_db_cluster_from_s3

#' Creates a new DB cluster from a DB snapshot or DB cluster snapshot
#'
#' @description
#' Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_restore_db_cluster_from_snapshot/](https://www.paws-r-sdk.com/docs/rds_restore_db_cluster_from_snapshot/) for full documentation.
#'
#' @param AvailabilityZones Provides the list of Availability Zones (AZs) where instances in the
#' restored DB cluster can be created.
#' 
#' Valid for: Aurora DB clusters only
#' @param DBClusterIdentifier &#91;required&#93; The name of the DB cluster to create from the DB snapshot or DB cluster
#' snapshot. This parameter isn't case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens
#' 
#' -   First character must be a letter
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens
#' 
#' Example: `my-snapshot-id`
#' 
#' Valid for: Aurora DB clusters and Multi-AZ DB clusters
#' @param SnapshotIdentifier &#91;required&#93; The identifier for the DB snapshot or DB cluster snapshot to restore
#' from.
#' 
#' You can use either the name or the Amazon Resource Name (ARN) to specify
#' a DB cluster snapshot. However, you can use only the ARN to specify a DB
#' snapshot.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing Snapshot.
#' 
#' Valid for: Aurora DB clusters and Multi-AZ DB clusters
#' @param Engine &#91;required&#93; The database engine to use for the new DB cluster.
#' 
#' Default: The same as source
#' 
#' Constraint: Must be compatible with the engine of the source
#' 
#' Valid for: Aurora DB clusters and Multi-AZ DB clusters
#' @param EngineVersion The version of the database engine to use for the new DB cluster. If you
#' don't specify an engine version, the default version for the database
#' engine in the Amazon Web Services Region is used.
#' 
#' To list all of the available engine versions for Aurora MySQL, use the
#' following command:
#' 
#' `aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"`
#' 
#' To list all of the available engine versions for Aurora PostgreSQL, use
#' the following command:
#' 
#' `aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"`
#' 
#' To list all of the available engine versions for RDS for MySQL, use the
#' following command:
#' 
#' `aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"`
#' 
#' To list all of the available engine versions for RDS for PostgreSQL, use
#' the following command:
#' 
#' `aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"`
#' 
#' **Aurora MySQL**
#' 
#' See [Database engine updates for Amazon Aurora
#' MySQL](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html)
#' in the *Amazon Aurora User Guide*.
#' 
#' **Aurora PostgreSQL**
#' 
#' See [Amazon Aurora PostgreSQL releases and engine
#' versions](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.20180305.html)
#' in the *Amazon Aurora User Guide*.
#' 
#' **MySQL**
#' 
#' See [Amazon RDS for
#' MySQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt)
#' in the *Amazon RDS User Guide.*
#' 
#' **PostgreSQL**
#' 
#' See [Amazon RDS for PostgreSQL versions and
#' extensions](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts)
#' in the *Amazon RDS User Guide.*
#' 
#' Valid for: Aurora DB clusters and Multi-AZ DB clusters
#' @param Port The port number on which the new DB cluster accepts connections.
#' 
#' Constraints: This value must be `1150-65535`
#' 
#' Default: The same port as the original DB cluster.
#' 
#' Valid for: Aurora DB clusters and Multi-AZ DB clusters
#' @param DBSubnetGroupName The name of the DB subnet group to use for the new DB cluster.
#' 
#' Constraints: If supplied, must match the name of an existing DB subnet
#' group.
#' 
#' Example: `mydbsubnetgroup`
#' 
#' Valid for: Aurora DB clusters and Multi-AZ DB clusters
#' @param DatabaseName The database name for the restored DB cluster.
#' 
#' Valid for: Aurora DB clusters and Multi-AZ DB clusters
#' @param OptionGroupName The name of the option group to use for the restored DB cluster.
#' 
#' DB clusters are associated with a default option group that can't be
#' modified.
#' @param VpcSecurityGroupIds A list of VPC security groups that the new DB cluster will belong to.
#' 
#' Valid for: Aurora DB clusters and Multi-AZ DB clusters
#' @param Tags The tags to be assigned to the restored DB cluster.
#' 
#' Valid for: Aurora DB clusters and Multi-AZ DB clusters
#' @param KmsKeyId The Amazon Web Services KMS key identifier to use when restoring an
#' encrypted DB cluster from a DB snapshot or DB cluster snapshot.
#' 
#' The Amazon Web Services KMS key identifier is the key ARN, key ID, alias
#' ARN, or alias name for the KMS key. To use a KMS key in a different
#' Amazon Web Services account, specify the key ARN or alias ARN.
#' 
#' When you don't specify a value for the `KmsKeyId` parameter, then the
#' following occurs:
#' 
#' -   If the DB snapshot or DB cluster snapshot in `SnapshotIdentifier` is
#'     encrypted, then the restored DB cluster is encrypted using the KMS
#'     key that was used to encrypt the DB snapshot or DB cluster snapshot.
#' 
#' -   If the DB snapshot or DB cluster snapshot in `SnapshotIdentifier`
#'     isn't encrypted, then the restored DB cluster isn't encrypted.
#' 
#' Valid for: Aurora DB clusters and Multi-AZ DB clusters
#' @param EnableIAMDatabaseAuthentication A value that indicates whether to enable mapping of Amazon Web Services
#' Identity and Access Management (IAM) accounts to database accounts. By
#' default, mapping isn't enabled.
#' 
#' For more information, see [IAM Database
#' Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html)
#' in the *Amazon Aurora User Guide*.
#' 
#' Valid for: Aurora DB clusters only
#' @param BacktrackWindow The target backtrack window, in seconds. To disable backtracking, set
#' this value to 0.
#' 
#' Currently, Backtrack is only supported for Aurora MySQL DB clusters.
#' 
#' Default: 0
#' 
#' Constraints:
#' 
#' -   If specified, this value must be set to a number from 0 to 259,200
#'     (72 hours).
#' 
#' Valid for: Aurora DB clusters only
#' @param EnableCloudwatchLogsExports The list of logs that the restored DB cluster is to export to Amazon
#' CloudWatch Logs. The values in the list depend on the DB engine being
#' used.
#' 
#' **RDS for MySQL**
#' 
#' Possible values are `error`, `general`, and `slowquery`.
#' 
#' **RDS for PostgreSQL**
#' 
#' Possible values are `postgresql` and `upgrade`.
#' 
#' **Aurora MySQL**
#' 
#' Possible values are `audit`, `error`, `general`, and `slowquery`.
#' 
#' **Aurora PostgreSQL**
#' 
#' Possible value is `postgresql`.
#' 
#' For more information about exporting CloudWatch Logs for Amazon RDS, see
#' [Publishing Database Logs to Amazon CloudWatch
#' Logs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch)
#' in the *Amazon RDS User Guide*.
#' 
#' For more information about exporting CloudWatch Logs for Amazon Aurora,
#' see [Publishing Database Logs to Amazon CloudWatch
#' Logs](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch)
#' in the *Amazon Aurora User Guide*.
#' 
#' Valid for: Aurora DB clusters and Multi-AZ DB clusters
#' @param EngineMode The DB engine mode of the DB cluster, either `provisioned` or
#' `serverless`.
#' 
#' For more information, see
#' [CreateDBCluster](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html).
#' 
#' Valid for: Aurora DB clusters only
#' @param ScalingConfiguration For DB clusters in `serverless` DB engine mode, the scaling properties
#' of the DB cluster.
#' 
#' Valid for: Aurora DB clusters only
#' @param DBClusterParameterGroupName The name of the DB cluster parameter group to associate with this DB
#' cluster. If this argument is omitted, the default DB cluster parameter
#' group for the specified engine is used.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing default DB cluster
#'     parameter group.
#' 
#' -   Must be 1 to 255 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens.
#' 
#' Valid for: Aurora DB clusters and Multi-AZ DB clusters
#' @param DeletionProtection A value that indicates whether the DB cluster has deletion protection
#' enabled. The database can't be deleted when deletion protection is
#' enabled. By default, deletion protection isn't enabled.
#' 
#' Valid for: Aurora DB clusters and Multi-AZ DB clusters
#' @param CopyTagsToSnapshot A value that indicates whether to copy all tags from the restored DB
#' cluster to snapshots of the restored DB cluster. The default is not to
#' copy them.
#' 
#' Valid for: Aurora DB clusters and Multi-AZ DB clusters
#' @param Domain Specify the Active Directory directory ID to restore the DB cluster in.
#' The domain must be created prior to this operation. Currently, only
#' MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be
#' created in an Active Directory Domain.
#' 
#' For more information, see [Kerberos
#' Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/database-authentication.html)
#' in the *Amazon RDS User Guide*.
#' 
#' Valid for: Aurora DB clusters only
#' @param DomainIAMRoleName Specify the name of the IAM role to be used when making API calls to the
#' Directory Service.
#' 
#' Valid for: Aurora DB clusters only
#' @param DBClusterInstanceClass The compute and memory capacity of the each DB instance in the Multi-AZ
#' DB cluster, for example db.m6gd.xlarge. Not all DB instance classes are
#' available in all Amazon Web Services Regions, or for all database
#' engines.
#' 
#' For the full list of DB instance classes, and availability for your
#' engine, see [DB Instance
#' Class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html)
#' in the *Amazon RDS User Guide.*
#' 
#' Valid for: Multi-AZ DB clusters only
#' @param StorageType Specifies the storage type to be associated with the DB cluster.
#' 
#' When specified for a Multi-AZ DB cluster, a value for the `Iops`
#' parameter is required.
#' 
#' Valid values: `aurora`, `aurora-iopt1` (Aurora DB clusters); `io1`
#' (Multi-AZ DB clusters)
#' 
#' Default: `aurora` (Aurora DB clusters); `io1` (Multi-AZ DB clusters)
#' 
#' Valid for: Aurora DB clusters and Multi-AZ DB clusters
#' @param Iops The amount of Provisioned IOPS (input/output operations per second) to
#' be initially allocated for each DB instance in the Multi-AZ DB cluster.
#' 
#' For information about valid IOPS values, see [Amazon RDS Provisioned
#' IOPS
#' storage](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS)
#' in the *Amazon RDS User Guide*.
#' 
#' Constraints: Must be a multiple between .5 and 50 of the storage amount
#' for the DB instance.
#' 
#' Valid for: Aurora DB clusters and Multi-AZ DB clusters
#' @param PubliclyAccessible A value that indicates whether the DB cluster is publicly accessible.
#' 
#' When the DB cluster is publicly accessible, its Domain Name System (DNS)
#' endpoint resolves to the private IP address from within the DB cluster's
#' virtual private cloud (VPC). It resolves to the public IP address from
#' outside of the DB cluster's VPC. Access to the DB cluster is ultimately
#' controlled by the security group it uses. That public access is not
#' permitted if the security group assigned to the DB cluster doesn't
#' permit it.
#' 
#' When the DB cluster isn't publicly accessible, it is an internal DB
#' cluster with a DNS name that resolves to a private IP address.
#' 
#' Default: The default behavior varies depending on whether
#' `DBSubnetGroupName` is specified.
#' 
#' If `DBSubnetGroupName` isn't specified, and `PubliclyAccessible` isn't
#' specified, the following applies:
#' 
#' -   If the default VPC in the target Region doesn’t have an internet
#'     gateway attached to it, the DB cluster is private.
#' 
#' -   If the default VPC in the target Region has an internet gateway
#'     attached to it, the DB cluster is public.
#' 
#' If `DBSubnetGroupName` is specified, and `PubliclyAccessible` isn't
#' specified, the following applies:
#' 
#' -   If the subnets are part of a VPC that doesn’t have an internet
#'     gateway attached to it, the DB cluster is private.
#' 
#' -   If the subnets are part of a VPC that has an internet gateway
#'     attached to it, the DB cluster is public.
#' 
#' Valid for: Aurora DB clusters and Multi-AZ DB clusters
#' @param ServerlessV2ScalingConfiguration 
#' @param NetworkType The network type of the DB cluster.
#' 
#' Valid values:
#' 
#' -   `IPV4`
#' 
#' -   `DUAL`
#' 
#' The network type is determined by the `DBSubnetGroup` specified for the
#' DB cluster. A `DBSubnetGroup` can support only the IPv4 protocol or the
#' IPv4 and the IPv6 protocols (`DUAL`).
#' 
#' For more information, see [Working with a DB instance in a
#' VPC](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html)
#' in the *Amazon Aurora User Guide.*
#' 
#' Valid for: Aurora DB clusters only
#'
#' @keywords internal
#'
#' @rdname rds_restore_db_cluster_from_snapshot
rds_restore_db_cluster_from_snapshot <- function(AvailabilityZones = NULL, DBClusterIdentifier, SnapshotIdentifier, Engine, EngineVersion = NULL, Port = NULL, DBSubnetGroupName = NULL, DatabaseName = NULL, OptionGroupName = NULL, VpcSecurityGroupIds = NULL, Tags = NULL, KmsKeyId = NULL, EnableIAMDatabaseAuthentication = NULL, BacktrackWindow = NULL, EnableCloudwatchLogsExports = NULL, EngineMode = NULL, ScalingConfiguration = NULL, DBClusterParameterGroupName = NULL, DeletionProtection = NULL, CopyTagsToSnapshot = NULL, Domain = NULL, DomainIAMRoleName = NULL, DBClusterInstanceClass = NULL, StorageType = NULL, Iops = NULL, PubliclyAccessible = NULL, ServerlessV2ScalingConfiguration = NULL, NetworkType = NULL) {
  op <- new_operation(
    name = "RestoreDBClusterFromSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$restore_db_cluster_from_snapshot_input(AvailabilityZones = AvailabilityZones, DBClusterIdentifier = DBClusterIdentifier, SnapshotIdentifier = SnapshotIdentifier, Engine = Engine, EngineVersion = EngineVersion, Port = Port, DBSubnetGroupName = DBSubnetGroupName, DatabaseName = DatabaseName, OptionGroupName = OptionGroupName, VpcSecurityGroupIds = VpcSecurityGroupIds, Tags = Tags, KmsKeyId = KmsKeyId, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, BacktrackWindow = BacktrackWindow, EnableCloudwatchLogsExports = EnableCloudwatchLogsExports, EngineMode = EngineMode, ScalingConfiguration = ScalingConfiguration, DBClusterParameterGroupName = DBClusterParameterGroupName, DeletionProtection = DeletionProtection, CopyTagsToSnapshot = CopyTagsToSnapshot, Domain = Domain, DomainIAMRoleName = DomainIAMRoleName, DBClusterInstanceClass = DBClusterInstanceClass, StorageType = StorageType, Iops = Iops, PubliclyAccessible = PubliclyAccessible, ServerlessV2ScalingConfiguration = ServerlessV2ScalingConfiguration, NetworkType = NetworkType)
  output <- .rds$restore_db_cluster_from_snapshot_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$restore_db_cluster_from_snapshot <- rds_restore_db_cluster_from_snapshot

#' Restores a DB cluster to an arbitrary point in time
#'
#' @description
#' Restores a DB cluster to an arbitrary point in time. Users can restore to any point in time before `LatestRestorableTime` for up to `BackupRetentionPeriod` days. The target DB cluster is created from the source DB cluster with the same configuration as the original DB cluster, except that the new DB cluster is created with the default DB security group.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_restore_db_cluster_to_point_in_time/](https://www.paws-r-sdk.com/docs/rds_restore_db_cluster_to_point_in_time/) for full documentation.
#'
#' @param DBClusterIdentifier &#91;required&#93; The name of the new DB cluster to be created.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens
#' 
#' -   First character must be a letter
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens
#' 
#' Valid for: Aurora DB clusters and Multi-AZ DB clusters
#' @param RestoreType The type of restore to be performed. You can specify one of the
#' following values:
#' 
#' -   `full-copy` - The new DB cluster is restored as a full copy of the
#'     source DB cluster.
#' 
#' -   `copy-on-write` - The new DB cluster is restored as a clone of the
#'     source DB cluster.
#' 
#' If you don't specify a `RestoreType` value, then the new DB cluster is
#' restored as a full copy of the source DB cluster.
#' 
#' Valid for: Aurora DB clusters and Multi-AZ DB clusters
#' @param SourceDBClusterIdentifier The identifier of the source DB cluster from which to restore.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DBCluster.
#' 
#' Valid for: Aurora DB clusters and Multi-AZ DB clusters
#' @param RestoreToTime The date and time to restore the DB cluster to.
#' 
#' Valid Values: Value must be a time in Universal Coordinated Time (UTC)
#' format
#' 
#' Constraints:
#' 
#' -   Must be before the latest restorable time for the DB instance
#' 
#' -   Must be specified if `UseLatestRestorableTime` parameter isn't
#'     provided
#' 
#' -   Can't be specified if the `UseLatestRestorableTime` parameter is
#'     enabled
#' 
#' -   Can't be specified if the `RestoreType` parameter is `copy-on-write`
#' 
#' Example: `2015-03-07T23:45:00Z`
#' 
#' Valid for: Aurora DB clusters and Multi-AZ DB clusters
#' @param UseLatestRestorableTime A value that indicates whether to restore the DB cluster to the latest
#' restorable backup time. By default, the DB cluster isn't restored to the
#' latest restorable backup time.
#' 
#' Constraints: Can't be specified if `RestoreToTime` parameter is
#' provided.
#' 
#' Valid for: Aurora DB clusters and Multi-AZ DB clusters
#' @param Port The port number on which the new DB cluster accepts connections.
#' 
#' Constraints: A value from `1150-65535`.
#' 
#' Default: The default port for the engine.
#' 
#' Valid for: Aurora DB clusters and Multi-AZ DB clusters
#' @param DBSubnetGroupName The DB subnet group name to use for the new DB cluster.
#' 
#' Constraints: If supplied, must match the name of an existing
#' DBSubnetGroup.
#' 
#' Example: `mydbsubnetgroup`
#' 
#' Valid for: Aurora DB clusters and Multi-AZ DB clusters
#' @param OptionGroupName The name of the option group for the new DB cluster.
#' 
#' DB clusters are associated with a default option group that can't be
#' modified.
#' @param VpcSecurityGroupIds A list of VPC security groups that the new DB cluster belongs to.
#' 
#' Valid for: Aurora DB clusters and Multi-AZ DB clusters
#' @param Tags 
#' @param KmsKeyId The Amazon Web Services KMS key identifier to use when restoring an
#' encrypted DB cluster from an encrypted DB cluster.
#' 
#' The Amazon Web Services KMS key identifier is the key ARN, key ID, alias
#' ARN, or alias name for the KMS key. To use a KMS key in a different
#' Amazon Web Services account, specify the key ARN or alias ARN.
#' 
#' You can restore to a new DB cluster and encrypt the new DB cluster with
#' a KMS key that is different from the KMS key used to encrypt the source
#' DB cluster. The new DB cluster is encrypted with the KMS key identified
#' by the `KmsKeyId` parameter.
#' 
#' If you don't specify a value for the `KmsKeyId` parameter, then the
#' following occurs:
#' 
#' -   If the DB cluster is encrypted, then the restored DB cluster is
#'     encrypted using the KMS key that was used to encrypt the source DB
#'     cluster.
#' 
#' -   If the DB cluster isn't encrypted, then the restored DB cluster
#'     isn't encrypted.
#' 
#' If `DBClusterIdentifier` refers to a DB cluster that isn't encrypted,
#' then the restore request is rejected.
#' 
#' Valid for: Aurora DB clusters and Multi-AZ DB clusters
#' @param EnableIAMDatabaseAuthentication A value that indicates whether to enable mapping of Amazon Web Services
#' Identity and Access Management (IAM) accounts to database accounts. By
#' default, mapping isn't enabled.
#' 
#' For more information, see [IAM Database
#' Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html)
#' in the *Amazon Aurora User Guide*.
#' 
#' Valid for: Aurora DB clusters only
#' @param BacktrackWindow The target backtrack window, in seconds. To disable backtracking, set
#' this value to 0.
#' 
#' Default: 0
#' 
#' Constraints:
#' 
#' -   If specified, this value must be set to a number from 0 to 259,200
#'     (72 hours).
#' 
#' Valid for: Aurora MySQL DB clusters only
#' @param EnableCloudwatchLogsExports The list of logs that the restored DB cluster is to export to CloudWatch
#' Logs. The values in the list depend on the DB engine being used.
#' 
#' **RDS for MySQL**
#' 
#' Possible values are `error`, `general`, and `slowquery`.
#' 
#' **RDS for PostgreSQL**
#' 
#' Possible values are `postgresql` and `upgrade`.
#' 
#' **Aurora MySQL**
#' 
#' Possible values are `audit`, `error`, `general`, and `slowquery`.
#' 
#' **Aurora PostgreSQL**
#' 
#' Possible value is `postgresql`.
#' 
#' For more information about exporting CloudWatch Logs for Amazon RDS, see
#' [Publishing Database Logs to Amazon CloudWatch
#' Logs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch)
#' in the *Amazon RDS User Guide*.
#' 
#' For more information about exporting CloudWatch Logs for Amazon Aurora,
#' see [Publishing Database Logs to Amazon CloudWatch
#' Logs](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch)
#' in the *Amazon Aurora User Guide*.
#' 
#' Valid for: Aurora DB clusters and Multi-AZ DB clusters
#' @param DBClusterParameterGroupName The name of the DB cluster parameter group to associate with this DB
#' cluster. If this argument is omitted, the default DB cluster parameter
#' group for the specified engine is used.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing DB cluster parameter
#'     group.
#' 
#' -   Must be 1 to 255 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens.
#' 
#' Valid for: Aurora DB clusters and Multi-AZ DB clusters
#' @param DeletionProtection A value that indicates whether the DB cluster has deletion protection
#' enabled. The database can't be deleted when deletion protection is
#' enabled. By default, deletion protection isn't enabled.
#' 
#' Valid for: Aurora DB clusters and Multi-AZ DB clusters
#' @param CopyTagsToSnapshot A value that indicates whether to copy all tags from the restored DB
#' cluster to snapshots of the restored DB cluster. The default is not to
#' copy them.
#' 
#' Valid for: Aurora DB clusters and Multi-AZ DB clusters
#' @param Domain Specify the Active Directory directory ID to restore the DB cluster in.
#' The domain must be created prior to this operation.
#' 
#' For Amazon Aurora DB clusters, Amazon RDS can use Kerberos
#' Authentication to authenticate users that connect to the DB cluster. For
#' more information, see [Kerberos
#' Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/database-authentication.html)
#' in the *Amazon Aurora User Guide*.
#' 
#' Valid for: Aurora DB clusters only
#' @param DomainIAMRoleName Specify the name of the IAM role to be used when making API calls to the
#' Directory Service.
#' 
#' Valid for: Aurora DB clusters only
#' @param ScalingConfiguration For DB clusters in `serverless` DB engine mode, the scaling properties
#' of the DB cluster.
#' 
#' Valid for: Aurora DB clusters only
#' @param EngineMode The engine mode of the new cluster. Specify `provisioned` or
#' `serverless`, depending on the type of the cluster you are creating. You
#' can create an Aurora Serverless v1 clone from a provisioned cluster, or
#' a provisioned clone from an Aurora Serverless v1 cluster. To create a
#' clone that is an Aurora Serverless v1 cluster, the original cluster must
#' be an Aurora Serverless v1 cluster or an encrypted provisioned cluster.
#' 
#' Valid for: Aurora DB clusters only
#' @param DBClusterInstanceClass The compute and memory capacity of the each DB instance in the Multi-AZ
#' DB cluster, for example db.m6gd.xlarge. Not all DB instance classes are
#' available in all Amazon Web Services Regions, or for all database
#' engines.
#' 
#' For the full list of DB instance classes, and availability for your
#' engine, see [DB instance
#' class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html)
#' in the *Amazon RDS User Guide.*
#' 
#' Valid for: Multi-AZ DB clusters only
#' @param StorageType Specifies the storage type to be associated with the DB cluster.
#' 
#' When specified for a Multi-AZ DB cluster, a value for the `Iops`
#' parameter is required.
#' 
#' Valid values: `aurora`, `aurora-iopt1` (Aurora DB clusters); `io1`
#' (Multi-AZ DB clusters)
#' 
#' Default: `aurora` (Aurora DB clusters); `io1` (Multi-AZ DB clusters)
#' 
#' Valid for: Aurora DB clusters and Multi-AZ DB clusters
#' @param PubliclyAccessible A value that indicates whether the DB cluster is publicly accessible.
#' 
#' When the DB cluster is publicly accessible, its Domain Name System (DNS)
#' endpoint resolves to the private IP address from within the DB cluster's
#' virtual private cloud (VPC). It resolves to the public IP address from
#' outside of the DB cluster's VPC. Access to the DB cluster is ultimately
#' controlled by the security group it uses. That public access is not
#' permitted if the security group assigned to the DB cluster doesn't
#' permit it.
#' 
#' When the DB cluster isn't publicly accessible, it is an internal DB
#' cluster with a DNS name that resolves to a private IP address.
#' 
#' Default: The default behavior varies depending on whether
#' `DBSubnetGroupName` is specified.
#' 
#' If `DBSubnetGroupName` isn't specified, and `PubliclyAccessible` isn't
#' specified, the following applies:
#' 
#' -   If the default VPC in the target Region doesn’t have an internet
#'     gateway attached to it, the DB cluster is private.
#' 
#' -   If the default VPC in the target Region has an internet gateway
#'     attached to it, the DB cluster is public.
#' 
#' If `DBSubnetGroupName` is specified, and `PubliclyAccessible` isn't
#' specified, the following applies:
#' 
#' -   If the subnets are part of a VPC that doesn’t have an internet
#'     gateway attached to it, the DB cluster is private.
#' 
#' -   If the subnets are part of a VPC that has an internet gateway
#'     attached to it, the DB cluster is public.
#' 
#' Valid for: Multi-AZ DB clusters only
#' @param Iops The amount of Provisioned IOPS (input/output operations per second) to
#' be initially allocated for each DB instance in the Multi-AZ DB cluster.
#' 
#' For information about valid IOPS values, see [Amazon RDS Provisioned
#' IOPS
#' storage](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS)
#' in the *Amazon RDS User Guide*.
#' 
#' Constraints: Must be a multiple between .5 and 50 of the storage amount
#' for the DB instance.
#' 
#' Valid for: Multi-AZ DB clusters only
#' @param ServerlessV2ScalingConfiguration 
#' @param NetworkType The network type of the DB cluster.
#' 
#' Valid values:
#' 
#' -   `IPV4`
#' 
#' -   `DUAL`
#' 
#' The network type is determined by the `DBSubnetGroup` specified for the
#' DB cluster. A `DBSubnetGroup` can support only the IPv4 protocol or the
#' IPv4 and the IPv6 protocols (`DUAL`).
#' 
#' For more information, see [Working with a DB instance in a
#' VPC](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html)
#' in the *Amazon Aurora User Guide.*
#' 
#' Valid for: Aurora DB clusters only
#' @param SourceDbClusterResourceId The resource ID of the source DB cluster from which to restore.
#'
#' @keywords internal
#'
#' @rdname rds_restore_db_cluster_to_point_in_time
rds_restore_db_cluster_to_point_in_time <- function(DBClusterIdentifier, RestoreType = NULL, SourceDBClusterIdentifier = NULL, RestoreToTime = NULL, UseLatestRestorableTime = NULL, Port = NULL, DBSubnetGroupName = NULL, OptionGroupName = NULL, VpcSecurityGroupIds = NULL, Tags = NULL, KmsKeyId = NULL, EnableIAMDatabaseAuthentication = NULL, BacktrackWindow = NULL, EnableCloudwatchLogsExports = NULL, DBClusterParameterGroupName = NULL, DeletionProtection = NULL, CopyTagsToSnapshot = NULL, Domain = NULL, DomainIAMRoleName = NULL, ScalingConfiguration = NULL, EngineMode = NULL, DBClusterInstanceClass = NULL, StorageType = NULL, PubliclyAccessible = NULL, Iops = NULL, ServerlessV2ScalingConfiguration = NULL, NetworkType = NULL, SourceDbClusterResourceId = NULL) {
  op <- new_operation(
    name = "RestoreDBClusterToPointInTime",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$restore_db_cluster_to_point_in_time_input(DBClusterIdentifier = DBClusterIdentifier, RestoreType = RestoreType, SourceDBClusterIdentifier = SourceDBClusterIdentifier, RestoreToTime = RestoreToTime, UseLatestRestorableTime = UseLatestRestorableTime, Port = Port, DBSubnetGroupName = DBSubnetGroupName, OptionGroupName = OptionGroupName, VpcSecurityGroupIds = VpcSecurityGroupIds, Tags = Tags, KmsKeyId = KmsKeyId, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, BacktrackWindow = BacktrackWindow, EnableCloudwatchLogsExports = EnableCloudwatchLogsExports, DBClusterParameterGroupName = DBClusterParameterGroupName, DeletionProtection = DeletionProtection, CopyTagsToSnapshot = CopyTagsToSnapshot, Domain = Domain, DomainIAMRoleName = DomainIAMRoleName, ScalingConfiguration = ScalingConfiguration, EngineMode = EngineMode, DBClusterInstanceClass = DBClusterInstanceClass, StorageType = StorageType, PubliclyAccessible = PubliclyAccessible, Iops = Iops, ServerlessV2ScalingConfiguration = ServerlessV2ScalingConfiguration, NetworkType = NetworkType, SourceDbClusterResourceId = SourceDbClusterResourceId)
  output <- .rds$restore_db_cluster_to_point_in_time_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$restore_db_cluster_to_point_in_time <- rds_restore_db_cluster_to_point_in_time

#' Creates a new DB instance from a DB snapshot
#'
#' @description
#' Creates a new DB instance from a DB snapshot. The target database is created from the source database restore point with most of the source's original configuration, including the default security group and DB parameter group. By default, the new DB instance is created as a Single-AZ deployment, except when the instance is a SQL Server instance that has an option group associated with mirroring. In this case, the instance becomes a Multi-AZ deployment, not a Single-AZ deployment.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_restore_db_instance_from_db_snapshot/](https://www.paws-r-sdk.com/docs/rds_restore_db_instance_from_db_snapshot/) for full documentation.
#'
#' @param DBInstanceIdentifier &#91;required&#93; Name of the DB instance to create from the DB snapshot. This parameter
#' isn't case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 numbers, letters, or hyphens
#' 
#' -   First character must be a letter
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens
#' 
#' Example: `my-snapshot-id`
#' @param DBSnapshotIdentifier The identifier for the DB snapshot to restore from.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DBSnapshot.
#' 
#' -   Can't be specified when `DBClusterSnapshotIdentifier` is specified.
#' 
#' -   Must be specified when `DBClusterSnapshotIdentifier` isn't
#'     specified.
#' 
#' -   If you are restoring from a shared manual DB snapshot, the
#'     `DBSnapshotIdentifier` must be the ARN of the shared DB snapshot.
#' @param DBInstanceClass The compute and memory capacity of the Amazon RDS DB instance, for
#' example db.m4.large. Not all DB instance classes are available in all
#' Amazon Web Services Regions, or for all database engines. For the full
#' list of DB instance classes, and availability for your engine, see [DB
#' Instance
#' Class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html)
#' in the *Amazon RDS User Guide.*
#' 
#' Default: The same DBInstanceClass as the original DB instance.
#' @param Port The port number on which the database accepts connections.
#' 
#' Default: The same port as the original DB instance
#' 
#' Constraints: Value must be `1150-65535`
#' @param AvailabilityZone The Availability Zone (AZ) where the DB instance will be created.
#' 
#' Default: A random, system-chosen Availability Zone.
#' 
#' Constraint: You can't specify the `AvailabilityZone` parameter if the DB
#' instance is a Multi-AZ deployment.
#' 
#' Example: `us-east-1a`
#' @param DBSubnetGroupName The DB subnet group name to use for the new instance.
#' 
#' Constraints: If supplied, must match the name of an existing
#' DBSubnetGroup.
#' 
#' Example: `mydbsubnetgroup`
#' @param MultiAZ A value that indicates whether the DB instance is a Multi-AZ deployment.
#' 
#' This setting doesn't apply to RDS Custom.
#' 
#' Constraint: You can't specify the `AvailabilityZone` parameter if the DB
#' instance is a Multi-AZ deployment.
#' @param PubliclyAccessible A value that indicates whether the DB instance is publicly accessible.
#' 
#' When the DB instance is publicly accessible, its Domain Name System
#' (DNS) endpoint resolves to the private IP address from within the DB
#' instance's virtual private cloud (VPC). It resolves to the public IP
#' address from outside of the DB instance's VPC. Access to the DB instance
#' is ultimately controlled by the security group it uses. That public
#' access is not permitted if the security group assigned to the DB
#' instance doesn't permit it.
#' 
#' When the DB instance isn't publicly accessible, it is an internal DB
#' instance with a DNS name that resolves to a private IP address.
#' 
#' For more information, see
#' [`create_db_instance`][rds_create_db_instance].
#' @param AutoMinorVersionUpgrade A value that indicates whether minor version upgrades are applied
#' automatically to the DB instance during the maintenance window.
#' 
#' If you restore an RDS Custom DB instance, you must disable this
#' parameter.
#' @param LicenseModel License model information for the restored DB instance.
#' 
#' This setting doesn't apply to RDS Custom.
#' 
#' Default: Same as source.
#' 
#' Valid values: `license-included` | `bring-your-own-license` |
#' `general-public-license`
#' @param DBName The database name for the restored DB instance.
#' 
#' This parameter doesn't apply to the MySQL, PostgreSQL, or MariaDB
#' engines. It also doesn't apply to RDS Custom DB instances.
#' @param Engine The database engine to use for the new instance.
#' 
#' This setting doesn't apply to RDS Custom.
#' 
#' Default: The same as source
#' 
#' Constraint: Must be compatible with the engine of the source. For
#' example, you can restore a MariaDB 10.1 DB instance from a MySQL 5.6
#' snapshot.
#' 
#' Valid Values:
#' 
#' -   `mariadb`
#' 
#' -   `mysql`
#' 
#' -   `oracle-ee`
#' 
#' -   `oracle-ee-cdb`
#' 
#' -   `oracle-se2`
#' 
#' -   `oracle-se2-cdb`
#' 
#' -   `postgres`
#' 
#' -   `sqlserver-ee`
#' 
#' -   `sqlserver-se`
#' 
#' -   `sqlserver-ex`
#' 
#' -   `sqlserver-web`
#' @param Iops Specifies the amount of provisioned IOPS for the DB instance, expressed
#' in I/O operations per second. If this parameter isn't specified, the
#' IOPS value is taken from the backup. If this parameter is set to 0, the
#' new instance is converted to a non-PIOPS instance. The conversion takes
#' additional time, though your DB instance is available for connections
#' before the conversion starts.
#' 
#' The provisioned IOPS value must follow the requirements for your
#' database engine. For more information, see [Amazon RDS Provisioned IOPS
#' storage](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS)
#' in the *Amazon RDS User Guide.*
#' 
#' Constraints: Must be an integer greater than 1000.
#' @param OptionGroupName The name of the option group to be used for the restored DB instance.
#' 
#' Permanent options, such as the TDE option for Oracle Advanced Security
#' TDE, can't be removed from an option group, and that option group can't
#' be removed from a DB instance after it is associated with a DB instance.
#' 
#' This setting doesn't apply to RDS Custom.
#' @param Tags 
#' @param StorageType Specifies the storage type to be associated with the DB instance.
#' 
#' Valid values: `gp2 | gp3 | io1 | standard`
#' 
#' If you specify `io1` or `gp3`, you must also include a value for the
#' `Iops` parameter.
#' 
#' Default: `io1` if the `Iops` parameter is specified, otherwise `gp2`
#' @param TdeCredentialArn The ARN from the key store with which to associate the instance for TDE
#' encryption.
#' 
#' This setting doesn't apply to RDS Custom.
#' @param TdeCredentialPassword The password for the given ARN from the key store in order to access the
#' device.
#' 
#' This setting doesn't apply to RDS Custom.
#' @param VpcSecurityGroupIds A list of EC2 VPC security groups to associate with this DB instance.
#' 
#' Default: The default EC2 VPC security group for the DB subnet group's
#' VPC.
#' @param Domain Specify the Active Directory directory ID to restore the DB instance in.
#' The domain/ must be created prior to this operation. Currently, you can
#' create only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB
#' instances in an Active Directory Domain.
#' 
#' For more information, see [Kerberos
#' Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/database-authentication.html)
#' in the *Amazon RDS User Guide*.
#' 
#' This setting doesn't apply to RDS Custom.
#' @param DomainFqdn The fully qualified domain name (FQDN) of an Active Directory domain.
#' 
#' Constraints:
#' 
#' -   Can't be longer than 64 characters.
#' 
#' Example: `mymanagedADtest.mymanagedAD.mydomain`
#' @param DomainOu The Active Directory organizational unit for your DB instance to join.
#' 
#' Constraints:
#' 
#' -   Must be in the distinguished name format.
#' 
#' -   Can't be longer than 64 characters.
#' 
#' Example:
#' `OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain`
#' @param DomainAuthSecretArn The ARN for the Secrets Manager secret with the credentials for the user
#' joining the domain.
#' 
#' Constraints:
#' 
#' Example:
#' `arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456`
#' @param DomainDnsIps The IPv4 DNS IP addresses of your primary and secondary Active Directory
#' domain controllers.
#' 
#' Constraints:
#' 
#' -   Two IP addresses must be provided. If there isn't a secondary domain
#'     controller, use the IP address of the primary domain controller for
#'     both entries in the list.
#' 
#' Example: `123.124.125.126,234.235.236.237`
#' @param CopyTagsToSnapshot A value that indicates whether to copy all tags from the restored DB
#' instance to snapshots of the DB instance.
#' 
#' In most cases, tags aren't copied by default. However, when you restore
#' a DB instance from a DB snapshot, RDS checks whether you specify new
#' tags. If yes, the new tags are added to the restored DB instance. If
#' there are no new tags, RDS looks for the tags from the source DB
#' instance for the DB snapshot, and then adds those tags to the restored
#' DB instance.
#' 
#' For more information, see [Copying tags to DB instance
#' snapshots](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html#USER_Tagging.CopyTags)
#' in the *Amazon RDS User Guide*.
#' @param DomainIAMRoleName The name of the IAM role to use when making API calls to the Directory
#' Service.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' @param EnableIAMDatabaseAuthentication A value that indicates whether to enable mapping of Amazon Web Services
#' Identity and Access Management (IAM) accounts to database accounts. By
#' default, mapping is disabled.
#' 
#' For more information about IAM database authentication, see [IAM
#' Database Authentication for MySQL and
#' PostgreSQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html)
#' in the *Amazon RDS User Guide.*
#' 
#' This setting doesn't apply to RDS Custom.
#' @param EnableCloudwatchLogsExports The list of logs that the restored DB instance is to export to
#' CloudWatch Logs. The values in the list depend on the DB engine being
#' used. For more information, see [Publishing Database Logs to Amazon
#' CloudWatch
#' Logs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch)
#' in the *Amazon RDS User Guide*.
#' 
#' This setting doesn't apply to RDS Custom.
#' @param ProcessorFeatures The number of CPU cores and the number of threads per core for the DB
#' instance class of the DB instance.
#' 
#' This setting doesn't apply to RDS Custom.
#' @param UseDefaultProcessorFeatures A value that indicates whether the DB instance class of the DB instance
#' uses its default processor features.
#' 
#' This setting doesn't apply to RDS Custom.
#' @param DBParameterGroupName The name of the DB parameter group to associate with this DB instance.
#' 
#' If you don't specify a value for `DBParameterGroupName`, then RDS uses
#' the default `DBParameterGroup` for the specified DB engine.
#' 
#' This setting doesn't apply to RDS Custom.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing DBParameterGroup.
#' 
#' -   Must be 1 to 255 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens.
#' @param DeletionProtection A value that indicates whether the DB instance has deletion protection
#' enabled. The database can't be deleted when deletion protection is
#' enabled. By default, deletion protection isn't enabled. For more
#' information, see [Deleting a DB
#' Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html).
#' @param EnableCustomerOwnedIp A value that indicates whether to enable a customer-owned IP address
#' (CoIP) for an RDS on Outposts DB instance.
#' 
#' A *CoIP* provides local or external connectivity to resources in your
#' Outpost subnets through your on-premises network. For some use cases, a
#' CoIP can provide lower latency for connections to the DB instance from
#' outside of its virtual private cloud (VPC) on your local network.
#' 
#' This setting doesn't apply to RDS Custom.
#' 
#' For more information about RDS on Outposts, see [Working with Amazon RDS
#' on Amazon Web Services
#' Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html)
#' in the *Amazon RDS User Guide*.
#' 
#' For more information about CoIPs, see [Customer-owned IP
#' addresses](https://docs.aws.amazon.com/outposts/latest/userguide/routing.html#ip-addressing)
#' in the *Amazon Web Services Outposts User Guide*.
#' @param CustomIamInstanceProfile The instance profile associated with the underlying Amazon EC2 instance
#' of an RDS Custom DB instance. The instance profile must meet the
#' following requirements:
#' 
#' -   The profile must exist in your account.
#' 
#' -   The profile must have an IAM role that Amazon EC2 has permissions to
#'     assume.
#' 
#' -   The instance profile name and the associated IAM role name must
#'     start with the prefix `AWSRDSCustom`.
#' 
#' For the list of permissions required for the IAM role, see [Configure
#' IAM and your
#' VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc)
#' in the *Amazon RDS User Guide*.
#' 
#' This setting is required for RDS Custom.
#' @param BackupTarget Specifies where automated backups and manual snapshots are stored for
#' the restored DB instance.
#' 
#' Possible values are `outposts` (Amazon Web Services Outposts) and
#' `region` (Amazon Web Services Region). The default is `region`.
#' 
#' For more information, see [Working with Amazon RDS on Amazon Web
#' Services
#' Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html)
#' in the *Amazon RDS User Guide*.
#' @param NetworkType The network type of the DB instance.
#' 
#' Valid values:
#' 
#' -   `IPV4`
#' 
#' -   `DUAL`
#' 
#' The network type is determined by the `DBSubnetGroup` specified for the
#' DB instance. A `DBSubnetGroup` can support only the IPv4 protocol or the
#' IPv4 and the IPv6 protocols (`DUAL`).
#' 
#' For more information, see [Working with a DB instance in a
#' VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html)
#' in the *Amazon RDS User Guide.*
#' @param StorageThroughput Specifies the storage throughput value for the DB instance.
#' 
#' This setting doesn't apply to RDS Custom or Amazon Aurora.
#' @param DBClusterSnapshotIdentifier The identifier for the RDS for MySQL Multi-AZ DB cluster snapshot to
#' restore from.
#' 
#' For more information on Multi-AZ DB clusters, see [Multi-AZ DB cluster
#' deployments](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html)
#' in the *Amazon RDS User Guide*.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing Multi-AZ DB cluster
#'     snapshot.
#' 
#' -   Can't be specified when `DBSnapshotIdentifier` is specified.
#' 
#' -   Must be specified when `DBSnapshotIdentifier` isn't specified.
#' 
#' -   If you are restoring from a shared manual Multi-AZ DB cluster
#'     snapshot, the `DBClusterSnapshotIdentifier` must be the ARN of the
#'     shared snapshot.
#' 
#' -   Can't be the identifier of an Aurora DB cluster snapshot.
#' 
#' -   Can't be the identifier of an RDS for PostgreSQL Multi-AZ DB cluster
#'     snapshot.
#' @param AllocatedStorage The amount of storage (in gibibytes) to allocate initially for the DB
#' instance. Follow the allocation rules specified in CreateDBInstance.
#' 
#' Be sure to allocate enough storage for your new DB instance so that the
#' restore operation can succeed. You can also allocate additional storage
#' for future growth.
#'
#' @keywords internal
#'
#' @rdname rds_restore_db_instance_from_db_snapshot
rds_restore_db_instance_from_db_snapshot <- function(DBInstanceIdentifier, DBSnapshotIdentifier = NULL, DBInstanceClass = NULL, Port = NULL, AvailabilityZone = NULL, DBSubnetGroupName = NULL, MultiAZ = NULL, PubliclyAccessible = NULL, AutoMinorVersionUpgrade = NULL, LicenseModel = NULL, DBName = NULL, Engine = NULL, Iops = NULL, OptionGroupName = NULL, Tags = NULL, StorageType = NULL, TdeCredentialArn = NULL, TdeCredentialPassword = NULL, VpcSecurityGroupIds = NULL, Domain = NULL, DomainFqdn = NULL, DomainOu = NULL, DomainAuthSecretArn = NULL, DomainDnsIps = NULL, CopyTagsToSnapshot = NULL, DomainIAMRoleName = NULL, EnableIAMDatabaseAuthentication = NULL, EnableCloudwatchLogsExports = NULL, ProcessorFeatures = NULL, UseDefaultProcessorFeatures = NULL, DBParameterGroupName = NULL, DeletionProtection = NULL, EnableCustomerOwnedIp = NULL, CustomIamInstanceProfile = NULL, BackupTarget = NULL, NetworkType = NULL, StorageThroughput = NULL, DBClusterSnapshotIdentifier = NULL, AllocatedStorage = NULL) {
  op <- new_operation(
    name = "RestoreDBInstanceFromDBSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$restore_db_instance_from_db_snapshot_input(DBInstanceIdentifier = DBInstanceIdentifier, DBSnapshotIdentifier = DBSnapshotIdentifier, DBInstanceClass = DBInstanceClass, Port = Port, AvailabilityZone = AvailabilityZone, DBSubnetGroupName = DBSubnetGroupName, MultiAZ = MultiAZ, PubliclyAccessible = PubliclyAccessible, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, LicenseModel = LicenseModel, DBName = DBName, Engine = Engine, Iops = Iops, OptionGroupName = OptionGroupName, Tags = Tags, StorageType = StorageType, TdeCredentialArn = TdeCredentialArn, TdeCredentialPassword = TdeCredentialPassword, VpcSecurityGroupIds = VpcSecurityGroupIds, Domain = Domain, DomainFqdn = DomainFqdn, DomainOu = DomainOu, DomainAuthSecretArn = DomainAuthSecretArn, DomainDnsIps = DomainDnsIps, CopyTagsToSnapshot = CopyTagsToSnapshot, DomainIAMRoleName = DomainIAMRoleName, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, EnableCloudwatchLogsExports = EnableCloudwatchLogsExports, ProcessorFeatures = ProcessorFeatures, UseDefaultProcessorFeatures = UseDefaultProcessorFeatures, DBParameterGroupName = DBParameterGroupName, DeletionProtection = DeletionProtection, EnableCustomerOwnedIp = EnableCustomerOwnedIp, CustomIamInstanceProfile = CustomIamInstanceProfile, BackupTarget = BackupTarget, NetworkType = NetworkType, StorageThroughput = StorageThroughput, DBClusterSnapshotIdentifier = DBClusterSnapshotIdentifier, AllocatedStorage = AllocatedStorage)
  output <- .rds$restore_db_instance_from_db_snapshot_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$restore_db_instance_from_db_snapshot <- rds_restore_db_instance_from_db_snapshot

#' Amazon Relational Database Service (Amazon RDS) supports importing MySQL
#' databases by using backup files
#'
#' @description
#' Amazon Relational Database Service (Amazon RDS) supports importing MySQL databases by using backup files. You can create a backup of your on-premises database, store it on Amazon Simple Storage Service (Amazon S3), and then restore the backup file onto a new Amazon RDS DB instance running MySQL. For more information, see [Importing Data into an Amazon RDS MySQL DB Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/MySQL.Procedural.Importing.html) in the *Amazon RDS User Guide.*
#'
#' See [https://www.paws-r-sdk.com/docs/rds_restore_db_instance_from_s3/](https://www.paws-r-sdk.com/docs/rds_restore_db_instance_from_s3/) for full documentation.
#'
#' @param DBName The name of the database to create when the DB instance is created.
#' Follow the naming rules specified in
#' [`create_db_instance`][rds_create_db_instance].
#' @param DBInstanceIdentifier &#91;required&#93; The DB instance identifier. This parameter is stored as a lowercase
#' string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `mydbinstance`
#' @param AllocatedStorage The amount of storage (in gibibytes) to allocate initially for the DB
#' instance. Follow the allocation rules specified in
#' [`create_db_instance`][rds_create_db_instance].
#' 
#' Be sure to allocate enough storage for your new DB instance so that the
#' restore operation can succeed. You can also allocate additional storage
#' for future growth.
#' @param DBInstanceClass &#91;required&#93; The compute and memory capacity of the DB instance, for example
#' db.m4.large. Not all DB instance classes are available in all Amazon Web
#' Services Regions, or for all database engines. For the full list of DB
#' instance classes, and availability for your engine, see [DB Instance
#' Class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html)
#' in the *Amazon RDS User Guide.*
#' 
#' Importing from Amazon S3 isn't supported on the db.t2.micro DB instance
#' class.
#' @param Engine &#91;required&#93; The name of the database engine to be used for this instance.
#' 
#' Valid Values: `mysql`
#' @param MasterUsername The name for the master user.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 16 letters or numbers.
#' 
#' -   First character must be a letter.
#' 
#' -   Can't be a reserved word for the chosen database engine.
#' @param MasterUserPassword The password for the master user. The password can include any printable
#' ASCII character except "/", """, or "@@".
#' 
#' Constraints: Can't be specified if `ManageMasterUserPassword` is turned
#' on.
#' 
#' **MariaDB**
#' 
#' Constraints: Must contain from 8 to 41 characters.
#' 
#' **Microsoft SQL Server**
#' 
#' Constraints: Must contain from 8 to 128 characters.
#' 
#' **MySQL**
#' 
#' Constraints: Must contain from 8 to 41 characters.
#' 
#' **Oracle**
#' 
#' Constraints: Must contain from 8 to 30 characters.
#' 
#' **PostgreSQL**
#' 
#' Constraints: Must contain from 8 to 128 characters.
#' @param DBSecurityGroups A list of DB security groups to associate with this DB instance.
#' 
#' Default: The default DB security group for the database engine.
#' @param VpcSecurityGroupIds A list of VPC security groups to associate with this DB instance.
#' @param AvailabilityZone The Availability Zone that the DB instance is created in. For
#' information about Amazon Web Services Regions and Availability Zones,
#' see [Regions and Availability
#' Zones](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html)
#' in the *Amazon RDS User Guide.*
#' 
#' Default: A random, system-chosen Availability Zone in the endpoint's
#' Amazon Web Services Region.
#' 
#' Example: `us-east-1d`
#' 
#' Constraint: The `AvailabilityZone` parameter can't be specified if the
#' DB instance is a Multi-AZ deployment. The specified Availability Zone
#' must be in the same Amazon Web Services Region as the current endpoint.
#' @param DBSubnetGroupName A DB subnet group to associate with this DB instance.
#' 
#' Constraints: If supplied, must match the name of an existing
#' DBSubnetGroup.
#' 
#' Example: `mydbsubnetgroup`
#' @param PreferredMaintenanceWindow The time range each week during which system maintenance can occur, in
#' Universal Coordinated Time (UTC). For more information, see [Amazon RDS
#' Maintenance
#' Window](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance)
#' in the *Amazon RDS User Guide.*
#' 
#' Constraints:
#' 
#' -   Must be in the format `ddd:hh24:mi-ddd:hh24:mi`.
#' 
#' -   Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
#' 
#' -   Must be in Universal Coordinated Time (UTC).
#' 
#' -   Must not conflict with the preferred backup window.
#' 
#' -   Must be at least 30 minutes.
#' @param DBParameterGroupName The name of the DB parameter group to associate with this DB instance.
#' 
#' If you do not specify a value for `DBParameterGroupName`, then the
#' default `DBParameterGroup` for the specified DB engine is used.
#' @param BackupRetentionPeriod The number of days for which automated backups are retained. Setting
#' this parameter to a positive number enables backups. For more
#' information, see [`create_db_instance`][rds_create_db_instance].
#' @param PreferredBackupWindow The time range each day during which automated backups are created if
#' automated backups are enabled. For more information, see [Backup
#' window](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow)
#' in the *Amazon RDS User Guide.*
#' 
#' Constraints:
#' 
#' -   Must be in the format `hh24:mi-hh24:mi`.
#' 
#' -   Must be in Universal Coordinated Time (UTC).
#' 
#' -   Must not conflict with the preferred maintenance window.
#' 
#' -   Must be at least 30 minutes.
#' @param Port The port number on which the database accepts connections.
#' 
#' Type: Integer
#' 
#' Valid Values: `1150`-`65535`
#' 
#' Default: `3306`
#' @param MultiAZ A value that indicates whether the DB instance is a Multi-AZ deployment.
#' If the DB instance is a Multi-AZ deployment, you can't set the
#' `AvailabilityZone` parameter.
#' @param EngineVersion The version number of the database engine to use. Choose the latest
#' minor version of your database engine. For information about engine
#' versions, see [`create_db_instance`][rds_create_db_instance], or call
#' [`describe_db_engine_versions`][rds_describe_db_engine_versions].
#' @param AutoMinorVersionUpgrade A value that indicates whether minor engine upgrades are applied
#' automatically to the DB instance during the maintenance window. By
#' default, minor engine upgrades are not applied automatically.
#' @param LicenseModel The license model for this DB instance. Use `general-public-license`.
#' @param Iops The amount of Provisioned IOPS (input/output operations per second) to
#' allocate initially for the DB instance. For information about valid IOPS
#' values, see [Amazon RDS Provisioned IOPS
#' storage](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS)
#' in the *Amazon RDS User Guide.*
#' @param OptionGroupName The name of the option group to associate with this DB instance. If this
#' argument is omitted, the default option group for the specified engine
#' is used.
#' @param PubliclyAccessible A value that indicates whether the DB instance is publicly accessible.
#' 
#' When the DB instance is publicly accessible, its Domain Name System
#' (DNS) endpoint resolves to the private IP address from within the DB
#' instance's virtual private cloud (VPC). It resolves to the public IP
#' address from outside of the DB instance's VPC. Access to the DB instance
#' is ultimately controlled by the security group it uses. That public
#' access is not permitted if the security group assigned to the DB
#' instance doesn't permit it.
#' 
#' When the DB instance isn't publicly accessible, it is an internal DB
#' instance with a DNS name that resolves to a private IP address.
#' 
#' For more information, see
#' [`create_db_instance`][rds_create_db_instance].
#' @param Tags A list of tags to associate with this DB instance. For more information,
#' see [Tagging Amazon RDS
#' Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html)
#' in the *Amazon RDS User Guide.*
#' @param StorageType Specifies the storage type to be associated with the DB instance.
#' 
#' Valid values: `gp2 | gp3 | io1 | standard`
#' 
#' If you specify `io1` or `gp3`, you must also include a value for the
#' `Iops` parameter.
#' 
#' Default: `io1` if the `Iops` parameter is specified; otherwise `gp2`
#' @param StorageEncrypted A value that indicates whether the new DB instance is encrypted or not.
#' @param KmsKeyId The Amazon Web Services KMS key identifier for an encrypted DB instance.
#' 
#' The Amazon Web Services KMS key identifier is the key ARN, key ID, alias
#' ARN, or alias name for the KMS key. To use a KMS key in a different
#' Amazon Web Services account, specify the key ARN or alias ARN.
#' 
#' If the `StorageEncrypted` parameter is enabled, and you do not specify a
#' value for the `KmsKeyId` parameter, then Amazon RDS will use your
#' default KMS key. There is a default KMS key for your Amazon Web Services
#' account. Your Amazon Web Services account has a different default KMS
#' key for each Amazon Web Services Region.
#' @param CopyTagsToSnapshot A value that indicates whether to copy all tags from the DB instance to
#' snapshots of the DB instance. By default, tags are not copied.
#' @param MonitoringInterval The interval, in seconds, between points when Enhanced Monitoring
#' metrics are collected for the DB instance. To disable collecting
#' Enhanced Monitoring metrics, specify 0.
#' 
#' If `MonitoringRoleArn` is specified, then you must also set
#' `MonitoringInterval` to a value other than 0.
#' 
#' Valid Values: 0, 1, 5, 10, 15, 30, 60
#' 
#' Default: `0`
#' @param MonitoringRoleArn The ARN for the IAM role that permits RDS to send enhanced monitoring
#' metrics to Amazon CloudWatch Logs. For example,
#' `arn:aws:iam:123456789012:role/emaccess`. For information on creating a
#' monitoring role, see [Setting Up and Enabling Enhanced
#' Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling)
#' in the *Amazon RDS User Guide.*
#' 
#' If `MonitoringInterval` is set to a value other than 0, then you must
#' supply a `MonitoringRoleArn` value.
#' @param EnableIAMDatabaseAuthentication A value that indicates whether to enable mapping of Amazon Web Services
#' Identity and Access Management (IAM) accounts to database accounts. By
#' default, mapping isn't enabled.
#' 
#' For more information about IAM database authentication, see [IAM
#' Database Authentication for MySQL and
#' PostgreSQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html)
#' in the *Amazon RDS User Guide.*
#' @param SourceEngine &#91;required&#93; The name of the engine of your source database.
#' 
#' Valid Values: `mysql`
#' @param SourceEngineVersion &#91;required&#93; The version of the database that the backup files were created from.
#' 
#' MySQL versions 5.6 and 5.7 are supported.
#' 
#' Example: `5.6.40`
#' @param S3BucketName &#91;required&#93; The name of your Amazon S3 bucket that contains your database backup
#' file.
#' @param S3Prefix The prefix of your Amazon S3 bucket.
#' @param S3IngestionRoleArn &#91;required&#93; An Amazon Web Services Identity and Access Management (IAM) role to
#' allow Amazon RDS to access your Amazon S3 bucket.
#' @param EnablePerformanceInsights A value that indicates whether to enable Performance Insights for the DB
#' instance.
#' 
#' For more information, see [Using Amazon Performance
#' Insights](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html)
#' in the *Amazon RDS User Guide*.
#' @param PerformanceInsightsKMSKeyId The Amazon Web Services KMS key identifier for encryption of Performance
#' Insights data.
#' 
#' The Amazon Web Services KMS key identifier is the key ARN, key ID, alias
#' ARN, or alias name for the KMS key.
#' 
#' If you do not specify a value for `PerformanceInsightsKMSKeyId`, then
#' Amazon RDS uses your default KMS key. There is a default KMS key for
#' your Amazon Web Services account. Your Amazon Web Services account has a
#' different default KMS key for each Amazon Web Services Region.
#' @param PerformanceInsightsRetentionPeriod The number of days to retain Performance Insights data. The default is 7
#' days. The following values are valid:
#' 
#' -   7
#' 
#' -   *month* * 31, where *month* is a number of months from 1-23
#' 
#' -   731
#' 
#' For example, the following values are valid:
#' 
#' -   93 (3 months * 31)
#' 
#' -   341 (11 months * 31)
#' 
#' -   589 (19 months * 31)
#' 
#' -   731
#' 
#' If you specify a retention period such as 94, which isn't a valid value,
#' RDS issues an error.
#' @param EnableCloudwatchLogsExports The list of logs that the restored DB instance is to export to
#' CloudWatch Logs. The values in the list depend on the DB engine being
#' used. For more information, see [Publishing Database Logs to Amazon
#' CloudWatch
#' Logs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch)
#' in the *Amazon RDS User Guide*.
#' @param ProcessorFeatures The number of CPU cores and the number of threads per core for the DB
#' instance class of the DB instance.
#' @param UseDefaultProcessorFeatures A value that indicates whether the DB instance class of the DB instance
#' uses its default processor features.
#' @param DeletionProtection A value that indicates whether the DB instance has deletion protection
#' enabled. The database can't be deleted when deletion protection is
#' enabled. By default, deletion protection isn't enabled. For more
#' information, see [Deleting a DB
#' Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html).
#' @param MaxAllocatedStorage The upper limit in gibibytes (GiB) to which Amazon RDS can automatically
#' scale the storage of the DB instance.
#' 
#' For more information about this setting, including limitations that
#' apply to it, see [Managing capacity automatically with Amazon RDS
#' storage
#' autoscaling](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling)
#' in the *Amazon RDS User Guide*.
#' @param NetworkType The network type of the DB instance.
#' 
#' Valid values:
#' 
#' -   `IPV4`
#' 
#' -   `DUAL`
#' 
#' The network type is determined by the `DBSubnetGroup` specified for the
#' DB instance. A `DBSubnetGroup` can support only the IPv4 protocol or the
#' IPv4 and the IPv6 protocols (`DUAL`).
#' 
#' For more information, see [Working with a DB instance in a
#' VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html)
#' in the *Amazon RDS User Guide.*
#' @param StorageThroughput Specifies the storage throughput value for the DB instance.
#' 
#' This setting doesn't apply to RDS Custom or Amazon Aurora.
#' @param ManageMasterUserPassword A value that indicates whether to manage the master user password with
#' Amazon Web Services Secrets Manager.
#' 
#' For more information, see [Password management with Amazon Web Services
#' Secrets
#' Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html)
#' in the *Amazon RDS User Guide.*
#' 
#' Constraints:
#' 
#' -   Can't manage the master user password with Amazon Web Services
#'     Secrets Manager if `MasterUserPassword` is specified.
#' @param MasterUserSecretKmsKeyId The Amazon Web Services KMS key identifier to encrypt a secret that is
#' automatically generated and managed in Amazon Web Services Secrets
#' Manager.
#' 
#' This setting is valid only if the master user password is managed by RDS
#' in Amazon Web Services Secrets Manager for the DB instance.
#' 
#' The Amazon Web Services KMS key identifier is the key ARN, key ID, alias
#' ARN, or alias name for the KMS key. To use a KMS key in a different
#' Amazon Web Services account, specify the key ARN or alias ARN.
#' 
#' If you don't specify `MasterUserSecretKmsKeyId`, then the
#' `aws/secretsmanager` KMS key is used to encrypt the secret. If the
#' secret is in a different Amazon Web Services account, then you can't use
#' the `aws/secretsmanager` KMS key to encrypt the secret, and you must use
#' a customer managed KMS key.
#' 
#' There is a default KMS key for your Amazon Web Services account. Your
#' Amazon Web Services account has a different default KMS key for each
#' Amazon Web Services Region.
#'
#' @keywords internal
#'
#' @rdname rds_restore_db_instance_from_s3
rds_restore_db_instance_from_s3 <- function(DBName = NULL, DBInstanceIdentifier, AllocatedStorage = NULL, DBInstanceClass, Engine, MasterUsername = NULL, MasterUserPassword = NULL, DBSecurityGroups = NULL, VpcSecurityGroupIds = NULL, AvailabilityZone = NULL, DBSubnetGroupName = NULL, PreferredMaintenanceWindow = NULL, DBParameterGroupName = NULL, BackupRetentionPeriod = NULL, PreferredBackupWindow = NULL, Port = NULL, MultiAZ = NULL, EngineVersion = NULL, AutoMinorVersionUpgrade = NULL, LicenseModel = NULL, Iops = NULL, OptionGroupName = NULL, PubliclyAccessible = NULL, Tags = NULL, StorageType = NULL, StorageEncrypted = NULL, KmsKeyId = NULL, CopyTagsToSnapshot = NULL, MonitoringInterval = NULL, MonitoringRoleArn = NULL, EnableIAMDatabaseAuthentication = NULL, SourceEngine, SourceEngineVersion, S3BucketName, S3Prefix = NULL, S3IngestionRoleArn, EnablePerformanceInsights = NULL, PerformanceInsightsKMSKeyId = NULL, PerformanceInsightsRetentionPeriod = NULL, EnableCloudwatchLogsExports = NULL, ProcessorFeatures = NULL, UseDefaultProcessorFeatures = NULL, DeletionProtection = NULL, MaxAllocatedStorage = NULL, NetworkType = NULL, StorageThroughput = NULL, ManageMasterUserPassword = NULL, MasterUserSecretKmsKeyId = NULL) {
  op <- new_operation(
    name = "RestoreDBInstanceFromS3",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$restore_db_instance_from_s3_input(DBName = DBName, DBInstanceIdentifier = DBInstanceIdentifier, AllocatedStorage = AllocatedStorage, DBInstanceClass = DBInstanceClass, Engine = Engine, MasterUsername = MasterUsername, MasterUserPassword = MasterUserPassword, DBSecurityGroups = DBSecurityGroups, VpcSecurityGroupIds = VpcSecurityGroupIds, AvailabilityZone = AvailabilityZone, DBSubnetGroupName = DBSubnetGroupName, PreferredMaintenanceWindow = PreferredMaintenanceWindow, DBParameterGroupName = DBParameterGroupName, BackupRetentionPeriod = BackupRetentionPeriod, PreferredBackupWindow = PreferredBackupWindow, Port = Port, MultiAZ = MultiAZ, EngineVersion = EngineVersion, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, LicenseModel = LicenseModel, Iops = Iops, OptionGroupName = OptionGroupName, PubliclyAccessible = PubliclyAccessible, Tags = Tags, StorageType = StorageType, StorageEncrypted = StorageEncrypted, KmsKeyId = KmsKeyId, CopyTagsToSnapshot = CopyTagsToSnapshot, MonitoringInterval = MonitoringInterval, MonitoringRoleArn = MonitoringRoleArn, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, SourceEngine = SourceEngine, SourceEngineVersion = SourceEngineVersion, S3BucketName = S3BucketName, S3Prefix = S3Prefix, S3IngestionRoleArn = S3IngestionRoleArn, EnablePerformanceInsights = EnablePerformanceInsights, PerformanceInsightsKMSKeyId = PerformanceInsightsKMSKeyId, PerformanceInsightsRetentionPeriod = PerformanceInsightsRetentionPeriod, EnableCloudwatchLogsExports = EnableCloudwatchLogsExports, ProcessorFeatures = ProcessorFeatures, UseDefaultProcessorFeatures = UseDefaultProcessorFeatures, DeletionProtection = DeletionProtection, MaxAllocatedStorage = MaxAllocatedStorage, NetworkType = NetworkType, StorageThroughput = StorageThroughput, ManageMasterUserPassword = ManageMasterUserPassword, MasterUserSecretKmsKeyId = MasterUserSecretKmsKeyId)
  output <- .rds$restore_db_instance_from_s3_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$restore_db_instance_from_s3 <- rds_restore_db_instance_from_s3

#' Restores a DB instance to an arbitrary point in time
#'
#' @description
#' Restores a DB instance to an arbitrary point in time. You can restore to any point in time before the time identified by the LatestRestorableTime property. You can restore to a point up to the number of days specified by the BackupRetentionPeriod property.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_restore_db_instance_to_point_in_time/](https://www.paws-r-sdk.com/docs/rds_restore_db_instance_to_point_in_time/) for full documentation.
#'
#' @param SourceDBInstanceIdentifier The identifier of the source DB instance from which to restore.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DB instance.
#' @param TargetDBInstanceIdentifier &#91;required&#93; The name of the new DB instance to be created.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens
#' 
#' -   First character must be a letter
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens
#' @param RestoreTime The date and time to restore from.
#' 
#' Valid Values: Value must be a time in Universal Coordinated Time (UTC)
#' format
#' 
#' Constraints:
#' 
#' -   Must be before the latest restorable time for the DB instance
#' 
#' -   Can't be specified if the `UseLatestRestorableTime` parameter is
#'     enabled
#' 
#' Example: `2009-09-07T23:45:00Z`
#' @param UseLatestRestorableTime A value that indicates whether the DB instance is restored from the
#' latest backup time. By default, the DB instance isn't restored from the
#' latest backup time.
#' 
#' Constraints: Can't be specified if the `RestoreTime` parameter is
#' provided.
#' @param DBInstanceClass The compute and memory capacity of the Amazon RDS DB instance, for
#' example db.m4.large. Not all DB instance classes are available in all
#' Amazon Web Services Regions, or for all database engines. For the full
#' list of DB instance classes, and availability for your engine, see [DB
#' Instance
#' Class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html)
#' in the *Amazon RDS User Guide*.
#' 
#' Default: The same DBInstanceClass as the original DB instance.
#' @param Port The port number on which the database accepts connections.
#' 
#' Constraints: Value must be `1150-65535`
#' 
#' Default: The same port as the original DB instance.
#' @param AvailabilityZone The Availability Zone (AZ) where the DB instance will be created.
#' 
#' Default: A random, system-chosen Availability Zone.
#' 
#' Constraint: You can't specify the `AvailabilityZone` parameter if the DB
#' instance is a Multi-AZ deployment.
#' 
#' Example: `us-east-1a`
#' @param DBSubnetGroupName The DB subnet group name to use for the new instance.
#' 
#' Constraints: If supplied, must match the name of an existing
#' DBSubnetGroup.
#' 
#' Example: `mydbsubnetgroup`
#' @param MultiAZ A value that indicates whether the DB instance is a Multi-AZ deployment.
#' 
#' This setting doesn't apply to RDS Custom.
#' 
#' Constraint: You can't specify the `AvailabilityZone` parameter if the DB
#' instance is a Multi-AZ deployment.
#' @param PubliclyAccessible A value that indicates whether the DB instance is publicly accessible.
#' 
#' When the DB cluster is publicly accessible, its Domain Name System (DNS)
#' endpoint resolves to the private IP address from within the DB cluster's
#' virtual private cloud (VPC). It resolves to the public IP address from
#' outside of the DB cluster's VPC. Access to the DB cluster is ultimately
#' controlled by the security group it uses. That public access isn't
#' permitted if the security group assigned to the DB cluster doesn't
#' permit it.
#' 
#' When the DB instance isn't publicly accessible, it is an internal DB
#' instance with a DNS name that resolves to a private IP address.
#' 
#' For more information, see
#' [`create_db_instance`][rds_create_db_instance].
#' @param AutoMinorVersionUpgrade A value that indicates whether minor version upgrades are applied
#' automatically to the DB instance during the maintenance window.
#' 
#' This setting doesn't apply to RDS Custom.
#' @param LicenseModel License model information for the restored DB instance.
#' 
#' This setting doesn't apply to RDS Custom.
#' 
#' Default: Same as source.
#' 
#' Valid values: `license-included` | `bring-your-own-license` |
#' `general-public-license`
#' @param DBName The database name for the restored DB instance.
#' 
#' This parameter isn't supported for the MySQL or MariaDB engines. It also
#' doesn't apply to RDS Custom.
#' @param Engine The database engine to use for the new instance.
#' 
#' This setting doesn't apply to RDS Custom.
#' 
#' Default: The same as source
#' 
#' Constraint: Must be compatible with the engine of the source
#' 
#' Valid Values:
#' 
#' -   `mariadb`
#' 
#' -   `mysql`
#' 
#' -   `oracle-ee`
#' 
#' -   `oracle-ee-cdb`
#' 
#' -   `oracle-se2`
#' 
#' -   `oracle-se2-cdb`
#' 
#' -   `postgres`
#' 
#' -   `sqlserver-ee`
#' 
#' -   `sqlserver-se`
#' 
#' -   `sqlserver-ex`
#' 
#' -   `sqlserver-web`
#' @param Iops The amount of Provisioned IOPS (input/output operations per second) to
#' be initially allocated for the DB instance.
#' 
#' Constraints: Must be an integer greater than 1000.
#' 
#' **SQL Server**
#' 
#' Setting the IOPS value for the SQL Server database engine isn't
#' supported.
#' @param OptionGroupName The name of the option group to be used for the restored DB instance.
#' 
#' Permanent options, such as the TDE option for Oracle Advanced Security
#' TDE, can't be removed from an option group, and that option group can't
#' be removed from a DB instance after it is associated with a DB instance
#' 
#' This setting doesn't apply to RDS Custom.
#' @param CopyTagsToSnapshot A value that indicates whether to copy all tags from the restored DB
#' instance to snapshots of the DB instance. By default, tags are not
#' copied.
#' @param Tags 
#' @param StorageType Specifies the storage type to be associated with the DB instance.
#' 
#' Valid values: `gp2 | gp3 | io1 | standard`
#' 
#' If you specify `io1` or `gp3`, you must also include a value for the
#' `Iops` parameter.
#' 
#' Default: `io1` if the `Iops` parameter is specified, otherwise `gp2`
#' @param TdeCredentialArn The ARN from the key store with which to associate the instance for TDE
#' encryption.
#' 
#' This setting doesn't apply to RDS Custom.
#' @param TdeCredentialPassword The password for the given ARN from the key store in order to access the
#' device.
#' 
#' This setting doesn't apply to RDS Custom.
#' @param VpcSecurityGroupIds A list of EC2 VPC security groups to associate with this DB instance.
#' 
#' Default: The default EC2 VPC security group for the DB subnet group's
#' VPC.
#' @param Domain Specify the Active Directory directory ID to restore the DB instance in.
#' Create the domain before running this command. Currently, you can create
#' only the MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB
#' instances in an Active Directory Domain.
#' 
#' This setting doesn't apply to RDS Custom.
#' 
#' For more information, see [Kerberos
#' Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/database-authentication.html)
#' in the *Amazon RDS User Guide*.
#' @param DomainIAMRoleName The name of the IAM role to use when making API calls to the Directory
#' Service.
#' 
#' This setting doesn't apply to RDS Custom DB instances.
#' @param DomainFqdn The fully qualified domain name (FQDN) of an Active Directory domain.
#' 
#' Constraints:
#' 
#' -   Can't be longer than 64 characters.
#' 
#' Example: `mymanagedADtest.mymanagedAD.mydomain`
#' @param DomainOu The Active Directory organizational unit for your DB instance to join.
#' 
#' Constraints:
#' 
#' -   Must be in the distinguished name format.
#' 
#' -   Can't be longer than 64 characters.
#' 
#' Example:
#' `OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain`
#' @param DomainAuthSecretArn The ARN for the Secrets Manager secret with the credentials for the user
#' joining the domain.
#' 
#' Constraints:
#' 
#' -   Can't be longer than 64 characters.
#' 
#' Example:
#' `arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456`
#' @param DomainDnsIps The IPv4 DNS IP addresses of your primary and secondary Active Directory
#' domain controllers.
#' 
#' Constraints:
#' 
#' -   Two IP addresses must be provided. If there isn't a secondary domain
#'     controller, use the IP address of the primary domain controller for
#'     both entries in the list.
#' 
#' Example: `123.124.125.126,234.235.236.237`
#' @param EnableIAMDatabaseAuthentication A value that indicates whether to enable mapping of Amazon Web Services
#' Identity and Access Management (IAM) accounts to database accounts. By
#' default, mapping isn't enabled.
#' 
#' This setting doesn't apply to RDS Custom.
#' 
#' For more information about IAM database authentication, see [IAM
#' Database Authentication for MySQL and
#' PostgreSQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html)
#' in the *Amazon RDS User Guide.*
#' @param EnableCloudwatchLogsExports The list of logs that the restored DB instance is to export to
#' CloudWatch Logs. The values in the list depend on the DB engine being
#' used. For more information, see [Publishing Database Logs to Amazon
#' CloudWatch
#' Logs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch)
#' in the *Amazon RDS User Guide*.
#' 
#' This setting doesn't apply to RDS Custom.
#' @param ProcessorFeatures The number of CPU cores and the number of threads per core for the DB
#' instance class of the DB instance.
#' 
#' This setting doesn't apply to RDS Custom.
#' @param UseDefaultProcessorFeatures A value that indicates whether the DB instance class of the DB instance
#' uses its default processor features.
#' 
#' This setting doesn't apply to RDS Custom.
#' @param DBParameterGroupName The name of the DB parameter group to associate with this DB instance.
#' 
#' If you do not specify a value for `DBParameterGroupName`, then the
#' default `DBParameterGroup` for the specified DB engine is used.
#' 
#' This setting doesn't apply to RDS Custom.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing DBParameterGroup.
#' 
#' -   Must be 1 to 255 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens.
#' @param DeletionProtection A value that indicates whether the DB instance has deletion protection
#' enabled. The database can't be deleted when deletion protection is
#' enabled. By default, deletion protection isn't enabled. For more
#' information, see [Deleting a DB
#' Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html).
#' @param SourceDbiResourceId The resource ID of the source DB instance from which to restore.
#' @param MaxAllocatedStorage The upper limit in gibibytes (GiB) to which Amazon RDS can automatically
#' scale the storage of the DB instance.
#' 
#' For more information about this setting, including limitations that
#' apply to it, see [Managing capacity automatically with Amazon RDS
#' storage
#' autoscaling](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling)
#' in the *Amazon RDS User Guide*.
#' 
#' This setting doesn't apply to RDS Custom.
#' @param SourceDBInstanceAutomatedBackupsArn The Amazon Resource Name (ARN) of the replicated automated backups from
#' which to restore, for example,
#' `arn:aws:rds:useast-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE`.
#' 
#' This setting doesn't apply to RDS Custom.
#' @param EnableCustomerOwnedIp A value that indicates whether to enable a customer-owned IP address
#' (CoIP) for an RDS on Outposts DB instance.
#' 
#' A *CoIP* provides local or external connectivity to resources in your
#' Outpost subnets through your on-premises network. For some use cases, a
#' CoIP can provide lower latency for connections to the DB instance from
#' outside of its virtual private cloud (VPC) on your local network.
#' 
#' This setting doesn't apply to RDS Custom.
#' 
#' For more information about RDS on Outposts, see [Working with Amazon RDS
#' on Amazon Web Services
#' Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html)
#' in the *Amazon RDS User Guide*.
#' 
#' For more information about CoIPs, see [Customer-owned IP
#' addresses](https://docs.aws.amazon.com/outposts/latest/userguide/routing.html#ip-addressing)
#' in the *Amazon Web Services Outposts User Guide*.
#' @param CustomIamInstanceProfile The instance profile associated with the underlying Amazon EC2 instance
#' of an RDS Custom DB instance. The instance profile must meet the
#' following requirements:
#' 
#' -   The profile must exist in your account.
#' 
#' -   The profile must have an IAM role that Amazon EC2 has permissions to
#'     assume.
#' 
#' -   The instance profile name and the associated IAM role name must
#'     start with the prefix `AWSRDSCustom`.
#' 
#' For the list of permissions required for the IAM role, see [Configure
#' IAM and your
#' VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc)
#' in the *Amazon RDS User Guide*.
#' 
#' This setting is required for RDS Custom.
#' @param BackupTarget Specifies where automated backups and manual snapshots are stored for
#' the restored DB instance.
#' 
#' Possible values are `outposts` (Amazon Web Services Outposts) and
#' `region` (Amazon Web Services Region). The default is `region`.
#' 
#' For more information, see [Working with Amazon RDS on Amazon Web
#' Services
#' Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html)
#' in the *Amazon RDS User Guide*.
#' @param NetworkType The network type of the DB instance.
#' 
#' Valid values:
#' 
#' -   `IPV4`
#' 
#' -   `DUAL`
#' 
#' The network type is determined by the `DBSubnetGroup` specified for the
#' DB instance. A `DBSubnetGroup` can support only the IPv4 protocol or the
#' IPv4 and the IPv6 protocols (`DUAL`).
#' 
#' For more information, see [Working with a DB instance in a
#' VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html)
#' in the *Amazon RDS User Guide.*
#' @param StorageThroughput Specifies the storage throughput value for the DB instance.
#' 
#' This setting doesn't apply to RDS Custom or Amazon Aurora.
#' @param AllocatedStorage The amount of storage (in gibibytes) to allocate initially for the DB
#' instance. Follow the allocation rules specified in
#' [`create_db_instance`][rds_create_db_instance].
#' 
#' Be sure to allocate enough storage for your new DB instance so that the
#' restore operation can succeed. You can also allocate additional storage
#' for future growth.
#'
#' @keywords internal
#'
#' @rdname rds_restore_db_instance_to_point_in_time
rds_restore_db_instance_to_point_in_time <- function(SourceDBInstanceIdentifier = NULL, TargetDBInstanceIdentifier, RestoreTime = NULL, UseLatestRestorableTime = NULL, DBInstanceClass = NULL, Port = NULL, AvailabilityZone = NULL, DBSubnetGroupName = NULL, MultiAZ = NULL, PubliclyAccessible = NULL, AutoMinorVersionUpgrade = NULL, LicenseModel = NULL, DBName = NULL, Engine = NULL, Iops = NULL, OptionGroupName = NULL, CopyTagsToSnapshot = NULL, Tags = NULL, StorageType = NULL, TdeCredentialArn = NULL, TdeCredentialPassword = NULL, VpcSecurityGroupIds = NULL, Domain = NULL, DomainIAMRoleName = NULL, DomainFqdn = NULL, DomainOu = NULL, DomainAuthSecretArn = NULL, DomainDnsIps = NULL, EnableIAMDatabaseAuthentication = NULL, EnableCloudwatchLogsExports = NULL, ProcessorFeatures = NULL, UseDefaultProcessorFeatures = NULL, DBParameterGroupName = NULL, DeletionProtection = NULL, SourceDbiResourceId = NULL, MaxAllocatedStorage = NULL, SourceDBInstanceAutomatedBackupsArn = NULL, EnableCustomerOwnedIp = NULL, CustomIamInstanceProfile = NULL, BackupTarget = NULL, NetworkType = NULL, StorageThroughput = NULL, AllocatedStorage = NULL) {
  op <- new_operation(
    name = "RestoreDBInstanceToPointInTime",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$restore_db_instance_to_point_in_time_input(SourceDBInstanceIdentifier = SourceDBInstanceIdentifier, TargetDBInstanceIdentifier = TargetDBInstanceIdentifier, RestoreTime = RestoreTime, UseLatestRestorableTime = UseLatestRestorableTime, DBInstanceClass = DBInstanceClass, Port = Port, AvailabilityZone = AvailabilityZone, DBSubnetGroupName = DBSubnetGroupName, MultiAZ = MultiAZ, PubliclyAccessible = PubliclyAccessible, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, LicenseModel = LicenseModel, DBName = DBName, Engine = Engine, Iops = Iops, OptionGroupName = OptionGroupName, CopyTagsToSnapshot = CopyTagsToSnapshot, Tags = Tags, StorageType = StorageType, TdeCredentialArn = TdeCredentialArn, TdeCredentialPassword = TdeCredentialPassword, VpcSecurityGroupIds = VpcSecurityGroupIds, Domain = Domain, DomainIAMRoleName = DomainIAMRoleName, DomainFqdn = DomainFqdn, DomainOu = DomainOu, DomainAuthSecretArn = DomainAuthSecretArn, DomainDnsIps = DomainDnsIps, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, EnableCloudwatchLogsExports = EnableCloudwatchLogsExports, ProcessorFeatures = ProcessorFeatures, UseDefaultProcessorFeatures = UseDefaultProcessorFeatures, DBParameterGroupName = DBParameterGroupName, DeletionProtection = DeletionProtection, SourceDbiResourceId = SourceDbiResourceId, MaxAllocatedStorage = MaxAllocatedStorage, SourceDBInstanceAutomatedBackupsArn = SourceDBInstanceAutomatedBackupsArn, EnableCustomerOwnedIp = EnableCustomerOwnedIp, CustomIamInstanceProfile = CustomIamInstanceProfile, BackupTarget = BackupTarget, NetworkType = NetworkType, StorageThroughput = StorageThroughput, AllocatedStorage = AllocatedStorage)
  output <- .rds$restore_db_instance_to_point_in_time_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$restore_db_instance_to_point_in_time <- rds_restore_db_instance_to_point_in_time

#' Revokes ingress from a DBSecurityGroup for previously authorized IP
#' ranges or EC2 or VPC security groups
#'
#' @description
#' Revokes ingress from a DBSecurityGroup for previously authorized IP ranges or EC2 or VPC security groups. Required parameters for this API are one of CIDRIP, EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId and either EC2SecurityGroupName or EC2SecurityGroupId).
#'
#' See [https://www.paws-r-sdk.com/docs/rds_revoke_db_security_group_ingress/](https://www.paws-r-sdk.com/docs/rds_revoke_db_security_group_ingress/) for full documentation.
#'
#' @param DBSecurityGroupName &#91;required&#93; The name of the DB security group to revoke ingress from.
#' @param CIDRIP The IP range to revoke access from. Must be a valid CIDR range. If
#' `CIDRIP` is specified, `EC2SecurityGroupName`, `EC2SecurityGroupId` and
#' `EC2SecurityGroupOwnerId` can't be provided.
#' @param EC2SecurityGroupName The name of the EC2 security group to revoke access from. For VPC DB
#' security groups, `EC2SecurityGroupId` must be provided. Otherwise,
#' EC2SecurityGroupOwnerId and either `EC2SecurityGroupName` or
#' `EC2SecurityGroupId` must be provided.
#' @param EC2SecurityGroupId The id of the EC2 security group to revoke access from. For VPC DB
#' security groups, `EC2SecurityGroupId` must be provided. Otherwise,
#' EC2SecurityGroupOwnerId and either `EC2SecurityGroupName` or
#' `EC2SecurityGroupId` must be provided.
#' @param EC2SecurityGroupOwnerId The Amazon Web Services account number of the owner of the EC2 security
#' group specified in the `EC2SecurityGroupName` parameter. The Amazon Web
#' Services access key ID isn't an acceptable value. For VPC DB security
#' groups, `EC2SecurityGroupId` must be provided. Otherwise,
#' EC2SecurityGroupOwnerId and either `EC2SecurityGroupName` or
#' `EC2SecurityGroupId` must be provided.
#'
#' @keywords internal
#'
#' @rdname rds_revoke_db_security_group_ingress
rds_revoke_db_security_group_ingress <- function(DBSecurityGroupName, CIDRIP = NULL, EC2SecurityGroupName = NULL, EC2SecurityGroupId = NULL, EC2SecurityGroupOwnerId = NULL) {
  op <- new_operation(
    name = "RevokeDBSecurityGroupIngress",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$revoke_db_security_group_ingress_input(DBSecurityGroupName = DBSecurityGroupName, CIDRIP = CIDRIP, EC2SecurityGroupName = EC2SecurityGroupName, EC2SecurityGroupId = EC2SecurityGroupId, EC2SecurityGroupOwnerId = EC2SecurityGroupOwnerId)
  output <- .rds$revoke_db_security_group_ingress_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$revoke_db_security_group_ingress <- rds_revoke_db_security_group_ingress

#' Starts a database activity stream to monitor activity on the database
#'
#' @description
#' Starts a database activity stream to monitor activity on the database. For more information, see [Monitoring Amazon Aurora with Database Activity Streams](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/DBActivityStreams.html) in the *Amazon Aurora User Guide* or [Monitoring Amazon RDS with Database Activity Streams](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/DBActivityStreams.html) in the *Amazon RDS User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_start_activity_stream/](https://www.paws-r-sdk.com/docs/rds_start_activity_stream/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the DB cluster, for example,
#' `arn:aws:rds:us-east-1:12345667890:cluster:das-cluster`.
#' @param Mode &#91;required&#93; Specifies the mode of the database activity stream. Database events such
#' as a change or access generate an activity stream event. The database
#' session can handle these events either synchronously or asynchronously.
#' @param KmsKeyId &#91;required&#93; The Amazon Web Services KMS key identifier for encrypting messages in
#' the database activity stream. The Amazon Web Services KMS key identifier
#' is the key ARN, key ID, alias ARN, or alias name for the KMS key.
#' @param ApplyImmediately Specifies whether or not the database activity stream is to start as
#' soon as possible, regardless of the maintenance window for the database.
#' @param EngineNativeAuditFieldsIncluded Specifies whether the database activity stream includes engine-native
#' audit fields. This option applies to an Oracle or Microsoft SQL Server
#' DB instance. By default, no engine-native audit fields are included.
#'
#' @keywords internal
#'
#' @rdname rds_start_activity_stream
rds_start_activity_stream <- function(ResourceArn, Mode, KmsKeyId, ApplyImmediately = NULL, EngineNativeAuditFieldsIncluded = NULL) {
  op <- new_operation(
    name = "StartActivityStream",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$start_activity_stream_input(ResourceArn = ResourceArn, Mode = Mode, KmsKeyId = KmsKeyId, ApplyImmediately = ApplyImmediately, EngineNativeAuditFieldsIncluded = EngineNativeAuditFieldsIncluded)
  output <- .rds$start_activity_stream_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$start_activity_stream <- rds_start_activity_stream

#' Starts an Amazon Aurora DB cluster that was stopped using the Amazon Web
#' Services console, the stop-db-cluster CLI command, or the StopDBCluster
#' action
#'
#' @description
#' Starts an Amazon Aurora DB cluster that was stopped using the Amazon Web Services console, the stop-db-cluster CLI command, or the StopDBCluster action.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_start_db_cluster/](https://www.paws-r-sdk.com/docs/rds_start_db_cluster/) for full documentation.
#'
#' @param DBClusterIdentifier &#91;required&#93; The DB cluster identifier of the Amazon Aurora DB cluster to be started.
#' This parameter is stored as a lowercase string.
#'
#' @keywords internal
#'
#' @rdname rds_start_db_cluster
rds_start_db_cluster <- function(DBClusterIdentifier) {
  op <- new_operation(
    name = "StartDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$start_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier)
  output <- .rds$start_db_cluster_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$start_db_cluster <- rds_start_db_cluster

#' Starts an Amazon RDS DB instance that was stopped using the Amazon Web
#' Services console, the stop-db-instance CLI command, or the
#' StopDBInstance action
#'
#' @description
#' Starts an Amazon RDS DB instance that was stopped using the Amazon Web Services console, the stop-db-instance CLI command, or the StopDBInstance action.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_start_db_instance/](https://www.paws-r-sdk.com/docs/rds_start_db_instance/) for full documentation.
#'
#' @param DBInstanceIdentifier &#91;required&#93; The user-supplied instance identifier.
#'
#' @keywords internal
#'
#' @rdname rds_start_db_instance
rds_start_db_instance <- function(DBInstanceIdentifier) {
  op <- new_operation(
    name = "StartDBInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$start_db_instance_input(DBInstanceIdentifier = DBInstanceIdentifier)
  output <- .rds$start_db_instance_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$start_db_instance <- rds_start_db_instance

#' Enables replication of automated backups to a different Amazon Web
#' Services Region
#'
#' @description
#' Enables replication of automated backups to a different Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_start_db_instance_automated_backups_replication/](https://www.paws-r-sdk.com/docs/rds_start_db_instance_automated_backups_replication/) for full documentation.
#'
#' @param SourceDBInstanceArn &#91;required&#93; The Amazon Resource Name (ARN) of the source DB instance for the
#' replicated automated backups, for example,
#' `arn:aws:rds:us-west-2:123456789012:db:mydatabase`.
#' @param BackupRetentionPeriod The retention period for the replicated automated backups.
#' @param KmsKeyId The Amazon Web Services KMS key identifier for encryption of the
#' replicated automated backups. The KMS key ID is the Amazon Resource Name
#' (ARN) for the KMS encryption key in the destination Amazon Web Services
#' Region, for example,
#' `arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE`.
#' @param PreSignedUrl In an Amazon Web Services GovCloud (US) Region, an URL that contains a
#' Signature Version 4 signed request for the
#' [`start_db_instance_automated_backups_replication`][rds_start_db_instance_automated_backups_replication]
#' operation to call in the Amazon Web Services Region of the source DB
#' instance. The presigned URL must be a valid request for the
#' [`start_db_instance_automated_backups_replication`][rds_start_db_instance_automated_backups_replication]
#' API operation that can run in the Amazon Web Services Region that
#' contains the source DB instance.
#' 
#' This setting applies only to Amazon Web Services GovCloud (US) Regions.
#' It's ignored in other Amazon Web Services Regions.
#' 
#' To learn how to generate a Signature Version 4 signed request, see
#' [Authenticating Requests: Using Query Parameters (Amazon Web Services
#' Signature Version
#' 4)](https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html)
#' and [Signature Version 4 Signing
#' Process](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html).
#' 
#' If you are using an Amazon Web Services SDK tool or the CLI, you can
#' specify `SourceRegion` (or `--source-region` for the CLI) instead of
#' specifying `PreSignedUrl` manually. Specifying `SourceRegion`
#' autogenerates a presigned URL that is a valid request for the operation
#' that can run in the source Amazon Web Services Region.
#'
#' @keywords internal
#'
#' @rdname rds_start_db_instance_automated_backups_replication
rds_start_db_instance_automated_backups_replication <- function(SourceDBInstanceArn, BackupRetentionPeriod = NULL, KmsKeyId = NULL, PreSignedUrl = NULL) {
  op <- new_operation(
    name = "StartDBInstanceAutomatedBackupsReplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$start_db_instance_automated_backups_replication_input(SourceDBInstanceArn = SourceDBInstanceArn, BackupRetentionPeriod = BackupRetentionPeriod, KmsKeyId = KmsKeyId, PreSignedUrl = PreSignedUrl)
  output <- .rds$start_db_instance_automated_backups_replication_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$start_db_instance_automated_backups_replication <- rds_start_db_instance_automated_backups_replication

#' Starts an export of DB snapshot or DB cluster data to Amazon S3
#'
#' @description
#' Starts an export of DB snapshot or DB cluster data to Amazon S3. The provided IAM role must have access to the S3 bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_start_export_task/](https://www.paws-r-sdk.com/docs/rds_start_export_task/) for full documentation.
#'
#' @param ExportTaskIdentifier &#91;required&#93; A unique identifier for the export task. This ID isn't an identifier for
#' the Amazon S3 bucket where the data is to be exported.
#' @param SourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the snapshot or cluster to export to
#' Amazon S3.
#' @param S3BucketName &#91;required&#93; The name of the Amazon S3 bucket to export the snapshot or cluster data
#' to.
#' @param IamRoleArn &#91;required&#93; The name of the IAM role to use for writing to the Amazon S3 bucket when
#' exporting a snapshot or cluster.
#' 
#' In the IAM policy attached to your IAM role, include the following
#' required actions to allow the transfer of files from Amazon RDS or
#' Amazon Aurora to an S3 bucket:
#' 
#' -   s3:PutObject*
#' 
#' -   s3:GetObject*
#' 
#' -   s3:ListBucket
#' 
#' -   s3:DeleteObject*
#' 
#' -   s3:GetBucketLocation
#' 
#' In the policy, include the resources to identify the S3 bucket and
#' objects in the bucket. The following list of resources shows the Amazon
#' Resource Name (ARN) format for accessing S3:
#' 
#' -   `arn:aws:s3:::your-s3-bucket `
#' 
#' -   `arn:aws:s3:::your-s3-bucket/*`
#' @param KmsKeyId &#91;required&#93; The ID of the Amazon Web Services KMS key to use to encrypt the data
#' exported to Amazon S3. The Amazon Web Services KMS key identifier is the
#' key ARN, key ID, alias ARN, or alias name for the KMS key. The caller of
#' this operation must be authorized to run the following operations. These
#' can be set in the Amazon Web Services KMS key policy:
#' 
#' -   kms:Encrypt
#' 
#' -   kms:Decrypt
#' 
#' -   kms:GenerateDataKey
#' 
#' -   kms:GenerateDataKeyWithoutPlaintext
#' 
#' -   kms:ReEncryptFrom
#' 
#' -   kms:ReEncryptTo
#' 
#' -   kms:CreateGrant
#' 
#' -   kms:DescribeKey
#' 
#' -   kms:RetireGrant
#' @param S3Prefix The Amazon S3 bucket prefix to use as the file name and path of the
#' exported data.
#' @param ExportOnly The data to be exported from the snapshot or cluster. If this parameter
#' is not provided, all of the data is exported. Valid values are the
#' following:
#' 
#' -   `database` - Export all the data from a specified database.
#' 
#' -   `database.table` *table-name* - Export a table of the snapshot or
#'     cluster. This format is valid only for RDS for MySQL, RDS for
#'     MariaDB, and Aurora MySQL.
#' 
#' -   `database.schema` *schema-name* - Export a database schema of the
#'     snapshot or cluster. This format is valid only for RDS for
#'     PostgreSQL and Aurora PostgreSQL.
#' 
#' -   `database.schema.table` *table-name* - Export a table of the
#'     database schema. This format is valid only for RDS for PostgreSQL
#'     and Aurora PostgreSQL.
#'
#' @keywords internal
#'
#' @rdname rds_start_export_task
rds_start_export_task <- function(ExportTaskIdentifier, SourceArn, S3BucketName, IamRoleArn, KmsKeyId, S3Prefix = NULL, ExportOnly = NULL) {
  op <- new_operation(
    name = "StartExportTask",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$start_export_task_input(ExportTaskIdentifier = ExportTaskIdentifier, SourceArn = SourceArn, S3BucketName = S3BucketName, IamRoleArn = IamRoleArn, KmsKeyId = KmsKeyId, S3Prefix = S3Prefix, ExportOnly = ExportOnly)
  output <- .rds$start_export_task_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$start_export_task <- rds_start_export_task

#' Stops a database activity stream that was started using the Amazon Web
#' Services console, the start-activity-stream CLI command, or the
#' StartActivityStream action
#'
#' @description
#' Stops a database activity stream that was started using the Amazon Web Services console, the `start-activity-stream` CLI command, or the [`start_activity_stream`][rds_start_activity_stream] action.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_stop_activity_stream/](https://www.paws-r-sdk.com/docs/rds_stop_activity_stream/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the DB cluster for the database
#' activity stream. For example,
#' `arn:aws:rds:us-east-1:12345667890:cluster:das-cluster`.
#' @param ApplyImmediately Specifies whether or not the database activity stream is to stop as soon
#' as possible, regardless of the maintenance window for the database.
#'
#' @keywords internal
#'
#' @rdname rds_stop_activity_stream
rds_stop_activity_stream <- function(ResourceArn, ApplyImmediately = NULL) {
  op <- new_operation(
    name = "StopActivityStream",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$stop_activity_stream_input(ResourceArn = ResourceArn, ApplyImmediately = ApplyImmediately)
  output <- .rds$stop_activity_stream_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$stop_activity_stream <- rds_stop_activity_stream

#' Stops an Amazon Aurora DB cluster
#'
#' @description
#' Stops an Amazon Aurora DB cluster. When you stop a DB cluster, Aurora retains the DB cluster's metadata, including its endpoints and DB parameter groups. Aurora also retains the transaction logs so you can do a point-in-time restore if necessary.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_stop_db_cluster/](https://www.paws-r-sdk.com/docs/rds_stop_db_cluster/) for full documentation.
#'
#' @param DBClusterIdentifier &#91;required&#93; The DB cluster identifier of the Amazon Aurora DB cluster to be stopped.
#' This parameter is stored as a lowercase string.
#'
#' @keywords internal
#'
#' @rdname rds_stop_db_cluster
rds_stop_db_cluster <- function(DBClusterIdentifier) {
  op <- new_operation(
    name = "StopDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$stop_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier)
  output <- .rds$stop_db_cluster_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$stop_db_cluster <- rds_stop_db_cluster

#' Stops an Amazon RDS DB instance
#'
#' @description
#' Stops an Amazon RDS DB instance. When you stop a DB instance, Amazon RDS retains the DB instance's metadata, including its endpoint, DB parameter group, and option group membership. Amazon RDS also retains the transaction logs so you can do a point-in-time restore if necessary.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_stop_db_instance/](https://www.paws-r-sdk.com/docs/rds_stop_db_instance/) for full documentation.
#'
#' @param DBInstanceIdentifier &#91;required&#93; The user-supplied instance identifier.
#' @param DBSnapshotIdentifier The user-supplied instance identifier of the DB Snapshot created
#' immediately before the DB instance is stopped.
#'
#' @keywords internal
#'
#' @rdname rds_stop_db_instance
rds_stop_db_instance <- function(DBInstanceIdentifier, DBSnapshotIdentifier = NULL) {
  op <- new_operation(
    name = "StopDBInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$stop_db_instance_input(DBInstanceIdentifier = DBInstanceIdentifier, DBSnapshotIdentifier = DBSnapshotIdentifier)
  output <- .rds$stop_db_instance_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$stop_db_instance <- rds_stop_db_instance

#' Stops automated backup replication for a DB instance
#'
#' @description
#' Stops automated backup replication for a DB instance.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_stop_db_instance_automated_backups_replication/](https://www.paws-r-sdk.com/docs/rds_stop_db_instance_automated_backups_replication/) for full documentation.
#'
#' @param SourceDBInstanceArn &#91;required&#93; The Amazon Resource Name (ARN) of the source DB instance for which to
#' stop replicating automate backups, for example,
#' `arn:aws:rds:us-west-2:123456789012:db:mydatabase`.
#'
#' @keywords internal
#'
#' @rdname rds_stop_db_instance_automated_backups_replication
rds_stop_db_instance_automated_backups_replication <- function(SourceDBInstanceArn) {
  op <- new_operation(
    name = "StopDBInstanceAutomatedBackupsReplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$stop_db_instance_automated_backups_replication_input(SourceDBInstanceArn = SourceDBInstanceArn)
  output <- .rds$stop_db_instance_automated_backups_replication_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$stop_db_instance_automated_backups_replication <- rds_stop_db_instance_automated_backups_replication

#' Switches over a blue/green deployment
#'
#' @description
#' Switches over a blue/green deployment.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_switchover_blue_green_deployment/](https://www.paws-r-sdk.com/docs/rds_switchover_blue_green_deployment/) for full documentation.
#'
#' @param BlueGreenDeploymentIdentifier &#91;required&#93; The unique identifier of the blue/green deployment.
#' 
#' Constraints:
#' 
#' -   Must match an existing blue/green deployment identifier.
#' @param SwitchoverTimeout The amount of time, in seconds, for the switchover to complete.
#' 
#' Default: 300
#' 
#' If the switchover takes longer than the specified duration, then any
#' changes are rolled back, and no changes are made to the environments.
#'
#' @keywords internal
#'
#' @rdname rds_switchover_blue_green_deployment
rds_switchover_blue_green_deployment <- function(BlueGreenDeploymentIdentifier, SwitchoverTimeout = NULL) {
  op <- new_operation(
    name = "SwitchoverBlueGreenDeployment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$switchover_blue_green_deployment_input(BlueGreenDeploymentIdentifier = BlueGreenDeploymentIdentifier, SwitchoverTimeout = SwitchoverTimeout)
  output <- .rds$switchover_blue_green_deployment_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$switchover_blue_green_deployment <- rds_switchover_blue_green_deployment

#' Switches over the specified secondary DB cluster to be the new primary
#' DB cluster in the global database cluster
#'
#' @description
#' Switches over the specified secondary DB cluster to be the new primary DB cluster in the global database cluster. Switchover operations were previously called "managed planned failovers."
#'
#' See [https://www.paws-r-sdk.com/docs/rds_switchover_global_cluster/](https://www.paws-r-sdk.com/docs/rds_switchover_global_cluster/) for full documentation.
#'
#' @param GlobalClusterIdentifier &#91;required&#93; The identifier of the global database cluster to switch over. This
#' parameter isn't case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing global database cluster
#'     (Aurora global database).
#' @param TargetDbClusterIdentifier &#91;required&#93; The identifier of the secondary Aurora DB cluster to promote to the new
#' primary for the global database cluster. Use the Amazon Resource Name
#' (ARN) for the identifier so that Aurora can locate the cluster in its
#' Amazon Web Services Region.
#'
#' @keywords internal
#'
#' @rdname rds_switchover_global_cluster
rds_switchover_global_cluster <- function(GlobalClusterIdentifier, TargetDbClusterIdentifier) {
  op <- new_operation(
    name = "SwitchoverGlobalCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$switchover_global_cluster_input(GlobalClusterIdentifier = GlobalClusterIdentifier, TargetDbClusterIdentifier = TargetDbClusterIdentifier)
  output <- .rds$switchover_global_cluster_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$switchover_global_cluster <- rds_switchover_global_cluster

#' Switches over an Oracle standby database in an Oracle Data Guard
#' environment, making it the new primary database
#'
#' @description
#' Switches over an Oracle standby database in an Oracle Data Guard environment, making it the new primary database. Issue this command in the Region that hosts the current standby database.
#'
#' See [https://www.paws-r-sdk.com/docs/rds_switchover_read_replica/](https://www.paws-r-sdk.com/docs/rds_switchover_read_replica/) for full documentation.
#'
#' @param DBInstanceIdentifier &#91;required&#93; The DB instance identifier of the current standby database. This value
#' is stored as a lowercase string.
#' 
#' Constraints:
#' 
#' -   Must match the identiﬁer of an existing Oracle read replica DB
#'     instance.
#'
#' @keywords internal
#'
#' @rdname rds_switchover_read_replica
rds_switchover_read_replica <- function(DBInstanceIdentifier) {
  op <- new_operation(
    name = "SwitchoverReadReplica",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$switchover_read_replica_input(DBInstanceIdentifier = DBInstanceIdentifier)
  output <- .rds$switchover_read_replica_output()
  config <- get_config()
  svc <- .rds$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$switchover_read_replica <- rds_switchover_read_replica
