% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_describe_db_cluster_snapshots}
\alias{neptune_describe_db_cluster_snapshots}
\title{Returns information about DB cluster snapshots}
\usage{
neptune_describe_db_cluster_snapshots(
  DBClusterIdentifier = NULL,
  DBClusterSnapshotIdentifier = NULL,
  SnapshotType = NULL,
  Filters = NULL,
  MaxRecords = NULL,
  Marker = NULL,
  IncludeShared = NULL,
  IncludePublic = NULL
)
}
\arguments{
\item{DBClusterIdentifier}{The ID of the DB cluster to retrieve the list of DB cluster snapshots
for. This parameter can't be used in conjunction with the
\code{DBClusterSnapshotIdentifier} parameter. This parameter is not
case-sensitive.

Constraints:
\itemize{
\item If supplied, must match the identifier of an existing DBCluster.
}}

\item{DBClusterSnapshotIdentifier}{A specific DB cluster snapshot identifier to describe. This parameter
can't be used in conjunction with the \code{DBClusterIdentifier} parameter.
This value is stored as a lowercase string.

Constraints:
\itemize{
\item If supplied, must match the identifier of an existing
DBClusterSnapshot.
\item If this identifier is for an automated snapshot, the \code{SnapshotType}
parameter must also be specified.
}}

\item{SnapshotType}{The type of DB cluster snapshots to be returned. You can specify one of
the following values:
\itemize{
\item \code{automated} - Return all DB cluster snapshots that have been
automatically taken by Amazon Neptune for my Amazon account.
\item \code{manual} - Return all DB cluster snapshots that have been taken by
my Amazon account.
\item \code{shared} - Return all manual DB cluster snapshots that have been
shared to my Amazon account.
\item \code{public} - Return all DB cluster snapshots that have been marked as
public.
}

If you don't specify a \code{SnapshotType} value, then both automated and
manual DB cluster snapshots are returned. You can include shared DB
cluster snapshots with these results by setting the \code{IncludeShared}
parameter to \code{true}. You can include public DB cluster snapshots with
these results by setting the \code{IncludePublic} parameter to \code{true}.

The \code{IncludeShared} and \code{IncludePublic} parameters don't apply for
\code{SnapshotType} values of \code{manual} or \code{automated}. The \code{IncludePublic}
parameter doesn't apply when \code{SnapshotType} is set to \code{shared}. The
\code{IncludeShared} parameter doesn't apply when \code{SnapshotType} is set to
\code{public}.}

\item{Filters}{This parameter is not currently supported.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so that the remaining
results can be retrieved.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous
\code{\link[=neptune_describe_db_cluster_snapshots]{describe_db_cluster_snapshots}}
request. If this parameter is specified, the response includes only
records beyond the marker, up to the value specified by \code{MaxRecords}.}

\item{IncludeShared}{True to include shared manual DB cluster snapshots from other Amazon
accounts that this Amazon account has been given permission to copy or
restore, and otherwise false. The default is \code{false}.

You can give an Amazon account permission to restore a manual DB cluster
snapshot from another Amazon account by the
\code{\link[=neptune_modify_db_cluster_snapshot_attribute]{modify_db_cluster_snapshot_attribute}}
API action.}

\item{IncludePublic}{True to include manual DB cluster snapshots that are public and can be
copied or restored by any Amazon account, and otherwise false. The
default is \code{false}. The default is false.

You can share a manual DB cluster snapshot as public by using the
\code{\link[=neptune_modify_db_cluster_snapshot_attribute]{modify_db_cluster_snapshot_attribute}}
API action.}
}
\description{
Returns information about DB cluster snapshots. This API action supports pagination.

See \url{https://www.paws-r-sdk.com/docs/neptune_describe_db_cluster_snapshots/} for full documentation.
}
\keyword{internal}
