% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memorydb_operations.R
\name{memorydb_create_parameter_group}
\alias{memorydb_create_parameter_group}
\title{Creates a new MemoryDB parameter group}
\usage{
memorydb_create_parameter_group(
  ParameterGroupName,
  Family,
  Description = NULL,
  Tags = NULL
)
}
\arguments{
\item{ParameterGroupName}{[required] The name of the parameter group.}

\item{Family}{[required] The name of the parameter group family that the parameter group can be
used with.}

\item{Description}{An optional description of the parameter group.}

\item{Tags}{A list of tags to be added to this resource. A tag is a key-value pair.
A tag key must be accompanied by a tag value, although null is accepted.}
}
\description{
Creates a new MemoryDB parameter group. A parameter group is a collection of parameters and their values that are applied to all of the nodes in any cluster. For more information, see \href{https://docs.aws.amazon.com/memorydb/latest/devguide/parametergroups.html}{Configuring engine parameters using parameter groups}.

See \url{https://www.paws-r-sdk.com/docs/memorydb_create_parameter_group/} for full documentation.
}
\keyword{internal}
