% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memorydb_operations.R
\name{memorydb_describe_reserved_nodes}
\alias{memorydb_describe_reserved_nodes}
\title{Returns information about reserved nodes for this account, or about a
specified reserved node}
\usage{
memorydb_describe_reserved_nodes(
  ReservationId = NULL,
  ReservedNodesOfferingId = NULL,
  NodeType = NULL,
  Duration = NULL,
  OfferingType = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{ReservationId}{The reserved node identifier filter value. Use this parameter to show
only the reservation that matches the specified reservation ID.}

\item{ReservedNodesOfferingId}{The offering identifier filter value. Use this parameter to show only
purchased reservations matching the specified offering identifier.}

\item{NodeType}{The node type filter value. Use this parameter to show only those
reservations matching the specified node type. For more information, see
\href{https://docs.aws.amazon.com/memorydb/latest/devguide/#reserved-nodes-supported}{Supported node types}.}

\item{Duration}{The duration filter value, specified in years or seconds. Use this
parameter to show only reservations for this duration.}

\item{OfferingType}{The offering type filter value. Use this parameter to show only the
available offerings matching the specified offering type. Valid values:
"All Upfront"|"Partial Upfront"| "No Upfront"}

\item{MaxResults}{The maximum number of records to include in the response. If more
records exist than the specified MaxRecords value, a marker is included
in the response so that the remaining results can be retrieved.}

\item{NextToken}{An optional marker returned from a prior request. Use this marker for
pagination of results from this operation. If this parameter is
specified, the response includes only records beyond the marker, up to
the value specified by MaxRecords.}
}
\description{
Returns information about reserved nodes for this account, or about a specified reserved node.

See \url{https://www.paws-r-sdk.com/docs/memorydb_describe_reserved_nodes/} for full documentation.
}
\keyword{internal}
