% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_copy_db_parameter_group}
\alias{neptune_copy_db_parameter_group}
\title{Copies the specified DB parameter group}
\usage{
neptune_copy_db_parameter_group(
  SourceDBParameterGroupIdentifier,
  TargetDBParameterGroupIdentifier,
  TargetDBParameterGroupDescription,
  Tags = NULL
)
}
\arguments{
\item{SourceDBParameterGroupIdentifier}{[required] The identifier or ARN for the source DB parameter group. For information
about creating an ARN, see \href{https://docs.aws.amazon.com/neptune/latest/userguide/#tagging.ARN.Constructing}{Constructing an Amazon Resource Name (ARN)}.

Constraints:
\itemize{
\item Must specify a valid DB parameter group.
\item Must specify a valid DB parameter group identifier, for example
\code{my-db-param-group}, or a valid ARN.
}}

\item{TargetDBParameterGroupIdentifier}{[required] The identifier for the copied DB parameter group.

Constraints:
\itemize{
\item Cannot be null, empty, or blank.
\item Must contain from 1 to 255 letters, numbers, or hyphens.
\item First character must be a letter.
\item Cannot end with a hyphen or contain two consecutive hyphens.
}

Example: \code{my-db-parameter-group}}

\item{TargetDBParameterGroupDescription}{[required] A description for the copied DB parameter group.}

\item{Tags}{The tags to be assigned to the copied DB parameter group.}
}
\description{
Copies the specified DB parameter group.

See \url{https://www.paws-r-sdk.com/docs/neptune_copy_db_parameter_group/} for full documentation.
}
\keyword{internal}
