% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptunedata_operations.R
\name{neptunedata_start_ml_data_processing_job}
\alias{neptunedata_start_ml_data_processing_job}
\title{Creates a new Neptune ML data processing job for processing the graph
data exported from Neptune for training}
\usage{
neptunedata_start_ml_data_processing_job(
  id = NULL,
  previousDataProcessingJobId = NULL,
  inputDataS3Location,
  processedDataS3Location,
  sagemakerIamRoleArn = NULL,
  neptuneIamRoleArn = NULL,
  processingInstanceType = NULL,
  processingInstanceVolumeSizeInGB = NULL,
  processingTimeOutInSeconds = NULL,
  modelType = NULL,
  configFileName = NULL,
  subnets = NULL,
  securityGroupIds = NULL,
  volumeEncryptionKMSKey = NULL,
  s3OutputEncryptionKMSKey = NULL
)
}
\arguments{
\item{id}{A unique identifier for the new job. The default is an autogenerated
UUID.}

\item{previousDataProcessingJobId}{The job ID of a completed data processing job run on an earlier version
of the data.}

\item{inputDataS3Location}{[required] The URI of the Amazon S3 location where you want SageMaker to download
the data needed to run the data processing job.}

\item{processedDataS3Location}{[required] The URI of the Amazon S3 location where you want SageMaker to save the
results of a data processing job.}

\item{sagemakerIamRoleArn}{The ARN of an IAM role for SageMaker execution. This must be listed in
your DB cluster parameter group or an error will occur.}

\item{neptuneIamRoleArn}{The Amazon Resource Name (ARN) of an IAM role that SageMaker can assume
to perform tasks on your behalf. This must be listed in your DB cluster
parameter group or an error will occur.}

\item{processingInstanceType}{The type of ML instance used during data processing. Its memory should
be large enough to hold the processed dataset. The default is the
smallest ml.r5 type whose memory is ten times larger than the size of
the exported graph data on disk.}

\item{processingInstanceVolumeSizeInGB}{The disk volume size of the processing instance. Both input data and
processed data are stored on disk, so the volume size must be large
enough to hold both data sets. The default is 0. If not specified or 0,
Neptune ML chooses the volume size automatically based on the data size.}

\item{processingTimeOutInSeconds}{Timeout in seconds for the data processing job. The default is 86,400 (1
day).}

\item{modelType}{One of the two model types that Neptune ML currently supports:
heterogeneous graph models (\code{heterogeneous}), and knowledge graph
(\code{kge}). The default is none. If not specified, Neptune ML chooses the
model type automatically based on the data.}

\item{configFileName}{A data specification file that describes how to load the exported graph
data for training. The file is automatically generated by the Neptune
export toolkit. The default is \code{training-data-configuration.json}.}

\item{subnets}{The IDs of the subnets in the Neptune VPC. The default is None.}

\item{securityGroupIds}{The VPC security group IDs. The default is None.}

\item{volumeEncryptionKMSKey}{The Amazon Key Management Service (Amazon KMS) key that SageMaker uses
to encrypt data on the storage volume attached to the ML compute
instances that run the training job. The default is None.}

\item{s3OutputEncryptionKMSKey}{The Amazon Key Management Service (Amazon KMS) key that SageMaker uses
to encrypt the output of the processing job. The default is none.}
}
\description{
Creates a new Neptune ML data processing job for processing the graph data exported from Neptune for training. See \href{https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html}{The \code{dataprocessing} command}.

See \url{https://www.paws-r-sdk.com/docs/neptunedata_start_ml_data_processing_job/} for full documentation.
}
\keyword{internal}
