% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_create_tenant_database}
\alias{rds_create_tenant_database}
\title{Creates a tenant database in a DB instance that uses the multi-tenant
configuration}
\usage{
rds_create_tenant_database(
  DBInstanceIdentifier,
  TenantDBName,
  MasterUsername,
  MasterUserPassword,
  CharacterSetName = NULL,
  NcharCharacterSetName = NULL,
  Tags = NULL
)
}
\arguments{
\item{DBInstanceIdentifier}{[required] The user-supplied DB instance identifier. RDS creates your tenant
database in this DB instance. This parameter isn't case-sensitive.}

\item{TenantDBName}{[required] The user-supplied name of the tenant database that you want to create in
your DB instance. This parameter has the same constraints as \code{DBName} in
\code{\link[=rds_create_db_instance]{create_db_instance}}.}

\item{MasterUsername}{[required] The name for the master user account in your tenant database. RDS
creates this user account in the tenant database and grants privileges
to the master user. This parameter is case-sensitive.

Constraints:
\itemize{
\item Must be 1 to 16 letters, numbers, or underscores.
\item First character must be a letter.
\item Can't be a reserved word for the chosen database engine.
}}

\item{MasterUserPassword}{[required] The password for the master user in your tenant database.

Constraints:
\itemize{
\item Must be 8 to 30 characters.
\item Can include any printable ASCII character except forward slash
(\code{/}), double quote (\verb{\\"}), at symbol (\code{@}), ampersand (\code{&}), or
single quote (\verb{\\'}).
}}

\item{CharacterSetName}{The character set for your tenant database. If you don't specify a
value, the character set name defaults to \code{AL32UTF8}.}

\item{NcharCharacterSetName}{The \code{NCHAR} value for the tenant database.}

\item{Tags}{}
}
\description{
Creates a tenant database in a DB instance that uses the multi-tenant configuration. Only RDS for Oracle container database (CDB) instances are supported.

See \url{https://www.paws-r-sdk.com/docs/rds_create_tenant_database/} for full documentation.
}
\keyword{internal}
