% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdb_operations.R
\name{docdb_add_source_identifier_to_subscription}
\alias{docdb_add_source_identifier_to_subscription}
\title{Adds a source identifier to an existing event notification subscription}
\usage{
docdb_add_source_identifier_to_subscription(SubscriptionName, SourceIdentifier)
}
\arguments{
\item{SubscriptionName}{[required] The name of the Amazon DocumentDB event notification subscription that
you want to add a source identifier to.}

\item{SourceIdentifier}{[required] The identifier of the event source to be added:
\itemize{
\item If the source type is an instance, a \code{DBInstanceIdentifier} must be
provided.
\item If the source type is a security group, a \code{DBSecurityGroupName} must
be provided.
\item If the source type is a parameter group, a \code{DBParameterGroupName}
must be provided.
\item If the source type is a snapshot, a \code{DBSnapshotIdentifier} must be
provided.
}}
}
\description{
Adds a source identifier to an existing event notification subscription.

See \url{https://www.paws-r-sdk.com/docs/docdb_add_source_identifier_to_subscription/} for full documentation.
}
\keyword{internal}
