% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memorydb_operations.R
\name{memorydb_update_cluster}
\alias{memorydb_update_cluster}
\title{Modifies the settings for a cluster}
\usage{
memorydb_update_cluster(
  ClusterName,
  Description = NULL,
  SecurityGroupIds = NULL,
  MaintenanceWindow = NULL,
  SnsTopicArn = NULL,
  SnsTopicStatus = NULL,
  ParameterGroupName = NULL,
  SnapshotWindow = NULL,
  SnapshotRetentionLimit = NULL,
  NodeType = NULL,
  EngineVersion = NULL,
  ReplicaConfiguration = NULL,
  ShardConfiguration = NULL,
  ACLName = NULL
)
}
\arguments{
\item{ClusterName}{[required] The name of the cluster to update}

\item{Description}{The description of the cluster to update}

\item{SecurityGroupIds}{The SecurityGroupIds to update}

\item{MaintenanceWindow}{Specifies the weekly time range during which maintenance on the cluster
is performed. It is specified as a range in the format
ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window
is a 60 minute period.

Valid values for \code{ddd} are:
\itemize{
\item \code{sun}
\item \code{mon}
\item \code{tue}
\item \code{wed}
\item \code{thu}
\item \code{fri}
\item \code{sat}
}

Example: \code{sun:23:00-mon:01:30}}

\item{SnsTopicArn}{The SNS topic ARN to update}

\item{SnsTopicStatus}{The status of the Amazon SNS notification topic. Notifications are sent
only if the status is active.}

\item{ParameterGroupName}{The name of the parameter group to update}

\item{SnapshotWindow}{The daily time range (in UTC) during which MemoryDB begins taking a
daily snapshot of your cluster.}

\item{SnapshotRetentionLimit}{The number of days for which MemoryDB retains automatic cluster
snapshots before deleting them. For example, if you set
SnapshotRetentionLimit to 5, a snapshot that was taken today is retained
for 5 days before being deleted.}

\item{NodeType}{A valid node type that you want to scale this cluster up or down to.}

\item{EngineVersion}{The upgraded version of the engine to be run on the nodes. You can
upgrade to a newer engine version, but you cannot downgrade to an
earlier engine version. If you want to use an earlier engine version,
you must delete the existing cluster and create it anew with the earlier
engine version.}

\item{ReplicaConfiguration}{The number of replicas that will reside in each shard}

\item{ShardConfiguration}{The number of shards in the cluster}

\item{ACLName}{The Access Control List that is associated with the cluster}
}
\description{
Modifies the settings for a cluster. You can use this operation to change one or more cluster configuration settings by specifying the settings and the new values.

See \url{https://www.paws-r-sdk.com/docs/memorydb_update_cluster/} for full documentation.
}
\keyword{internal}
