% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptunedata_operations.R
\name{neptunedata_cancel_ml_model_transform_job}
\alias{neptunedata_cancel_ml_model_transform_job}
\title{Cancels a specified model transform job}
\usage{
neptunedata_cancel_ml_model_transform_job(
  id,
  neptuneIamRoleArn = NULL,
  clean = NULL
)
}
\arguments{
\item{id}{[required] The unique ID of the model transform job to be canceled.}

\item{neptuneIamRoleArn}{The ARN of an IAM role that provides Neptune access to SageMaker and
Amazon S3 resources. This must be listed in your DB cluster parameter
group or an error will occur.}

\item{clean}{If this flag is set to \code{TRUE}, all Neptune ML S3 artifacts should be
deleted when the job is stopped. The default is \code{FALSE}.}
}
\description{
Cancels a specified model transform job. See \href{https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html}{Use a trained model to generate new model artifacts}.

See \url{https://www.paws-r-sdk.com/docs/neptunedata_cancel_ml_model_transform_job/} for full documentation.
}
\keyword{internal}
