% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_db_shard_groups}
\alias{rds_describe_db_shard_groups}
\title{Describes existing Aurora Limitless Database DB shard groups}
\usage{
rds_describe_db_shard_groups(
  DBShardGroupIdentifier = NULL,
  Filters = NULL,
  Marker = NULL,
  MaxRecords = NULL
)
}
\arguments{
\item{DBShardGroupIdentifier}{The user-supplied DB shard group identifier or the Amazon Resource Name
(ARN) of the DB shard group. If this parameter is specified, information
for only the specific DB shard group is returned. This parameter isn't
case-sensitive.

Constraints:
\itemize{
\item If supplied, must match an existing DB shard group identifier.
}}

\item{Filters}{A filter that specifies one or more DB shard groups to describe.}

\item{Marker}{An optional pagination token provided by a previous
\code{\link[=rds_describe_db_shard_groups]{describe_db_shard_groups}} request. If
this parameter is specified, the response includes only records beyond
the marker, up to the value specified by \code{MaxRecords}.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so you can retrieve the
remaining results.

Default: 100

Constraints: Minimum 20, maximum 100}
}
\description{
Describes existing Aurora Limitless Database DB shard groups.

See \url{https://www.paws-r-sdk.com/docs/rds_describe_db_shard_groups/} for full documentation.
}
\keyword{internal}
