% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_modify_tenant_database}
\alias{rds_modify_tenant_database}
\title{Modifies an existing tenant database in a DB instance}
\usage{
rds_modify_tenant_database(
  DBInstanceIdentifier,
  TenantDBName,
  MasterUserPassword = NULL,
  NewTenantDBName = NULL
)
}
\arguments{
\item{DBInstanceIdentifier}{[required] The identifier of the DB instance that contains the tenant database that
you are modifying. This parameter isn't case-sensitive.

Constraints:
\itemize{
\item Must match the identifier of an existing DB instance.
}}

\item{TenantDBName}{[required] The user-supplied name of the tenant database that you want to modify.
This parameter isn’t case-sensitive.

Constraints:
\itemize{
\item Must match the identifier of an existing tenant database.
}}

\item{MasterUserPassword}{The new password for the master user of the specified tenant database in
your DB instance.

Amazon RDS operations never return the password, so this action provides
a way to regain access to a tenant database user if the password is
lost. This includes restoring privileges that might have been
accidentally revoked.

Constraints:
\itemize{
\item Can include any printable ASCII character except \code{/}, \verb{\\"} (double
quote), \code{@}, \code{&} (ampersand), and \verb{\\'} (single quote).
}

Length constraints:
\itemize{
\item Must contain between 8 and 30 characters.
}}

\item{NewTenantDBName}{The new name of the tenant database when renaming a tenant database.
This parameter isn’t case-sensitive.

Constraints:
\itemize{
\item Can't be the string null or any other reserved word.
\item Can't be longer than 8 characters.
}}
}
\description{
Modifies an existing tenant database in a DB instance. You can change the tenant database name or the master user password. This operation is supported only for RDS for Oracle CDB instances using the multi-tenant configuration.

See \url{https://www.paws-r-sdk.com/docs/rds_modify_tenant_database/} for full documentation.
}
\keyword{internal}
