% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshiftserverless_operations.R
\name{redshiftserverless_create_snapshot}
\alias{redshiftserverless_create_snapshot}
\title{Creates a snapshot of all databases in a namespace}
\usage{
redshiftserverless_create_snapshot(
  namespaceName,
  retentionPeriod = NULL,
  snapshotName,
  tags = NULL
)
}
\arguments{
\item{namespaceName}{[required] The namespace to create a snapshot for.}

\item{retentionPeriod}{How long to retain the created snapshot.}

\item{snapshotName}{[required] The name of the snapshot.}

\item{tags}{An array of \href{https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_Tag.html}{Tag objects}
to associate with the snapshot.}
}
\description{
Creates a snapshot of all databases in a namespace. For more information about snapshots, see \href{https://docs.aws.amazon.com/redshift/latest/mgmt/}{Working with snapshots and recovery points}.

See \url{https://www.paws-r-sdk.com/docs/redshiftserverless_create_snapshot/} for full documentation.
}
\keyword{internal}
