# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include codebuild_service.R
NULL

#' Deletes one or more builds
#'
#' @description
#' Deletes one or more builds.
#'
#' See [https://paws-r.github.io/docs/codebuild/batch_delete_builds.html](https://paws-r.github.io/docs/codebuild/batch_delete_builds.html) for full documentation.
#'
#' @param ids &#91;required&#93; The IDs of the builds to delete.
#'
#' @keywords internal
#'
#' @rdname codebuild_batch_delete_builds
codebuild_batch_delete_builds <- function(ids) {
  op <- new_operation(
    name = "BatchDeleteBuilds",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$batch_delete_builds_input(ids = ids)
  output <- .codebuild$batch_delete_builds_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$batch_delete_builds <- codebuild_batch_delete_builds

#' Retrieves information about one or more batch builds
#'
#' @description
#' Retrieves information about one or more batch builds.
#'
#' See [https://paws-r.github.io/docs/codebuild/batch_get_build_batches.html](https://paws-r.github.io/docs/codebuild/batch_get_build_batches.html) for full documentation.
#'
#' @param ids &#91;required&#93; An array that contains the batch build identifiers to retrieve.
#'
#' @keywords internal
#'
#' @rdname codebuild_batch_get_build_batches
codebuild_batch_get_build_batches <- function(ids) {
  op <- new_operation(
    name = "BatchGetBuildBatches",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$batch_get_build_batches_input(ids = ids)
  output <- .codebuild$batch_get_build_batches_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$batch_get_build_batches <- codebuild_batch_get_build_batches

#' Gets information about one or more builds
#'
#' @description
#' Gets information about one or more builds.
#'
#' See [https://paws-r.github.io/docs/codebuild/batch_get_builds.html](https://paws-r.github.io/docs/codebuild/batch_get_builds.html) for full documentation.
#'
#' @param ids &#91;required&#93; The IDs of the builds.
#'
#' @keywords internal
#'
#' @rdname codebuild_batch_get_builds
codebuild_batch_get_builds <- function(ids) {
  op <- new_operation(
    name = "BatchGetBuilds",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$batch_get_builds_input(ids = ids)
  output <- .codebuild$batch_get_builds_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$batch_get_builds <- codebuild_batch_get_builds

#' Gets information about one or more build projects
#'
#' @description
#' Gets information about one or more build projects.
#'
#' See [https://paws-r.github.io/docs/codebuild/batch_get_projects.html](https://paws-r.github.io/docs/codebuild/batch_get_projects.html) for full documentation.
#'
#' @param names &#91;required&#93; The names or ARNs of the build projects. To get information about a
#' project shared with your Amazon Web Services account, its ARN must be
#' specified. You cannot specify a shared project using its name.
#'
#' @keywords internal
#'
#' @rdname codebuild_batch_get_projects
codebuild_batch_get_projects <- function(names) {
  op <- new_operation(
    name = "BatchGetProjects",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$batch_get_projects_input(names = names)
  output <- .codebuild$batch_get_projects_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$batch_get_projects <- codebuild_batch_get_projects

#' Returns an array of report groups
#'
#' @description
#' Returns an array of report groups.
#'
#' See [https://paws-r.github.io/docs/codebuild/batch_get_report_groups.html](https://paws-r.github.io/docs/codebuild/batch_get_report_groups.html) for full documentation.
#'
#' @param reportGroupArns &#91;required&#93; An array of report group ARNs that identify the report groups to return.
#'
#' @keywords internal
#'
#' @rdname codebuild_batch_get_report_groups
codebuild_batch_get_report_groups <- function(reportGroupArns) {
  op <- new_operation(
    name = "BatchGetReportGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$batch_get_report_groups_input(reportGroupArns = reportGroupArns)
  output <- .codebuild$batch_get_report_groups_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$batch_get_report_groups <- codebuild_batch_get_report_groups

#' Returns an array of reports
#'
#' @description
#' Returns an array of reports.
#'
#' See [https://paws-r.github.io/docs/codebuild/batch_get_reports.html](https://paws-r.github.io/docs/codebuild/batch_get_reports.html) for full documentation.
#'
#' @param reportArns &#91;required&#93; An array of ARNs that identify the `Report` objects to return.
#'
#' @keywords internal
#'
#' @rdname codebuild_batch_get_reports
codebuild_batch_get_reports <- function(reportArns) {
  op <- new_operation(
    name = "BatchGetReports",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$batch_get_reports_input(reportArns = reportArns)
  output <- .codebuild$batch_get_reports_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$batch_get_reports <- codebuild_batch_get_reports

#' Creates a build project
#'
#' @description
#' Creates a build project.
#'
#' See [https://paws-r.github.io/docs/codebuild/create_project.html](https://paws-r.github.io/docs/codebuild/create_project.html) for full documentation.
#'
#' @param name &#91;required&#93; The name of the build project.
#' @param description A description that makes the build project easy to identify.
#' @param source &#91;required&#93; Information about the build input source code for the build project.
#' @param secondarySources An array of `ProjectSource` objects.
#' @param sourceVersion A version of the build input to be built for this project. If not
#' specified, the latest version is used. If specified, it must be one of:
#' 
#' -   For CodeCommit: the commit ID, branch, or Git tag to use.
#' 
#' -   For GitHub: the commit ID, pull request ID, branch name, or tag name
#'     that corresponds to the version of the source code you want to
#'     build. If a pull request ID is specified, it must use the format
#'     `pr/pull-request-ID` (for example `pr/25`). If a branch name is
#'     specified, the branch's HEAD commit ID is used. If not specified,
#'     the default branch's HEAD commit ID is used.
#' 
#' -   For Bitbucket: the commit ID, branch name, or tag name that
#'     corresponds to the version of the source code you want to build. If
#'     a branch name is specified, the branch's HEAD commit ID is used. If
#'     not specified, the default branch's HEAD commit ID is used.
#' 
#' -   For Amazon S3: the version ID of the object that represents the
#'     build input ZIP file to use.
#' 
#' If `sourceVersion` is specified at the build level, then that version
#' takes precedence over this `sourceVersion` (at the project level).
#' 
#' For more information, see [Source Version Sample with
#' CodeBuild](https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html)
#' in the *CodeBuild User Guide*.
#' @param secondarySourceVersions An array of `ProjectSourceVersion` objects. If `secondarySourceVersions`
#' is specified at the build level, then they take precedence over these
#' `secondarySourceVersions` (at the project level).
#' @param artifacts &#91;required&#93; Information about the build output artifacts for the build project.
#' @param secondaryArtifacts An array of `ProjectArtifacts` objects.
#' @param cache Stores recently used information so that it can be quickly accessed at a
#' later time.
#' @param environment &#91;required&#93; Information about the build environment for the build project.
#' @param serviceRole &#91;required&#93; The ARN of the IAM role that enables CodeBuild to interact with
#' dependent Amazon Web Services services on behalf of the Amazon Web
#' Services account.
#' @param timeoutInMinutes How long, in minutes, from 5 to 480 (8 hours), for CodeBuild to wait
#' before it times out any build that has not been marked as completed. The
#' default is 60 minutes.
#' @param queuedTimeoutInMinutes The number of minutes a build is allowed to be queued before it times
#' out.
#' @param encryptionKey The Key Management Service customer master key (CMK) to be used for
#' encrypting the build output artifacts.
#' 
#' You can use a cross-account KMS key to encrypt the build output
#' artifacts if your service role has permission to that key.
#' 
#' You can specify either the Amazon Resource Name (ARN) of the CMK or, if
#' available, the CMK's alias (using the format `alias/<alias-name>`).
#' @param tags A list of tag key and value pairs associated with this build project.
#' 
#' These tags are available for use by Amazon Web Services services that
#' support CodeBuild build project tags.
#' @param vpcConfig VpcConfig enables CodeBuild to access resources in an Amazon VPC.
#' @param badgeEnabled Set this to true to generate a publicly accessible URL for your
#' project's build badge.
#' @param logsConfig Information about logs for the build project. These can be logs in
#' CloudWatch Logs, logs uploaded to a specified S3 bucket, or both.
#' @param fileSystemLocations An array of `ProjectFileSystemLocation` objects for a CodeBuild build
#' project. A `ProjectFileSystemLocation` object specifies the
#' `identifier`, `location`, `mountOptions`, `mountPoint`, and `type` of a
#' file system created using Amazon Elastic File System.
#' @param buildBatchConfig A ProjectBuildBatchConfig object that defines the batch build options
#' for the project.
#' @param concurrentBuildLimit The maximum number of concurrent builds that are allowed for this
#' project.
#' 
#' New builds are only started if the current number of builds is less than
#' or equal to this limit. If the current build count meets this limit, new
#' builds are throttled and are not run.
#'
#' @keywords internal
#'
#' @rdname codebuild_create_project
codebuild_create_project <- function(name, description = NULL, source, secondarySources = NULL, sourceVersion = NULL, secondarySourceVersions = NULL, artifacts, secondaryArtifacts = NULL, cache = NULL, environment, serviceRole, timeoutInMinutes = NULL, queuedTimeoutInMinutes = NULL, encryptionKey = NULL, tags = NULL, vpcConfig = NULL, badgeEnabled = NULL, logsConfig = NULL, fileSystemLocations = NULL, buildBatchConfig = NULL, concurrentBuildLimit = NULL) {
  op <- new_operation(
    name = "CreateProject",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$create_project_input(name = name, description = description, source = source, secondarySources = secondarySources, sourceVersion = sourceVersion, secondarySourceVersions = secondarySourceVersions, artifacts = artifacts, secondaryArtifacts = secondaryArtifacts, cache = cache, environment = environment, serviceRole = serviceRole, timeoutInMinutes = timeoutInMinutes, queuedTimeoutInMinutes = queuedTimeoutInMinutes, encryptionKey = encryptionKey, tags = tags, vpcConfig = vpcConfig, badgeEnabled = badgeEnabled, logsConfig = logsConfig, fileSystemLocations = fileSystemLocations, buildBatchConfig = buildBatchConfig, concurrentBuildLimit = concurrentBuildLimit)
  output <- .codebuild$create_project_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$create_project <- codebuild_create_project

#' Creates a report group
#'
#' @description
#' Creates a report group. A report group contains a collection of reports.
#'
#' See [https://paws-r.github.io/docs/codebuild/create_report_group.html](https://paws-r.github.io/docs/codebuild/create_report_group.html) for full documentation.
#'
#' @param name &#91;required&#93; The name of the report group.
#' @param type &#91;required&#93; The type of report group.
#' @param exportConfig &#91;required&#93; A `ReportExportConfig` object that contains information about where the
#' report group test results are exported.
#' @param tags A list of tag key and value pairs associated with this report group.
#' 
#' These tags are available for use by Amazon Web Services services that
#' support CodeBuild report group tags.
#'
#' @keywords internal
#'
#' @rdname codebuild_create_report_group
codebuild_create_report_group <- function(name, type, exportConfig, tags = NULL) {
  op <- new_operation(
    name = "CreateReportGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$create_report_group_input(name = name, type = type, exportConfig = exportConfig, tags = tags)
  output <- .codebuild$create_report_group_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$create_report_group <- codebuild_create_report_group

#' For an existing CodeBuild build project that has its source code stored
#' in a GitHub or Bitbucket repository, enables CodeBuild to start
#' rebuilding the source code every time a code change is pushed to the
#' repository
#'
#' @description
#' For an existing CodeBuild build project that has its source code stored in a GitHub or Bitbucket repository, enables CodeBuild to start rebuilding the source code every time a code change is pushed to the repository.
#'
#' See [https://paws-r.github.io/docs/codebuild/create_webhook.html](https://paws-r.github.io/docs/codebuild/create_webhook.html) for full documentation.
#'
#' @param projectName &#91;required&#93; The name of the CodeBuild project.
#' @param branchFilter A regular expression used to determine which repository branches are
#' built when a webhook is triggered. If the name of a branch matches the
#' regular expression, then it is built. If `branchFilter` is empty, then
#' all branches are built.
#' 
#' It is recommended that you use `filterGroups` instead of `branchFilter`.
#' @param filterGroups An array of arrays of `WebhookFilter` objects used to determine which
#' webhooks are triggered. At least one `WebhookFilter` in the array must
#' specify `EVENT` as its `type`.
#' 
#' For a build to be triggered, at least one filter group in the
#' `filterGroups` array must pass. For a filter group to pass, each of its
#' filters must pass.
#' @param buildType Specifies the type of build this webhook will trigger.
#'
#' @keywords internal
#'
#' @rdname codebuild_create_webhook
codebuild_create_webhook <- function(projectName, branchFilter = NULL, filterGroups = NULL, buildType = NULL) {
  op <- new_operation(
    name = "CreateWebhook",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$create_webhook_input(projectName = projectName, branchFilter = branchFilter, filterGroups = filterGroups, buildType = buildType)
  output <- .codebuild$create_webhook_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$create_webhook <- codebuild_create_webhook

#' Deletes a batch build
#'
#' @description
#' Deletes a batch build.
#'
#' See [https://paws-r.github.io/docs/codebuild/delete_build_batch.html](https://paws-r.github.io/docs/codebuild/delete_build_batch.html) for full documentation.
#'
#' @param id &#91;required&#93; The identifier of the batch build to delete.
#'
#' @keywords internal
#'
#' @rdname codebuild_delete_build_batch
codebuild_delete_build_batch <- function(id) {
  op <- new_operation(
    name = "DeleteBuildBatch",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$delete_build_batch_input(id = id)
  output <- .codebuild$delete_build_batch_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$delete_build_batch <- codebuild_delete_build_batch

#' Deletes a build project
#'
#' @description
#' Deletes a build project. When you delete a project, its builds are not deleted.
#'
#' See [https://paws-r.github.io/docs/codebuild/delete_project.html](https://paws-r.github.io/docs/codebuild/delete_project.html) for full documentation.
#'
#' @param name &#91;required&#93; The name of the build project.
#'
#' @keywords internal
#'
#' @rdname codebuild_delete_project
codebuild_delete_project <- function(name) {
  op <- new_operation(
    name = "DeleteProject",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$delete_project_input(name = name)
  output <- .codebuild$delete_project_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$delete_project <- codebuild_delete_project

#' Deletes a report
#'
#' @description
#' Deletes a report.
#'
#' See [https://paws-r.github.io/docs/codebuild/delete_report.html](https://paws-r.github.io/docs/codebuild/delete_report.html) for full documentation.
#'
#' @param arn &#91;required&#93; The ARN of the report to delete.
#'
#' @keywords internal
#'
#' @rdname codebuild_delete_report
codebuild_delete_report <- function(arn) {
  op <- new_operation(
    name = "DeleteReport",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$delete_report_input(arn = arn)
  output <- .codebuild$delete_report_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$delete_report <- codebuild_delete_report

#' Deletes a report group
#'
#' @description
#' Deletes a report group. Before you delete a report group, you must delete its reports.
#'
#' See [https://paws-r.github.io/docs/codebuild/delete_report_group.html](https://paws-r.github.io/docs/codebuild/delete_report_group.html) for full documentation.
#'
#' @param arn &#91;required&#93; The ARN of the report group to delete.
#' @param deleteReports If `true`, deletes any reports that belong to a report group before
#' deleting the report group.
#' 
#' If `false`, you must delete any reports in the report group. Use
#' [`list_reports_for_report_group`][codebuild_list_reports_for_report_group]
#' to get the reports in a report group. Use
#' [`delete_report`][codebuild_delete_report] to delete the reports. If you
#' call [`delete_report_group`][codebuild_delete_report_group] for a report
#' group that contains one or more reports, an exception is thrown.
#'
#' @keywords internal
#'
#' @rdname codebuild_delete_report_group
codebuild_delete_report_group <- function(arn, deleteReports = NULL) {
  op <- new_operation(
    name = "DeleteReportGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$delete_report_group_input(arn = arn, deleteReports = deleteReports)
  output <- .codebuild$delete_report_group_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$delete_report_group <- codebuild_delete_report_group

#' Deletes a resource policy that is identified by its resource ARN
#'
#' @description
#' Deletes a resource policy that is identified by its resource ARN.
#'
#' See [https://paws-r.github.io/docs/codebuild/delete_resource_policy.html](https://paws-r.github.io/docs/codebuild/delete_resource_policy.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource that is associated with the resource policy.
#'
#' @keywords internal
#'
#' @rdname codebuild_delete_resource_policy
codebuild_delete_resource_policy <- function(resourceArn) {
  op <- new_operation(
    name = "DeleteResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$delete_resource_policy_input(resourceArn = resourceArn)
  output <- .codebuild$delete_resource_policy_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$delete_resource_policy <- codebuild_delete_resource_policy

#' Deletes a set of GitHub, GitHub Enterprise, or Bitbucket source
#' credentials
#'
#' @description
#' Deletes a set of GitHub, GitHub Enterprise, or Bitbucket source credentials.
#'
#' See [https://paws-r.github.io/docs/codebuild/delete_source_credentials.html](https://paws-r.github.io/docs/codebuild/delete_source_credentials.html) for full documentation.
#'
#' @param arn &#91;required&#93; The Amazon Resource Name (ARN) of the token.
#'
#' @keywords internal
#'
#' @rdname codebuild_delete_source_credentials
codebuild_delete_source_credentials <- function(arn) {
  op <- new_operation(
    name = "DeleteSourceCredentials",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$delete_source_credentials_input(arn = arn)
  output <- .codebuild$delete_source_credentials_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$delete_source_credentials <- codebuild_delete_source_credentials

#' For an existing CodeBuild build project that has its source code stored
#' in a GitHub or Bitbucket repository, stops CodeBuild from rebuilding the
#' source code every time a code change is pushed to the repository
#'
#' @description
#' For an existing CodeBuild build project that has its source code stored in a GitHub or Bitbucket repository, stops CodeBuild from rebuilding the source code every time a code change is pushed to the repository.
#'
#' See [https://paws-r.github.io/docs/codebuild/delete_webhook.html](https://paws-r.github.io/docs/codebuild/delete_webhook.html) for full documentation.
#'
#' @param projectName &#91;required&#93; The name of the CodeBuild project.
#'
#' @keywords internal
#'
#' @rdname codebuild_delete_webhook
codebuild_delete_webhook <- function(projectName) {
  op <- new_operation(
    name = "DeleteWebhook",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$delete_webhook_input(projectName = projectName)
  output <- .codebuild$delete_webhook_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$delete_webhook <- codebuild_delete_webhook

#' Retrieves one or more code coverage reports
#'
#' @description
#' Retrieves one or more code coverage reports.
#'
#' See [https://paws-r.github.io/docs/codebuild/describe_code_coverages.html](https://paws-r.github.io/docs/codebuild/describe_code_coverages.html) for full documentation.
#'
#' @param reportArn &#91;required&#93; The ARN of the report for which test cases are returned.
#' @param nextToken The `nextToken` value returned from a previous call to
#' [`describe_code_coverages`][codebuild_describe_code_coverages]. This
#' specifies the next item to return. To return the beginning of the list,
#' exclude this parameter.
#' @param maxResults The maximum number of results to return.
#' @param sortOrder Specifies if the results are sorted in ascending or descending order.
#' @param sortBy Specifies how the results are sorted. Possible values are:
#' 
#' **FILE_PATH**
#' 
#' The results are sorted by file path.
#' 
#' **LINE_COVERAGE_PERCENTAGE**
#' 
#' The results are sorted by the percentage of lines that are covered.
#' @param minLineCoveragePercentage The minimum line coverage percentage to report.
#' @param maxLineCoveragePercentage The maximum line coverage percentage to report.
#'
#' @keywords internal
#'
#' @rdname codebuild_describe_code_coverages
codebuild_describe_code_coverages <- function(reportArn, nextToken = NULL, maxResults = NULL, sortOrder = NULL, sortBy = NULL, minLineCoveragePercentage = NULL, maxLineCoveragePercentage = NULL) {
  op <- new_operation(
    name = "DescribeCodeCoverages",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$describe_code_coverages_input(reportArn = reportArn, nextToken = nextToken, maxResults = maxResults, sortOrder = sortOrder, sortBy = sortBy, minLineCoveragePercentage = minLineCoveragePercentage, maxLineCoveragePercentage = maxLineCoveragePercentage)
  output <- .codebuild$describe_code_coverages_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$describe_code_coverages <- codebuild_describe_code_coverages

#' Returns a list of details about test cases for a report
#'
#' @description
#' Returns a list of details about test cases for a report.
#'
#' See [https://paws-r.github.io/docs/codebuild/describe_test_cases.html](https://paws-r.github.io/docs/codebuild/describe_test_cases.html) for full documentation.
#'
#' @param reportArn &#91;required&#93; The ARN of the report for which test cases are returned.
#' @param nextToken During a previous call, the maximum number of items that can be returned
#' is the value specified in `maxResults`. If there more items in the list,
#' then a unique string called a *nextToken* is returned. To get the next
#' batch of items in the list, call this operation again, adding the next
#' token to the call. To get all of the items in the list, keep calling
#' this operation with each subsequent next token that is returned, until
#' no more next tokens are returned.
#' @param maxResults The maximum number of paginated test cases returned per response. Use
#' `nextToken` to iterate pages in the list of returned `TestCase` objects.
#' The default value is 100.
#' @param filter A `TestCaseFilter` object used to filter the returned reports.
#'
#' @keywords internal
#'
#' @rdname codebuild_describe_test_cases
codebuild_describe_test_cases <- function(reportArn, nextToken = NULL, maxResults = NULL, filter = NULL) {
  op <- new_operation(
    name = "DescribeTestCases",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$describe_test_cases_input(reportArn = reportArn, nextToken = nextToken, maxResults = maxResults, filter = filter)
  output <- .codebuild$describe_test_cases_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$describe_test_cases <- codebuild_describe_test_cases

#' Analyzes and accumulates test report values for the specified test
#' reports
#'
#' @description
#' Analyzes and accumulates test report values for the specified test reports.
#'
#' See [https://paws-r.github.io/docs/codebuild/get_report_group_trend.html](https://paws-r.github.io/docs/codebuild/get_report_group_trend.html) for full documentation.
#'
#' @param reportGroupArn &#91;required&#93; The ARN of the report group that contains the reports to analyze.
#' @param numOfReports The number of reports to analyze. This operation always retrieves the
#' most recent reports.
#' 
#' If this parameter is omitted, the most recent 100 reports are analyzed.
#' @param trendField &#91;required&#93; The test report value to accumulate. This must be one of the following
#' values:
#' 
#' **Test reports:**
#' 
#' **DURATION**
#' 
#' Accumulate the test run times for the specified reports.
#' 
#' **PASS_RATE**
#' 
#' Accumulate the percentage of tests that passed for the specified test
#' reports.
#' 
#' **TOTAL**
#' 
#' Accumulate the total number of tests for the specified test reports.
#' 
#' **Code coverage reports:**
#' 
#' **BRANCH_COVERAGE**
#' 
#' Accumulate the branch coverage percentages for the specified test
#' reports.
#' 
#' **BRANCHES_COVERED**
#' 
#' Accumulate the branches covered values for the specified test reports.
#' 
#' **BRANCHES_MISSED**
#' 
#' Accumulate the branches missed values for the specified test reports.
#' 
#' **LINE_COVERAGE**
#' 
#' Accumulate the line coverage percentages for the specified test reports.
#' 
#' **LINES_COVERED**
#' 
#' Accumulate the lines covered values for the specified test reports.
#' 
#' **LINES_MISSED**
#' 
#' Accumulate the lines not covered values for the specified test reports.
#'
#' @keywords internal
#'
#' @rdname codebuild_get_report_group_trend
codebuild_get_report_group_trend <- function(reportGroupArn, numOfReports = NULL, trendField) {
  op <- new_operation(
    name = "GetReportGroupTrend",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$get_report_group_trend_input(reportGroupArn = reportGroupArn, numOfReports = numOfReports, trendField = trendField)
  output <- .codebuild$get_report_group_trend_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$get_report_group_trend <- codebuild_get_report_group_trend

#' Gets a resource policy that is identified by its resource ARN
#'
#' @description
#' Gets a resource policy that is identified by its resource ARN.
#'
#' See [https://paws-r.github.io/docs/codebuild/get_resource_policy.html](https://paws-r.github.io/docs/codebuild/get_resource_policy.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource that is associated with the resource policy.
#'
#' @keywords internal
#'
#' @rdname codebuild_get_resource_policy
codebuild_get_resource_policy <- function(resourceArn) {
  op <- new_operation(
    name = "GetResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$get_resource_policy_input(resourceArn = resourceArn)
  output <- .codebuild$get_resource_policy_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$get_resource_policy <- codebuild_get_resource_policy

#' Imports the source repository credentials for an CodeBuild project that
#' has its source code stored in a GitHub, GitHub Enterprise, or Bitbucket
#' repository
#'
#' @description
#' Imports the source repository credentials for an CodeBuild project that has its source code stored in a GitHub, GitHub Enterprise, or Bitbucket repository.
#'
#' See [https://paws-r.github.io/docs/codebuild/import_source_credentials.html](https://paws-r.github.io/docs/codebuild/import_source_credentials.html) for full documentation.
#'
#' @param username The Bitbucket username when the `authType` is BASIC_AUTH. This parameter
#' is not valid for other types of source providers or connections.
#' @param token &#91;required&#93; For GitHub or GitHub Enterprise, this is the personal access token. For
#' Bitbucket, this is the app password.
#' @param serverType &#91;required&#93; The source provider used for this project.
#' @param authType &#91;required&#93; The type of authentication used to connect to a GitHub, GitHub
#' Enterprise, or Bitbucket repository. An OAUTH connection is not
#' supported by the API and must be created using the CodeBuild console.
#' @param shouldOverwrite Set to `false` to prevent overwriting the repository source credentials.
#' Set to `true` to overwrite the repository source credentials. The
#' default value is `true`.
#'
#' @keywords internal
#'
#' @rdname codebuild_import_source_credentials
codebuild_import_source_credentials <- function(username = NULL, token, serverType, authType, shouldOverwrite = NULL) {
  op <- new_operation(
    name = "ImportSourceCredentials",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$import_source_credentials_input(username = username, token = token, serverType = serverType, authType = authType, shouldOverwrite = shouldOverwrite)
  output <- .codebuild$import_source_credentials_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$import_source_credentials <- codebuild_import_source_credentials

#' Resets the cache for a project
#'
#' @description
#' Resets the cache for a project.
#'
#' See [https://paws-r.github.io/docs/codebuild/invalidate_project_cache.html](https://paws-r.github.io/docs/codebuild/invalidate_project_cache.html) for full documentation.
#'
#' @param projectName &#91;required&#93; The name of the CodeBuild build project that the cache is reset for.
#'
#' @keywords internal
#'
#' @rdname codebuild_invalidate_project_cache
codebuild_invalidate_project_cache <- function(projectName) {
  op <- new_operation(
    name = "InvalidateProjectCache",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$invalidate_project_cache_input(projectName = projectName)
  output <- .codebuild$invalidate_project_cache_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$invalidate_project_cache <- codebuild_invalidate_project_cache

#' Retrieves the identifiers of your build batches in the current region
#'
#' @description
#' Retrieves the identifiers of your build batches in the current region.
#'
#' See [https://paws-r.github.io/docs/codebuild/list_build_batches.html](https://paws-r.github.io/docs/codebuild/list_build_batches.html) for full documentation.
#'
#' @param filter A `BuildBatchFilter` object that specifies the filters for the search.
#' @param maxResults The maximum number of results to return.
#' @param sortOrder Specifies the sort order of the returned items. Valid values include:
#' 
#' -   `ASCENDING`: List the batch build identifiers in ascending order by
#'     identifier.
#' 
#' -   `DESCENDING`: List the batch build identifiers in descending order
#'     by identifier.
#' @param nextToken The `nextToken` value returned from a previous call to
#' [`list_build_batches`][codebuild_list_build_batches]. This specifies the
#' next item to return. To return the beginning of the list, exclude this
#' parameter.
#'
#' @keywords internal
#'
#' @rdname codebuild_list_build_batches
codebuild_list_build_batches <- function(filter = NULL, maxResults = NULL, sortOrder = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListBuildBatches",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$list_build_batches_input(filter = filter, maxResults = maxResults, sortOrder = sortOrder, nextToken = nextToken)
  output <- .codebuild$list_build_batches_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$list_build_batches <- codebuild_list_build_batches

#' Retrieves the identifiers of the build batches for a specific project
#'
#' @description
#' Retrieves the identifiers of the build batches for a specific project.
#'
#' See [https://paws-r.github.io/docs/codebuild/list_build_batches_for_project.html](https://paws-r.github.io/docs/codebuild/list_build_batches_for_project.html) for full documentation.
#'
#' @param projectName The name of the project.
#' @param filter A `BuildBatchFilter` object that specifies the filters for the search.
#' @param maxResults The maximum number of results to return.
#' @param sortOrder Specifies the sort order of the returned items. Valid values include:
#' 
#' -   `ASCENDING`: List the batch build identifiers in ascending order by
#'     identifier.
#' 
#' -   `DESCENDING`: List the batch build identifiers in descending order
#'     by identifier.
#' @param nextToken The `nextToken` value returned from a previous call to
#' [`list_build_batches_for_project`][codebuild_list_build_batches_for_project].
#' This specifies the next item to return. To return the beginning of the
#' list, exclude this parameter.
#'
#' @keywords internal
#'
#' @rdname codebuild_list_build_batches_for_project
codebuild_list_build_batches_for_project <- function(projectName = NULL, filter = NULL, maxResults = NULL, sortOrder = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListBuildBatchesForProject",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$list_build_batches_for_project_input(projectName = projectName, filter = filter, maxResults = maxResults, sortOrder = sortOrder, nextToken = nextToken)
  output <- .codebuild$list_build_batches_for_project_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$list_build_batches_for_project <- codebuild_list_build_batches_for_project

#' Gets a list of build IDs, with each build ID representing a single build
#'
#' @description
#' Gets a list of build IDs, with each build ID representing a single build.
#'
#' See [https://paws-r.github.io/docs/codebuild/list_builds.html](https://paws-r.github.io/docs/codebuild/list_builds.html) for full documentation.
#'
#' @param sortOrder The order to list build IDs. Valid values include:
#' 
#' -   `ASCENDING`: List the build IDs in ascending order by build ID.
#' 
#' -   `DESCENDING`: List the build IDs in descending order by build ID.
#' @param nextToken During a previous call, if there are more than 100 items in the list,
#' only the first 100 items are returned, along with a unique string called
#' a *nextToken*. To get the next batch of items in the list, call this
#' operation again, adding the next token to the call. To get all of the
#' items in the list, keep calling this operation with each subsequent next
#' token that is returned, until no more next tokens are returned.
#'
#' @keywords internal
#'
#' @rdname codebuild_list_builds
codebuild_list_builds <- function(sortOrder = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListBuilds",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$list_builds_input(sortOrder = sortOrder, nextToken = nextToken)
  output <- .codebuild$list_builds_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$list_builds <- codebuild_list_builds

#' Gets a list of build identifiers for the specified build project, with
#' each build identifier representing a single build
#'
#' @description
#' Gets a list of build identifiers for the specified build project, with each build identifier representing a single build.
#'
#' See [https://paws-r.github.io/docs/codebuild/list_builds_for_project.html](https://paws-r.github.io/docs/codebuild/list_builds_for_project.html) for full documentation.
#'
#' @param projectName &#91;required&#93; The name of the CodeBuild project.
#' @param sortOrder The order to sort the results in. The results are sorted by build
#' number, not the build identifier. If this is not specified, the results
#' are sorted in descending order.
#' 
#' Valid values include:
#' 
#' -   `ASCENDING`: List the build identifiers in ascending order, by build
#'     number.
#' 
#' -   `DESCENDING`: List the build identifiers in descending order, by
#'     build number.
#' 
#' If the project has more than 100 builds, setting the sort order will
#' result in an error.
#' @param nextToken During a previous call, if there are more than 100 items in the list,
#' only the first 100 items are returned, along with a unique string called
#' a *nextToken*. To get the next batch of items in the list, call this
#' operation again, adding the next token to the call. To get all of the
#' items in the list, keep calling this operation with each subsequent next
#' token that is returned, until no more next tokens are returned.
#'
#' @keywords internal
#'
#' @rdname codebuild_list_builds_for_project
codebuild_list_builds_for_project <- function(projectName, sortOrder = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListBuildsForProject",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$list_builds_for_project_input(projectName = projectName, sortOrder = sortOrder, nextToken = nextToken)
  output <- .codebuild$list_builds_for_project_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$list_builds_for_project <- codebuild_list_builds_for_project

#' Gets information about Docker images that are managed by CodeBuild
#'
#' @description
#' Gets information about Docker images that are managed by CodeBuild.
#'
#' See [https://paws-r.github.io/docs/codebuild/list_curated_environment_images.html](https://paws-r.github.io/docs/codebuild/list_curated_environment_images.html) for full documentation.
#'
#' @keywords internal
#'
#' @rdname codebuild_list_curated_environment_images
codebuild_list_curated_environment_images <- function() {
  op <- new_operation(
    name = "ListCuratedEnvironmentImages",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$list_curated_environment_images_input()
  output <- .codebuild$list_curated_environment_images_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$list_curated_environment_images <- codebuild_list_curated_environment_images

#' Gets a list of build project names, with each build project name
#' representing a single build project
#'
#' @description
#' Gets a list of build project names, with each build project name representing a single build project.
#'
#' See [https://paws-r.github.io/docs/codebuild/list_projects.html](https://paws-r.github.io/docs/codebuild/list_projects.html) for full documentation.
#'
#' @param sortBy The criterion to be used to list build project names. Valid values
#' include:
#' 
#' -   `CREATED_TIME`: List based on when each build project was created.
#' 
#' -   `LAST_MODIFIED_TIME`: List based on when information about each
#'     build project was last changed.
#' 
#' -   `NAME`: List based on each build project's name.
#' 
#' Use `sortOrder` to specify in what order to list the build project names
#' based on the preceding criteria.
#' @param sortOrder The order in which to list build projects. Valid values include:
#' 
#' -   `ASCENDING`: List in ascending order.
#' 
#' -   `DESCENDING`: List in descending order.
#' 
#' Use `sortBy` to specify the criterion to be used to list build project
#' names.
#' @param nextToken During a previous call, if there are more than 100 items in the list,
#' only the first 100 items are returned, along with a unique string called
#' a *nextToken*. To get the next batch of items in the list, call this
#' operation again, adding the next token to the call. To get all of the
#' items in the list, keep calling this operation with each subsequent next
#' token that is returned, until no more next tokens are returned.
#'
#' @keywords internal
#'
#' @rdname codebuild_list_projects
codebuild_list_projects <- function(sortBy = NULL, sortOrder = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListProjects",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$list_projects_input(sortBy = sortBy, sortOrder = sortOrder, nextToken = nextToken)
  output <- .codebuild$list_projects_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$list_projects <- codebuild_list_projects

#' Gets a list ARNs for the report groups in the current Amazon Web
#' Services account
#'
#' @description
#' Gets a list ARNs for the report groups in the current Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/codebuild/list_report_groups.html](https://paws-r.github.io/docs/codebuild/list_report_groups.html) for full documentation.
#'
#' @param sortOrder Used to specify the order to sort the list of returned report groups.
#' Valid values are `ASCENDING` and `DESCENDING`.
#' @param sortBy The criterion to be used to list build report groups. Valid values
#' include:
#' 
#' -   `CREATED_TIME`: List based on when each report group was created.
#' 
#' -   `LAST_MODIFIED_TIME`: List based on when each report group was last
#'     changed.
#' 
#' -   `NAME`: List based on each report group's name.
#' @param nextToken During a previous call, the maximum number of items that can be returned
#' is the value specified in `maxResults`. If there more items in the list,
#' then a unique string called a *nextToken* is returned. To get the next
#' batch of items in the list, call this operation again, adding the next
#' token to the call. To get all of the items in the list, keep calling
#' this operation with each subsequent next token that is returned, until
#' no more next tokens are returned.
#' @param maxResults The maximum number of paginated report groups returned per response. Use
#' `nextToken` to iterate pages in the list of returned `ReportGroup`
#' objects. The default value is 100.
#'
#' @keywords internal
#'
#' @rdname codebuild_list_report_groups
codebuild_list_report_groups <- function(sortOrder = NULL, sortBy = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListReportGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$list_report_groups_input(sortOrder = sortOrder, sortBy = sortBy, nextToken = nextToken, maxResults = maxResults)
  output <- .codebuild$list_report_groups_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$list_report_groups <- codebuild_list_report_groups

#' Returns a list of ARNs for the reports in the current Amazon Web
#' Services account
#'
#' @description
#' Returns a list of ARNs for the reports in the current Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/codebuild/list_reports.html](https://paws-r.github.io/docs/codebuild/list_reports.html) for full documentation.
#'
#' @param sortOrder Specifies the sort order for the list of returned reports. Valid values
#' are:
#' 
#' -   `ASCENDING`: return reports in chronological order based on their
#'     creation date.
#' 
#' -   `DESCENDING`: return reports in the reverse chronological order
#'     based on their creation date.
#' @param nextToken During a previous call, the maximum number of items that can be returned
#' is the value specified in `maxResults`. If there more items in the list,
#' then a unique string called a *nextToken* is returned. To get the next
#' batch of items in the list, call this operation again, adding the next
#' token to the call. To get all of the items in the list, keep calling
#' this operation with each subsequent next token that is returned, until
#' no more next tokens are returned.
#' @param maxResults The maximum number of paginated reports returned per response. Use
#' `nextToken` to iterate pages in the list of returned `Report` objects.
#' The default value is 100.
#' @param filter A `ReportFilter` object used to filter the returned reports.
#'
#' @keywords internal
#'
#' @rdname codebuild_list_reports
codebuild_list_reports <- function(sortOrder = NULL, nextToken = NULL, maxResults = NULL, filter = NULL) {
  op <- new_operation(
    name = "ListReports",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$list_reports_input(sortOrder = sortOrder, nextToken = nextToken, maxResults = maxResults, filter = filter)
  output <- .codebuild$list_reports_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$list_reports <- codebuild_list_reports

#' Returns a list of ARNs for the reports that belong to a ReportGroup
#'
#' @description
#' Returns a list of ARNs for the reports that belong to a `ReportGroup`.
#'
#' See [https://paws-r.github.io/docs/codebuild/list_reports_for_report_group.html](https://paws-r.github.io/docs/codebuild/list_reports_for_report_group.html) for full documentation.
#'
#' @param reportGroupArn &#91;required&#93; The ARN of the report group for which you want to return report ARNs.
#' @param nextToken During a previous call, the maximum number of items that can be returned
#' is the value specified in `maxResults`. If there more items in the list,
#' then a unique string called a *nextToken* is returned. To get the next
#' batch of items in the list, call this operation again, adding the next
#' token to the call. To get all of the items in the list, keep calling
#' this operation with each subsequent next token that is returned, until
#' no more next tokens are returned.
#' @param sortOrder Use to specify whether the results are returned in ascending or
#' descending order.
#' @param maxResults The maximum number of paginated reports in this report group returned
#' per response. Use `nextToken` to iterate pages in the list of returned
#' `Report` objects. The default value is 100.
#' @param filter A `ReportFilter` object used to filter the returned reports.
#'
#' @keywords internal
#'
#' @rdname codebuild_list_reports_for_report_group
codebuild_list_reports_for_report_group <- function(reportGroupArn, nextToken = NULL, sortOrder = NULL, maxResults = NULL, filter = NULL) {
  op <- new_operation(
    name = "ListReportsForReportGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$list_reports_for_report_group_input(reportGroupArn = reportGroupArn, nextToken = nextToken, sortOrder = sortOrder, maxResults = maxResults, filter = filter)
  output <- .codebuild$list_reports_for_report_group_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$list_reports_for_report_group <- codebuild_list_reports_for_report_group

#' Gets a list of projects that are shared with other Amazon Web Services
#' accounts or users
#'
#' @description
#' Gets a list of projects that are shared with other Amazon Web Services accounts or users.
#'
#' See [https://paws-r.github.io/docs/codebuild/list_shared_projects.html](https://paws-r.github.io/docs/codebuild/list_shared_projects.html) for full documentation.
#'
#' @param sortBy The criterion to be used to list build projects shared with the current
#' Amazon Web Services account or user. Valid values include:
#' 
#' -   `ARN`: List based on the ARN.
#' 
#' -   `MODIFIED_TIME`: List based on when information about the shared
#'     project was last changed.
#' @param sortOrder The order in which to list shared build projects. Valid values include:
#' 
#' -   `ASCENDING`: List in ascending order.
#' 
#' -   `DESCENDING`: List in descending order.
#' @param maxResults The maximum number of paginated shared build projects returned per
#' response. Use `nextToken` to iterate pages in the list of returned
#' `Project` objects. The default value is 100.
#' @param nextToken During a previous call, the maximum number of items that can be returned
#' is the value specified in `maxResults`. If there more items in the list,
#' then a unique string called a *nextToken* is returned. To get the next
#' batch of items in the list, call this operation again, adding the next
#' token to the call. To get all of the items in the list, keep calling
#' this operation with each subsequent next token that is returned, until
#' no more next tokens are returned.
#'
#' @keywords internal
#'
#' @rdname codebuild_list_shared_projects
codebuild_list_shared_projects <- function(sortBy = NULL, sortOrder = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListSharedProjects",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$list_shared_projects_input(sortBy = sortBy, sortOrder = sortOrder, maxResults = maxResults, nextToken = nextToken)
  output <- .codebuild$list_shared_projects_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$list_shared_projects <- codebuild_list_shared_projects

#' Gets a list of report groups that are shared with other Amazon Web
#' Services accounts or users
#'
#' @description
#' Gets a list of report groups that are shared with other Amazon Web Services accounts or users.
#'
#' See [https://paws-r.github.io/docs/codebuild/list_shared_report_groups.html](https://paws-r.github.io/docs/codebuild/list_shared_report_groups.html) for full documentation.
#'
#' @param sortOrder The order in which to list shared report groups. Valid values include:
#' 
#' -   `ASCENDING`: List in ascending order.
#' 
#' -   `DESCENDING`: List in descending order.
#' @param sortBy The criterion to be used to list report groups shared with the current
#' Amazon Web Services account or user. Valid values include:
#' 
#' -   `ARN`: List based on the ARN.
#' 
#' -   `MODIFIED_TIME`: List based on when information about the shared
#'     report group was last changed.
#' @param nextToken During a previous call, the maximum number of items that can be returned
#' is the value specified in `maxResults`. If there more items in the list,
#' then a unique string called a *nextToken* is returned. To get the next
#' batch of items in the list, call this operation again, adding the next
#' token to the call. To get all of the items in the list, keep calling
#' this operation with each subsequent next token that is returned, until
#' no more next tokens are returned.
#' @param maxResults The maximum number of paginated shared report groups per response. Use
#' `nextToken` to iterate pages in the list of returned `ReportGroup`
#' objects. The default value is 100.
#'
#' @keywords internal
#'
#' @rdname codebuild_list_shared_report_groups
codebuild_list_shared_report_groups <- function(sortOrder = NULL, sortBy = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListSharedReportGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$list_shared_report_groups_input(sortOrder = sortOrder, sortBy = sortBy, nextToken = nextToken, maxResults = maxResults)
  output <- .codebuild$list_shared_report_groups_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$list_shared_report_groups <- codebuild_list_shared_report_groups

#' Returns a list of SourceCredentialsInfo objects
#'
#' @description
#' Returns a list of `SourceCredentialsInfo` objects.
#'
#' See [https://paws-r.github.io/docs/codebuild/list_source_credentials.html](https://paws-r.github.io/docs/codebuild/list_source_credentials.html) for full documentation.
#'
#' @keywords internal
#'
#' @rdname codebuild_list_source_credentials
codebuild_list_source_credentials <- function() {
  op <- new_operation(
    name = "ListSourceCredentials",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$list_source_credentials_input()
  output <- .codebuild$list_source_credentials_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$list_source_credentials <- codebuild_list_source_credentials

#' Stores a resource policy for the ARN of a Project or ReportGroup object
#'
#' @description
#' Stores a resource policy for the ARN of a `Project` or `ReportGroup` object.
#'
#' See [https://paws-r.github.io/docs/codebuild/put_resource_policy.html](https://paws-r.github.io/docs/codebuild/put_resource_policy.html) for full documentation.
#'
#' @param policy &#91;required&#93; A JSON-formatted resource policy. For more information, see [Sharing a
#' Project](https://docs.aws.amazon.com/codebuild/latest/userguide/project-sharing.html#project-sharing-share)
#' and [Sharing a Report
#' Group](https://docs.aws.amazon.com/codebuild/latest/userguide/report-groups-sharing.html#report-groups-sharing-share)
#' in the *CodeBuild User Guide*.
#' @param resourceArn &#91;required&#93; The ARN of the `Project` or `ReportGroup` resource you want to associate
#' with a resource policy.
#'
#' @keywords internal
#'
#' @rdname codebuild_put_resource_policy
codebuild_put_resource_policy <- function(policy, resourceArn) {
  op <- new_operation(
    name = "PutResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$put_resource_policy_input(policy = policy, resourceArn = resourceArn)
  output <- .codebuild$put_resource_policy_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$put_resource_policy <- codebuild_put_resource_policy

#' Restarts a build
#'
#' @description
#' Restarts a build.
#'
#' See [https://paws-r.github.io/docs/codebuild/retry_build.html](https://paws-r.github.io/docs/codebuild/retry_build.html) for full documentation.
#'
#' @param id Specifies the identifier of the build to restart.
#' @param idempotencyToken A unique, case sensitive identifier you provide to ensure the
#' idempotency of the [`retry_build`][codebuild_retry_build] request. The
#' token is included in the [`retry_build`][codebuild_retry_build] request
#' and is valid for five minutes. If you repeat the
#' [`retry_build`][codebuild_retry_build] request with the same token, but
#' change a parameter, CodeBuild returns a parameter mismatch error.
#'
#' @keywords internal
#'
#' @rdname codebuild_retry_build
codebuild_retry_build <- function(id = NULL, idempotencyToken = NULL) {
  op <- new_operation(
    name = "RetryBuild",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$retry_build_input(id = id, idempotencyToken = idempotencyToken)
  output <- .codebuild$retry_build_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$retry_build <- codebuild_retry_build

#' Restarts a failed batch build
#'
#' @description
#' Restarts a failed batch build. Only batch builds that have failed can be retried.
#'
#' See [https://paws-r.github.io/docs/codebuild/retry_build_batch.html](https://paws-r.github.io/docs/codebuild/retry_build_batch.html) for full documentation.
#'
#' @param id Specifies the identifier of the batch build to restart.
#' @param idempotencyToken A unique, case sensitive identifier you provide to ensure the
#' idempotency of the [`retry_build_batch`][codebuild_retry_build_batch]
#' request. The token is included in the
#' [`retry_build_batch`][codebuild_retry_build_batch] request and is valid
#' for five minutes. If you repeat the
#' [`retry_build_batch`][codebuild_retry_build_batch] request with the same
#' token, but change a parameter, CodeBuild returns a parameter mismatch
#' error.
#' @param retryType Specifies the type of retry to perform.
#'
#' @keywords internal
#'
#' @rdname codebuild_retry_build_batch
codebuild_retry_build_batch <- function(id = NULL, idempotencyToken = NULL, retryType = NULL) {
  op <- new_operation(
    name = "RetryBuildBatch",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$retry_build_batch_input(id = id, idempotencyToken = idempotencyToken, retryType = retryType)
  output <- .codebuild$retry_build_batch_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$retry_build_batch <- codebuild_retry_build_batch

#' Starts running a build
#'
#' @description
#' Starts running a build.
#'
#' See [https://paws-r.github.io/docs/codebuild/start_build.html](https://paws-r.github.io/docs/codebuild/start_build.html) for full documentation.
#'
#' @param projectName &#91;required&#93; The name of the CodeBuild build project to start running a build.
#' @param secondarySourcesOverride An array of `ProjectSource` objects.
#' @param secondarySourcesVersionOverride An array of `ProjectSourceVersion` objects that specify one or more
#' versions of the project's secondary sources to be used for this build
#' only.
#' @param sourceVersion The version of the build input to be built, for this build only. If not
#' specified, the latest version is used. If specified, the contents
#' depends on the source provider:
#' 
#' **CodeCommit**
#' 
#' The commit ID, branch, or Git tag to use.
#' 
#' **GitHub**
#' 
#' The commit ID, pull request ID, branch name, or tag name that
#' corresponds to the version of the source code you want to build. If a
#' pull request ID is specified, it must use the format
#' `pr/pull-request-ID` (for example `pr/25`). If a branch name is
#' specified, the branch's HEAD commit ID is used. If not specified, the
#' default branch's HEAD commit ID is used.
#' 
#' **Bitbucket**
#' 
#' The commit ID, branch name, or tag name that corresponds to the version
#' of the source code you want to build. If a branch name is specified, the
#' branch's HEAD commit ID is used. If not specified, the default branch's
#' HEAD commit ID is used.
#' 
#' **Amazon S3**
#' 
#' The version ID of the object that represents the build input ZIP file to
#' use.
#' 
#' If `sourceVersion` is specified at the project level, then this
#' `sourceVersion` (at the build level) takes precedence.
#' 
#' For more information, see [Source Version Sample with
#' CodeBuild](https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html)
#' in the *CodeBuild User Guide*.
#' @param artifactsOverride Build output artifact settings that override, for this build only, the
#' latest ones already defined in the build project.
#' @param secondaryArtifactsOverride An array of `ProjectArtifacts` objects.
#' @param environmentVariablesOverride A set of environment variables that overrides, for this build only, the
#' latest ones already defined in the build project.
#' @param sourceTypeOverride A source input type, for this build, that overrides the source input
#' defined in the build project.
#' @param sourceLocationOverride A location that overrides, for this build, the source location for the
#' one defined in the build project.
#' @param sourceAuthOverride An authorization type for this build that overrides the one defined in
#' the build project. This override applies only if the build project's
#' source is BitBucket or GitHub.
#' @param gitCloneDepthOverride The user-defined depth of history, with a minimum value of 0, that
#' overrides, for this build only, any previous depth of history defined in
#' the build project.
#' @param gitSubmodulesConfigOverride Information about the Git submodules configuration for this build of an
#' CodeBuild build project.
#' @param buildspecOverride A buildspec file declaration that overrides, for this build only, the
#' latest one already defined in the build project.
#' 
#' If this value is set, it can be either an inline buildspec definition,
#' the path to an alternate buildspec file relative to the value of the
#' built-in `CODEBUILD_SRC_DIR` environment variable, or the path to an S3
#' bucket. The bucket must be in the same Amazon Web Services Region as the
#' build project. Specify the buildspec file using its ARN (for example,
#' `arn:aws:s3:::my-codebuild-sample2/buildspec.yml`). If this value is not
#' provided or is set to an empty string, the source code must contain a
#' buildspec file in its root directory. For more information, see
#' [Buildspec File Name and Storage
#' Location](https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-name-storage).
#' @param insecureSslOverride Enable this flag to override the insecure SSL setting that is specified
#' in the build project. The insecure SSL setting determines whether to
#' ignore SSL warnings while connecting to the project source code. This
#' override applies only if the build's source is GitHub Enterprise.
#' @param reportBuildStatusOverride Set to true to report to your source provider the status of a build's
#' start and completion. If you use this option with a source provider
#' other than GitHub, GitHub Enterprise, or Bitbucket, an
#' `invalidInputException` is thrown.
#' 
#' To be able to report the build status to the source provider, the user
#' associated with the source provider must have write access to the repo.
#' If the user does not have write access, the build status cannot be
#' updated. For more information, see [Source provider
#' access](https://docs.aws.amazon.com/codebuild/latest/userguide/access-tokens.html)
#' in the *CodeBuild User Guide*.
#' 
#' The status of a build triggered by a webhook is always reported to your
#' source provider.
#' @param buildStatusConfigOverride Contains information that defines how the build project reports the
#' build status to the source provider. This option is only used when the
#' source provider is `GITHUB`, `GITHUB_ENTERPRISE`, or `BITBUCKET`.
#' @param environmentTypeOverride A container type for this build that overrides the one specified in the
#' build project.
#' @param imageOverride The name of an image for this build that overrides the one specified in
#' the build project.
#' @param computeTypeOverride The name of a compute type for this build that overrides the one
#' specified in the build project.
#' @param certificateOverride The name of a certificate for this build that overrides the one
#' specified in the build project.
#' @param cacheOverride A ProjectCache object specified for this build that overrides the one
#' defined in the build project.
#' @param serviceRoleOverride The name of a service role for this build that overrides the one
#' specified in the build project.
#' @param privilegedModeOverride Enable this flag to override privileged mode in the build project.
#' @param timeoutInMinutesOverride The number of build timeout minutes, from 5 to 480 (8 hours), that
#' overrides, for this build only, the latest setting already defined in
#' the build project.
#' @param queuedTimeoutInMinutesOverride The number of minutes a build is allowed to be queued before it times
#' out.
#' @param encryptionKeyOverride The Key Management Service customer master key (CMK) that overrides the
#' one specified in the build project. The CMK key encrypts the build
#' output artifacts.
#' 
#' You can use a cross-account KMS key to encrypt the build output
#' artifacts if your service role has permission to that key.
#' 
#' You can specify either the Amazon Resource Name (ARN) of the CMK or, if
#' available, the CMK's alias (using the format `alias/<alias-name>`).
#' @param idempotencyToken A unique, case sensitive identifier you provide to ensure the
#' idempotency of the StartBuild request. The token is included in the
#' StartBuild request and is valid for 5 minutes. If you repeat the
#' StartBuild request with the same token, but change a parameter,
#' CodeBuild returns a parameter mismatch error.
#' @param logsConfigOverride Log settings for this build that override the log settings defined in
#' the build project.
#' @param registryCredentialOverride The credentials for access to a private registry.
#' @param imagePullCredentialsTypeOverride The type of credentials CodeBuild uses to pull images in your build.
#' There are two valid values:
#' 
#' **CODEBUILD**
#' 
#' Specifies that CodeBuild uses its own credentials. This requires that
#' you modify your ECR repository policy to trust CodeBuild's service
#' principal.
#' 
#' **SERVICE_ROLE**
#' 
#' Specifies that CodeBuild uses your build project's service role.
#' 
#' When using a cross-account or private registry image, you must use
#' `SERVICE_ROLE` credentials. When using an CodeBuild curated image, you
#' must use `CODEBUILD` credentials.
#' @param debugSessionEnabled Specifies if session debugging is enabled for this build. For more
#' information, see [Viewing a running build in Session
#' Manager](https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html).
#'
#' @keywords internal
#'
#' @rdname codebuild_start_build
codebuild_start_build <- function(projectName, secondarySourcesOverride = NULL, secondarySourcesVersionOverride = NULL, sourceVersion = NULL, artifactsOverride = NULL, secondaryArtifactsOverride = NULL, environmentVariablesOverride = NULL, sourceTypeOverride = NULL, sourceLocationOverride = NULL, sourceAuthOverride = NULL, gitCloneDepthOverride = NULL, gitSubmodulesConfigOverride = NULL, buildspecOverride = NULL, insecureSslOverride = NULL, reportBuildStatusOverride = NULL, buildStatusConfigOverride = NULL, environmentTypeOverride = NULL, imageOverride = NULL, computeTypeOverride = NULL, certificateOverride = NULL, cacheOverride = NULL, serviceRoleOverride = NULL, privilegedModeOverride = NULL, timeoutInMinutesOverride = NULL, queuedTimeoutInMinutesOverride = NULL, encryptionKeyOverride = NULL, idempotencyToken = NULL, logsConfigOverride = NULL, registryCredentialOverride = NULL, imagePullCredentialsTypeOverride = NULL, debugSessionEnabled = NULL) {
  op <- new_operation(
    name = "StartBuild",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$start_build_input(projectName = projectName, secondarySourcesOverride = secondarySourcesOverride, secondarySourcesVersionOverride = secondarySourcesVersionOverride, sourceVersion = sourceVersion, artifactsOverride = artifactsOverride, secondaryArtifactsOverride = secondaryArtifactsOverride, environmentVariablesOverride = environmentVariablesOverride, sourceTypeOverride = sourceTypeOverride, sourceLocationOverride = sourceLocationOverride, sourceAuthOverride = sourceAuthOverride, gitCloneDepthOverride = gitCloneDepthOverride, gitSubmodulesConfigOverride = gitSubmodulesConfigOverride, buildspecOverride = buildspecOverride, insecureSslOverride = insecureSslOverride, reportBuildStatusOverride = reportBuildStatusOverride, buildStatusConfigOverride = buildStatusConfigOverride, environmentTypeOverride = environmentTypeOverride, imageOverride = imageOverride, computeTypeOverride = computeTypeOverride, certificateOverride = certificateOverride, cacheOverride = cacheOverride, serviceRoleOverride = serviceRoleOverride, privilegedModeOverride = privilegedModeOverride, timeoutInMinutesOverride = timeoutInMinutesOverride, queuedTimeoutInMinutesOverride = queuedTimeoutInMinutesOverride, encryptionKeyOverride = encryptionKeyOverride, idempotencyToken = idempotencyToken, logsConfigOverride = logsConfigOverride, registryCredentialOverride = registryCredentialOverride, imagePullCredentialsTypeOverride = imagePullCredentialsTypeOverride, debugSessionEnabled = debugSessionEnabled)
  output <- .codebuild$start_build_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$start_build <- codebuild_start_build

#' Starts a batch build for a project
#'
#' @description
#' Starts a batch build for a project.
#'
#' See [https://paws-r.github.io/docs/codebuild/start_build_batch.html](https://paws-r.github.io/docs/codebuild/start_build_batch.html) for full documentation.
#'
#' @param projectName &#91;required&#93; The name of the project.
#' @param secondarySourcesOverride An array of `ProjectSource` objects that override the secondary sources
#' defined in the batch build project.
#' @param secondarySourcesVersionOverride An array of `ProjectSourceVersion` objects that override the secondary
#' source versions in the batch build project.
#' @param sourceVersion The version of the batch build input to be built, for this build only.
#' If not specified, the latest version is used. If specified, the contents
#' depends on the source provider:
#' 
#' **CodeCommit**
#' 
#' The commit ID, branch, or Git tag to use.
#' 
#' **GitHub**
#' 
#' The commit ID, pull request ID, branch name, or tag name that
#' corresponds to the version of the source code you want to build. If a
#' pull request ID is specified, it must use the format
#' `pr/pull-request-ID` (for example `pr/25`). If a branch name is
#' specified, the branch's HEAD commit ID is used. If not specified, the
#' default branch's HEAD commit ID is used.
#' 
#' **Bitbucket**
#' 
#' The commit ID, branch name, or tag name that corresponds to the version
#' of the source code you want to build. If a branch name is specified, the
#' branch's HEAD commit ID is used. If not specified, the default branch's
#' HEAD commit ID is used.
#' 
#' **Amazon S3**
#' 
#' The version ID of the object that represents the build input ZIP file to
#' use.
#' 
#' If `sourceVersion` is specified at the project level, then this
#' `sourceVersion` (at the build level) takes precedence.
#' 
#' For more information, see [Source Version Sample with
#' CodeBuild](https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html)
#' in the *CodeBuild User Guide*.
#' @param artifactsOverride An array of `ProjectArtifacts` objects that contains information about
#' the build output artifact overrides for the build project.
#' @param secondaryArtifactsOverride An array of `ProjectArtifacts` objects that override the secondary
#' artifacts defined in the batch build project.
#' @param environmentVariablesOverride An array of `EnvironmentVariable` objects that override, or add to, the
#' environment variables defined in the batch build project.
#' @param sourceTypeOverride The source input type that overrides the source input defined in the
#' batch build project.
#' @param sourceLocationOverride A location that overrides, for this batch build, the source location
#' defined in the batch build project.
#' @param sourceAuthOverride A `SourceAuth` object that overrides the one defined in the batch build
#' project. This override applies only if the build project's source is
#' BitBucket or GitHub.
#' @param gitCloneDepthOverride The user-defined depth of history, with a minimum value of 0, that
#' overrides, for this batch build only, any previous depth of history
#' defined in the batch build project.
#' @param gitSubmodulesConfigOverride A `GitSubmodulesConfig` object that overrides the Git submodules
#' configuration for this batch build.
#' @param buildspecOverride A buildspec file declaration that overrides, for this build only, the
#' latest one already defined in the build project.
#' 
#' If this value is set, it can be either an inline buildspec definition,
#' the path to an alternate buildspec file relative to the value of the
#' built-in `CODEBUILD_SRC_DIR` environment variable, or the path to an S3
#' bucket. The bucket must be in the same Amazon Web Services Region as the
#' build project. Specify the buildspec file using its ARN (for example,
#' `arn:aws:s3:::my-codebuild-sample2/buildspec.yml`). If this value is not
#' provided or is set to an empty string, the source code must contain a
#' buildspec file in its root directory. For more information, see
#' [Buildspec File Name and Storage
#' Location](https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-name-storage).
#' @param insecureSslOverride Enable this flag to override the insecure SSL setting that is specified
#' in the batch build project. The insecure SSL setting determines whether
#' to ignore SSL warnings while connecting to the project source code. This
#' override applies only if the build's source is GitHub Enterprise.
#' @param reportBuildBatchStatusOverride Set to `true` to report to your source provider the status of a batch
#' build's start and completion. If you use this option with a source
#' provider other than GitHub, GitHub Enterprise, or Bitbucket, an
#' `invalidInputException` is thrown.
#' 
#' The status of a build triggered by a webhook is always reported to your
#' source provider.
#' @param environmentTypeOverride A container type for this batch build that overrides the one specified
#' in the batch build project.
#' @param imageOverride The name of an image for this batch build that overrides the one
#' specified in the batch build project.
#' @param computeTypeOverride The name of a compute type for this batch build that overrides the one
#' specified in the batch build project.
#' @param certificateOverride The name of a certificate for this batch build that overrides the one
#' specified in the batch build project.
#' @param cacheOverride A `ProjectCache` object that specifies cache overrides.
#' @param serviceRoleOverride The name of a service role for this batch build that overrides the one
#' specified in the batch build project.
#' @param privilegedModeOverride Enable this flag to override privileged mode in the batch build project.
#' @param buildTimeoutInMinutesOverride Overrides the build timeout specified in the batch build project.
#' @param queuedTimeoutInMinutesOverride The number of minutes a batch build is allowed to be queued before it
#' times out.
#' @param encryptionKeyOverride The Key Management Service customer master key (CMK) that overrides the
#' one specified in the batch build project. The CMK key encrypts the build
#' output artifacts.
#' 
#' You can use a cross-account KMS key to encrypt the build output
#' artifacts if your service role has permission to that key.
#' 
#' You can specify either the Amazon Resource Name (ARN) of the CMK or, if
#' available, the CMK's alias (using the format `alias/<alias-name>`).
#' @param idempotencyToken A unique, case sensitive identifier you provide to ensure the
#' idempotency of the [`start_build_batch`][codebuild_start_build_batch]
#' request. The token is included in the
#' [`start_build_batch`][codebuild_start_build_batch] request and is valid
#' for five minutes. If you repeat the
#' [`start_build_batch`][codebuild_start_build_batch] request with the same
#' token, but change a parameter, CodeBuild returns a parameter mismatch
#' error.
#' @param logsConfigOverride A `LogsConfig` object that override the log settings defined in the
#' batch build project.
#' @param registryCredentialOverride A `RegistryCredential` object that overrides credentials for access to a
#' private registry.
#' @param imagePullCredentialsTypeOverride The type of credentials CodeBuild uses to pull images in your batch
#' build. There are two valid values:
#' 
#' **CODEBUILD**
#' 
#' Specifies that CodeBuild uses its own credentials. This requires that
#' you modify your ECR repository policy to trust CodeBuild's service
#' principal.
#' 
#' **SERVICE_ROLE**
#' 
#' Specifies that CodeBuild uses your build project's service role.
#' 
#' When using a cross-account or private registry image, you must use
#' `SERVICE_ROLE` credentials. When using an CodeBuild curated image, you
#' must use `CODEBUILD` credentials.
#' @param buildBatchConfigOverride A `BuildBatchConfigOverride` object that contains batch build
#' configuration overrides.
#' @param debugSessionEnabled Specifies if session debugging is enabled for this batch build. For more
#' information, see [Viewing a running build in Session
#' Manager](https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html).
#' Batch session debugging is not supported for matrix batch builds.
#'
#' @keywords internal
#'
#' @rdname codebuild_start_build_batch
codebuild_start_build_batch <- function(projectName, secondarySourcesOverride = NULL, secondarySourcesVersionOverride = NULL, sourceVersion = NULL, artifactsOverride = NULL, secondaryArtifactsOverride = NULL, environmentVariablesOverride = NULL, sourceTypeOverride = NULL, sourceLocationOverride = NULL, sourceAuthOverride = NULL, gitCloneDepthOverride = NULL, gitSubmodulesConfigOverride = NULL, buildspecOverride = NULL, insecureSslOverride = NULL, reportBuildBatchStatusOverride = NULL, environmentTypeOverride = NULL, imageOverride = NULL, computeTypeOverride = NULL, certificateOverride = NULL, cacheOverride = NULL, serviceRoleOverride = NULL, privilegedModeOverride = NULL, buildTimeoutInMinutesOverride = NULL, queuedTimeoutInMinutesOverride = NULL, encryptionKeyOverride = NULL, idempotencyToken = NULL, logsConfigOverride = NULL, registryCredentialOverride = NULL, imagePullCredentialsTypeOverride = NULL, buildBatchConfigOverride = NULL, debugSessionEnabled = NULL) {
  op <- new_operation(
    name = "StartBuildBatch",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$start_build_batch_input(projectName = projectName, secondarySourcesOverride = secondarySourcesOverride, secondarySourcesVersionOverride = secondarySourcesVersionOverride, sourceVersion = sourceVersion, artifactsOverride = artifactsOverride, secondaryArtifactsOverride = secondaryArtifactsOverride, environmentVariablesOverride = environmentVariablesOverride, sourceTypeOverride = sourceTypeOverride, sourceLocationOverride = sourceLocationOverride, sourceAuthOverride = sourceAuthOverride, gitCloneDepthOverride = gitCloneDepthOverride, gitSubmodulesConfigOverride = gitSubmodulesConfigOverride, buildspecOverride = buildspecOverride, insecureSslOverride = insecureSslOverride, reportBuildBatchStatusOverride = reportBuildBatchStatusOverride, environmentTypeOverride = environmentTypeOverride, imageOverride = imageOverride, computeTypeOverride = computeTypeOverride, certificateOverride = certificateOverride, cacheOverride = cacheOverride, serviceRoleOverride = serviceRoleOverride, privilegedModeOverride = privilegedModeOverride, buildTimeoutInMinutesOverride = buildTimeoutInMinutesOverride, queuedTimeoutInMinutesOverride = queuedTimeoutInMinutesOverride, encryptionKeyOverride = encryptionKeyOverride, idempotencyToken = idempotencyToken, logsConfigOverride = logsConfigOverride, registryCredentialOverride = registryCredentialOverride, imagePullCredentialsTypeOverride = imagePullCredentialsTypeOverride, buildBatchConfigOverride = buildBatchConfigOverride, debugSessionEnabled = debugSessionEnabled)
  output <- .codebuild$start_build_batch_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$start_build_batch <- codebuild_start_build_batch

#' Attempts to stop running a build
#'
#' @description
#' Attempts to stop running a build.
#'
#' See [https://paws-r.github.io/docs/codebuild/stop_build.html](https://paws-r.github.io/docs/codebuild/stop_build.html) for full documentation.
#'
#' @param id &#91;required&#93; The ID of the build.
#'
#' @keywords internal
#'
#' @rdname codebuild_stop_build
codebuild_stop_build <- function(id) {
  op <- new_operation(
    name = "StopBuild",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$stop_build_input(id = id)
  output <- .codebuild$stop_build_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$stop_build <- codebuild_stop_build

#' Stops a running batch build
#'
#' @description
#' Stops a running batch build.
#'
#' See [https://paws-r.github.io/docs/codebuild/stop_build_batch.html](https://paws-r.github.io/docs/codebuild/stop_build_batch.html) for full documentation.
#'
#' @param id &#91;required&#93; The identifier of the batch build to stop.
#'
#' @keywords internal
#'
#' @rdname codebuild_stop_build_batch
codebuild_stop_build_batch <- function(id) {
  op <- new_operation(
    name = "StopBuildBatch",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$stop_build_batch_input(id = id)
  output <- .codebuild$stop_build_batch_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$stop_build_batch <- codebuild_stop_build_batch

#' Changes the settings of a build project
#'
#' @description
#' Changes the settings of a build project.
#'
#' See [https://paws-r.github.io/docs/codebuild/update_project.html](https://paws-r.github.io/docs/codebuild/update_project.html) for full documentation.
#'
#' @param name &#91;required&#93; The name of the build project.
#' 
#' You cannot change a build project's name.
#' @param description A new or replacement description of the build project.
#' @param source Information to be changed about the build input source code for the
#' build project.
#' @param secondarySources An array of `ProjectSource` objects.
#' @param sourceVersion A version of the build input to be built for this project. If not
#' specified, the latest version is used. If specified, it must be one of:
#' 
#' -   For CodeCommit: the commit ID, branch, or Git tag to use.
#' 
#' -   For GitHub: the commit ID, pull request ID, branch name, or tag name
#'     that corresponds to the version of the source code you want to
#'     build. If a pull request ID is specified, it must use the format
#'     `pr/pull-request-ID` (for example `pr/25`). If a branch name is
#'     specified, the branch's HEAD commit ID is used. If not specified,
#'     the default branch's HEAD commit ID is used.
#' 
#' -   For Bitbucket: the commit ID, branch name, or tag name that
#'     corresponds to the version of the source code you want to build. If
#'     a branch name is specified, the branch's HEAD commit ID is used. If
#'     not specified, the default branch's HEAD commit ID is used.
#' 
#' -   For Amazon S3: the version ID of the object that represents the
#'     build input ZIP file to use.
#' 
#' If `sourceVersion` is specified at the build level, then that version
#' takes precedence over this `sourceVersion` (at the project level).
#' 
#' For more information, see [Source Version Sample with
#' CodeBuild](https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html)
#' in the *CodeBuild User Guide*.
#' @param secondarySourceVersions An array of `ProjectSourceVersion` objects. If `secondarySourceVersions`
#' is specified at the build level, then they take over these
#' `secondarySourceVersions` (at the project level).
#' @param artifacts Information to be changed about the build output artifacts for the build
#' project.
#' @param secondaryArtifacts An array of `ProjectArtifact` objects.
#' @param cache Stores recently used information so that it can be quickly accessed at a
#' later time.
#' @param environment Information to be changed about the build environment for the build
#' project.
#' @param serviceRole The replacement ARN of the IAM role that enables CodeBuild to interact
#' with dependent Amazon Web Services services on behalf of the Amazon Web
#' Services account.
#' @param timeoutInMinutes The replacement value in minutes, from 5 to 480 (8 hours), for CodeBuild
#' to wait before timing out any related build that did not get marked as
#' completed.
#' @param queuedTimeoutInMinutes The number of minutes a build is allowed to be queued before it times
#' out.
#' @param encryptionKey The Key Management Service customer master key (CMK) to be used for
#' encrypting the build output artifacts.
#' 
#' You can use a cross-account KMS key to encrypt the build output
#' artifacts if your service role has permission to that key.
#' 
#' You can specify either the Amazon Resource Name (ARN) of the CMK or, if
#' available, the CMK's alias (using the format `alias/<alias-name>`).
#' @param tags An updated list of tag key and value pairs associated with this build
#' project.
#' 
#' These tags are available for use by Amazon Web Services services that
#' support CodeBuild build project tags.
#' @param vpcConfig VpcConfig enables CodeBuild to access resources in an Amazon VPC.
#' @param badgeEnabled Set this to true to generate a publicly accessible URL for your
#' project's build badge.
#' @param logsConfig Information about logs for the build project. A project can create logs
#' in CloudWatch Logs, logs in an S3 bucket, or both.
#' @param fileSystemLocations An array of `ProjectFileSystemLocation` objects for a CodeBuild build
#' project. A `ProjectFileSystemLocation` object specifies the
#' `identifier`, `location`, `mountOptions`, `mountPoint`, and `type` of a
#' file system created using Amazon Elastic File System.
#' @param buildBatchConfig 
#' @param concurrentBuildLimit The maximum number of concurrent builds that are allowed for this
#' project.
#' 
#' New builds are only started if the current number of builds is less than
#' or equal to this limit. If the current build count meets this limit, new
#' builds are throttled and are not run.
#' 
#' To remove this limit, set this value to -1.
#'
#' @keywords internal
#'
#' @rdname codebuild_update_project
codebuild_update_project <- function(name, description = NULL, source = NULL, secondarySources = NULL, sourceVersion = NULL, secondarySourceVersions = NULL, artifacts = NULL, secondaryArtifacts = NULL, cache = NULL, environment = NULL, serviceRole = NULL, timeoutInMinutes = NULL, queuedTimeoutInMinutes = NULL, encryptionKey = NULL, tags = NULL, vpcConfig = NULL, badgeEnabled = NULL, logsConfig = NULL, fileSystemLocations = NULL, buildBatchConfig = NULL, concurrentBuildLimit = NULL) {
  op <- new_operation(
    name = "UpdateProject",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$update_project_input(name = name, description = description, source = source, secondarySources = secondarySources, sourceVersion = sourceVersion, secondarySourceVersions = secondarySourceVersions, artifacts = artifacts, secondaryArtifacts = secondaryArtifacts, cache = cache, environment = environment, serviceRole = serviceRole, timeoutInMinutes = timeoutInMinutes, queuedTimeoutInMinutes = queuedTimeoutInMinutes, encryptionKey = encryptionKey, tags = tags, vpcConfig = vpcConfig, badgeEnabled = badgeEnabled, logsConfig = logsConfig, fileSystemLocations = fileSystemLocations, buildBatchConfig = buildBatchConfig, concurrentBuildLimit = concurrentBuildLimit)
  output <- .codebuild$update_project_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$update_project <- codebuild_update_project

#' Changes the public visibility for a project
#'
#' @description
#' Changes the public visibility for a project. The project's build results, logs, and artifacts are available to the general public. For more information, see [Public build projects](https://docs.aws.amazon.com/codebuild/latest/userguide/public-builds.html) in the *CodeBuild User Guide*.
#'
#' See [https://paws-r.github.io/docs/codebuild/update_project_visibility.html](https://paws-r.github.io/docs/codebuild/update_project_visibility.html) for full documentation.
#'
#' @param projectArn &#91;required&#93; The Amazon Resource Name (ARN) of the build project.
#' @param projectVisibility &#91;required&#93; 
#' @param resourceAccessRole The ARN of the IAM role that enables CodeBuild to access the CloudWatch
#' Logs and Amazon S3 artifacts for the project's builds.
#'
#' @keywords internal
#'
#' @rdname codebuild_update_project_visibility
codebuild_update_project_visibility <- function(projectArn, projectVisibility, resourceAccessRole = NULL) {
  op <- new_operation(
    name = "UpdateProjectVisibility",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$update_project_visibility_input(projectArn = projectArn, projectVisibility = projectVisibility, resourceAccessRole = resourceAccessRole)
  output <- .codebuild$update_project_visibility_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$update_project_visibility <- codebuild_update_project_visibility

#' Updates a report group
#'
#' @description
#' Updates a report group.
#'
#' See [https://paws-r.github.io/docs/codebuild/update_report_group.html](https://paws-r.github.io/docs/codebuild/update_report_group.html) for full documentation.
#'
#' @param arn &#91;required&#93; The ARN of the report group to update.
#' @param exportConfig Used to specify an updated export type. Valid values are:
#' 
#' -   `S3`: The report results are exported to an S3 bucket.
#' 
#' -   `NO_EXPORT`: The report results are not exported.
#' @param tags An updated list of tag key and value pairs associated with this report
#' group.
#' 
#' These tags are available for use by Amazon Web Services services that
#' support CodeBuild report group tags.
#'
#' @keywords internal
#'
#' @rdname codebuild_update_report_group
codebuild_update_report_group <- function(arn, exportConfig = NULL, tags = NULL) {
  op <- new_operation(
    name = "UpdateReportGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$update_report_group_input(arn = arn, exportConfig = exportConfig, tags = tags)
  output <- .codebuild$update_report_group_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$update_report_group <- codebuild_update_report_group

#' Updates the webhook associated with an CodeBuild build project
#'
#' @description
#' Updates the webhook associated with an CodeBuild build project.
#'
#' See [https://paws-r.github.io/docs/codebuild/update_webhook.html](https://paws-r.github.io/docs/codebuild/update_webhook.html) for full documentation.
#'
#' @param projectName &#91;required&#93; The name of the CodeBuild project.
#' @param branchFilter A regular expression used to determine which repository branches are
#' built when a webhook is triggered. If the name of a branch matches the
#' regular expression, then it is built. If `branchFilter` is empty, then
#' all branches are built.
#' 
#' It is recommended that you use `filterGroups` instead of `branchFilter`.
#' @param rotateSecret A boolean value that specifies whether the associated GitHub
#' repository's secret token should be updated. If you use Bitbucket for
#' your repository, `rotateSecret` is ignored.
#' @param filterGroups An array of arrays of `WebhookFilter` objects used to determine if a
#' webhook event can trigger a build. A filter group must contain at least
#' one `EVENT` `WebhookFilter`.
#' @param buildType Specifies the type of build this webhook will trigger.
#'
#' @keywords internal
#'
#' @rdname codebuild_update_webhook
codebuild_update_webhook <- function(projectName, branchFilter = NULL, rotateSecret = NULL, filterGroups = NULL, buildType = NULL) {
  op <- new_operation(
    name = "UpdateWebhook",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codebuild$update_webhook_input(projectName = projectName, branchFilter = branchFilter, rotateSecret = rotateSecret, filterGroups = filterGroups, buildType = buildType)
  output <- .codebuild$update_webhook_output()
  config <- get_config()
  svc <- .codebuild$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codebuild$operations$update_webhook <- codebuild_update_webhook
