% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeguruprofiler_operations.R
\name{codeguruprofiler_get_profile}
\alias{codeguruprofiler_get_profile}
\title{Gets the aggregated profile of a profiling group for a specified time
range}
\usage{
codeguruprofiler_get_profile(
  accept = NULL,
  endTime = NULL,
  maxDepth = NULL,
  period = NULL,
  profilingGroupName,
  startTime = NULL
)
}
\arguments{
\item{accept}{The format of the returned profiling data. The format maps to the
\code{Accept} and \code{Content-Type} headers of the HTTP request. You can specify
one of the following: or the default .

\if{html}{\out{<div class="sourceCode">}}\preformatted{ <ul> <li> <p> <code>application/json</code> — standard JSON format </p> </li> <li> <p> <code>application/x-amzn-ion</code> — the Amazon Ion data format. For more information, see <a href="http://amzn.github.io/ion-docs/">Amazon Ion</a>. </p> </li> </ul>
}\if{html}{\out{</div>}}}

\item{endTime}{The end time of the requested profile. Specify using the ISO 8601
format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond
past June 1, 2020 1:15:02 PM UTC.

If you specify \code{endTime}, then you must also specify \code{period} or
\code{startTime}, but not both.}

\item{maxDepth}{The maximum depth of the stacks in the code that is represented in the
aggregated profile. For example, if CodeGuru Profiler finds a method
\code{A}, which calls method \code{B}, which calls method \code{C}, which calls method
\code{D}, then the depth is 4. If the \code{maxDepth} is set to 2, then the
aggregated profile contains representations of methods \code{A} and \code{B}.}

\item{period}{Used with \code{startTime} or \code{endTime} to specify the time range for the
returned aggregated profile. Specify using the ISO 8601 format. For
example, \code{P1DT1H1M1S}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{ <p> To get the latest aggregated profile, specify only <code>period</code>. </p>
}\if{html}{\out{</div>}}}

\item{profilingGroupName}{[required] The name of the profiling group to get.}

\item{startTime}{The start time of the profile to get. Specify using the ISO 8601 format.
For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June
1, 2020 1:15:02 PM UTC.

\if{html}{\out{<div class="sourceCode">}}\preformatted{ <p> If you specify <code>startTime</code>, then you must also specify <code>period</code> or <code>endTime</code>, but not both. </p>
}\if{html}{\out{</div>}}}
}
\description{
Gets the aggregated profile of a profiling group for a specified time range. Amazon CodeGuru Profiler collects posted agent profiles for a profiling group into aggregated profiles.

See \url{https://paws-r.github.io/docs/codeguruprofiler/get_profile.html} for full documentation.
}
\keyword{internal}
