% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devopsguru_operations.R
\name{devopsguru_search_insights}
\alias{devopsguru_search_insights}
\title{Returns a list of insights in your Amazon Web Services account}
\usage{
devopsguru_search_insights(
  StartTimeRange,
  Filters = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  Type
)
}
\arguments{
\item{StartTimeRange}{[required] The start of the time range passed in. Returned insights occurred after
this time.}

\item{Filters}{A \code{SearchInsightsFilters} object that is used to set the severity and
status filters on your insight search.}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{NextToken}{The pagination token to use to retrieve the next page of results for
this operation. If this value is null, it retrieves the first page.}

\item{Type}{[required] The type of insights you are searching for (\code{REACTIVE} or \code{PROACTIVE}).}
}
\description{
Returns a list of insights in your Amazon Web Services account. You can specify which insights are returned by their start time, one or more statuses (\code{ONGOING}, \code{CLOSED}, and \code{CLOSED}), one or more severities (\code{LOW}, \code{MEDIUM}, and \code{HIGH}), and type (\code{REACTIVE} or \code{PROACTIVE}).

See \url{https://paws-r.github.io/docs/devopsguru/search_insights.html} for full documentation.
}
\keyword{internal}
