% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workdocs_operations.R
\name{workdocs_add_resource_permissions}
\alias{workdocs_add_resource_permissions}
\title{Creates a set of permissions for the specified folder or document}
\usage{
workdocs_add_resource_permissions(AuthenticationToken, ResourceId,
  Principals, NotificationOptions)
}
\arguments{
\item{AuthenticationToken}{Amazon WorkDocs authentication token. Not required when using AWS
administrator credentials to access the API.}

\item{ResourceId}{[required] The ID of the resource.}

\item{Principals}{[required] The users, groups, or organization being granted permission.}

\item{NotificationOptions}{The notification options.}
}
\value{
A list with the following syntax:\preformatted{list(
  ShareResults = list(
    list(
      PrincipalId = "string",
      InviteePrincipalId = "string",
      Role = "VIEWER"|"CONTRIBUTOR"|"OWNER"|"COOWNER",
      Status = "SUCCESS"|"FAILURE",
      ShareId = "string",
      StatusMessage = "string"
    )
  )
)
}
}
\description{
Creates a set of permissions for the specified folder or document. The
resource permissions are overwritten if the principals already have
different permissions.
}
\section{Request syntax}{
\preformatted{svc$add_resource_permissions(
  AuthenticationToken = "string",
  ResourceId = "string",
  Principals = list(
    list(
      Id = "string",
      Type = "USER"|"GROUP"|"INVITE"|"ANONYMOUS"|"ORGANIZATION",
      Role = "VIEWER"|"CONTRIBUTOR"|"OWNER"|"COOWNER"
    )
  ),
  NotificationOptions = list(
    SendEmail = TRUE|FALSE,
    EmailMessage = "string"
  )
)
}
}

\keyword{internal}
