% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workdocs_operations.R
\name{workdocs_describe_folder_contents}
\alias{workdocs_describe_folder_contents}
\title{Describes the contents of the specified folder, including its documents
and subfolders}
\usage{
workdocs_describe_folder_contents(AuthenticationToken, FolderId, Sort,
  Order, Limit, Marker, Type, Include)
}
\arguments{
\item{AuthenticationToken}{Amazon WorkDocs authentication token. Not required when using AWS
administrator credentials to access the API.}

\item{FolderId}{[required] The ID of the folder.}

\item{Sort}{The sorting criteria.}

\item{Order}{The order for the contents of the folder.}

\item{Limit}{The maximum number of items to return with this call.}

\item{Marker}{The marker for the next set of results. This marker was received from a
previous call.}

\item{Type}{The type of items.}

\item{Include}{The contents to include. Specify "INITIALIZED" to include initialized
documents.}
}
\value{
A list with the following syntax:\preformatted{list(
  Folders = list(
    list(
      Id = "string",
      Name = "string",
      CreatorId = "string",
      ParentFolderId = "string",
      CreatedTimestamp = as.POSIXct(
        "2015-01-01"
      ),
      ModifiedTimestamp = as.POSIXct(
        "2015-01-01"
      ),
      ResourceState = "ACTIVE"|"RESTORING"|"RECYCLING"|"RECYCLED",
      Signature = "string",
      Labels = list(
        "string"
      ),
      Size = 123,
      LatestVersionSize = 123
    )
  ),
  Documents = list(
    list(
      Id = "string",
      CreatorId = "string",
      ParentFolderId = "string",
      CreatedTimestamp = as.POSIXct(
        "2015-01-01"
      ),
      ModifiedTimestamp = as.POSIXct(
        "2015-01-01"
      ),
      LatestVersionMetadata = list(
        Id = "string",
        Name = "string",
        ContentType = "string",
        Size = 123,
        Signature = "string",
        Status = "INITIALIZED"|"ACTIVE",
        CreatedTimestamp = as.POSIXct(
          "2015-01-01"
        ),
        ModifiedTimestamp = as.POSIXct(
          "2015-01-01"
        ),
        ContentCreatedTimestamp = as.POSIXct(
          "2015-01-01"
        ),
        ContentModifiedTimestamp = as.POSIXct(
          "2015-01-01"
        ),
        CreatorId = "string",
        Thumbnail = list(
          "string"
        ),
        Source = list(
          "string"
        )
      ),
      ResourceState = "ACTIVE"|"RESTORING"|"RECYCLING"|"RECYCLED",
      Labels = list(
        "string"
      )
    )
  ),
  Marker = "string"
)
}
}
\description{
Describes the contents of the specified folder, including its documents
and subfolders.

By default, Amazon WorkDocs returns the first 100 active document and
folder metadata items. If there are more results, the response includes
a marker that you can use to request the next set of results. You can
also request initialized documents.
}
\section{Request syntax}{
\preformatted{svc$describe_folder_contents(
  AuthenticationToken = "string",
  FolderId = "string",
  Sort = "DATE"|"NAME",
  Order = "ASCENDING"|"DESCENDING",
  Limit = 123,
  Marker = "string",
  Type = "ALL"|"DOCUMENT"|"FOLDER",
  Include = "string"
)
}
}

\keyword{internal}
