% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehend_operations.R
\name{comprehend_batch_detect_syntax}
\alias{comprehend_batch_detect_syntax}
\title{Inspects the text of a batch of documents for the syntax and part of
speech of the words in the document and returns information about them}
\usage{
comprehend_batch_detect_syntax(TextList, LanguageCode)
}
\arguments{
\item{TextList}{[required] A list containing the text of the input documents. The list can contain
a maximum of 25 documents. Each document must contain fewer that 5,000
bytes of UTF-8 encoded characters.}

\item{LanguageCode}{[required] The language of the input documents. You can specify any of the
following languages supported by Amazon Comprehend: German ("de"),
English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), or
Portuguese ("pt"). All documents must be in the same language.}
}
\value{
A list with the following syntax:\preformatted{list(
  ResultList = list(
    list(
      Index = 123,
      SyntaxTokens = list(
        list(
          TokenId = 123,
          Text = "string",
          BeginOffset = 123,
          EndOffset = 123,
          PartOfSpeech = list(
            Tag = "ADJ"|"ADP"|"ADV"|"AUX"|"CONJ"|"CCONJ"|"DET"|"INTJ"|"NOUN"|"NUM"|"O"|"PART"|"PRON"|"PROPN"|"PUNCT"|"SCONJ"|"SYM"|"VERB",
            Score = 123.0
          )
        )
      )
    )
  ),
  ErrorList = list(
    list(
      Index = 123,
      ErrorCode = "string",
      ErrorMessage = "string"
    )
  )
)
}
}
\description{
Inspects the text of a batch of documents for the syntax and part of
speech of the words in the document and returns information about them.
For more information, see how-syntax.
}
\section{Request syntax}{
\preformatted{svc$batch_detect_syntax(
  TextList = list(
    "string"
  ),
  LanguageCode = "en"|"es"|"fr"|"de"|"it"|"pt"
)
}
}

\keyword{internal}
