% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehend_operations.R
\name{comprehend_describe_entities_detection_job}
\alias{comprehend_describe_entities_detection_job}
\title{Gets the properties associated with an entities detection job}
\usage{
comprehend_describe_entities_detection_job(JobId)
}
\arguments{
\item{JobId}{[required] The identifier that Amazon Comprehend generated for the job. The
operation returns this identifier in its response.}
}
\value{
A list with the following syntax:\preformatted{list(
  EntitiesDetectionJobProperties = list(
    JobId = "string",
    JobName = "string",
    JobStatus = "SUBMITTED"|"IN_PROGRESS"|"COMPLETED"|"FAILED"|"STOP_REQUESTED"|"STOPPED",
    Message = "string",
    SubmitTime = as.POSIXct(
      "2015-01-01"
    ),
    EndTime = as.POSIXct(
      "2015-01-01"
    ),
    EntityRecognizerArn = "string",
    InputDataConfig = list(
      S3Uri = "string",
      InputFormat = "ONE_DOC_PER_FILE"|"ONE_DOC_PER_LINE"
    ),
    OutputDataConfig = list(
      S3Uri = "string",
      KmsKeyId = "string"
    ),
    LanguageCode = "en"|"es"|"fr"|"de"|"it"|"pt"|"ar"|"hi"|"ja"|"ko"|"zh"|"zh-TW",
    DataAccessRoleArn = "string",
    VolumeKmsKeyId = "string",
    VpcConfig = list(
      SecurityGroupIds = list(
        "string"
      ),
      Subnets = list(
        "string"
      )
    )
  )
)
}
}
\description{
Gets the properties associated with an entities detection job. Use this
operation to get the status of a detection job.
}
\section{Request syntax}{
\preformatted{svc$describe_entities_detection_job(
  JobId = "string"
)
}
}

\keyword{internal}
