% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelbuildingservice_operations.R
\name{lexmodelbuildingservice_get_builtin_slot_types}
\alias{lexmodelbuildingservice_get_builtin_slot_types}
\title{Gets a list of built-in slot types that meet the specified criteria}
\usage{
lexmodelbuildingservice_get_builtin_slot_types(locale,
  signatureContains, nextToken, maxResults)
}
\arguments{
\item{locale}{A list of locales that the slot type supports.}

\item{signatureContains}{Substring to match in built-in slot type signatures. A slot type will be
returned if any part of its signature matches the substring. For
example, "xyz" matches both "xyzabc" and "abcxyz."}

\item{nextToken}{A pagination token that fetches the next page of slot types. If the
response to this API call is truncated, Amazon Lex returns a pagination
token in the response. To fetch the next page of slot types, specify the
pagination token in the next request.}

\item{maxResults}{The maximum number of slot types to return in the response. The default
is 10.}
}
\value{
A list with the following syntax:\preformatted{list(
  slotTypes = list(
    list(
      signature = "string",
      supportedLocales = list(
        "de-DE"|"en-AU"|"en-GB"|"en-US"|"es-419"|"es-ES"|"es-US"|"fr-FR"|"fr-CA"|"it-IT"
      )
    )
  ),
  nextToken = "string"
)
}
}
\description{
Gets a list of built-in slot types that meet the specified criteria.

For a list of built-in slot types, see \href{https://developer.amazon.com/en-US/docs/alexa/custom-skills/slot-type-reference.html}{Slot Type Reference}
in the \emph{Alexa Skills Kit}.

This operation requires permission for the \code{lex:GetBuiltInSlotTypes}
action.
}
\section{Request syntax}{
\preformatted{svc$get_builtin_slot_types(
  locale = "de-DE"|"en-AU"|"en-GB"|"en-US"|"es-419"|"es-ES"|"es-US"|"fr-FR"|"fr-CA"|"it-IT",
  signatureContains = "string",
  nextToken = "string",
  maxResults = 123
)
}
}

\keyword{internal}
